/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.fx.rpc;

import com.gridnine.xtrip.common.search.SortOrder;
import com.gridnine.xtrip.common.util.TextUtil;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class DictQuery
implements Serializable {
    private static final long serialVersionUID = 9038751124974891642L;
    public static final int MAX_LIMIT = 200;
    private int limit;
    private int offset;
    private String pattern;
    private final HashSet<String> fields = new HashSet();
    private final LinkedHashMap<String, SortOrder> sorting = new LinkedHashMap();
    private final List<SearchCriterion> criterions = new ArrayList<SearchCriterion>();

    public int getLimit() {
        return this.limit;
    }

    public void setLimit(int value) {
        this.limit = value;
    }

    public int getOffset() {
        return this.offset;
    }

    public void setOffset(int value) {
        this.offset = value;
    }

    public String getPattern() {
        return this.pattern;
    }

    public void setPattern(String value) {
        this.pattern = value;
    }

    public Set<String> getFields() {
        return this.fields;
    }

    public Map<String, SortOrder> getSorting() {
        return this.sorting;
    }

    public List<SearchCriterion> getCriterions() {
        return this.criterions;
    }

    public String toString() {
        int count;
        StringBuilder buf = new StringBuilder();
        buf.append("SELECT ").append(TextUtil.join((String)", ", this.fields));
        if (!this.criterions.isEmpty() || this.pattern != null) {
            buf.append(" WHERE ");
            count = 0;
            for (SearchCriterion searchCriterion : this.criterions) {
                if (count > 0) {
                    buf.append(" AND ");
                }
                buf.append(searchCriterion.getFiled()).append(" = ").append(Arrays.toString(searchCriterion.getValues()));
                ++count;
            }
            if (this.pattern != null) {
                if (count > 0) {
                    buf.append(" AND ");
                }
                buf.append("FREETEXT MATCHES \"").append(this.pattern).append('\"');
            }
        }
        if (!this.sorting.isEmpty()) {
            buf.append(" ORDER BY ");
            count = 0;
            for (Map.Entry entry : this.sorting.entrySet()) {
                if (count > 0) {
                    buf.append(", ");
                }
                buf.append((String)entry.getKey()).append(' ').append(((SortOrder)entry.getValue()).name());
                ++count;
            }
        }
        buf.append(" LIMIT ").append(this.limit).append(" OFFSET ").append(this.offset);
        return buf.toString();
    }

    public static class SearchCriterion
    implements Serializable {
        private static final long serialVersionUID = 4191054916180144771L;
        private static final Object[] EMPTY_ARR = new Object[0];
        private final String filed;
        private final Object[] values;

        public SearchCriterion(String filedId, Object ... fieldValue) {
            this.filed = filedId;
            this.values = fieldValue == null ? EMPTY_ARR : fieldValue;
        }

        public String getFiled() {
            return this.filed;
        }

        public Object[] getValues() {
            return this.values;
        }
    }
}

