/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.fx.ibecorp.rpc;

import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.finance.FinanceDocument;
import com.gridnine.xtrip.common.model.finance.Shipment;
import com.gridnine.xtrip.common.model.ibecorp.xreports.ReportGroup;
import com.gridnine.xtrip.common.model.ibecorp.xreports.ReportReference;
import com.gridnine.xtrip.common.model.kkt.atol.AtolSettings;
import com.gridnine.xtrip.common.model.mail.MailDocument;
import com.gridnine.xtrip.common.model.profile.Person;
import com.gridnine.xtrip.common.model.system.Document;
import com.gridnine.xtrip.common.model.system.Message;
import com.gridnine.xtrip.common.rpc.ServiceException;
import com.gridnine.xtrip.common.rpc.ServiceInvocationContext;
import com.gridnine.xtrip.common.util.TextUtil;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public interface IbecorpModelService {
    public List<ReportReference> getAllXreportsRegistriesReferences(ServiceInvocationContext var1) throws ServiceException;

    public List<ReportGroup> getAllXreportsReportGroups(ServiceInvocationContext var1) throws ServiceException;

    public Map<String, String> getAllXreportsRegistryFields(ServiceInvocationContext var1) throws ServiceException;

    public boolean isPersonalDataStuffOff(ServiceInvocationContext var1) throws ServiceException;

    public Integer getKettlePackSize(ServiceInvocationContext var1) throws ServiceException;

    public boolean setKettlePackSize(ServiceInvocationContext var1, int var2) throws ServiceException;

    public Integer getOptKettlePackSize(ServiceInvocationContext var1) throws ServiceException;

    public ShipmentDocumentsData getShipmentDocumentsData(ServiceInvocationContext var1, EntityReference<Shipment> var2, FinanceDocumentsChangeSettings var3, boolean var4, boolean var5) throws ServiceException;

    public ReportRegistryData getReportRegistryData(ServiceInvocationContext var1, EntityReference<Shipment> var2) throws ServiceException;

    public MailDocument createMailDocument(ServiceInvocationContext var1, EntityReference<BookingFile> var2, String var3, EntityReference<?> ... var4) throws ServiceException;

    public void sendMailDocument(ServiceInvocationContext var1, MailDocument var2, boolean var3) throws ServiceException;

    public void sendFinanceMailDocument(ServiceInvocationContext var1, List<EntityReference<Shipment>> var2, List<String> var3) throws ServiceException;

    public List<String> getCustomerEmails(ServiceInvocationContext var1, List<EntityReference<Shipment>> var2) throws ServiceException;

    public List<EntityContainer<AtolSettings>> findAtolSettings(ServiceInvocationContext var1, Collection<Reservation> var2) throws ServiceException;

    public Set<String> getProductPaymentGatesNames(ServiceInvocationContext var1, BaseProduct var2) throws ServiceException;

    public static class ReportRegistryData
    implements Serializable {
        private static final long serialVersionUID = -5065815693710475568L;
        private final String fileName;
        private final byte[] content;
        private final boolean registryNotConfigured;

        public ReportRegistryData(boolean registryNotConfigured, String fileName, byte[] content) {
            this.registryNotConfigured = registryNotConfigured;
            this.fileName = registryNotConfigured ? null : TextUtil.requireNonBlank((String)fileName, (String)"file name is absent");
            this.content = registryNotConfigured ? null : Objects.requireNonNull(content, () -> "content is absent for document " + fileName);
        }

        public String getFileName() {
            return this.fileName;
        }

        public byte[] getContent() {
            return this.content;
        }

        public boolean isRegistryNotConfigured() {
            return this.registryNotConfigured;
        }
    }

    public static class ShipmentDocumentsData
    implements Serializable {
        private static final long serialVersionUID = -4011815693710475563L;
        private final EntityReference<Shipment> shipmentReference;
        private final List<FinanceDocumentData> financeDocuments;
        private final List<DocumentData> documents;
        private final ReportRegistryData reportRegistry;
        private final List<Message> messages;

        public ShipmentDocumentsData(EntityReference<Shipment> shipmentReference, List<FinanceDocumentData> financeDocuments, List<DocumentData> documents, ReportRegistryData reportRegistry, List<Message> messages) {
            this.shipmentReference = shipmentReference;
            this.financeDocuments = financeDocuments;
            this.documents = documents;
            this.reportRegistry = reportRegistry;
            this.messages = messages;
        }

        public EntityReference<Shipment> getShipmentReference() {
            return this.shipmentReference;
        }

        public List<FinanceDocumentData> getFinanceDocuments() {
            return this.financeDocuments;
        }

        public List<DocumentData> getDocuments() {
            return this.documents;
        }

        public ReportRegistryData getReportRegistry() {
            return this.reportRegistry;
        }

        public List<Message> getMessages() {
            return this.messages;
        }

        public static class DocumentData
        implements Serializable {
            private static final long serialVersionUID = -3011815693710475567L;
            private final EntityContainer<Document> container;
            private final int numberOfCopies;

            public DocumentData(EntityContainer<Document> container, int numberOfCopies) {
                this.container = Objects.requireNonNull(container);
                this.numberOfCopies = numberOfCopies;
            }

            public EntityContainer<Document> getContainer() {
                return this.container;
            }

            public int getNumberOfCopies() {
                return this.numberOfCopies;
            }
        }

        public static class FinanceDocumentData
        implements Serializable {
            private static final long serialVersionUID = -4011815693710475568L;
            private final EntityContainer<FinanceDocument> container;
            private final int numberOfCopies;

            public FinanceDocumentData(EntityContainer<FinanceDocument> container, int numberOfCopies) {
                this.container = Objects.requireNonNull(container);
                this.numberOfCopies = numberOfCopies;
            }

            public EntityContainer<FinanceDocument> getContainer() {
                return this.container;
            }

            public int getNumberOfCopies() {
                return this.numberOfCopies;
            }
        }
    }

    public static class FinanceDocumentsChangeSettings
    implements Serializable {
        private static final long serialVersionUID = -1955815693710475568L;
        private final EntityReference<Person> agent;
        private final boolean useDelegate;
        private final boolean useFacsimile;

        public EntityReference<Person> getAgent() {
            return this.agent;
        }

        public boolean isUseDelegate() {
            return this.useDelegate;
        }

        public boolean isUseFacsimile() {
            return this.useFacsimile;
        }

        public FinanceDocumentsChangeSettings(EntityReference<Person> agent, boolean useDelegate, boolean useFacsimile) {
            this.agent = agent;
            this.useDelegate = useDelegate;
            this.useFacsimile = useFacsimile;
        }
    }
}

