/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.fx.rpc;

import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.BlankType;
import com.gridnine.xtrip.common.model.booking.air.Tax;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.dict.MCOCategory;
import com.gridnine.xtrip.common.model.profile.Person;
import com.gridnine.xtrip.common.model.system.Money;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class ProductExchangeRefundProperties
implements Serializable {
    private final Date operationDate;
    private final EntityReference<Person> agent;
    private MCOCategory mcoCategory;
    private final boolean isForced;
    private final BigDecimal usedBaseFare;
    private final BigDecimal usedEquivFare;
    private BigDecimal baseFareAddition = BigDecimal.ZERO;
    private BigDecimal equivFareAddition = BigDecimal.ZERO;
    private final BigDecimal penalty;
    private final List<String> segmentDescriptions = new ArrayList<String>();
    private final List<Tax> taxes = new ArrayList<Tax>();
    private final List<Tax> taxesAddition = new ArrayList<Tax>();
    private final List<ExchangeRefundEMD> emds = new ArrayList<ExchangeRefundEMD>();
    private String emdReferenceNumber = null;
    private static final long serialVersionUID = 8927587404168941086L;

    private ProductExchangeRefundProperties(Date operationDate, EntityReference<Person> agent, boolean isForced, BigDecimal usedBaseFare, BigDecimal usedEquivFare, BigDecimal penalty, List<String> segmentUids, List<Tax> taxes) {
        this.operationDate = operationDate;
        this.agent = agent;
        this.isForced = isForced;
        this.usedBaseFare = usedBaseFare;
        this.usedEquivFare = usedEquivFare;
        this.penalty = penalty;
        this.segmentDescriptions.addAll(segmentUids);
        this.taxes.addAll(taxes);
    }

    public ProductExchangeRefundProperties(Date operationDate, EntityReference<Person> agent, boolean isForced, BigDecimal usedBaseFare, BigDecimal usedEquivFare, BigDecimal penalty, List<String> segmentUids, List<Tax> taxes, List<ExchangeRefundEMD> emds) {
        this(operationDate, agent, isForced, usedBaseFare, usedEquivFare, penalty, segmentUids, taxes);
        this.emds.addAll(emds);
    }

    public ProductExchangeRefundProperties(Date operationDate, EntityReference<Person> agent, MCOCategory mcoCategory, boolean isForced, BigDecimal usedBaseFare, BigDecimal usedEquivFare, BigDecimal baseFareAddition, BigDecimal equivFareAddition, BigDecimal penalty, List<String> segmentUids, List<Tax> taxes, List<Tax> taxesAdditional, List<ExchangeRefundEMD> emds) {
        this(operationDate, agent, isForced, usedBaseFare, usedEquivFare, penalty, segmentUids, taxes, emds);
        this.mcoCategory = mcoCategory;
        this.baseFareAddition = baseFareAddition;
        this.equivFareAddition = equivFareAddition;
        this.taxesAddition.addAll(taxesAdditional);
    }

    public ProductExchangeRefundProperties(Date operationDate, EntityReference<Person> agent, boolean isForced, BigDecimal usedBaseFare, BigDecimal usedEquivFare, BigDecimal penalty, List<String> segmentUids, List<Tax> taxes, List<ExchangeRefundEMD> emdPenalty, String emdReferenceNumber) {
        this(operationDate, agent, isForced, usedBaseFare, usedEquivFare, penalty, segmentUids, taxes);
        this.emds.addAll(emdPenalty);
        this.emdReferenceNumber = emdReferenceNumber;
    }

    public Date getOperationDate() {
        return this.operationDate;
    }

    public EntityReference<Person> getAgent() {
        return this.agent;
    }

    public MCOCategory getMcoCategory() {
        return this.mcoCategory;
    }

    public boolean isForced() {
        return this.isForced;
    }

    public BigDecimal getUsedBaseFare() {
        return this.usedBaseFare;
    }

    public BigDecimal getUsedEquivFare() {
        return this.usedEquivFare;
    }

    public BigDecimal getPenalty() {
        return this.penalty;
    }

    public List<String> getSegmentDescriptions() {
        return this.segmentDescriptions;
    }

    public List<ExchangeRefundEMD> getEmds() {
        return this.emds;
    }

    public List<Tax> getTaxes() {
        return this.taxes;
    }

    public String getEmdReferenceNumber() {
        return this.emdReferenceNumber;
    }

    public BigDecimal getBaseFareAddition() {
        return this.baseFareAddition;
    }

    public BigDecimal getEquivFareAddition() {
        return this.equivFareAddition;
    }

    public List<Tax> getTaxesAddition() {
        return this.taxesAddition;
    }

    public static class ExchangeRefundEMD
    implements Serializable {
        private static final long serialVersionUID = 6739670107747656608L;
        private final String systemNumber;
        private final Money baseAmount;
        private final BigDecimal equivAmount;
        private final MCOCategory category;
        private final DictionaryReference<BlankType> blankTypeRef;

        public ExchangeRefundEMD(String systemNumber, BigDecimal baseAmount, String currency, BigDecimal equivAmount, MCOCategory category, DictionaryReference<BlankType> blankTypeRef) {
            this.systemNumber = systemNumber;
            Money money = new Money();
            money.setValue(baseAmount);
            money.setCurrency(currency);
            this.baseAmount = money;
            this.equivAmount = equivAmount;
            this.category = category;
            this.blankTypeRef = blankTypeRef;
        }

        public String getSystemNumber() {
            return this.systemNumber;
        }

        public Money getBaseAmount() {
            return this.baseAmount;
        }

        public BigDecimal getEquivAmount() {
            return this.equivAmount;
        }

        public MCOCategory getCategory() {
            return this.category;
        }

        public DictionaryReference<BlankType> getBlankTypeRef() {
            return this.blankTypeRef;
        }
    }
}

