/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.gds.helper;

import com.gridnine.xtrip.common.gds.model.GdsValidationMessages;
import com.gridnine.xtrip.common.model.validation.ValidationMessage;
import java.util.Collection;
import java.util.Date;
import org.joda.time.DateTime;
import org.joda.time.Period;
import org.joda.time.PeriodType;
import org.joda.time.ReadableInstant;

public class AgeRestriction {
    private final Integer minAge;
    private final Boolean minAgeStrict;
    private final Integer maxAge;
    private final Boolean maxAgeStrict;

    public AgeRestriction(Integer minAge, Boolean minAgeStrict, Integer maxAge, Boolean maxAgeStrict) {
        this.minAge = minAge;
        this.minAgeStrict = minAgeStrict;
        this.maxAge = maxAge;
        this.maxAgeStrict = maxAgeStrict;
    }

    public void validate(Date birthDate, Date calcDate, Collection<ValidationMessage> vms) {
        Period period = new Period((ReadableInstant)new DateTime((Object)birthDate), (ReadableInstant)new DateTime((Object)calcDate), PeriodType.yearDay());
        int years = period.getYears();
        int days = period.getDays();
        if (this.minAge != null && (years < this.minAge || years == this.minAge && days == 0 && this.minAgeStrict != null && this.minAgeStrict.booleanValue())) {
            vms.add(GdsValidationMessages.getInvalidBirthdayMinYears((Integer)this.minAge));
        }
        if (this.maxAge != null && (years > this.maxAge || years == this.maxAge && (days > 0 || this.maxAgeStrict.booleanValue()))) {
            vms.add(GdsValidationMessages.getInvalidBirthdayMaxYears((Integer)this.maxAge));
        }
    }

    public Integer getMinAge() {
        return this.minAge;
    }

    public Boolean getMinAgeStrict() {
        return this.minAgeStrict;
    }

    public Integer getMaxAge() {
        return this.maxAge;
    }

    public Boolean getMaxAgeStrict() {
        return this.maxAgeStrict;
    }
}

