/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.gds.helper;

import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.ReservationRemark;
import com.gridnine.xtrip.common.model.standard.helpers.NamedValueHelper;
import com.gridnine.xtrip.common.model.system.NamedValue;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;

public class CommonGdsHelper {
    public static List<ReservationRemark> convertToReservationRemarks(List<NamedValue> customProperties) {
        if (customProperties.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<ReservationRemark> result = new ArrayList<ReservationRemark>();
        Date now = new Date();
        for (NamedValue nv : customProperties) {
            result.add(CommonGdsHelper.createReservationRemark(nv.getName(), nv.getValue(), now));
        }
        return result;
    }

    public static List<NamedValue> convertReservationRemarksToNamedValues(List<ReservationRemark> remarks) {
        if (remarks.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<NamedValue> result = new ArrayList<NamedValue>();
        remarks.forEach(remark -> result.add(NamedValueHelper.namedValue((String)remark.getQualifier(), (String)remark.getRemarkText())));
        return result;
    }

    public static ReservationRemark createReservationRemark(String qualifier, String remarkText) {
        return CommonGdsHelper.createReservationRemark(qualifier, remarkText, new Date());
    }

    public static ReservationRemark createReservationRemark(String qualifier, String remarkText, Date remarkDate) {
        ReservationRemark remark = new ReservationRemark();
        remark.setQualifier(qualifier);
        remark.setRemarkText(remarkText);
        remark.setRemarkDate(remarkDate);
        return remark;
    }

    public static ReservationRemark findReservationRemark(Reservation res, String qualifier) {
        if (qualifier == null) {
            return null;
        }
        for (ReservationRemark rm : res.getReservationRemarks()) {
            if (!qualifier.equals(rm.getQualifier())) continue;
            return rm;
        }
        return null;
    }

    public static String getReservationRemarkValue(Reservation res, String qualifier) {
        ReservationRemark remark = CommonGdsHelper.findReservationRemark(res, qualifier);
        return remark == null ? null : remark.getRemarkText();
    }
}

