/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.gds.helper;

import com.gridnine.xtrip.common.gds.helper.FlightSegmentIterator;
import com.gridnine.xtrip.common.gds.model.AncillaryFee;
import com.gridnine.xtrip.common.gds.model.CardGdsCommission;
import com.gridnine.xtrip.common.gds.model.FareInfo;
import com.gridnine.xtrip.common.gds.model.Flight;
import com.gridnine.xtrip.common.gds.model.FlightFare;
import com.gridnine.xtrip.common.gds.model.FlightMultiTicketItem;
import com.gridnine.xtrip.common.gds.model.FlightPassengerTypeData;
import com.gridnine.xtrip.common.gds.model.FlightPenalty;
import com.gridnine.xtrip.common.gds.model.FlightSegment;
import com.gridnine.xtrip.common.gds.model.FlightSegmentTariff;
import com.gridnine.xtrip.common.gds.model.FlightTax;
import com.gridnine.xtrip.common.gds.model.GdsCommission;
import com.gridnine.xtrip.common.gds.model.GdsContractRelationData;
import com.gridnine.xtrip.common.gds.model.RouteSegment;
import com.gridnine.xtrip.common.gds.model.SeatPreferences;
import com.gridnine.xtrip.common.l10n.model.LocaleManager;
import com.gridnine.xtrip.common.midoffice.model.AncillaryFeeContractRelationData;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.booking.BaseCommission;
import com.gridnine.xtrip.common.model.booking.ExpiryWarningTime;
import com.gridnine.xtrip.common.model.booking.PassengerType;
import com.gridnine.xtrip.common.model.booking.SalesChain;
import com.gridnine.xtrip.common.model.booking.SimpleTax;
import com.gridnine.xtrip.common.model.booking.TimeLimitType;
import com.gridnine.xtrip.common.model.booking.air.Commission;
import com.gridnine.xtrip.common.model.booking.commission.BaseCommissionProperties;
import com.gridnine.xtrip.common.model.booking.commission.CommissionProperties;
import com.gridnine.xtrip.common.model.booking.commission.DiscountProperties;
import com.gridnine.xtrip.common.model.booking.commission.FeeProperties;
import com.gridnine.xtrip.common.model.booking.commission.PaymentFeeProperties;
import com.gridnine.xtrip.common.model.dict.Airline;
import com.gridnine.xtrip.common.model.dict.ClassOfService;
import com.gridnine.xtrip.common.model.dict.ClassOfServiceCode;
import com.gridnine.xtrip.common.model.dict.ContractType;
import com.gridnine.xtrip.common.model.dict.DictionaryCache;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.dict.GeoLocation;
import com.gridnine.xtrip.common.model.dict.PreferenceKey;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.helpers.BookingHelper;
import com.gridnine.xtrip.common.model.helpers.DictHelper;
import com.gridnine.xtrip.common.model.helpers.GeneralProductHelper;
import com.gridnine.xtrip.common.model.helpers.GeoLocationHelper;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.profile.PredefinedContractorType;
import com.gridnine.xtrip.common.util.DateTimeConverter;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.Pair;
import com.gridnine.xtrip.common.util.Streams;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.common.util.XCloneHelper;
import com.gridnine.xtrip.common.util.XCloneable;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.time.Duration;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.TimeZone;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.time.FastDateFormat;
import org.joda.time.LocalDate;

public class FlightHelper {
    private static final FastDateFormat DF = FastDateFormat.getInstance((String)"dd.MM.yyyy");

    public static BigDecimal getEquivalentFareOfClientRelation(Flight flight, DictionaryReference<PassengerType> passengerType) {
        GdsContractRelationData relation = FlightHelper.findClientRelation(flight, passengerType);
        if (relation == null) {
            return BigDecimal.ZERO;
        }
        return relation.getServiceData().getDetalization().getFare();
    }

    public static List<SimpleTax> getTaxesOfClientRelation(Flight flight, DictionaryReference<PassengerType> passengerType) {
        GdsContractRelationData relation = FlightHelper.findClientRelation(flight, passengerType);
        if (relation == null) {
            return Collections.emptyList();
        }
        return relation.getServiceData().getDetalization().getTaxes();
    }

    private static GdsContractRelationData findClientRelation(Flight flight, DictionaryReference<PassengerType> passengerType) {
        for (Map.Entry item : flight.getContractRelations().entrySet()) {
            if (!passengerType.equals(item.getKey())) continue;
            return FlightHelper.findContractRelation((List)item.getValue(), ContractType.CLIENT);
        }
        return null;
    }

    public static BigDecimal getEquivalentFare(Flight flight, DictionaryReference<PassengerType> passengerType) {
        BigDecimal result = BigDecimal.ZERO;
        for (FlightFare fare : flight.getFares()) {
            if (!MiscUtil.equals((Object)fare.getPassengerType(), passengerType)) continue;
            result = result.add(fare.getEquivalentAmount());
        }
        return result;
    }

    public static BigDecimal getEquivalentPenalty(Flight flight, DictionaryReference<PassengerType> passengerType) {
        BigDecimal result = BigDecimal.ZERO;
        for (FlightPenalty flightPenalty : flight.getExchangeData().getPenalties()) {
            if (!MiscUtil.equals((Object)flightPenalty.getPassengerType(), passengerType)) continue;
            result = result.add(flightPenalty.getEquivalentAmount());
        }
        return result;
    }

    public static BigDecimal getEquivalentTaxSum(Flight flight, DictionaryReference<PassengerType> passengerType) {
        return FlightHelper.getEquivalentTaxSum(flight, passengerType, true);
    }

    public static BigDecimal getEquivalentTaxSum(Flight flight, DictionaryReference<PassengerType> passengerType, boolean isIncludingHiddenFees) {
        BigDecimal result = BigDecimal.ZERO;
        for (FlightTax tax : flight.getTaxes()) {
            if (!MiscUtil.equals((Object)tax.getPassengerType(), passengerType)) continue;
            result = result.add(tax.getEquivalentAmount());
        }
        if (isIncludingHiddenFees) {
            result = result.add(FlightHelper.getEquivalentHiddenFee(flight, passengerType));
        }
        return result;
    }

    public static BigDecimal getEquivalentFee(Flight flight, DictionaryReference<PassengerType> passengerType) {
        BigDecimal result = BigDecimal.ZERO;
        for (CardGdsCommission fee : FlightHelper.getCardFees(flight, ContractType.CLIENT)) {
            if (!MiscUtil.equals((Object)fee.getPassengerType(), passengerType)) continue;
            result = result.add(fee.getEquivalentAmount());
        }
        return result;
    }

    private static BigDecimal getEquivalentHiddenFee(Flight flight, DictionaryReference<PassengerType> passengerType) {
        BigDecimal result = BigDecimal.ZERO;
        for (CardGdsCommission fee : FlightHelper.getCardFees(flight, ContractType.CLIENT)) {
            BaseCommissionProperties commProp;
            EntityReference<? extends BaseCommissionProperties> commPropRef;
            if (!MiscUtil.equals((Object)fee.getPassengerType(), passengerType) || (commPropRef = FlightHelper.getGdsCommissionProperties(fee)) == null || !((commProp = (BaseCommissionProperties)EntityStorage.get().resolve(commPropRef).getEntity()) instanceof FeeProperties) || !((FeeProperties)commProp).isHidden()) continue;
            result = result.add(fee.getEquivalentAmount());
        }
        return result;
    }

    private static EntityReference<? extends BaseCommissionProperties> getGdsCommissionProperties(CardGdsCommission fee) {
        return fee.getSource() != null ? fee.getSource().getCommissionProperties() : fee.getCommissionProperties();
    }

    public static Commission getTotalVendorCommission(Flight flight, DictionaryReference<PassengerType> passengerType) {
        EntityContainer blankOwnerCtr = EntityStorage.get().resolve(flight.getBlankOwner());
        if (blankOwnerCtr == null) {
            return null;
        }
        boolean bsp = "BSP".equals(((Organization)blankOwnerCtr.getEntity()).getCode());
        return FlightHelper.getTotalVendorCommission(flight, passengerType, bsp);
    }

    public static Commission getTotalVendorNonBspCommission(Flight flight, DictionaryReference<PassengerType> passengerType) {
        List<GdsCommission> commissions = FlightHelper.getGdsCommissions(flight, passengerType);
        commissions.removeIf(comm -> BookingHelper.isBSPCommission((EntityReference)comm.getCommissionProperties()));
        if (commissions.isEmpty()) {
            return null;
        }
        BaseCommission commission = (BaseCommission)commissions.get(0);
        Commission result = new Commission();
        result.setAmount(commission.getAmount());
        result.setEquivalentAmount(commission.getEquivalentAmount());
        result.setRate(commission.getRate());
        return result;
    }

    private static Commission getTotalVendorCommission(Flight flight, DictionaryReference<PassengerType> passengerType, boolean bsp) {
        List<GdsCommission> commissions = FlightHelper.getGdsCommissions(flight, passengerType);
        EntityContainer supplierCtr = EntityStorage.get().resolve(GeneralProductHelper.getContractor((SalesChain)flight.getSalesChain(), (PredefinedContractorType)PredefinedContractorType.SUPPLIER));
        boolean supplierIsBsp = supplierCtr != null && "BSP".equals(((Organization)supplierCtr.getEntity()).getCode());
        return BookingHelper.getTotalVendorCommission(commissions, (boolean)bsp, (boolean)supplierIsBsp);
    }

    private static List<GdsCommission> getGdsCommissions(Flight flight, DictionaryReference<PassengerType> passengerType) {
        ArrayList<GdsCommission> commissions = new ArrayList<GdsCommission>();
        for (GdsCommission comm : FlightHelper.getGdsCommissions(flight, ContractType.VENDOR, passengerType)) {
            if (comm.getCommissionProperties() != null && !CommissionProperties.class.getName().equals(comm.getCommissionProperties().getType().getName())) continue;
            commissions.add(comm);
        }
        return commissions;
    }

    public static BigDecimal getCommissionAmount(Flight flight, ContractType cType, Map<DictionaryReference<PassengerType>, Integer> passengers) {
        BigDecimal result = BigDecimal.ZERO;
        for (Map.Entry<DictionaryReference<PassengerType>, Integer> entry : passengers.entrySet()) {
            DictionaryReference<PassengerType> passType = entry.getKey();
            Collection<Object> commissions = FlightHelper.getGdsCommissions(flight, cType, passType);
            commissions = GeneralProductHelper.filterCommissions(commissions, (Set)GeneralProductHelper.commissionPropertyTypes, null, null);
            Integer value = passengers.get(passType);
            for (GdsCommission gdsCommission : commissions) {
                result = result.add(gdsCommission.getEquivalentAmount().multiply(BigDecimal.valueOf(value.longValue())));
            }
        }
        return result;
    }

    public static DictionaryReference<GeoLocation> getFinalDestinationLocationRef(Flight flight) {
        return FlightHelper.getFinalDestinationLocationRef(flight.getSegmentTariffs());
    }

    private static DictionaryReference<GeoLocation> getFinalDestinationLocationRef(List<FlightSegmentTariff> flightSegmentTariffs) {
        DictionaryCache dictionaryCache = DictionaryCache.get();
        DictionaryReference segmentStartLocationRef = null;
        DictionaryReference segmentEndLocationRef = null;
        DictionaryReference farthestLocationRef = null;
        int startingSegmentNumber = 1;
        GeoLocation startingLocation = null;
        Iterator<FlightSegmentTariff> fstIterator = flightSegmentTariffs.iterator();
        while (fstIterator.hasNext()) {
            FlightSegmentTariff fst = fstIterator.next();
            Iterator fsIterator = fst.getSegments().iterator();
            while (fsIterator.hasNext()) {
                int numLoopsNeeded;
                FlightSegment fs = (FlightSegment)fsIterator.next();
                if (startingLocation == null) {
                    segmentStartLocationRef = fs.getLocationBegin();
                    segmentEndLocationRef = fs.getLocationEnd();
                    startingLocation = (GeoLocation)dictionaryCache.resolveReference(segmentStartLocationRef);
                    if (fsIterator.hasNext() || fstIterator.hasNext()) continue;
                    farthestLocationRef = segmentEndLocationRef;
                    continue;
                }
                if (fs.isStarting()) {
                    ++startingSegmentNumber;
                    numLoopsNeeded = !fsIterator.hasNext() && !fstIterator.hasNext() ? 2 : 1;
                } else {
                    segmentEndLocationRef = fs.getLocationEnd();
                    numLoopsNeeded = fsIterator.hasNext() || fstIterator.hasNext() ? 0 : 1;
                }
                while (numLoopsNeeded > 0) {
                    if (farthestLocationRef == null) {
                        farthestLocationRef = segmentEndLocationRef;
                    } else {
                        GeoLocation segmentStartLocation = (GeoLocation)dictionaryCache.resolveReference(segmentStartLocationRef);
                        GeoLocation segmentEndLocation = (GeoLocation)dictionaryCache.resolveReference(segmentEndLocationRef);
                        if (startingSegmentNumber != 2 || !segmentStartLocation.equals((Object)dictionaryCache.resolveReference(farthestLocationRef)) || !segmentEndLocation.equals((Object)startingLocation)) {
                            return null;
                        }
                    }
                    segmentStartLocationRef = fs.getLocationBegin();
                    segmentEndLocationRef = fs.getLocationEnd();
                    --numLoopsNeeded;
                }
            }
        }
        return farthestLocationRef;
    }

    public static ClassOfService getClassOfService(FlightSegment fs) {
        ClassOfServiceCode classOfServiceCode;
        ClassOfService segmentClass = fs.getServiceClass();
        if (segmentClass == null && (classOfServiceCode = DictHelper.findClassOfServiceCode((DictionaryReference)fs.getAirline(), (DictionaryReference)fs.getOperatingAirline(), (String)fs.getBookingClass(), (boolean)DictHelper.isInternational((DictionaryReference)fs.getLocationBegin(), (DictionaryReference)fs.getLocationEnd()))) != null) {
            segmentClass = classOfServiceCode.getClassOfService();
        }
        return segmentClass;
    }

    public static Comparator<Flight> getFlightComparator() {
        return (thisFlight, otherFlight) -> {
            int result = thisFlight.getCarrier().getCode().compareTo(otherFlight.getCarrier().getCode());
            if (result != 0) {
                return result;
            }
            List thisFstList = thisFlight.getSegmentTariffs();
            List otherFstList = otherFlight.getSegmentTariffs();
            result = thisFstList.size() - otherFstList.size();
            if (result != 0) {
                return result;
            }
            Iterator thisFstItr = thisFstList.iterator();
            Iterator otherFstItr = otherFstList.iterator();
            while (thisFstItr.hasNext()) {
                result = ((FlightSegmentTariff)thisFstItr.next()).getSegments().size() - ((FlightSegmentTariff)otherFstItr.next()).getSegments().size();
                if (result == 0) continue;
                return result;
            }
            thisFstItr = thisFstList.iterator();
            otherFstItr = otherFstList.iterator();
            while (thisFstItr.hasNext()) {
                Iterator thisFsItr = ((FlightSegmentTariff)thisFstItr.next()).getSegments().iterator();
                Iterator otherFsItr = ((FlightSegmentTariff)otherFstItr.next()).getSegments().iterator();
                while (thisFsItr.hasNext()) {
                    FlightSegment thisFs = (FlightSegment)thisFsItr.next();
                    FlightSegment otherFs = (FlightSegment)otherFsItr.next();
                    result = thisFs.getFlightNumber().compareTo(otherFs.getFlightNumber());
                    if (result != 0) {
                        return result;
                    }
                    result = thisFs.getAirline().getCode().compareTo(otherFs.getAirline().getCode());
                    if (result != 0) {
                        return result;
                    }
                    result = thisFs.getOperatingAirline().getCode().compareTo(otherFs.getOperatingAirline().getCode());
                    if (result != 0) {
                        return result;
                    }
                    if (thisFs.getServiceClass() == null) {
                        if (otherFs.getServiceClass() == null) continue;
                        return Integer.MIN_VALUE;
                    }
                    if (otherFs.getServiceClass() == null) {
                        return Integer.MAX_VALUE;
                    }
                    result = thisFs.getServiceClass().compareTo((Enum)otherFs.getServiceClass());
                    if (result == 0) continue;
                    return result;
                }
            }
            return result;
        };
    }

    @Deprecated
    public static boolean areSameFlights(Flight thisFlight, Flight otherFlight) {
        return FlightHelper.areSameFlights(thisFlight, otherFlight, false);
    }

    public static boolean areSameFlights(Flight thisFlight, Flight otherFlight, boolean disregardSegmentTariffGrouping) {
        List otherFsList;
        List thisFsList;
        if (!thisFlight.getCarrier().equals((Object)otherFlight.getCarrier())) {
            return false;
        }
        List thisFstList = thisFlight.getSegmentTariffs();
        List otherFstList = otherFlight.getSegmentTariffs();
        if (thisFstList.size() != otherFstList.size()) {
            if (disregardSegmentTariffGrouping) {
                Iterator thisFstItr = thisFstList.iterator();
                Iterator otherFstItr = otherFstList.iterator();
                int thisTotalNumSegments = 0;
                int otherTotalNumSegments = 0;
                while (thisFstItr.hasNext()) {
                    thisTotalNumSegments += ((FlightSegmentTariff)thisFstItr.next()).getSegments().size();
                }
                if (otherFstItr.hasNext()) {
                    otherTotalNumSegments += ((FlightSegmentTariff)otherFstItr.next()).getSegments().size();
                }
                if (thisTotalNumSegments != otherTotalNumSegments) {
                    return false;
                }
                return FlightHelper.hasEqualSegments(thisFstList, otherFstList);
            }
            return false;
        }
        if (thisFstList.size() == 0) {
            return true;
        }
        Iterator thisFstItr = thisFstList.iterator();
        Iterator otherFstItr = otherFstList.iterator();
        while (thisFstItr.hasNext()) {
            thisFsList = ((FlightSegmentTariff)thisFstItr.next()).getSegments();
            otherFsList = ((FlightSegmentTariff)otherFstItr.next()).getSegments();
            if (thisFsList.size() == otherFsList.size()) continue;
            if (disregardSegmentTariffGrouping) {
                return FlightHelper.hasEqualSegments(thisFstList, otherFstList);
            }
            return false;
        }
        thisFstItr = thisFstList.iterator();
        otherFstItr = otherFstList.iterator();
        while (thisFstItr.hasNext()) {
            thisFsList = ((FlightSegmentTariff)thisFstItr.next()).getSegments();
            otherFsList = ((FlightSegmentTariff)otherFstItr.next()).getSegments();
            for (int j = 0; j < thisFsList.size(); ++j) {
                FlightSegment otherFs;
                FlightSegment thisFs = (FlightSegment)thisFsList.get(j);
                if (FlightHelper.areEqualSegments(thisFs, otherFs = (FlightSegment)otherFsList.get(j))) continue;
                return false;
            }
        }
        return true;
    }

    private static boolean hasEqualSegments(List<FlightSegmentTariff> thisFstList, List<FlightSegmentTariff> otherFstList) {
        FlightSegmentIterator thisItr = new FlightSegmentIterator(thisFstList);
        FlightSegmentIterator otherItr = new FlightSegmentIterator(otherFstList);
        while (thisItr.hasNext()) {
            FlightSegment thisFs = thisItr.next();
            if (!otherItr.hasNext()) {
                return false;
            }
            FlightSegment otherFs = otherItr.next();
            if (FlightHelper.areEqualSegments(thisFs, otherFs)) continue;
            return false;
        }
        return true;
    }

    private static boolean areEqualSegments(FlightSegment thisFs, FlightSegment otherFs) {
        if (!thisFs.getFlightNumber().equals(otherFs.getFlightNumber())) {
            return false;
        }
        if (!thisFs.getAirline().equals((Object)otherFs.getAirline())) {
            return false;
        }
        return thisFs.getServiceClass() == otherFs.getServiceClass();
    }

    public static FlightSegment getFirstSegment(Flight flight) {
        List fsList;
        List fstList = flight.getSegmentTariffs();
        if (!fstList.isEmpty() && !(fsList = ((FlightSegmentTariff)fstList.get(0)).getSegments()).isEmpty()) {
            return (FlightSegment)fsList.get(0);
        }
        return null;
    }

    public static Date getFirstDepartureTime(Flight flight) {
        FlightSegment fs = FlightHelper.getFirstSegment(flight);
        return fs != null ? fs.getDateBegin() : null;
    }

    public static Date getFirstArrivalTime(Flight flight) {
        FlightSegment fs = FlightHelper.getFirstSegment(flight);
        return fs != null ? fs.getDateEnd() : null;
    }

    public static FlightSegment getLastSegment(Flight flight) {
        List fsList;
        List fstList = flight.getSegmentTariffs();
        if (!fstList.isEmpty() && !(fsList = ((FlightSegmentTariff)fstList.get(fstList.size() - 1)).getSegments()).isEmpty()) {
            return (FlightSegment)fsList.get(fsList.size() - 1);
        }
        return null;
    }

    public static Date getLastDepartureTime(Flight flight) {
        FlightSegment fs = FlightHelper.getLastSegment(flight);
        return fs != null ? fs.getDateBegin() : null;
    }

    public static Date getLastArrivalTime(Flight flight) {
        FlightSegment fs = FlightHelper.getLastSegment(flight);
        return fs != null ? fs.getDateEnd() : null;
    }

    public static boolean isDomestic(Flight flight) {
        DictionaryReference geoLoc = null;
        for (FlightSegmentTariff fst : flight.getSegmentTariffs()) {
            for (FlightSegment fs : fst.getSegments()) {
                if (geoLoc != fs.getLocationBegin() && !GeoLocationHelper.isDomestic((DictionaryReference)(geoLoc = fs.getLocationBegin()))) {
                    return false;
                }
                geoLoc = fs.getLocationEnd();
                if (GeoLocationHelper.isDomestic((DictionaryReference)geoLoc)) continue;
                return false;
            }
        }
        return true;
    }

    public static String buildFlightNumbersString(Flight flight) {
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
        StringBuilder sb = new StringBuilder();
        FlightHelper.getSegments(flight).forEach(fs -> {
            if (sb.length() > 0) {
                sb.append('|');
            }
            sb.append(fs.getAirline().getCode());
            sb.append(fs.getFlightNumber());
            sb.append('/');
            sb.append(df.format(fs.getDateBegin()));
        });
        return sb.toString();
    }

    public static String toString(Flight flight) {
        StringBuilder sb = new StringBuilder(128);
        sb.append("Flight[");
        sb.append(flight.getCarrier());
        sb.append(": ");
        for (FlightSegmentTariff fst : flight.getSegmentTariffs()) {
            for (FlightSegment fs : fst.getSegments()) {
                sb.append(fs.getAirline() == null ? "?" : fs.getAirline().getCode());
                DictionaryReference operatingAirline = fs.getOperatingAirline();
                if (operatingAirline != null && operatingAirline != fs.getAirline()) {
                    sb.append('(');
                    sb.append(operatingAirline.getCode());
                    sb.append(')');
                }
                sb.append(fs.getFlightNumber());
                sb.append('(');
                sb.append(fs.getLocationBegin().getCode());
                sb.append('-');
                sb.append(fs.getLocationEnd().getCode());
                sb.append(") ");
                sb.append("{SC: ");
                sb.append(fs.getServiceClass());
                sb.append("} ");
            }
        }
        sb.append("]");
        return sb.toString();
    }

    public static GdsCommission buildGdsCommission(Commission comm, DictionaryReference<PassengerType> passengerType) {
        GdsCommission gdsComm = new GdsCommission();
        gdsComm.setRate(comm.getRate());
        gdsComm.setAmount(comm.getAmount());
        gdsComm.setEquivalentAmount(comm.getEquivalentAmount());
        gdsComm.setCommissionProperties(comm.getCommissionProperties());
        gdsComm.setContractType(comm.getContractType());
        return gdsComm;
    }

    public static List<SimpleTax> buildSimpleTaxes(Flight flight, DictionaryReference<PassengerType> passengerType) {
        ArrayList<SimpleTax> taxes = new ArrayList<SimpleTax>();
        for (FlightTax tax : flight.getTaxes()) {
            if (!MiscUtil.equals(passengerType, (Object)tax.getPassengerType())) continue;
            SimpleTax simpleTax = new SimpleTax();
            simpleTax.setCode(tax.getCode());
            simpleTax.setAmount(tax.getEquivalentAmount());
            taxes.add(simpleTax);
        }
        return taxes;
    }

    public static Collection<CardGdsCommission> getCardFees(Flight flight, ContractType contractType) {
        return FlightHelper.getCardCommissions(flight, contractType, GeneralProductHelper.feePropertyTypes);
    }

    public static Collection<CardGdsCommission> getCardCommissions(Flight flight, ContractType contractType, Set<Class<? extends BaseCommissionProperties>> properties) {
        Map<DictionaryReference<PassengerType>, GdsContractRelationData> contractRelations = FlightHelper.getContractRelations(flight, contractType);
        ArrayList<CardGdsCommission> result = new ArrayList<CardGdsCommission>();
        for (Map.Entry<DictionaryReference<PassengerType>, GdsContractRelationData> entry : contractRelations.entrySet()) {
            for (GdsCommission comm : entry.getValue().getCommissions()) {
                result.add(FlightHelper.buildCardGdsCommission(comm, entry.getKey()));
            }
        }
        return GeneralProductHelper.filterCommissions(result, properties, null, null);
    }

    private static CardGdsCommission buildCardGdsCommission(GdsCommission comm, DictionaryReference<PassengerType> passengerType) {
        CardGdsCommission oldComm = new CardGdsCommission();
        oldComm.setAmount(comm.getAmount());
        oldComm.setCommissionProperties(comm.getCommissionProperties());
        oldComm.setContractType(comm.getContractType());
        oldComm.setEquivalentAmount(comm.getEquivalentAmount());
        oldComm.setPassengerType(passengerType);
        oldComm.setRate(comm.getRate());
        oldComm.setSource(comm.getSource());
        return oldComm;
    }

    public static Collection<GdsCommission> getFees(Flight flight, ContractType contractType) {
        List<GdsCommission> commissions = FlightHelper.getGdsCommissions(flight, contractType);
        return GeneralProductHelper.filterCommissions(commissions, (Set)GeneralProductHelper.feePropertyTypes, null, null);
    }

    public static Collection<GdsCommission> getFees(Flight flight, ContractType contractType, DictionaryReference<PassengerType> passengerType) {
        return FlightHelper.getFees(flight, contractType, passengerType, false);
    }

    public static Collection<GdsCommission> getFees(Flight flight, ContractType contractType, DictionaryReference<PassengerType> passengerType, boolean includeNullPassengerType) {
        List<GdsCommission> commissions = FlightHelper.getGdsCommissions(flight, contractType, passengerType);
        if (includeNullPassengerType) {
            commissions.addAll(FlightHelper.getGdsCommissions(flight, contractType, null));
        }
        return GeneralProductHelper.filterCommissions(commissions, (Set)GeneralProductHelper.feePropertyTypes, null, null);
    }

    public static List<GdsCommission> getGdsCommissions(Flight flight, ContractType contractType) {
        Map<DictionaryReference<PassengerType>, GdsContractRelationData> contractRelations = FlightHelper.getContractRelations(flight, contractType);
        ArrayList<GdsCommission> result = new ArrayList<GdsCommission>();
        for (GdsContractRelationData data : contractRelations.values()) {
            result.addAll(data.getCommissions());
        }
        return result;
    }

    public static List<GdsCommission> getGdsCommissionsForAllContracts(Flight flight, DictionaryReference<PassengerType> passengerType) {
        ArrayList<GdsCommission> result = new ArrayList<GdsCommission>();
        if (flight.getContractRelations() != null) {
            for (Map.Entry entry : flight.getContractRelations().entrySet()) {
                if (!MiscUtil.equals(entry.getKey(), passengerType)) continue;
                for (GdsContractRelationData data : (List)entry.getValue()) {
                    result.addAll(data.getCommissions());
                }
            }
        }
        return result;
    }

    public static List<GdsCommission> getGdsCommissions(Flight flight, ContractType contractType, DictionaryReference<PassengerType> passengerType) {
        List<GdsContractRelationData> contractRelations = FlightHelper.getContractRelations(flight, contractType, passengerType);
        ArrayList<GdsCommission> result = new ArrayList<GdsCommission>();
        for (GdsContractRelationData data : contractRelations) {
            result.addAll(data.getCommissions());
        }
        return result;
    }

    public static List<GdsContractRelationData> getContractRelations(Flight flight, ContractType contractType, DictionaryReference<PassengerType> passengerType) {
        ArrayList<GdsContractRelationData> result = new ArrayList<GdsContractRelationData>();
        Map<DictionaryReference<PassengerType>, GdsContractRelationData> contractRelations = FlightHelper.getContractRelations(flight, contractType);
        for (Map.Entry<DictionaryReference<PassengerType>, GdsContractRelationData> entry : contractRelations.entrySet()) {
            if (!MiscUtil.equals(entry.getKey(), passengerType)) continue;
            result.add(entry.getValue());
        }
        return result;
    }

    public static GdsContractRelationData getContractRelation(Flight flight, ContractType contractType, DictionaryReference<PassengerType> passengerType) {
        Map<DictionaryReference<PassengerType>, GdsContractRelationData> contractRelations = FlightHelper.getContractRelations(flight, contractType);
        return contractRelations.get(passengerType);
    }

    public static Map<DictionaryReference<PassengerType>, GdsContractRelationData> getContractRelations(Flight flight, ContractType contractType) {
        LinkedHashMap<DictionaryReference<PassengerType>, GdsContractRelationData> result = new LinkedHashMap<DictionaryReference<PassengerType>, GdsContractRelationData>();
        if (flight.getContractRelations() != null) {
            for (Map.Entry entry : flight.getContractRelations().entrySet()) {
                GdsContractRelationData data = FlightHelper.findContractRelation((List)entry.getValue(), contractType);
                if (data == null) continue;
                result.put((DictionaryReference<PassengerType>)entry.getKey(), data);
            }
        }
        return result;
    }

    public static GdsContractRelationData findContractRelation(List<GdsContractRelationData> relations, ContractType type) {
        for (GdsContractRelationData relation : relations) {
            if (GeneralProductHelper.getContractType((EntityReference)relation.getDescription()) != type) continue;
            return relation;
        }
        return null;
    }

    public static void mergeContractRelations(Flight original, Flight part) throws Exception {
        if (part.getContractRelations() != null) {
            for (Map.Entry entry : part.getContractRelations().entrySet()) {
                if (!original.getContractRelations().containsKey(entry.getKey())) {
                    original.getContractRelations().put(entry.getKey(), new ArrayList());
                }
                List existRelations = (List)original.getContractRelations().get(entry.getKey());
                for (GdsContractRelationData data : (List)entry.getValue()) {
                    GdsContractRelationData originalData = null;
                    for (GdsContractRelationData existData : existRelations) {
                        if (GeneralProductHelper.getContractType((EntityReference)data.getDescription()) != GeneralProductHelper.getContractType((EntityReference)existData.getDescription())) continue;
                        originalData = existData;
                        break;
                    }
                    if (originalData == null) {
                        existRelations.add(XCloneHelper.clone((XCloneable)data, (boolean)true));
                        continue;
                    }
                    originalData.getCommissions().addAll(data.getCommissions());
                    originalData.getServiceData().getDetalization().getTaxes().addAll(data.getServiceData().getDetalization().getTaxes());
                    BigDecimal fare = originalData.getServiceData().getDetalization().getFare();
                    BigDecimal total = MiscUtil.guarded((BigDecimal)originalData.getServiceData().getTotalPrice());
                    fare = fare.add(data.getServiceData().getDetalization().getFare());
                    total = MiscUtil.sum((BigDecimal[])new BigDecimal[]{total, data.getServiceData().getTotalPrice()});
                    originalData.getServiceData().getDetalization().setFare(fare);
                    originalData.getServiceData().setTotalPrice(total);
                    originalData.getServiceData().setPaymentPrice(total);
                }
            }
        }
    }

    public static ContractType getContractType(GdsCommission gdsCommission) {
        return FlightHelper.getSourceCommission(gdsCommission).getContractType();
    }

    public static GdsCommission getSourceCommission(GdsCommission gdsCommission) {
        if (gdsCommission.getSource() == null) {
            return gdsCommission;
        }
        return FlightHelper.getSourceCommission(gdsCommission.getSource());
    }

    public static List<FlightSegment> getSegments(Flight flight) {
        return FlightHelper.getFlightSegmentsStream(flight).collect(Collectors.toList());
    }

    private static int getMinutesBetweenSegmentsUnsafe(FlightSegment prevSegment, FlightSegment currentSegment) {
        long diffInMs = currentSegment.getDateBegin().getTime() - prevSegment.getDateEnd().getTime();
        return diffInMs > 0L ? (int)TimeUnit.MILLISECONDS.toMinutes(diffInMs) : 0;
    }

    public static int getTotalDuration(Flight flight, boolean includingTransfers) {
        FlightSegment prevFs = null;
        int sum = 0;
        for (FlightSegmentTariff fst : flight.getSegmentTariffs()) {
            for (FlightSegment fs : fst.getSegments()) {
                if (includingTransfers) {
                    if (!fs.isStarting() && prevFs != null) {
                        int minutes = FlightHelper.getMinutesBetweenSegmentsUnsafe(prevFs, fs);
                        sum += minutes;
                    }
                    prevFs = fs;
                }
                sum += fs.getTravelDuration();
                FlightHelper.getMinutesBetweenSegmentsUnsafe(prevFs, fs);
            }
        }
        return sum;
    }

    public static int getMaxLegDuration(Flight flight, boolean includingTransfers) {
        int maxLegDuration = 0;
        int legDuration = 0;
        FlightSegment prevFs = null;
        for (FlightSegmentTariff fst : flight.getSegmentTariffs()) {
            for (FlightSegment fs : fst.getSegments()) {
                if (fs.isStarting()) {
                    if (legDuration > maxLegDuration) {
                        maxLegDuration = legDuration;
                    }
                    legDuration = 0;
                    if (includingTransfers) {
                        prevFs = fs;
                    }
                } else if (includingTransfers) {
                    if (prevFs != null) {
                        legDuration += FlightHelper.getMinutesBetweenSegmentsUnsafe(prevFs, fs);
                    }
                    prevFs = fs;
                }
                legDuration += fs.getTravelDuration();
            }
        }
        return legDuration > maxLegDuration ? legDuration : maxLegDuration;
    }

    public static int getSegmentDurationInMinutes(FlightSegment segment) {
        ZonedDateTime begin = DictHelper.getZonedDateTime((Date)segment.getDateBegin(), (DictionaryReference)segment.getLocationBegin(), (boolean)false);
        ZonedDateTime end = DictHelper.getZonedDateTime((Date)segment.getDateEnd(), (DictionaryReference)segment.getLocationEnd(), (boolean)false);
        long differenceInMinutes = Duration.between(begin, end).getSeconds() / 60L;
        return Integer.parseInt(Long.toString(differenceInMinutes));
    }

    private static double getGeoDistance(FlightSegment seg, DictionaryCache dc) {
        GeoLocation locStart = (GeoLocation)dc.resolveReference(seg.getLocationBegin());
        GeoLocation locEnd = (GeoLocation)dc.resolveReference(seg.getLocationEnd());
        return GeoLocationHelper.getDistance((GeoLocation)locStart, (GeoLocation)locEnd);
    }

    public static Double getGeoDistance(FlightSegment fs) {
        double fsDistance = FlightHelper.getGeoDistance(fs, DictionaryCache.get());
        return fsDistance < 0.0 ? null : Double.valueOf(fsDistance);
    }

    public static Double getGeoDistance(Flight flight) {
        DictionaryCache dc = DictionaryCache.get();
        double totalDistance = 0.0;
        for (FlightSegmentTariff fst : flight.getSegmentTariffs()) {
            for (FlightSegment fs : fst.getSegments()) {
                double fsDistance = FlightHelper.getGeoDistance(fs, dc);
                if (fsDistance < 0.0) {
                    return null;
                }
                totalDistance += fsDistance;
            }
        }
        return totalDistance;
    }

    public static FlightSegment findSegmentByUid(Flight flight, String uid) {
        for (FlightSegment fs : FlightHelper.getSegments(flight)) {
            if (!uid.equals(fs.getUid())) continue;
            return fs;
        }
        return null;
    }

    public static FlightSegment findSegmentByGdsId(Flight flight, String gdsId) {
        if (TextUtil.isBlank((String)gdsId)) {
            return null;
        }
        for (FlightSegment fs : FlightHelper.getSegments(flight)) {
            if (!gdsId.equals(fs.getGdsId())) continue;
            return fs;
        }
        return null;
    }

    public static boolean containsMarketingAirline(Flight flight, DictionaryReference<Airline> airlineRef) {
        for (FlightSegment fs : FlightHelper.getSegments(flight)) {
            if (!airlineRef.equals((Object)fs.getAirline())) continue;
            return true;
        }
        return false;
    }

    public static ClassOfService findClassOfService(DictionaryReference<Airline> airline, DictionaryReference<Airline> operatingAirline, String bookingClass, boolean international) {
        ClassOfServiceCode classOfServiceCode = DictHelper.findClassOfServiceCode(airline, operatingAirline, (String)bookingClass, null, (boolean)international);
        return classOfServiceCode == null ? null : classOfServiceCode.getClassOfService();
    }

    public static String getDatesInfo(List<RouteSegment> routes) {
        if (routes.isEmpty()) {
            return null;
        }
        LocalDate firstDate = new LocalDate((Object)routes.get(0).getDate());
        LocalDate lastDate = new LocalDate((Object)routes.get(routes.size() - 1).getDate());
        StringBuilder sb = new StringBuilder();
        if (!firstDate.equals((Object)lastDate)) {
            sb.append(FlightHelper.getDateInfo(firstDate, firstDate.getMonthOfYear() == lastDate.getMonthOfYear(), firstDate.getYear() == lastDate.getYear()));
            sb.append("-");
        }
        sb.append(FlightHelper.getDateInfo(lastDate, false, false));
        return sb.toString();
    }

    public static String getDateInfo(Date date) {
        return FlightHelper.getDateInfo(new LocalDate((Object)date), false, false);
    }

    private static String getDateInfo(LocalDate date, boolean sameMonth, boolean sameYear) {
        if (date == null) {
            return "";
        }
        StringBuilder timePattern = new StringBuilder("d");
        if (!sameMonth) {
            timePattern.append(" MMMM");
        }
        if (!sameYear && new LocalDate().getYear() != date.getYear()) {
            timePattern.append(" yyyy");
        }
        return new SimpleDateFormat(timePattern.toString(), LocaleManager.get().getCurrentLocale()).format(date.toDate());
    }

    public static BigDecimal getEquivalentFareAndTaxesTotal(Flight flight) {
        BigDecimal result = BigDecimal.ZERO;
        for (SeatPreferences sp : flight.getSeats()) {
            BigDecimal spPrice = BigDecimal.ZERO;
            spPrice = spPrice.add(FlightHelper.getEquivalentFare(flight, (DictionaryReference<PassengerType>)sp.getPassengerType()));
            spPrice = spPrice.add(FlightHelper.getEquivalentTaxSum(flight, (DictionaryReference<PassengerType>)sp.getPassengerType()));
            BigDecimal spTotal = spPrice.multiply(BigDecimal.valueOf(sp.getCount()));
            result = result.add(spTotal);
        }
        return result;
    }

    public static BigDecimal getEquivalentPenaltiesTotal(Flight flight) {
        BigDecimal result = BigDecimal.ZERO;
        for (SeatPreferences sp : flight.getSeats()) {
            BigDecimal spPrice = BigDecimal.ZERO;
            spPrice = spPrice.add(FlightHelper.getEquivalentPenalty(flight, (DictionaryReference<PassengerType>)sp.getPassengerType()));
            BigDecimal spTotal = spPrice.multiply(BigDecimal.valueOf(sp.getCount()));
            result = result.add(spTotal);
        }
        return result;
    }

    public static BigDecimal calcTotalPrice(Flight flight, ContractType contractType) {
        BigDecimal commValue;
        Map<DictionaryReference<PassengerType>, GdsContractRelationData> contractRelations = FlightHelper.getContractRelations(flight, contractType);
        BigDecimal result = BigDecimal.ZERO;
        for (SeatPreferences sp : flight.getSeats()) {
            GdsContractRelationData contractRelation = contractRelations.get(sp.getPassengerType());
            commValue = BigDecimal.ZERO;
            for (GdsCommission commission : contractRelation.getCommissions()) {
                if (commission.getCommissionProperties() != null && (FeeProperties.class.equals((Object)commission.getCommissionProperties().getType()) || PaymentFeeProperties.class.equals((Object)commission.getCommissionProperties().getType())) && commission.getContractType() == contractType) {
                    commValue = commValue.add(commission.getEquivalentAmount());
                }
                if (commission.getCommissionProperties() == null || !DiscountProperties.class.equals((Object)commission.getCommissionProperties().getType()) || commission.getContractType() != contractType) continue;
                commValue = commValue.subtract(commission.getEquivalentAmount());
            }
            BigDecimal spPrice = MiscUtil.sum((BigDecimal[])new BigDecimal[]{BigDecimal.ZERO, contractRelation.getServiceData().getTotalPrice(), commValue});
            BigDecimal spTotal = spPrice.multiply(BigDecimal.valueOf(sp.getCount()));
            result = result.add(spTotal);
        }
        for (AncillaryFee ancillaryFee : flight.getAncillaryFees()) {
            AncillaryFeeContractRelationData afCr;
            if (!ancillaryFee.isSelected() || (afCr = (AncillaryFeeContractRelationData)ancillaryFee.getContractRelations().stream().filter(cr -> GeneralProductHelper.getContractType((EntityReference)cr.getDescription()) == contractType).findFirst().orElse(null)) == null) continue;
            commValue = BigDecimal.ZERO;
            for (GdsCommission commission : afCr.getCommissions()) {
                if (commission.getCommissionProperties() != null && (FeeProperties.class.equals((Object)commission.getCommissionProperties().getType()) || PaymentFeeProperties.class.equals((Object)commission.getCommissionProperties().getType()))) {
                    commValue = commValue.add(commission.getEquivalentAmount());
                }
                if (commission.getCommissionProperties() == null || !DiscountProperties.class.equals((Object)commission.getCommissionProperties().getType())) continue;
                commValue = commValue.subtract(commission.getEquivalentAmount());
            }
            BigDecimal afToral = MiscUtil.sum((BigDecimal[])new BigDecimal[]{BigDecimal.ZERO, afCr.getPrice(), commValue});
            result = result.add(afToral);
        }
        return result;
    }

    public static String getCurrency(Flight flight, ContractType contractType) {
        return flight.getContractRelations().values().stream().map(contractRelationData -> FlightHelper.findContractRelation(contractRelationData, contractType)).map(GeneralProductHelper::getCurrency).filter(Objects::nonNull).map(DictionaryReference::getCode).findFirst().orElse(DictHelper.getPreferenceValue((PreferenceKey)PreferenceKey.EQUIVE_CURRENCY, null));
    }

    public static String getFlightTitle(Flight flight) {
        if (flight == null) {
            return null;
        }
        StringBuilder result = new StringBuilder();
        for (FlightSegmentTariff st : flight.getSegmentTariffs()) {
            List segments = st.getSegments();
            for (FlightSegment seg : segments) {
                if (result.length() > 0) {
                    result.append('-');
                }
                result.append(seg.getAirline().getCode()).append(seg.getFlightNumber());
            }
        }
        return result.toString();
    }

    public static FareInfo getFareInfo(FlightSegment fs, DictionaryReference<PassengerType> ptRef) {
        for (FareInfo fi : fs.getFareInfos()) {
            if (!MiscUtil.equals((Object)fi.getPassengerType(), ptRef)) continue;
            return fi;
        }
        if (ptRef.getCode().matches("CHILD_\\d{2}")) {
            return FlightHelper.getFareInfo(fs, (DictionaryReference<PassengerType>)DictHelper.getChildPassengerType());
        }
        return null;
    }

    public static Stream<FlightSegment> getFlightSegmentsStream(Flight flight) {
        return flight.getSegmentTariffs().stream().flatMap(st -> st.getSegments().stream());
    }

    public static List<FlightSegment> getFlightSegmentsList(Flight flight) {
        return FlightHelper.getFlightSegmentsStream(flight).collect(Collectors.toList());
    }

    public static Set<DictionaryReference<PassengerType>> collectPts(Flight flight) {
        HashSet<DictionaryReference<PassengerType>> result = new HashSet<DictionaryReference<PassengerType>>();
        result.addAll(flight.getFares().stream().filter(ff -> ff.getPassengerType() != null).map(FlightFare::getPassengerType).collect(Collectors.toSet()));
        result.addAll(flight.getTaxes().stream().filter(ft -> ft.getPassengerType() != null).map(FlightTax::getPassengerType).collect(Collectors.toSet()));
        return result;
    }

    public static DictionaryReference<PassengerType> getAdultPassengerType(Flight flight) {
        return flight.getFares().stream().map(FlightFare::getPassengerType).filter(DictHelper::isAdultPassengerTypeCategory).findAny().orElse(null);
    }

    public static Flight cloneFlightItin(Flight flight) throws Exception {
        Flight newFlight = (Flight)XCloneHelper.clone((XCloneable)flight, (boolean)true);
        newFlight.getSeats().clear();
        newFlight.getFares().clear();
        newFlight.getTaxes().clear();
        newFlight.getContractRelations().clear();
        newFlight.getPenaltiesInfos().clear();
        for (FlightSegment fs : FlightHelper.getSegments(newFlight)) {
            fs.setBookingClass(null);
            fs.setAvailableSeats(null);
            fs.getFareInfos().clear();
        }
        newFlight.setSubsidizedTariff(false);
        newFlight.setIgnoreContractsForSubsidizedTariffFlag(false);
        newFlight.setTripartiteContractDetails(null);
        return newFlight;
    }

    public static List<List<FlightSegment>> getFlightLegs(Flight flight) {
        ArrayList<List<FlightSegment>> legs = new ArrayList<List<FlightSegment>>();
        ArrayList<FlightSegment> leg = new ArrayList<FlightSegment>();
        for (FlightSegment fs : FlightHelper.getSegments(flight)) {
            if (fs.isStarting() && !leg.isEmpty()) {
                legs.add(leg);
                leg = new ArrayList();
            }
            leg.add(fs);
        }
        if (!leg.isEmpty()) {
            legs.add(leg);
        }
        return legs;
    }

    public static Integer getDaysBeforeDeparture(RouteSegment rs) {
        ZonedDateTime zdt = DictHelper.getZonedDateTime((Date)rs.getDate(), (DictionaryReference)rs.getLocationBegin(), (boolean)true);
        if (zdt == null) {
            return null;
        }
        return (int)ChronoUnit.DAYS.between(ZonedDateTime.now(), zdt);
    }

    public static String toIdentifiableString(Flight flight) {
        if (flight == null) {
            return "[null]";
        }
        StringBuilder sb = new StringBuilder();
        FlightHelper.toIdentifiableString(FlightHelper.getSegments(flight), sb);
        sb.append(", seats=");
        sb.append(flight.getSeats().stream().map(sp -> sp.getCount() + "*" + sp.getPassengerType().getCode()).collect(Collectors.joining("+")));
        sb.append(", fareBasises=");
        sb.append(FlightHelper.getSegments(flight).stream().map(fs -> fs.getFareInfos().stream().map(FareInfo::getFareBasis).collect(Collectors.joining(","))).collect(Collectors.joining("|")));
        sb.append(", accountCode=");
        sb.append(flight.getAccountCode());
        sb.append(", corporateId=");
        sb.append(flight.getCorporateId());
        return sb.toString();
    }

    public static String toIdentifiableString(List<FlightSegment> flightSegments) {
        StringBuilder sb = new StringBuilder();
        FlightHelper.toIdentifiableString(flightSegments, sb);
        return sb.toString();
    }

    private static void toIdentifiableString(List<FlightSegment> flightSegments, StringBuilder sb) {
        for (FlightSegment fs : flightSegments) {
            if (sb.length() > 0) {
                sb.append('|');
            }
            sb.append(fs.getLocationBegin().getCode());
            sb.append("->");
            sb.append(fs.getLocationEnd().getCode());
            sb.append('@');
            sb.append(DictHelper.getCode((DictionaryReference)fs.getAirline()));
            sb.append(fs.getFlightNumber());
            sb.append('@');
            sb.append(fs.getDateBegin() == null ? "null" : DF.format(fs.getDateBegin()));
        }
    }

    public static boolean isFlightAllBranded(Flight flight) {
        return FlightHelper.getSegments(flight).stream().map(fs -> (FareInfo)fs.getFareInfos().get(0)).allMatch(fi -> fi.getFareDetails() != null && fi.getFareDetails().getPricingParameters() != null && !StringUtils.isBlank((String)fi.getFareDetails().getPricingParameters().getBrandId()));
    }

    public static boolean isFlightAnyBranded(Flight flight) {
        return FlightHelper.getSegments(flight).stream().map(fs -> (FareInfo)fs.getFareInfos().get(0)).anyMatch(fi -> fi.getFareDetails() != null && fi.getFareDetails().getPricingParameters() != null && !StringUtils.isBlank((String)fi.getFareDetails().getPricingParameters().getBrandId()));
    }

    public static Stream<FlightSegmentTariff> segmentTariffStreamSafe(Flight flight) {
        if (Objects.isNull(flight)) {
            return Stream.empty();
        }
        return flight.getSegmentTariffs().stream().filter(Objects::nonNull);
    }

    public static Stream<FlightSegment> segmentStreamSafe(Flight flight) {
        return FlightHelper.segmentTariffStreamSafe(flight).map(FlightSegmentTariff::getSegments).flatMap(Collection::stream).filter(Objects::nonNull);
    }

    public static Date calculateTimeLimit(TimeLimitType timeLimitType, int timeForTimeLimit, Flight flight) {
        FlightSegment seg0 = (FlightSegment)((FlightSegmentTariff)flight.getSegmentTariffs().get(0)).getSegments().get(0);
        return FlightHelper.calculateTimeLimit(timeLimitType, timeForTimeLimit, flight.getPqTimeLimit(), (DictionaryReference<GeoLocation>)seg0.getLocationBegin(), seg0.getDateBegin(), new Date());
    }

    public static Date calculateTimeLimit(TimeLimitType timeLimitType, int timeForTimeLimit, Date pqTimeLimit, DictionaryReference<GeoLocation> locationBeginRef, Date dateBegin, Date bookingDate) {
        if (timeLimitType != null) {
            String errorMessagePrefix = "\u0412 \u043f\u0440\u0430\u0432\u0438\u043b\u0430\u0445 \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u043b\u0435\u043d \u0442\u0438\u043f \u0442\u0430\u0439\u043c-\u043b\u0438\u043c\u0438\u0442\u0430 \u0432 " + timeLimitType + ". ";
            switch (timeLimitType) {
                case SUPPLIER_TIME_LIMIT: {
                    if (pqTimeLimit == null) {
                        throw Xeption.forEndUser((String)(errorMessagePrefix + "\u0422\u0430\u0439\u043c-\u043b\u0438\u043c\u0438\u0442 \u043e\u0442 \u043f\u043e\u0441\u0442\u0430\u0432\u0449\u0438\u043a\u0430 \u043d\u0435 \u043f\u043e\u043b\u0443\u0447\u0435\u043d."), (Object[])new Object[0]);
                    }
                    return FlightHelper.calculateDate(pqTimeLimit, timeForTimeLimit, true);
                }
                case BOOKING_TIME: {
                    if (timeForTimeLimit < 0) {
                        throw Xeption.forEndUser((String)(errorMessagePrefix + "\u0423\u0441\u0442\u0430\u043d\u043e\u0432\u043b\u0435\u043d\u043d\u043e\u0435 \u0432\u0440\u0435\u043c\u044f \u0440\u0430\u043d\u044c\u0448\u0435 \u0434\u0430\u0442\u044b \u0431\u0440\u043e\u043d\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u044f."), (Object[])new Object[0]);
                    }
                    return FlightHelper.calculateDate(bookingDate, timeForTimeLimit, true);
                }
                case DEPARTURE_TIME: {
                    if (timeForTimeLimit > 0) {
                        throw Xeption.forEndUser((String)(errorMessagePrefix + "\u0423\u0441\u0442\u0430\u043d\u043e\u0432\u043b\u0435\u043d\u043d\u043e\u0435 \u0432\u0440\u0435\u043c\u044f \u043f\u043e\u0437\u0436\u0435 \u0434\u0430\u0442\u044b \u0432\u044b\u043b\u0435\u0442\u0430."), (Object[])new Object[0]);
                    }
                    GeoLocation locationBegin = (GeoLocation)DictionaryCache.get().resolveReference(locationBeginRef);
                    ZoneId beginZoneId = DictHelper.getZoneId(locationBeginRef);
                    if (beginZoneId == null) {
                        throw Xeption.forEndUser((String)("\u0412 \u0441\u043f\u0440\u0430\u0432\u043e\u0447\u043d\u0438\u043a\u0435 \u043e\u0442\u0441\u0443\u0442\u0441\u0442\u0432\u0443\u0435\u0442 \u0447\u0430\u0441\u043e\u0432\u043e\u0439 \u043f\u043e\u044f\u0441: " + locationBegin), (Object[])new Object[0]);
                    }
                    Date dateEnd = DateTimeConverter.convert((Date)dateBegin, (TimeZone)TimeZone.getTimeZone(beginZoneId.getId()), (TimeZone)TimeZone.getDefault());
                    return FlightHelper.calculateDate(dateEnd, timeForTimeLimit, true);
                }
            }
        }
        return null;
    }

    public static Date calculateDate(Date date, int timeInMinutes, boolean isPlus) {
        if (date != null) {
            LocalDateTime dateToLDT = MiscUtil.toLocalDateTime((Date)date);
            LocalDateTime timeLimitLDT = isPlus ? dateToLDT.plusMinutes(timeInMinutes) : dateToLDT.minusMinutes(timeInMinutes);
            return MiscUtil.toDate((LocalDateTime)timeLimitLDT);
        }
        return null;
    }

    public static ExpiryWarningTime buildExpiryWarningTime(Date date) {
        if (date == null) {
            throw Xeption.forDeveloper((String)"Date for ExpiryWarningTime must not be null", (Object[])new Object[0]);
        }
        ExpiryWarningTime expiryWarningTime = new ExpiryWarningTime();
        expiryWarningTime.setTimeLimitExpiryWarningTime(date);
        return expiryWarningTime;
    }

    public static <T> void fillMultiTicketBreakdown(Flight flight, Function<FlightSegmentTariff, T> keyFunction, Function<FlightSegmentTariff, DictionaryReference<Airline>> carrierFunction) {
        LinkedHashMap segmentTariffsByTicket = new LinkedHashMap();
        for (FlightSegmentTariff fst : flight.getSegmentTariffs()) {
            T ticketKey = keyFunction.apply(fst);
            if (!segmentTariffsByTicket.containsKey(ticketKey)) {
                segmentTariffsByTicket.put(ticketKey, new ArrayList());
            }
            ((List)segmentTariffsByTicket.get(ticketKey)).add(fst);
        }
        if (segmentTariffsByTicket.keySet().size() > 1) {
            Pair segmentIndexes = new Pair((Object)-1, (Object)-1);
            for (Map.Entry entry : segmentTariffsByTicket.entrySet()) {
                FlightMultiTicketItem item = new FlightMultiTicketItem();
                item.setCarrier((DictionaryReference)Streams.single(((List)entry.getValue()).stream().map(carrierFunction).distinct()));
                segmentIndexes.setFirst((Object)((Integer)segmentIndexes.getLast() + 1));
                for (FlightSegmentTariff fst : (List)entry.getValue()) {
                    segmentIndexes.setLast((Object)((Integer)segmentIndexes.getLast() + fst.getSegments().size()));
                    item.getSegmentTariffs().add(fst);
                    item.getFares().addAll(flight.getFares().stream().filter(ff -> ff.getSegmentTariff() == fst).collect(Collectors.toList()));
                    item.getTaxes().addAll(flight.getTaxes().stream().filter(ft -> ft.getSegmentTariff() == fst).collect(Collectors.toList()));
                }
                item.getAncillaryFees().addAll(flight.getAncillaryFees().stream().filter(fee -> FlightHelper.containsSegments(fee, (Pair<Integer>)segmentIndexes)).collect(Collectors.toList()));
                flight.getMultiTicketBreakdown().add(item);
            }
        }
    }

    private static boolean containsSegments(AncillaryFee ancillaryFee, Pair<Integer> segmentIndexes) {
        for (Integer segNum : ancillaryFee.getSegmentNumbers()) {
            if (segNum < (Integer)segmentIndexes.getFirst() || segNum > (Integer)segmentIndexes.getLast()) continue;
            return true;
        }
        return false;
    }

    public static FlightPassengerTypeData getOrCreatePassengerTypeData(Flight flight, DictionaryReference<PassengerType> passengerType) {
        FlightPassengerTypeData data = new FlightPassengerTypeData();
        flight.getPassengerTypeData().put(passengerType, data);
        return data;
    }

    public static Optional<FlightPassengerTypeData> getPassengerTypeData(Flight flight, DictionaryReference<PassengerType> passengerType) {
        return Optional.ofNullable(flight.getPassengerTypeData().get(passengerType));
    }
}

