/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.gds.rules;

import com.gridnine.xtrip.common.gds.model.PenaltyProperties;
import com.gridnine.xtrip.common.gds.rules.AutoRefundActionsSet;
import com.gridnine.xtrip.common.gds.rules.Targets;
import com.gridnine.xtrip.common.gds.rules.ValueTypes;
import com.gridnine.xtrip.common.l10n.model.LocaleManager;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.helpers.MoneyHelper;
import com.gridnine.xtrip.common.model.rules.standard.RuleResultValue;
import com.gridnine.xtrip.common.model.rules.standard.RulesHelper;
import com.gridnine.xtrip.common.model.system.Money;
import com.gridnine.xtrip.common.rules.elements.RuleAction;
import com.gridnine.xtrip.common.rules.elements.RuleProxy;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.XCloneHelper;
import com.gridnine.xtrip.common.util.XCloneable;
import org.apache.commons.lang.BooleanUtils;

public enum AutoRefundActions implements RuleAction
{
    PENALTY{

        public String getDisplayName() {
            return "\u0423\u0441\u0442\u0430\u043d\u043e\u0432\u0438\u0442\u044c \u0448\u0442\u0440\u0430\u0444";
        }

        public String getRendererId() {
            return ValueTypes.PENALTY.name();
        }

        public boolean hasValue() {
            return true;
        }

        public void buildInfo(StringBuilder buf, Object value) {
            RulesHelper.buildCommissionInfo((StringBuilder)buf, (RuleResultValue)((RuleResultValue)value));
        }

        public String getRuleCategoryValue(Object actionSet, Object value) throws Exception {
            RuleResultValue rrv = (RuleResultValue)value;
            if (rrv.getTarget() == null) {
                return null;
            }
            EntityContainer prop = EntityStorage.get().resolve(rrv.getTarget());
            if (prop == null) {
                return null;
            }
            return ((PenaltyProperties)prop.getEntity()).getCategory() == null ? null : ((PenaltyProperties)prop.getEntity()).getCategory().getCode();
        }

        public void apply(RuleProxy<?, ?> proxy, Object value) throws Exception {
            RuleResultValue rrv = (RuleResultValue)value;
            AutoRefundActionsSet as = (AutoRefundActionsSet)proxy.getActionSet();
            as.getPenalties().add((RuleResultValue)XCloneHelper.clone((XCloneable)rrv));
            proxy.getAppliedRuleCategories().add(this.getRuleCategoryValue(as, value));
        }

        @Override
        String[] getTargetIds() {
            return new String[]{Targets.REFUND_PARAMETERS.getId()};
        }
    }
    ,
    NON_REFUNDABLE_TAXES{

        public String getDisplayName() {
            return "\u0423\u0434\u0435\u0440\u0436\u0430\u0442\u044c \u0432\u0441\u0435 \u0442\u0430\u043a\u0441\u044b";
        }

        public String getRendererId() {
            return com.gridnine.xtrip.common.model.rules.standard.ValueTypes.YES_NO.name();
        }

        public boolean hasValue() {
            return true;
        }

        public void buildInfo(StringBuilder buf, Object value) {
            if (value == null) {
                return;
            }
            if (((Boolean)value).booleanValue()) {
                buf.append("\u0443\u0434\u0435\u0440\u0436\u0430\u0442\u044c \u0432\u0441\u0435 \u0442\u0430\u043a\u0441\u044b");
            } else {
                buf.append("\u041d\u0415 \u0443\u0434\u0435\u0440\u0436\u0438\u0432\u0430\u0442\u044c \u0432\u0441\u0435 \u0442\u0430\u043a\u0441\u044b");
            }
        }

        public String getRuleCategoryValue(Object actionSet, Object value) throws Exception {
            return NON_REFUNDABLE_TAXES.getId();
        }

        public void apply(RuleProxy<?, ?> proxy, Object value) throws Exception {
            AutoRefundActionsSet as = (AutoRefundActionsSet)proxy.getActionSet();
            as.setNotRefundAllTaxes(BooleanUtils.isTrue((Boolean)((Boolean)value)));
            proxy.getAppliedRuleCategories().add(this.getRuleCategoryValue(as, value));
        }

        @Override
        String[] getTargetIds() {
            return new String[]{Targets.REFUND_PARAMETERS.getId()};
        }
    }
    ,
    PENALTY_FARE_AND_TAX{

        public String getDisplayName() {
            return "\u0423\u0441\u0442\u0430\u043d\u043e\u0432\u0438\u0442\u044c \u0448\u0442\u0440\u0430\u0444 (\u0422\u0430\u0440\u0438\u0444+\u0422\u0430\u043a\u0441\u0430)";
        }

        public String getRendererId() {
            return com.gridnine.xtrip.common.model.rules.standard.ValueTypes.STRING_WITH_PRICE.name();
        }

        public boolean hasValue() {
            return true;
        }

        public void buildInfo(StringBuilder buf, Object value) {
            RuleResultValue rrv = (RuleResultValue)value;
            buf.append("\u0423\u0441\u0442\u0430\u043d\u043e\u0432\u0438\u0442\u044c \u0448\u0442\u0440\u0430\u0444 \u043d\u0430 \u0442\u0430\u0440\u0438\u0444 \u0441 \u0442\u0430\u043a\u0441\u043e\u0439 ").append(rrv.getAddValue()).append(": ").append(LocaleManager.get().getCurrentLocaleData().getPriceFormat().format(rrv.getValue())).append(' ').append(rrv.getCurrencyCode());
        }

        public String getRuleCategoryValue(Object actionSet, Object value) throws Exception {
            return PENALTY_FARE_AND_TAX.getId();
        }

        public void apply(RuleProxy<?, ?> proxy, Object value) throws Exception {
            RuleResultValue rrv = (RuleResultValue)value;
            AutoRefundActionsSet as = (AutoRefundActionsSet)proxy.getActionSet();
            as.setFarePenaltyData((MiscUtil.Pair<Money, String>)MiscUtil.Pair.of((Object)MoneyHelper.buildMoney((double)rrv.getValue(), (String)rrv.getCurrencyCode()), (Object)((String)rrv.getAddValue())));
            proxy.getAppliedRuleCategories().add(this.getRuleCategoryValue(as, value));
        }

        @Override
        String[] getTargetIds() {
            return new String[]{Targets.REFUND_PARAMETERS.getId()};
        }
    }
    ,
    AUTO_REFUND_ALLOWED{

        public String getDisplayName() {
            return "\u0420\u0430\u0437\u0440\u0435\u0448\u0435\u043d \u0430\u0432\u0442\u043e\u043c\u0430\u0442\u0438\u0447\u0435\u0441\u043a\u0438\u0439 \u0432\u043e\u0437\u0432\u0440\u0430\u0442";
        }

        public void buildInfo(StringBuilder buf, Object value) {
            if (value == null) {
                return;
            }
            if (((Boolean)value).booleanValue()) {
                buf.append("\u0430\u0432\u0442\u043e\u043c\u0430\u0442\u0438\u0447\u0435\u0441\u043a\u0438\u0439 \u0432\u043e\u0437\u0432\u0440\u0430\u0442 \u0440\u0430\u0437\u0440\u0435\u0448\u0435\u043d");
            } else {
                buf.append("\u0430\u0432\u0442\u043e\u043c\u0430\u0442\u0438\u0447\u0435\u0441\u043a\u0438\u0439 \u0432\u043e\u0437\u0432\u0440\u0430\u0442 \u041d\u0415 \u0440\u0430\u0437\u0440\u0435\u0448\u0435\u043d");
            }
        }

        public String getRendererId() {
            return com.gridnine.xtrip.common.model.rules.standard.ValueTypes.YES_NO.name();
        }

        public boolean hasValue() {
            return true;
        }

        @Override
        String[] getTargetIds() {
            return new String[]{Targets.REFUND_PARAMETERS.getId()};
        }

        public String getRuleCategoryValue(Object actionSet, Object value) throws Exception {
            return AUTO_REFUND_ALLOWED.getId();
        }

        public void apply(RuleProxy<?, ?> proxy, Object value) throws Exception {
            AutoRefundActionsSet as = (AutoRefundActionsSet)proxy.getActionSet();
            as.setAutoRefundAllowed(Boolean.TRUE.equals(value));
            proxy.getAppliedRuleCategories().add(this.getRuleCategoryValue(as, value));
        }
    };


    public String getId() {
        return this.name();
    }

    abstract String[] getTargetIds();
}

