/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.gds.rules;

import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.dict.GeoLocation;
import com.gridnine.xtrip.common.model.rules.standard.Conditions;
import com.gridnine.xtrip.common.model.rules.standard.RulesHelper;
import com.gridnine.xtrip.common.rules.elements.RuleCondition;
import com.gridnine.xtrip.common.util.TextUtil;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;

public class ConnectionTimePropertiesSet
implements Serializable {
    private static final long serialVersionUID = -6400881656949599266L;
    private final Set<String> arrivalCodes = new HashSet<String>();
    private final Set<String> departureCodes = new HashSet<String>();

    public ConnectionTimePropertiesSet(DictionaryReference<GeoLocation> departure, DictionaryReference<GeoLocation> arrival) {
        if (departure != null) {
            this.departureCodes.add(departure.getCode());
            RulesHelper.collectGeoCodes(this.departureCodes, (boolean)true);
        }
        if (this.arrivalCodes != null) {
            this.arrivalCodes.add(arrival.getCode());
            RulesHelper.collectGeoCodes(this.arrivalCodes, (boolean)true);
        }
    }

    public boolean match(Collection<String> data, RuleCondition cond) {
        boolean equals;
        boolean bl = equals = Conditions.EQUALS == cond;
        if (data == null) {
            return !equals;
        }
        for (String segment : data) {
            boolean hval = this.match(segment);
            if (!hval) continue;
            return equals;
        }
        return !equals;
    }

    private boolean match(String segment) {
        if ("*".equals(segment)) {
            return true;
        }
        int idx = segment.indexOf("-");
        if (idx == -1) {
            return false;
        }
        String firstCode = segment.substring(0, idx);
        if (!this.match(firstCode, this.departureCodes)) {
            return false;
        }
        String secondCode = segment.substring(idx + 1);
        return this.match(secondCode, this.arrivalCodes);
    }

    private boolean match(String code, Set<String> codes) {
        if (TextUtil.isBlank((String)code)) {
            return false;
        }
        if ("*".equals(code)) {
            return true;
        }
        return codes.contains(code);
    }
}

