/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.gds.rules;

import com.gridnine.xtrip.common.l10n.messages.L10n;
import com.gridnine.xtrip.common.l10n.model.L10nResourcesManager;
import com.gridnine.xtrip.common.model.booking.timelimit.TimeLimitTypeAndTime;
import com.gridnine.xtrip.common.model.rules.l10n.Messages;
import com.gridnine.xtrip.common.model.rules.standard.TimeLimitActionsProvider;
import com.gridnine.xtrip.common.model.rules.standard.ValueTypes;
import com.gridnine.xtrip.common.rules.elements.RuleAction;
import com.gridnine.xtrip.common.rules.elements.RuleProxy;
import java.util.ArrayList;

public enum TimeLimitActions implements RuleAction
{
    SET_TIME_LIMIT{

        public String getDisplayName() {
            return L10n.get((String)Messages.ruleAction_setTimeLimit);
        }

        public String getRendererId() {
            return ValueTypes.TIME_LIMIT_TYPE.name();
        }

        public void buildInfo(StringBuilder buf, Object value) {
            if (value != null) {
                TimeLimitTypeAndTime timeLimitTypeAndTime = (TimeLimitTypeAndTime)value;
                buf.append(L10nResourcesManager.getStr((String)Messages.ruleAction_setTimeLimit_info, (Object[])new Object[]{timeLimitTypeAndTime.getType(), timeLimitTypeAndTime.getTime()}));
            }
        }

        public String getRuleCategoryValue(Object actionSet, Object value) throws Exception {
            return "\"set time limit\"";
        }

        public void apply(RuleProxy<?, ?> proxy, Object value) throws Exception {
            TimeLimitActionsProvider as = (TimeLimitActionsProvider)proxy.getActionSet();
            TimeLimitTypeAndTime timeLimitTypeAndTime = (TimeLimitTypeAndTime)value;
            as.setTimeLimitType(timeLimitTypeAndTime.getType());
            as.setTimeForTimeLimit(timeLimitTypeAndTime.getTime());
            proxy.getAppliedRuleCategories().add(this.getRuleCategoryValue(as, value));
        }
    }
    ,
    WARNING_ABOUT_EXPIRING{

        public String getDisplayName() {
            return L10n.get((String)Messages.ruleAction_warnAboutExpiringTimeLimit);
        }

        public String getRendererId() {
            return ValueTypes.INTEGER_LIST.name();
        }

        public void buildInfo(StringBuilder buf, Object value) {
            if (value != null) {
                buf.append(L10nResourcesManager.getStr((String)Messages.ruleAction_warnAboutExpiringTimeLimit_info, (Object[])new Object[]{value}));
            }
        }

        public String getRuleCategoryValue(Object actionSet, Object value) throws Exception {
            return "\"warning about expiring time limit\"";
        }

        public void apply(RuleProxy<?, ?> proxy, Object value) throws Exception {
            TimeLimitActionsProvider as = (TimeLimitActionsProvider)proxy.getActionSet();
            as.getWarningAboutExpiringTime().addAll((ArrayList)value);
            proxy.getAppliedRuleCategories().add(this.getRuleCategoryValue(as, value));
        }
    };


    public boolean hasValue() {
        return true;
    }

    public String getId() {
        return this.name();
    }
}

