/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.hotels2.helper;

import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.xtriphotels.HotelProduct;
import com.gridnine.xtrip.common.model.helpers.BookingHelper;
import com.gridnine.xtrip.common.model.helpers.GeneralProductHelper;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;

public class CommonHotelHelper {
    public static final Set<ProductStatus> IGNORE_SYNC_STATUSES = EnumSet.of(ProductStatus.INTENTION, ProductStatus.VOID_INTENTION);

    public static List<Reservation> getHotelReservationsForSync(BookingFile bookingFile) {
        List reservations = BookingHelper.getReservationsForProduct((BookingFile)bookingFile, (Class[])new Class[]{HotelProduct.class});
        reservations.removeIf(res -> res.getProducts().isEmpty() || res.getProducts().stream().anyMatch(p -> IGNORE_SYNC_STATUSES.contains(GeneralProductHelper.getStatus((BaseProduct)p))) || res.getGdsNameInfo().getOnlineGdsAccount() == null);
        return reservations;
    }

    public static boolean isTripartiteDiscount(HotelProduct product) {
        return product.isTripartiteAgreement();
    }
}

