/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.hotels2.rules;

import com.gridnine.xtrip.common.gds.model.BaseGdsAccount;
import com.gridnine.xtrip.common.hotels2.rules.HotelsParametersPropertiesProvider;
import com.gridnine.xtrip.common.midoffice.helper.CommonHelper;
import com.gridnine.xtrip.common.midoffice.model.SalesContext;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.dict.Country;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.profile.Person;
import com.gridnine.xtrip.common.rules.elements.RuleProxy;
import java.util.HashSet;
import java.util.Set;

public class HotelsParametersProperties
implements HotelsParametersPropertiesProvider {
    private static final long serialVersionUID = -4862926644813433707L;
    private final Set<String> subagencyCodes = new HashSet<String>();
    private final Set<String> profileGroups = new HashSet<String>();
    private DictionaryReference<Country> country;
    private EntityReference<Person> agent;
    private EntityReference<Organization> client;
    private EntityReference<? extends BaseGdsAccount> gdsAccount;
    private String agencyCode;

    public HotelsParametersProperties(SalesContext ctx, RuleProxy<?, ?> proxy) {
        proxy.getTracer().traceEnteringMethod(this.getClass(), "ctor()", new String[0]);
        try {
            this.addSubagencyCodes((EntityReference<Organization>)ctx.getSubagency());
            this.agent = ctx.getAgent();
            this.client = ctx.getClient();
            this.agencyCode = CommonHelper.getAgencyCode((SalesContext)ctx);
        }
        finally {
            proxy.getTracer().traceObject("proxy", (Object)this);
            proxy.getTracer().traceExitingMethod(this.getClass(), "ctor()", new String[0]);
        }
    }

    private void addSubagencyCodes(EntityReference<Organization> agencyRef) {
        if (agencyRef != null) {
            try {
                Organization agency = (Organization)EntityStorage.get().resolve(agencyRef).getEntity();
                this.subagencyCodes.add(agency.getCode());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public String getAgencyCode() {
        return this.agencyCode;
    }

    public Set<String> getSubagencyCodes() {
        return this.subagencyCodes;
    }

    public Set<String> getProfileGroups() {
        return this.profileGroups;
    }

    public EntityReference<Person> getAgent() {
        return this.agent;
    }

    public EntityReference<Organization> getClient() {
        return this.client;
    }

    @Override
    public DictionaryReference<Country> getCountry() {
        return this.country;
    }

    public EntityReference<? extends BaseGdsAccount> getGdsAccount() {
        return this.gdsAccount;
    }

    public String getGdsName() {
        return null;
    }

    public void setGdsAccount(EntityReference<? extends BaseGdsAccount> gdsAccount) {
        this.gdsAccount = gdsAccount;
    }

    public void setCountry(DictionaryReference<Country> country) {
        this.country = country;
    }
}

