/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.ibecorp.common;

import com.gridnine.xtrip.common.gds.helper.FlightHelper;
import com.gridnine.xtrip.common.gds.model.Flight;
import com.gridnine.xtrip.common.ibecorp.exception.AmbiguousCurrencyException;
import com.gridnine.xtrip.common.model.booking.PassengerType;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.air.Product;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.gds.PenaltiesInfo;
import com.gridnine.xtrip.common.model.helpers.AirProductHelper;
import com.gridnine.xtrip.common.model.system.Money;
import java.math.BigDecimal;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;

public final class PenaltiesResolver {
    private final Map<DictionaryReference<PassengerType>, PenaltiesInfo> penaltiesInfos = new HashMap<DictionaryReference<PassengerType>, PenaltiesInfo>();
    private boolean refundBeforeDepartureAmbiguousCurrency;
    private boolean refundAfterDepartureAmbiguousCurrency;
    private boolean exchangeBeforeDepartureAmbiguousCurrency;
    private boolean exchangeAfterDepartureAmbiguousCurrency;
    public static final Comparator<Money> MONEY_COMPARATOR = (o1, o2) -> {
        if (o1 == o2) {
            return 0;
        }
        if (o1 == null) {
            return -1;
        }
        if (o2 == null) {
            return 1;
        }
        if (o1.getValue().equals(BigDecimal.ZERO) || o2.getValue().equals(BigDecimal.ZERO)) {
            return o1.getValue().compareTo(o2.getValue());
        }
        if (o1.getCurrency() == null || o2.getCurrency() == null) {
            throw new IllegalStateException("Currency code is null");
        }
        if (o1.getCurrency().equals(o2.getCurrency())) {
            return o1.getValue().compareTo(o2.getValue());
        }
        throw new AmbiguousCurrencyException(o1.getCurrency(), o2.getCurrency());
    };

    public void setRefundBeforeDepartureAmbiguousCurrency(boolean refundBeforeDepartureAmbiguousCurrency) {
        this.refundBeforeDepartureAmbiguousCurrency = refundBeforeDepartureAmbiguousCurrency;
    }

    public void setRefundAfterDepartureAmbiguousCurrency(boolean refundAfterDepartureAmbiguousCurrency) {
        this.refundAfterDepartureAmbiguousCurrency = refundAfterDepartureAmbiguousCurrency;
    }

    public void setExchangeBeforeDepartureAmbiguousCurrency(boolean exchangeBeforeDepartureAmbiguousCurrency) {
        this.exchangeBeforeDepartureAmbiguousCurrency = exchangeBeforeDepartureAmbiguousCurrency;
    }

    public void setExchangeAfterDepartureAmbiguousCurrency(boolean exchangeAfterDepartureAmbiguousCurrency) {
        this.exchangeAfterDepartureAmbiguousCurrency = exchangeAfterDepartureAmbiguousCurrency;
    }

    public PenaltiesResolver(Flight gdsFlight) {
        FlightHelper.getFlightSegmentsStream((Flight)gdsFlight).flatMap(fs -> fs.getFareInfos().stream()).forEach(fi -> this.resolvePenaltiesInfo((DictionaryReference<PassengerType>)fi.getPassengerType(), fi.getPenaltiesInfo()));
        this.applyStandardPenaltiesInfo(gdsFlight.getPenaltiesInfos().entrySet().stream().collect(Collectors.toMap(e -> (DictionaryReference)e.getKey(), Map.Entry::getValue)));
    }

    public PenaltiesResolver(Reservation reservation) {
        AirProductHelper.getAirProductsStream((Reservation)reservation).forEach(p -> AirProductHelper.getProductSegmentsStream((Product)p).forEach(s -> this.resolvePenaltiesInfo((DictionaryReference<PassengerType>)p.getPassengerType(), s.getPenaltiesInfo())));
        this.applyStandardPenaltiesInfo(AirProductHelper.getAirProductsStream((Reservation)reservation).filter(p -> p.getPenaltiesInfo() != null && p.getPassengerType() != null).collect(Collectors.toMap(Product::getPassengerType, Product::getPenaltiesInfo, (value1, value2) -> value1)));
    }

    private static void merge(PenaltiesInfo current, PenaltiesInfo candidate, Function<PenaltiesInfo, Money> moneyGetter, BiConsumer<PenaltiesInfo, Money> moneySetter, Function<PenaltiesInfo, Boolean> conditionsApplyGetter, BiConsumer<PenaltiesInfo, Boolean> conditionsApplySetter, Consumer<Boolean> exceptionConsumer) {
        try {
            if (MONEY_COMPARATOR.compare(moneyGetter.apply(current), moneyGetter.apply(candidate)) < 0) {
                moneySetter.accept(current, moneyGetter.apply(candidate));
                conditionsApplySetter.accept(current, conditionsApplyGetter.apply(candidate));
            }
        }
        catch (AmbiguousCurrencyException ex) {
            exceptionConsumer.accept(true);
        }
    }

    private void mergeExchangeToWorstCase(DictionaryReference<PassengerType> passengerType, PenaltiesInfo candidate) {
        PenaltiesInfo current = this.penaltiesInfos.computeIfAbsent(passengerType, k -> new PenaltiesInfo());
        if (Boolean.FALSE.equals(candidate.getExchangableBeforeDeparture())) {
            current.setExchangableBeforeDeparture(Boolean.valueOf(false));
            current.setExchangeBeforeDeparture(null);
        } else if (!Boolean.FALSE.equals(current.getExchangableBeforeDeparture()) && (Boolean.TRUE.equals(candidate.getExchangableBeforeDeparture()) || candidate.getExchangableBeforeDeparture() == null && candidate.getExchangeBeforeDeparture() != null)) {
            current.setExchangableBeforeDeparture(Boolean.valueOf(true));
            PenaltiesResolver.merge(current, candidate, PenaltiesInfo::getExchangeBeforeDeparture, PenaltiesInfo::setExchangeBeforeDeparture, PenaltiesInfo::isConditionsApplyExchangableBefore, PenaltiesInfo::setConditionsApplyExchangableBefore, this::setExchangeBeforeDepartureAmbiguousCurrency);
        }
        if (Boolean.FALSE.equals(candidate.getExchangableAfterDeparture())) {
            current.setExchangableAfterDeparture(Boolean.valueOf(false));
            current.setExchangeAfterDeparture(null);
        } else if (!Boolean.FALSE.equals(current.getExchangableAfterDeparture()) && (Boolean.TRUE.equals(candidate.getExchangableAfterDeparture()) || candidate.getExchangableAfterDeparture() == null && candidate.getExchangeAfterDeparture() != null)) {
            current.setExchangableAfterDeparture(Boolean.valueOf(true));
            PenaltiesResolver.merge(current, candidate, PenaltiesInfo::getExchangeAfterDeparture, PenaltiesInfo::setExchangeAfterDeparture, PenaltiesInfo::isConditionsApplyExchangableAfter, PenaltiesInfo::setConditionsApplyExchangableAfter, this::setExchangeAfterDepartureAmbiguousCurrency);
        }
    }

    private void mergeRefundToWorstCase(DictionaryReference<PassengerType> passengerType, PenaltiesInfo candidate) {
        PenaltiesInfo current = this.penaltiesInfos.computeIfAbsent(passengerType, k -> new PenaltiesInfo());
        if (Boolean.FALSE.equals(candidate.getRefundableBeforeDeparture())) {
            current.setRefundableBeforeDeparture(Boolean.valueOf(false));
            current.setRefundBeforeDeparture(null);
        } else if (!Boolean.FALSE.equals(current.getRefundableBeforeDeparture()) && (Boolean.TRUE.equals(candidate.getRefundableBeforeDeparture()) || candidate.getRefundableBeforeDeparture() == null && candidate.getRefundBeforeDeparture() != null)) {
            current.setRefundableBeforeDeparture(Boolean.valueOf(true));
            PenaltiesResolver.merge(current, candidate, PenaltiesInfo::getRefundBeforeDeparture, PenaltiesInfo::setRefundBeforeDeparture, PenaltiesInfo::isConditionsApplyRefundableBefore, PenaltiesInfo::setConditionsApplyRefundableBefore, this::setRefundBeforeDepartureAmbiguousCurrency);
        }
        if (Boolean.FALSE.equals(candidate.getRefundableAfterDeparture())) {
            current.setRefundableAfterDeparture(Boolean.valueOf(false));
            current.setRefundAfterDeparture(null);
        } else if (!Boolean.FALSE.equals(current.getRefundableAfterDeparture()) && (Boolean.TRUE.equals(candidate.getRefundableAfterDeparture()) || candidate.getRefundableAfterDeparture() == null && candidate.getRefundAfterDeparture() != null)) {
            current.setRefundableAfterDeparture(Boolean.valueOf(true));
            PenaltiesResolver.merge(current, candidate, PenaltiesInfo::getRefundAfterDeparture, PenaltiesInfo::setRefundAfterDeparture, PenaltiesInfo::isConditionsApplyRefundableAfter, PenaltiesInfo::setConditionsApplyRefundableAfter, this::setRefundAfterDepartureAmbiguousCurrency);
        }
    }

    private void resolvePenaltiesInfo(DictionaryReference<PassengerType> passengerType, PenaltiesInfo penaltiesInfo) {
        if (penaltiesInfo != null && (penaltiesInfo.getExchangableAfterDeparture() != null || penaltiesInfo.getExchangableBeforeDeparture() != null || penaltiesInfo.getRefundableBeforeDeparture() != null || penaltiesInfo.getRefundableAfterDeparture() != null)) {
            this.mergeExchangeToWorstCase(passengerType, penaltiesInfo);
            this.mergeRefundToWorstCase(passengerType, penaltiesInfo);
        }
    }

    public Map<DictionaryReference<PassengerType>, PenaltiesInfo> getPenaltiesInfos() {
        return this.penaltiesInfos;
    }

    private void applyStandardPenaltiesInfo(Map<DictionaryReference<PassengerType>, PenaltiesInfo> standardPenalties) {
        standardPenalties.entrySet().stream().forEach(e -> {
            if (this.penaltiesInfos.get(e.getKey()) == null) {
                this.mergeRefundToWorstCase((DictionaryReference<PassengerType>)((DictionaryReference)e.getKey()), (PenaltiesInfo)standardPenalties.get(e.getKey()));
                this.mergeExchangeToWorstCase((DictionaryReference<PassengerType>)((DictionaryReference)e.getKey()), (PenaltiesInfo)standardPenalties.get(e.getKey()));
            }
        });
        this.clearAmounts(this.refundBeforeDepartureAmbiguousCurrency, PenaltiesInfo::setRefundBeforeDeparture);
        this.clearAmounts(this.refundAfterDepartureAmbiguousCurrency, PenaltiesInfo::setRefundAfterDeparture);
        this.clearAmounts(this.exchangeBeforeDepartureAmbiguousCurrency, PenaltiesInfo::setExchangeBeforeDeparture);
        this.clearAmounts(this.exchangeAfterDepartureAmbiguousCurrency, PenaltiesInfo::setExchangeAfterDeparture);
    }

    private void clearAmounts(boolean needToClear, BiConsumer<PenaltiesInfo, Money> setter) {
        if (!needToClear) {
            return;
        }
        this.penaltiesInfos.values().forEach(info -> setter.accept((PenaltiesInfo)info, (Money)null));
    }
}

