/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.ibecorp.correspondence.handlers;

import com.gridnine.xtrip.common.l10n.model.LocaleManager;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.dict.CommunicationType;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.helpers.ProfileHelper;
import com.gridnine.xtrip.common.model.ibecorp.correspondence.BaseIssue;
import com.gridnine.xtrip.common.model.ibecorp.correspondence.IssueSubject;
import com.gridnine.xtrip.common.model.ibecorp.correspondence.IssueType;
import com.gridnine.xtrip.common.model.ibecorp.correspondence.NotificationEvent;
import com.gridnine.xtrip.common.model.ibecorp.correspondence.Post;
import com.gridnine.xtrip.common.model.mail.MailDocument;
import com.gridnine.xtrip.common.model.mail.MailPart;
import com.gridnine.xtrip.common.model.profile.Communication;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.profile.Person;
import com.gridnine.xtrip.common.model.system.ContentType;
import com.gridnine.xtrip.common.model.system.Document;
import com.gridnine.xtrip.common.util.LocaleUtil;
import com.gridnine.xtrip.common.util.Predicates;
import com.gridnine.xtrip.common.util.TextUtil;
import java.io.InputStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public abstract class BaseIssueHandler<T extends BaseIssue> {
    protected static final String HEAD = "head";
    protected static final String BODY = "body";
    protected static final String CREATED = "created";
    protected static final String UPDATED = "updated";
    protected static final String EVENT = "event";
    protected static final String TITLE = "title";
    protected static final String PRIORITY = "priority";
    protected static final String ASSIGNEE = "assignee";
    protected static final String STATUS = "status";
    protected static final String CLIENT = "client";
    protected static final String DESCRIPTION = "description";
    private static final Pattern ISSUE_NUMBER_PATTERN = Pattern.compile("\\$\\{issueNumber}");

    public InputStream getPrintTemplate() {
        return this.getClass().getResourceAsStream(this.getPrintTemplateName());
    }

    public int getTotalPosts(T issue) {
        int descCount = this.calcDescriptionCount(issue);
        return issue.getPosts().size() + descCount;
    }

    private int calcDescriptionCount(T issue) {
        String issueDescription = issue.getDescription();
        if (TextUtil.isBlank((String)issueDescription)) {
            return 0;
        }
        Optional<String> findFirst = issue.getPosts().stream().filter(Objects::nonNull).map(Post::getContent).filter(TextUtil::nonBlank).filter(postContent -> postContent.equals(issueDescription)).findAny();
        return findFirst.isPresent() ? 0 : 1;
    }

    public abstract String getPrintTemplateName();

    protected Map<String, Object> createParameters(T issue) {
        SimpleDateFormat df = new SimpleDateFormat();
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put(CREATED, issue.getCreateDate() != null ? df.format(issue.getCreateDate()) : "");
        params.put(UPDATED, issue.getUpdateDate() != null ? df.format(issue.getUpdateDate()) : "");
        params.put(TITLE, issue.getTitle());
        params.put(ASSIGNEE, issue.getAssignee() != null ? issue.getAssignee().toString() : "");
        params.put(STATUS, issue.getStatus() != null ? issue.getStatus().toString() : "");
        params.put(CLIENT, issue.getClient() != null ? issue.getClient().toString() : "");
        params.put(DESCRIPTION, issue.getDescription());
        return params;
    }

    public MailDocument buildMailMessage(EntityContainer<T> issueCtr, T oldIssue, NotificationEvent notificationEvent, String userId, EntityContainer<BookingFile> bookingFileCtr) {
        BaseIssue issue = (BaseIssue)issueCtr.getEntity();
        String subject = this.buildSubject(issue, userId, notificationEvent);
        String head = "<html><head><meta http-equiv=\"Content-Type\" content=\"text/html; charset=UTF-8\"></head><body><pre>";
        String wholeBody = this.buildBody(issue, oldIssue, notificationEvent);
        String mailData = head + wholeBody + "</pre></body></html>";
        MailPart mailPart = new MailPart();
        mailPart.setContentType(ContentType.HTML);
        mailPart.setData(mailData.getBytes());
        MailDocument mailDocument = new MailDocument();
        mailDocument.setCreated(new Date());
        mailDocument.setSubject(subject);
        mailDocument.setName(subject);
        mailDocument.setTitle(subject);
        mailDocument.setBody(mailPart);
        if (bookingFileCtr != null) {
            mailDocument.setOwner(bookingFileCtr.toReference());
        }
        mailDocument.getAttachments().addAll(this.buildAttachments(issue, oldIssue, notificationEvent));
        return mailDocument;
    }

    protected String buildSubject(T issue, String userId, NotificationEvent notificationEvent) {
        EntityContainer personCtr = ProfileHelper.getPersonCtr((String)userId);
        String userName = personCtr == null ? userId : personCtr.toReference().getCaption();
        return userName + ", " + notificationEvent + ": (" + issue.getNumber() + ") " + issue.getTitle();
    }

    private String buildBody(T issue, T oldIssue, NotificationEvent event) {
        StringBuilder body = new StringBuilder();
        if (event == NotificationEvent.ISSUE_CREATED) {
            EntityContainer authorCtr;
            EntityContainer assigneeCtr;
            body.append(issue.getTitle());
            body.append("<br>");
            body.append("<br>");
            body.append("ID: ");
            body.append(TextUtil.buildFullNumber(issue));
            body.append("<br>");
            body.append("Issue Type: ").append(this.getIssueType());
            body.append("<br>");
            EntityContainer clientCtr = EntityStorage.get().resolve(issue.getClient());
            if (clientCtr != null) {
                Organization client = (Organization)clientCtr.getEntity();
                body.append("Client code: ");
                String clientCode = client.getCode();
                if (TextUtil.nonBlank((String)clientCode)) {
                    body.append(clientCode);
                }
                body.append("<br>");
                body.append("Client name: ");
                String clientNameRu = (String)client.getShortName().getValues().get(LocaleUtil.LOCALE_RU);
                if (TextUtil.nonBlank((String)clientNameRu)) {
                    body.append(clientNameRu);
                }
                body.append("<br>");
            }
            body.append("Assignee: ");
            if (issue.getAssignee() != null && (assigneeCtr = EntityStorage.get().resolve(issue.getAssignee())) != null) {
                body.append(ProfileHelper.getFullName((Person)((Person)assigneeCtr.getEntity()), (Locale)LocaleManager.get().getDefaultLocale(), (boolean)false));
            }
            body.append("<br>");
            body.append("Author: ");
            if (issue.getAuthor() != null && (authorCtr = EntityStorage.get().resolve(issue.getAuthor())) != null) {
                body.append(ProfileHelper.getFullName((Person)((Person)authorCtr.getEntity()), (Locale)LocaleManager.get().getDefaultLocale(), (boolean)false));
                body.append("<br>");
                body.append("Author e-mail: ");
                body.append(((Person)authorCtr.getEntity()).getCommunications().stream().filter(communication -> communication.getType() == CommunicationType.EMAIL).map(Communication::getSense).filter(TextUtil::nonBlank).collect(Collectors.joining(", ")));
            }
            body.append("<br>");
            body.append("<br><br>");
            if (issue.getDescription() != null) {
                body.append(issue.getDescription());
            }
        } else if (event == NotificationEvent.ASSIGNEE_CHANGED) {
            body.append("Assignee: ");
            body.append((Object)(issue.getAssignee() == null ? "" : issue.getAssignee()));
            body.append("<br>");
            body.append("was: ");
            body.append((Object)(oldIssue.getAssignee() == null ? "" : oldIssue.getAssignee()));
        } else if (event == NotificationEvent.CLIENT_CHANGED) {
            body.append("Client: ");
            body.append((Object)(issue.getClient() == null ? "" : issue.getClient()));
            body.append("<br>");
            body.append("was: ");
            body.append((Object)(oldIssue.getClient() == null ? "" : oldIssue.getClient()));
        } else if (event == NotificationEvent.STATUS_CHANGED) {
            body.append("Status: ");
            body.append((Object)(issue.getStatus() == null ? "" : issue.getStatus()));
            body.append("<br>");
            body.append("was: ");
            body.append((Object)(oldIssue.getStatus() == null ? "" : oldIssue.getStatus()));
        } else if (event == NotificationEvent.COMMENT_ADDED) {
            int size = issue.getPosts().size();
            if (size > 0) {
                body.append(((Post)issue.getPosts().get(size - 1)).getContent());
            }
        } else if (event == NotificationEvent.TITLE_CHANGED) {
            body.append("Title: ");
            body.append(issue.getTitle() == null ? "" : issue.getTitle());
            body.append("<br>");
            body.append("was: ");
            body.append(oldIssue.getTitle() == null ? "" : oldIssue.getTitle());
        } else if (event == NotificationEvent.DESCRIPTION_CHANGED) {
            body.append("Description: ");
            body.append(issue.getDescription() == null ? "" : issue.getDescription());
            body.append("<br>");
            body.append("was: ");
            body.append(oldIssue.getDescription() == null ? "" : oldIssue.getDescription());
        }
        String result = body.toString();
        Matcher matcher = ISSUE_NUMBER_PATTERN.matcher(result);
        if (matcher.find()) {
            result = matcher.replaceAll(issue.getNumber());
        }
        return result;
    }

    private Collection<MailPart> buildAttachments(T issue, T oldIssue, NotificationEvent event) {
        ArrayList<MailPart> result = new ArrayList<MailPart>();
        if (event == NotificationEvent.ATTACHMENT_ADDED) {
            Set oldAttachments = oldIssue == null ? Collections.emptySet() : oldIssue.getPosts().stream().map(Post::getAttachments).flatMap(Collection::stream).collect(Collectors.toSet());
            return issue.getPosts().stream().map(Post::getAttachments).flatMap(Collection::stream).filter(Predicates.not(oldAttachments::contains)).map(BaseIssueHandler::buildAttachment).collect(Collectors.toList());
        }
        return result;
    }

    private static MailPart buildAttachment(EntityReference<Document> documentRef) {
        Document document = (Document)EntityStorage.get().resolve(documentRef).getEntity();
        MailPart result = new MailPart();
        result.setName(document.getName());
        result.setContentType(document.getContentType());
        result.setData(document.getContent());
        return result;
    }

    public abstract Class<?> getEntityClass();

    public abstract IssueType getIssueType();

    public abstract IssueSubject getSubject(T var1);
}

