/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.ibecorp.correspondence.rules;

import com.gridnine.xtrip.common.ibecorp.correspondence.rules.NotificationPropertySet;
import com.gridnine.xtrip.common.ibecorp.correspondence.rules.NotificationTargets;
import com.gridnine.xtrip.common.ibecorp.correspondence.rules.NotificationValueTypes;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.profile.SalesPoint;
import com.gridnine.xtrip.common.model.rules.standard.Conditions;
import com.gridnine.xtrip.common.model.rules.standard.RulesHelper;
import com.gridnine.xtrip.common.model.rules.standard.ValueTypes;
import com.gridnine.xtrip.common.rules.elements.RuleCondition;
import com.gridnine.xtrip.common.rules.elements.RuleProperty;
import java.util.List;
import org.slf4j.LoggerFactory;

public enum NotificationProperties implements RuleProperty
{
    AGENCY{
        private static final String DISPLAY_NAME = "\u041a\u043e\u0434 \u0430\u0433\u0435\u043d\u0442\u0441\u0442\u0432\u0430";

        @Override
        String[] getConditionIds() {
            return new String[]{Conditions.EQUALS.getId(), Conditions.NOT_EQUALS.getId()};
        }

        public String getDisplayName() {
            return DISPLAY_NAME;
        }

        public String getRendererId() {
            return ValueTypes.STRING_LIST.name();
        }

        @Override
        String[] getTargetIds() {
            return new String[]{NotificationTargets.NOTIFICATION_TARGET.getId()};
        }

        public void buildInfo(StringBuilder buf, RuleCondition cond, Object value) {
            buf.append(DISPLAY_NAME).append(" ").append(cond.getDisplayName()).append(" \"").append(RulesHelper.toString((Object)value)).append("\"");
        }

        public boolean match(Object propertySet, RuleCondition condition, Object value) {
            NotificationPropertySet ps = (NotificationPropertySet)propertySet;
            if (Conditions.EQUALS.equals((Object)condition)) {
                return RulesHelper.matchesStringRestriction((String)ps.getAgency(), (Object)value, (boolean)true);
            }
            if (Conditions.NOT_EQUALS.equals((Object)condition)) {
                return RulesHelper.matchesStringRestriction((String)ps.getAgency(), (Object)value, (boolean)false);
            }
            return true;
        }
    }
    ,
    SUBANGENCY{
        private static final String DISPLAY_NAME = "\u041a\u043e\u0434 \u0441\u0443\u0431\u0430\u0433\u0435\u043d\u0442\u0441\u0442\u0432\u0430";

        @Override
        String[] getConditionIds() {
            return new String[]{Conditions.EQUALS.getId(), Conditions.NOT_EQUALS.getId()};
        }

        public String getDisplayName() {
            return DISPLAY_NAME;
        }

        public String getRendererId() {
            return ValueTypes.STRING_LIST.name();
        }

        @Override
        String[] getTargetIds() {
            return new String[]{NotificationTargets.NOTIFICATION_TARGET.getId()};
        }

        public void buildInfo(StringBuilder buf, RuleCondition cond, Object value) {
            buf.append(DISPLAY_NAME).append(" ").append(cond.getDisplayName()).append(" \"").append(RulesHelper.toString((Object)value)).append("\"");
        }

        public boolean match(Object propertySet, RuleCondition condition, Object value) {
            NotificationPropertySet ps = (NotificationPropertySet)propertySet;
            if (Conditions.EQUALS.equals((Object)condition)) {
                return RulesHelper.matchesStringRestriction((String)ps.getSubagency(), (Object)value, (boolean)true);
            }
            if (Conditions.NOT_EQUALS.equals((Object)condition)) {
                return RulesHelper.matchesStringRestriction((String)ps.getSubagency(), (Object)value, (boolean)false);
            }
            return true;
        }
    }
    ,
    CLIENT{
        private static final String DISPLAY_NAME = "\u041a\u043e\u0434 \u043a\u043b\u0438\u0435\u043d\u0442\u0430";

        @Override
        String[] getConditionIds() {
            return new String[]{Conditions.EQUALS.getId(), Conditions.NOT_EQUALS.getId()};
        }

        public String getDisplayName() {
            return DISPLAY_NAME;
        }

        public String getRendererId() {
            return ValueTypes.STRING_LIST.name();
        }

        @Override
        String[] getTargetIds() {
            return new String[]{NotificationTargets.NOTIFICATION_TARGET.getId()};
        }

        public void buildInfo(StringBuilder buf, RuleCondition cond, Object value) {
            buf.append(DISPLAY_NAME).append(" ").append(cond.getDisplayName()).append(" \"").append(RulesHelper.toString((Object)value)).append("\"");
        }

        public boolean match(Object propertySet, RuleCondition condition, Object value) {
            NotificationPropertySet ps = (NotificationPropertySet)propertySet;
            if (Conditions.EQUALS.equals((Object)condition)) {
                return RulesHelper.matchesStringRestriction((String)ps.getClient(), (Object)value, (boolean)true);
            }
            if (Conditions.NOT_EQUALS.equals((Object)condition)) {
                return RulesHelper.matchesStringRestriction((String)ps.getClient(), (Object)value, (boolean)false);
            }
            return true;
        }
    }
    ,
    NOTIFICATION_EVENT{
        private static final String DISPLAY_NAME = "\u0421\u043e\u0431\u044b\u0442\u0438\u0435";

        @Override
        String[] getConditionIds() {
            return new String[]{Conditions.EQUALS.getId(), Conditions.NOT_EQUALS.getId()};
        }

        public String getDisplayName() {
            return DISPLAY_NAME;
        }

        public String getRendererId() {
            return NotificationValueTypes.NOTIFICATION_EVENT.name();
        }

        @Override
        String[] getTargetIds() {
            return new String[]{NotificationTargets.NOTIFICATION_TARGET.getId()};
        }

        public void buildInfo(StringBuilder buf, RuleCondition cond, Object value) {
            buf.append(DISPLAY_NAME).append(" ").append(cond.getDisplayName()).append(" \"").append(RulesHelper.toString((Object)value)).append("\"");
        }

        public boolean match(Object propertySet, RuleCondition condition, Object value) {
            NotificationPropertySet ps = (NotificationPropertySet)propertySet;
            if (Conditions.EQUALS.equals((Object)condition)) {
                return RulesHelper.matchesEnumRestriction((String)ps.getEventName(), (List)((List)value), (boolean)true);
            }
            if (Conditions.NOT_EQUALS.equals((Object)condition)) {
                return RulesHelper.matchesEnumRestriction((String)ps.getEventName(), (List)((List)value), (boolean)false);
            }
            return true;
        }
    }
    ,
    ISSUE_SUBJECT{
        private static final String DISPLAY_NAME = "\u0422\u0435\u043c\u0430 \u043f\u0435\u0440\u0435\u043f\u0438\u0441\u043a\u0438";

        @Override
        String[] getConditionIds() {
            return new String[]{Conditions.INCLUDE.getId()};
        }

        public String getDisplayName() {
            return DISPLAY_NAME;
        }

        public String getRendererId() {
            return NotificationValueTypes.ISSUE_SUBJECT.name();
        }

        @Override
        String[] getTargetIds() {
            return new String[]{NotificationTargets.NOTIFICATION_TARGET.getId()};
        }

        public void buildInfo(StringBuilder buf, RuleCondition cond, Object value) {
            buf.append(String.format("%s %s \"%s\"", DISPLAY_NAME, cond.getDisplayName(), RulesHelper.toString((Object)value)));
        }

        public boolean match(Object propertySet, RuleCondition condition, Object value) {
            NotificationPropertySet ps = (NotificationPropertySet)propertySet;
            if (Conditions.INCLUDE.equals((Object)condition)) {
                return RulesHelper.matchesEnumRestriction((String)ps.getIssueSubject(), (List)((List)value), (boolean)true);
            }
            return true;
        }
    }
    ,
    NOTIFICATION_SALES_POINT{
        private static final String DISPLAY_NAME = "\u0422\u043e\u0447\u043a\u0430 \u043f\u0440\u043e\u0434\u0430\u0436";

        @Override
        String[] getConditionIds() {
            return new String[]{Conditions.EQUALS.getId(), Conditions.NOT_EQUALS.getId()};
        }

        public String getDisplayName() {
            return DISPLAY_NAME;
        }

        public String getRendererId() {
            return ValueTypes.SALES_POINTS.name();
        }

        @Override
        String[] getTargetIds() {
            return new String[]{NotificationTargets.NOTIFICATION_TARGET.getId()};
        }

        public void buildInfo(StringBuilder buf, RuleCondition cond, Object value) {
            buf.append(DISPLAY_NAME).append(" ").append(cond.getDisplayName()).append(" ").append(this.toString((List)value));
        }

        private String toString(List<String> value) {
            if (value == null || value.isEmpty()) {
                return "";
            }
            StringBuilder sb = new StringBuilder();
            for (String uid : value) {
                String title = "???";
                try {
                    EntityContainer ctr = EntityStorage.get().resolve(new EntityReference(uid, SalesPoint.class, null));
                    if (ctr != null) {
                        title = ctr.toReference().toString();
                    }
                }
                catch (Exception e) {
                    LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("unable to resolve reference", (Throwable)e);
                }
                if (sb.length() > 0) {
                    sb.append(", ");
                }
                sb.append(title);
            }
            return sb.toString();
        }

        public boolean match(Object propertySet, RuleCondition condition, Object value) {
            NotificationPropertySet ps = (NotificationPropertySet)propertySet;
            List uids = (List)value;
            return RulesHelper.matchesStringRestriction((String)ps.getSalesPointUid(), (Object)uids, (boolean)Conditions.EQUALS.equals((Object)condition));
        }
    };


    public String getId() {
        return this.name();
    }

    abstract String[] getTargetIds();

    abstract String[] getConditionIds();
}

