/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.ibecorp.handlers;

import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.ReservationType;
import com.gridnine.xtrip.common.model.booking.railway.RailwayProduct;
import com.gridnine.xtrip.common.model.booking.railway.RailwaySegment;
import com.gridnine.xtrip.common.model.handlers.RailwayReceiptHandler;
import com.gridnine.xtrip.common.model.helpers.ProfileHelper;
import com.gridnine.xtrip.common.model.ibecorp.sm.SMSite;
import com.gridnine.xtrip.common.util.TextUtil;
import java.util.Locale;
import java.util.Map;

public class IbecorpRailwayReceiptHandler
implements RailwayReceiptHandler {
    private static final String EXPRESS_ID = "EXPRESS_ID";
    private static final String BARCODE_TEXT = "BARCODE_TEXT";
    private static final String SM_SITE = "SM_SITE";
    private static final String ARRIVAL_TRAIN_NUMBER = "ARRIVAL_TRAIN_NUMBER";
    private static final String WITH_BEDDING = "WITH_BEDDING";

    public String getId() {
        return "IBECORP-RAILWAY-RECEIPT-HANDLER";
    }

    public void getParameters(Map<String, Object> parameters, RailwayProduct product, Locale locale) {
        parameters.put(EXPRESS_ID, product.getExpressId());
        parameters.put(BARCODE_TEXT, product.getBarcodeText());
        parameters.put(SM_SITE, IbecorpRailwayReceiptHandler.getSMSite(product));
        parameters.put(ARRIVAL_TRAIN_NUMBER, IbecorpRailwayReceiptHandler.getArrivalTrainNumber(product));
        parameters.put(WITH_BEDDING, product.getWithBedding());
    }

    public static String getSMSite(RailwayProduct product) {
        Reservation reservation = product.getReservation();
        if (reservation == null) {
            return null;
        }
        if (reservation.getType() == ReservationType.INTERNET || reservation.getType() == ReservationType.IBE) {
            if (reservation.getBookingFile() == null) {
                return null;
            }
            EntityReference rfSMSite = reservation.getBookingFile().getSite();
            if (rfSMSite == null) {
                return null;
            }
            SMSite smSite = (SMSite)ProfileHelper.resolveReference((EntityReference)rfSMSite);
            if (smSite == null) {
                return null;
            }
            return smSite.getDomain();
        }
        return null;
    }

    public static String getArrivalTrainNumber(RailwayProduct product) {
        for (RailwaySegment segment : product.getSegments()) {
            if (segment.getArrivalTrainNumber() == null) continue;
            if (segment.getDepartureTrainNumber() != null && !TextUtil.isSame((String)segment.getArrivalTrainNumber(), (String)segment.getDepartureTrainNumber(), (boolean)true, (boolean)true)) {
                return TextUtil.trim((String)segment.getArrivalTrainNumber());
            }
            return TextUtil.trim((String)segment.getArrivalTrainNumber());
        }
        return null;
    }
}

