/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.ibecorp.model.helpers;

import com.gridnine.xtrip.common.Environment;
import com.gridnine.xtrip.common.gds.helper.FlightHelper;
import com.gridnine.xtrip.common.gds.model.Flight;
import com.gridnine.xtrip.common.gds.model.GdsCommission;
import com.gridnine.xtrip.common.gds.model.GdsContractRelationData;
import com.gridnine.xtrip.common.ibecorp.CurrencyHelper;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.PassengerType;
import com.gridnine.xtrip.common.model.booking.commission.BaseCommissionProperties;
import com.gridnine.xtrip.common.model.booking.commission.FeeProperties;
import com.gridnine.xtrip.common.model.dict.ContractType;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.helpers.GeneralProductHelper;
import com.gridnine.xtrip.common.model.helpers.ProfileHelper;
import com.gridnine.xtrip.common.model.profile.Contract;
import com.gridnine.xtrip.common.util.MiscUtil;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;

public final class IbecorpFlightHelper {
    private IbecorpFlightHelper() {
    }

    public static BigDecimal getCommissionsEquivalentAmount(Flight flight, ContractType contractType, Set<Class<? extends BaseCommissionProperties>> properties, Map<DictionaryReference<PassengerType>, Integer> passengers, int totalSeats, String currency) {
        BigDecimal result = BigDecimal.ZERO;
        Map contractRelations = FlightHelper.getContractRelations((Flight)flight, (ContractType)contractType);
        for (Map.Entry entry : contractRelations.entrySet()) {
            boolean isNotDirectBspContract = false;
            EntityContainer contract = EntityStorage.get().resolve((EntityReference)((GdsContractRelationData)entry.getValue()).getGeneralData().getContract());
            if (contract != null && ((Contract)contract.getEntity()).getContractType() == ContractType.VENDOR && !MiscUtil.equals((Object)((Contract)contract.getEntity()).getSupplier(), (Object)flight.getBlankOwner()) && ProfileHelper.isOrganizationCode((EntityReference)flight.getBlankOwner(), (String)"BSP")) {
                isNotDirectBspContract = true;
            }
            Collection gdsCommissions = GeneralProductHelper.filterCommissions((Collection)((GdsContractRelationData)entry.getValue()).getCommissions(), properties, isNotDirectBspContract ? Collections.singleton(GeneralProductHelper.CommissionType.STANDARD) : null, null);
            for (GdsCommission comm : gdsCommissions) {
                ArrayList contractRelationDatas = new ArrayList();
                contractRelationDatas.addAll(FlightHelper.getContractRelations((Flight)flight, (ContractType)ContractType.VENDOR, (DictionaryReference)((DictionaryReference)entry.getKey())));
                contractRelationDatas.addAll(FlightHelper.getContractRelations((Flight)flight, (ContractType)ContractType.SUBAGENCY, (DictionaryReference)((DictionaryReference)entry.getKey())));
                contractRelationDatas.addAll(FlightHelper.getContractRelations((Flight)flight, (ContractType)ContractType.CLIENT, (DictionaryReference)((DictionaryReference)entry.getKey())));
                BigDecimal value = CurrencyHelper.exchange(comm, currency, contractRelationDatas, true);
                if (value == null) continue;
                DictionaryReference passengerType = (DictionaryReference)entry.getKey();
                value = value.multiply(BigDecimal.valueOf(passengerType == null ? (long)totalSeats : (long)passengers.get(passengerType).intValue()));
                result = result.add(value);
            }
        }
        return result;
    }

    @Deprecated
    public static BigDecimal getSubagentCommissionsIncludeFilterByChargeToClient(Flight flight, Set<Class<? extends BaseCommissionProperties>> properties, Map<DictionaryReference<PassengerType>, Integer> passengers, int totalSeats, String currency) {
        BigDecimal result = BigDecimal.ZERO;
        Map contractRelations = FlightHelper.getContractRelations((Flight)flight, (ContractType)ContractType.CLIENT);
        for (Map.Entry entry : contractRelations.entrySet()) {
            for (GdsCommission comm : GeneralProductHelper.filterCommissions((Collection)((GdsContractRelationData)entry.getValue()).getCommissions(), properties, null, null)) {
                BigDecimal value;
                EntityContainer propCtr = ((EntityStorage)Environment.getPublished(EntityStorage.class)).resolve(comm.getCommissionProperties());
                if (propCtr == null || !(propCtr.getEntity() instanceof FeeProperties) || !((FeeProperties)propCtr.getEntity()).isChargeToClientForAllContractTypes() || (value = CurrencyHelper.exchange(comm, currency, Collections.singletonList(entry.getValue()), true)) == null) continue;
                DictionaryReference passengerType = (DictionaryReference)entry.getKey();
                value = value.multiply(BigDecimal.valueOf(passengerType == null ? (long)totalSeats : (long)passengers.get(passengerType).intValue()));
                result = result.add(value);
            }
        }
        return result;
    }
}

