/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.ibecorp.rest;

import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.util.DesUtil;
import com.gridnine.xtrip.common.util.TextUtil;

public final class AuthToken {
    public static final String IBECORP_B2B_AUTH_TOKEN_COOKIE_NAME = "IBECORP_B2B_AUTH_TOKEN_COOKIE";
    public static final String IBECORP_B2C_AUTH_TOKEN_COOKIE_NAME = "IBECORP_B2C_AUTH_TOKEN_COOKIE";
    private static final long AUTH_TOKEN_TTL_SECS = 600L;
    private static final char[] SKEY = "Jv6DwMBLSmLYG4Wi".toCharArray();
    private String data;
    private long ttl;

    public static AuthToken decode(String str) throws Exception {
        if (TextUtil.isBlank((String)str)) {
            return null;
        }
        AuthToken result = new AuthToken();
        String token = DesUtil.decrypt((char[])SKEY, (String)str);
        int p = token.indexOf(124);
        if (p == -1) {
            throw Xeption.forDeveloper((String)"invalid auth token", (Object[])new Object[0]);
        }
        result.ttl = Long.parseLong(token.substring(0, p));
        result.data = token.substring(p + 1);
        return result;
    }

    private AuthToken() {
    }

    public AuthToken(String authData) {
        this.data = authData;
        this.ttl = System.currentTimeMillis() + 600000L;
    }

    public AuthToken(String authData, int minutesToLive) {
        this.data = authData;
        this.ttl = System.currentTimeMillis() + (long)(minutesToLive * 60) * 1000L;
    }

    public boolean isExpired() {
        return System.currentTimeMillis() > this.ttl;
    }

    public String getData() {
        return this.data;
    }

    public String encode() throws Exception {
        return DesUtil.encrypt((char[])SKEY, (String)(String.valueOf(this.ttl) + '|' + this.data));
    }
}

