/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.ibecorp.rules;

import com.gridnine.xtrip.common.gds.rules.GDSParametersActionsProvider;
import com.gridnine.xtrip.common.ibecorp.rules.AuthorizationTemplateActionResult;
import com.gridnine.xtrip.common.ibecorp.rules.HotelPreprocessingActionsProvider;
import com.gridnine.xtrip.common.ibecorp.rules.IbecorpActionsProvider;
import com.gridnine.xtrip.common.ibecorp.rules.IbecorpShipmentActionSet;
import com.gridnine.xtrip.common.ibecorp.rules.NotificationsActionSet;
import com.gridnine.xtrip.common.ibecorp.rules.NotificationsActionsProvider;
import com.gridnine.xtrip.common.ibecorp.rules.PrintActionSet;
import com.gridnine.xtrip.common.ibecorp.rules.ReportApplicationActionSet;
import com.gridnine.xtrip.common.ibecorp.rules.SbisActionSet;
import com.gridnine.xtrip.common.ibecorp.rules.SbisExportParametersSettings;
import com.gridnine.xtrip.common.ibecorp.rules.SearchResultSortTypeActionsProvider;
import com.gridnine.xtrip.common.ibecorp.rules.Targets;
import com.gridnine.xtrip.common.ibecorp.rules.ValueTypes;
import com.gridnine.xtrip.common.ibecorp.rules.l10n.Messages;
import com.gridnine.xtrip.common.l10n.messages.L10n;
import com.gridnine.xtrip.common.l10n.model.L10nResourcesManager;
import com.gridnine.xtrip.common.l10n.model.LocaleHelper;
import com.gridnine.xtrip.common.meta.EntityType;
import com.gridnine.xtrip.common.meta.MetaRegistryHelper;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.Introspectable;
import com.gridnine.xtrip.common.model.booking.AirItineraryReceiptData;
import com.gridnine.xtrip.common.model.booking.CertificateOfCompletedFlightData;
import com.gridnine.xtrip.common.model.booking.FinanceDocumentType;
import com.gridnine.xtrip.common.model.booking.HotelVoucherData;
import com.gridnine.xtrip.common.model.booking.additionalservice.AdditionalServiceCategory;
import com.gridnine.xtrip.common.model.finance.DocumentSortType;
import com.gridnine.xtrip.common.model.finance.FinancePrintData;
import com.gridnine.xtrip.common.model.ibecorp.AvailableRegistryFieldsSettings;
import com.gridnine.xtrip.common.model.ibecorp.AvailableReportsSettings;
import com.gridnine.xtrip.common.model.ibecorp.IssueMailTemplate;
import com.gridnine.xtrip.common.model.ibecorp.NotificationRecipientMailTemplate;
import com.gridnine.xtrip.common.model.ibecorp.SearchResultSortType;
import com.gridnine.xtrip.common.model.ibecorp.sbis.SbisDocumentElementAttributesPredefined;
import com.gridnine.xtrip.common.model.ibecorp.sbis.SbisDocumentElementData;
import com.gridnine.xtrip.common.model.ibecorp.sbis.SbisDocumentFormatSettings;
import com.gridnine.xtrip.common.model.ibecorp.sm.AuthorizationMailTemplate;
import com.gridnine.xtrip.common.model.ibecorp.sm.MailTemplate;
import com.gridnine.xtrip.common.model.ibecorp.xreports.ReportReference;
import com.gridnine.xtrip.common.model.rules.standard.CommissionActionsProvider;
import com.gridnine.xtrip.common.model.rules.standard.RuleResultValue;
import com.gridnine.xtrip.common.model.rules.standard.RulesHelper;
import com.gridnine.xtrip.common.model.system.DocumentType;
import com.gridnine.xtrip.common.rules.elements.RuleAction;
import com.gridnine.xtrip.common.rules.elements.RuleProxy;
import com.gridnine.xtrip.common.util.BooleanUtil;
import com.gridnine.xtrip.common.util.CollectionUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;

public enum Actions implements RuleAction
{
    RESERVATIONS_CANCEL{

        public String getDisplayName() {
            return "\u0420\u0430\u0437\u0440\u0435\u0448\u0438\u0442\u044c \u043e\u0442\u043c\u0435\u043d\u0443 \u0431\u0440\u043e\u043d\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u0439 \u043d\u0430 \u0441\u0430\u0439\u0442\u0435";
        }

        public String getRendererId() {
            return com.gridnine.xtrip.common.model.rules.standard.ValueTypes.YES_NO.name();
        }

        public boolean hasValue() {
            return true;
        }

        public void buildInfo(StringBuilder buf, Object value) {
            buf.append("\u0420\u0430\u0437\u0440\u0435\u0448\u0438\u0442\u044c \u043e\u0442\u043c\u0435\u043d\u0443 \u0431\u0440\u043e\u043d\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u0439 \u043d\u0430 \u0441\u0430\u0439\u0442\u0435: ").append((Boolean)value);
        }

        public String getRuleCategoryValue(Object actionSet, Object value) {
            return "reservations_cancel_tickets";
        }

        public void apply(RuleProxy<?, ?> proxy, Object value) {
            IbecorpActionsProvider iap = (IbecorpActionsProvider)proxy.getActionSet();
            Boolean permitted = (Boolean)value;
            iap.setReservationCancelPermitted(permitted);
            proxy.getAppliedRuleCategories().add(this.getRuleCategoryValue(iap, value));
        }

        @Override
        String[] getTargetIds() {
            return new String[]{Targets.RESERVATIONS_CANCEL_TICKETS_VOIDING.getId()};
        }
    }
    ,
    TICKETS_VOIDING{

        public String getDisplayName() {
            return "\u0420\u0430\u0437\u0440\u0435\u0448\u0438\u0442\u044c \u0430\u043d\u043d\u0443\u043b\u044f\u0446\u0438\u044e \u0431\u0438\u043b\u0435\u0442\u043e\u0432 \u043d\u0430 \u0441\u0430\u0439\u0442\u0435";
        }

        public String getRendererId() {
            return com.gridnine.xtrip.common.model.rules.standard.ValueTypes.YES_NO.name();
        }

        public boolean hasValue() {
            return true;
        }

        public void buildInfo(StringBuilder buf, Object value) {
            buf.append(this.getDisplayName()).append(": ").append((Boolean)value);
        }

        public String getRuleCategoryValue(Object actionSet, Object value) {
            return "reservations_voiding_tickets";
        }

        public void apply(RuleProxy<?, ?> proxy, Object value) {
            IbecorpActionsProvider iap = (IbecorpActionsProvider)proxy.getActionSet();
            Boolean permitted = (Boolean)value;
            iap.setTicketVoidingPermitted(permitted);
            proxy.getAppliedRuleCategories().add(this.getRuleCategoryValue(iap, value));
        }

        @Override
        String[] getTargetIds() {
            return new String[]{Targets.RESERVATIONS_CANCEL_TICKETS_VOIDING.getId()};
        }
    }
    ,
    TICKETS_REFUND{

        public String getDisplayName() {
            return L10n.get((String)Messages.IbecorpRuleAction_TICKETS_REFUND);
        }

        public String getRendererId() {
            return com.gridnine.xtrip.common.model.rules.standard.ValueTypes.YES_NO.name();
        }

        public boolean hasValue() {
            return true;
        }

        public void buildInfo(StringBuilder buf, Object value) {
            buf.append(this.getDisplayName()).append(": ").append((Boolean)value);
        }

        public String getRuleCategoryValue(Object actionSet, Object value) {
            return "reservations_refund_tickets";
        }

        public void apply(RuleProxy<?, ?> proxy, Object value) {
            IbecorpActionsProvider iap = (IbecorpActionsProvider)proxy.getActionSet();
            Boolean permitted = (Boolean)value;
            iap.setTicketRefundPermitted(permitted);
            proxy.getAppliedRuleCategories().add(this.getRuleCategoryValue(iap, value));
        }

        @Override
        String[] getTargetIds() {
            return new String[]{Targets.RESERVATIONS_CANCEL_TICKETS_VOIDING.getId()};
        }
    }
    ,
    VOID_IN_REFUND{

        public String getDisplayName() {
            return L10n.get((String)Messages.IbecorpRuleAction_VOID_IN_REFUND);
        }

        public String getRendererId() {
            return com.gridnine.xtrip.common.model.rules.standard.ValueTypes.YES_NO.name();
        }

        public boolean hasValue() {
            return true;
        }

        public void buildInfo(StringBuilder buf, Object value) {
            buf.append(this.getDisplayName()).append(": ").append((Boolean)value);
        }

        public String getRuleCategoryValue(Object actionSet, Object value) {
            return "reservations_void_in_refund";
        }

        public void apply(RuleProxy<?, ?> proxy, Object value) {
            IbecorpActionsProvider iap = (IbecorpActionsProvider)proxy.getActionSet();
            iap.setVoidInRefund((Boolean)value);
            proxy.getAppliedRuleCategories().add(this.getRuleCategoryValue(iap, value));
        }

        @Override
        String[] getTargetIds() {
            return new String[]{Targets.RESERVATIONS_CANCEL_TICKETS_VOIDING.getId()};
        }
    }
    ,
    TICKETS_EXCHANGE{

        public String getDisplayName() {
            return "\u0420\u0430\u0437\u0440\u0435\u0448\u0438\u0442\u044c \u043e\u0431\u043c\u0435\u043d \u0431\u0438\u043b\u0435\u0442\u043e\u0432 \u043d\u0430 \u0441\u0430\u0439\u0442\u0435";
        }

        public String getRendererId() {
            return com.gridnine.xtrip.common.model.rules.standard.ValueTypes.YES_NO.name();
        }

        public boolean hasValue() {
            return true;
        }

        public void buildInfo(StringBuilder buf, Object value) {
            buf.append(this.getDisplayName()).append(": ").append((Boolean)value);
        }

        public String getRuleCategoryValue(Object actionSet, Object value) {
            return this.name();
        }

        public void apply(RuleProxy<?, ?> proxy, Object value) {
            IbecorpActionsProvider iap = (IbecorpActionsProvider)proxy.getActionSet();
            Boolean permitted = (Boolean)value;
            iap.setTicketExchangePermitted(permitted);
            proxy.getAppliedRuleCategories().add(this.getRuleCategoryValue(iap, value));
        }

        @Override
        String[] getTargetIds() {
            return new String[]{Targets.TICKETS_EXCHANGE.getId()};
        }
    }
    ,
    PERMIT_ADDITIONAL_SERVICE_CREATION{

        public String getDisplayName() {
            return "\u0420\u0430\u0437\u0440\u0435\u0448\u0438\u0442\u044c \u0441\u043e\u0437\u0434\u0430\u043d\u0438\u0435 \u0434\u043e\u043f\u043e\u043b\u043d\u0438\u0442\u0435\u043b\u044c\u043d\u044b\u0445 \u0443\u0441\u043b\u0443\u0433";
        }

        public String getRendererId() {
            return com.gridnine.xtrip.common.model.rules.standard.ValueTypes.ADDITIONAL_SERVICE_CATEGORY.name();
        }

        public boolean hasValue() {
            return true;
        }

        public void buildInfo(StringBuilder buf, Object value) {
            if (value == null) {
                return;
            }
            List categories = (List)value;
            if (categories.size() == 0) {
                return;
            }
            buf.append(L10nResourcesManager.getStr((String)com.gridnine.xtrip.common.model.rules.l10n.Messages.RuleAction_PermitAdditionalServicesCreation_info, (Object[])new Object[]{CollectionUtil.collectionToString((Iterable)categories, (String)", ", (boolean)false)}));
        }

        @Override
        String[] getTargetIds() {
            return new String[]{Targets.ADDITIONAL_SERVICES.getId()};
        }

        public String getRuleCategoryValue(Object actionSet, Object value) {
            return "\"enable-creating\"";
        }

        public void apply(RuleProxy<?, ?> proxy, Object value) {
            for (AdditionalServiceCategory category : (List)value) {
                ((IbecorpActionsProvider)proxy.getActionSet()).addAllowedAdditionalServiceCategory(category);
            }
            proxy.getAppliedRuleCategories().add(this.getRuleCategoryValue(proxy.getActionSet(), value));
        }
    }
    ,
    PERMIT_ANCILLARY_FEES{

        public String getDisplayName() {
            return L10n.get((String)Messages.IbecorpRuleAction_PERMIT_ANCILLARY_FEES);
        }

        public String getRendererId() {
            return com.gridnine.xtrip.common.model.rules.standard.ValueTypes.YES_NO.name();
        }

        public boolean hasValue() {
            return true;
        }

        public void buildInfo(StringBuilder buf, Object value) {
            buf.append(this.getDisplayName()).append(": ").append((Boolean)value);
        }

        public String getRuleCategoryValue(Object actionSet, Object value) {
            return this.name();
        }

        public void apply(RuleProxy<?, ?> proxy, Object value) {
            IbecorpActionsProvider iap = (IbecorpActionsProvider)proxy.getActionSet();
            Boolean permitted = (Boolean)value;
            iap.setAncillaryFeesPermitted(permitted);
            proxy.getAppliedRuleCategories().add(this.getRuleCategoryValue(iap, value));
        }

        @Override
        String[] getTargetIds() {
            return new String[]{Targets.ADDITIONAL_SERVICES.getId()};
        }
    }
    ,
    AVIA_RECEIPT{

        public String getDisplayName() {
            return L10n.get((String)Messages.AVIA_RECEIPT_displayName);
        }

        public String getRendererId() {
            return ValueTypes.AVIA_RECEIPT.name();
        }

        public boolean hasValue() {
            return true;
        }

        public void buildInfo(StringBuilder buf, Object value) {
            List templates;
            if (value != null && (templates = ((AirItineraryReceiptData)value).getTemplates()) != null) {
                templates.forEach(buf::append);
            }
        }

        public String getRuleCategoryValue(Object actionSet, Object value) {
            return "avia_receipt";
        }

        public void apply(RuleProxy<?, ?> proxy, Object value) {
            CommissionActionsProvider actionSet = (CommissionActionsProvider)proxy.getActionSet();
            AirItineraryReceiptData data = (AirItineraryReceiptData)value;
            actionSet.setItineraryReceiptData(data);
            proxy.getAppliedRuleCategories().add(this.getRuleCategoryValue(proxy.getActionSet(), value));
        }

        @Override
        String[] getTargetIds() {
            return new String[]{com.gridnine.xtrip.common.model.rules.standard.Targets.PRODUCT_COMMISSION.getId()};
        }
    }
    ,
    RAILWAY_RECEIPT{

        public String getDisplayName() {
            return "\u0428\u0430\u0431\u043b\u043e\u043d(\u044b) \u043a\u0432\u0438\u0442\u0430\u043d\u0446\u0438\u0438(\u0439)";
        }

        public String getRendererId() {
            return ValueTypes.RAILWAY_RECEIPT.name();
        }

        public boolean hasValue() {
            return true;
        }

        public void buildInfo(StringBuilder buf, Object value) {
            if (value != null) {
                buf.append(value);
            }
        }

        public String getRuleCategoryValue(Object actionSet, Object value) {
            return "railway_receipts";
        }

        public void apply(RuleProxy<?, ?> proxy, Object value) {
            CommissionActionsProvider actionSet = (CommissionActionsProvider)proxy.getActionSet();
            List<EntityReference> templates = value == null ? Collections.emptyList() : (value instanceof List ? (List<EntityReference>)value : Collections.singletonList((EntityReference)value));
            actionSet.setReceiptTemplates(templates);
            proxy.getAppliedRuleCategories().add(this.getRuleCategoryValue(proxy.getActionSet(), value));
        }

        @Override
        String[] getTargetIds() {
            return new String[]{com.gridnine.xtrip.common.railway.model.rules.standart.Targets.RAILWAY_PRODUCT_COMMISSION.getId()};
        }
    }
    ,
    TRANSFER_RECEIPT{

        public String getDisplayName() {
            return "\u0428\u0430\u0431\u043b\u043e\u043d(\u044b) \u043a\u0432\u0438\u0442\u0430\u043d\u0446\u0438\u0438(\u0439)";
        }

        public String getRendererId() {
            return ValueTypes.TRANSFER_RECEIPT.name();
        }

        public boolean hasValue() {
            return true;
        }

        public void buildInfo(StringBuilder buf, Object value) {
            if (value != null) {
                buf.append(value);
            }
        }

        public String getRuleCategoryValue(Object actionSet, Object value) {
            return "transfer_receipts";
        }

        public void apply(RuleProxy<?, ?> proxy, Object value) {
            CommissionActionsProvider actionSet = (CommissionActionsProvider)proxy.getActionSet();
            List<EntityReference> templates = value == null ? Collections.emptyList() : (value instanceof List ? (List<EntityReference>)value : Collections.singletonList((EntityReference)value));
            actionSet.setReceiptTemplates(templates);
            proxy.getAppliedRuleCategories().add(this.getRuleCategoryValue(proxy.getActionSet(), value));
        }

        @Override
        String[] getTargetIds() {
            return new String[]{com.gridnine.xtrip.common.model.rules.standard.Targets.TRANSFER.getId()};
        }
    }
    ,
    HOTEL_RECEIPT{

        public String getDisplayName() {
            return L10n.get((String)Messages.Actions_HOTEL_RECEIPT_displayName);
        }

        public String getRendererId() {
            return ValueTypes.HOTEL_RECEIPT.name();
        }

        public boolean hasValue() {
            return true;
        }

        public void buildInfo(StringBuilder buf, Object value) {
            List templates;
            if (value != null && (templates = ((HotelVoucherData)value).getTemplates()) != null) {
                templates.forEach(buf::append);
            }
        }

        public String getRuleCategoryValue(Object actionSet, Object value) {
            return "hotel_receipt";
        }

        public void apply(RuleProxy<?, ?> proxy, Object value) {
            CommissionActionsProvider actionSet = (CommissionActionsProvider)proxy.getActionSet();
            HotelVoucherData data = (HotelVoucherData)value;
            actionSet.setHotelVoucherData(data);
            proxy.getAppliedRuleCategories().add(this.getRuleCategoryValue(proxy.getActionSet(), value));
        }

        @Override
        String[] getTargetIds() {
            return new String[]{com.gridnine.xtrip.common.model.rules.standard.Targets.HOTELS_COMMISSION.getId()};
        }
    }
    ,
    AEROEXPRESS_RECEIPT{

        public String getDisplayName() {
            return "\u0428\u0430\u0431\u043b\u043e\u043d(\u044b) \u043a\u0432\u0438\u0442\u0430\u043d\u0446\u0438\u0438(\u0439)";
        }

        public String getRendererId() {
            return ValueTypes.AEROEXPRESS_RECEIPT.name();
        }

        public boolean hasValue() {
            return true;
        }

        public void buildInfo(StringBuilder buf, Object value) {
            if (value != null) {
                buf.append(value);
            }
        }

        public String getRuleCategoryValue(Object actionSet, Object value) {
            return "aeroexpress_receipts";
        }

        public void apply(RuleProxy<?, ?> proxy, Object value) {
            CommissionActionsProvider actionSet = (CommissionActionsProvider)proxy.getActionSet();
            List<EntityReference> templates = value == null ? Collections.emptyList() : (value instanceof List ? (List<EntityReference>)value : Collections.singletonList((EntityReference)value));
            actionSet.setReceiptTemplates(templates);
            proxy.getAppliedRuleCategories().add(this.getRuleCategoryValue(proxy.getActionSet(), value));
        }

        @Override
        String[] getTargetIds() {
            return new String[]{com.gridnine.xtrip.common.model.rules.standard.Targets.AEROEXPRESS_COMMISSION.getId()};
        }
    }
    ,
    CERTIFICATE_OF_COMPLETED_FLIGHT_RECEIPT{

        public String getDisplayName() {
            return "\u0428\u0430\u0431\u043b\u043e\u043d \u0441\u043f\u0440\u0430\u0432\u043a\u0438 \u043e \u0441\u043e\u0432\u0435\u0440\u0448\u0435\u043d\u043d\u043e\u043c \u043f\u0435\u0440\u0435\u043b\u0435\u0442\u0435";
        }

        public String getRendererId() {
            return ValueTypes.CERTIFICATE_OF_COMPLETED_FLIGHT_RECEIPT.name();
        }

        public boolean hasValue() {
            return true;
        }

        public void buildInfo(StringBuilder buf, Object value) {
            List templates;
            if (value != null && !(templates = ((CertificateOfCompletedFlightData)value).getTemplates()).isEmpty()) {
                buf.append(templates.stream().map(Objects::toString).collect(Collectors.joining(", ")));
            }
        }

        public String getRuleCategoryValue(Object actionSet, Object value) {
            return "certificate_of_completed_flight_receipt";
        }

        public void apply(RuleProxy<?, ?> proxy, Object value) {
            CommissionActionsProvider actionSet = (CommissionActionsProvider)proxy.getActionSet();
            CertificateOfCompletedFlightData template = (CertificateOfCompletedFlightData)value;
            actionSet.setCertificateOfCompletedFlightData(template);
            proxy.getAppliedRuleCategories().add(this.getRuleCategoryValue(proxy.getActionSet(), value));
        }

        @Override
        String[] getTargetIds() {
            return new String[]{com.gridnine.xtrip.common.model.rules.standard.Targets.ADDITIONAL_SERVICE_PRODUCT.getId()};
        }
    }
    ,
    AUTO_CREATE_CERTIFICATE_OF_COMPLETED_FLIGHT{

        public String getDisplayName() {
            return L10n.get((String)Messages.AUTO_CREATE_CERTIFICATE_OF_COMPLETED_FLIGHT_displayName);
        }

        public String getRendererId() {
            return com.gridnine.xtrip.common.model.rules.standard.ValueTypes.YES_NO.name();
        }

        public boolean hasValue() {
            return true;
        }

        public void buildInfo(StringBuilder buf, Object value) {
        }

        public String getRuleCategoryValue(Object actionSet, Object value) {
            return "auto-create-certificate_of_completed_flight";
        }

        public void apply(RuleProxy<?, ?> proxy, Object value) {
            CommissionActionsProvider actionSet = (CommissionActionsProvider)proxy.getActionSet();
            actionSet.setAutoCreateCertificateOfCompletedFlight(Boolean.TRUE.equals(value));
            proxy.getAppliedRuleCategories().add(this.getRuleCategoryValue(proxy.getActionSet(), value));
        }

        @Override
        String[] getTargetIds() {
            return new String[]{com.gridnine.xtrip.common.model.rules.standard.Targets.PRODUCT_COMMISSION.getId()};
        }
    }
    ,
    XREPORTS_REGISTRY{

        public String getDisplayName() {
            return L10n.get((String)"XREPORTS_REGISTRY");
        }

        public String getRendererId() {
            return ValueTypes.XREPORTS_REGISTRY.name();
        }

        public boolean hasValue() {
            return true;
        }

        public void buildInfo(StringBuilder buf, Object value) {
            ReportReference ref = (ReportReference)value;
            buf.append(L10n.replace((String)L10n.get((String)"XREPORTS_REGISTRY_INFO"), (Object[])new Object[]{ref == null ? "???" : ref.getTitle()}));
        }

        public String getRuleCategoryValue(Object actionSet, Object value) {
            return this.name();
        }

        public void apply(RuleProxy<?, ?> proxy, Object value) {
            ReportReference ref = (ReportReference)value;
            if (ref != null && proxy.getActionSet() instanceof IbecorpShipmentActionSet) {
                IbecorpShipmentActionSet actionSet = (IbecorpShipmentActionSet)((Object)proxy.getActionSet());
                actionSet.setReportReference(ref);
                proxy.getAppliedRuleCategories().add(this.getRuleCategoryValue((Object)actionSet, value));
            }
        }

        @Override
        String[] getTargetIds() {
            return new String[]{com.gridnine.xtrip.common.model.rules.finance.Targets.SHIPMENT.getId()};
        }
    }
    ,
    SBIS_DOCUMENTS_FORMAT{

        public String getDisplayName() {
            return L10n.get((String)"SBIS_DOCUMENTS_FORMAT");
        }

        public String getRendererId() {
            return ValueTypes.SBIS_DOCUMENTS_FORMAT.name();
        }

        public boolean hasValue() {
            return true;
        }

        public void buildInfo(StringBuilder buf, Object value) {
            SbisDocumentFormatSettings settings = (SbisDocumentFormatSettings)value;
            if (settings != null) {
                buf.append(L10n.replace((String)L10n.get((String)"SBIS_DOCUMENTS_FORMAT_INFO"), (Object[])new Object[]{settings.getAcceptanceCertificate(), settings.getInvoice(), settings.getInvoiceFactura(), settings.getUniversalDocument()}));
            }
        }

        public String getRuleCategoryValue(Object actionSet, Object value) {
            return this.name();
        }

        public void apply(RuleProxy<?, ?> proxy, Object value) {
            SbisDocumentFormatSettings settings = (SbisDocumentFormatSettings)value;
            if (settings != null && proxy.getActionSet() instanceof SbisActionSet) {
                SbisActionSet actionSet = (SbisActionSet)proxy.getActionSet();
                actionSet.setSbisDocumentFormatSettings(settings);
                proxy.getAppliedRuleCategories().add(this.getRuleCategoryValue(actionSet, value));
            }
        }

        @Override
        String[] getTargetIds() {
            return new String[]{Targets.SBIS_PARAMETERS.getId()};
        }
    }
    ,
    SBIS_RELATED_DOCUMENTS_SETTINGS{

        @Override
        String[] getTargetIds() {
            return new String[]{Targets.SBIS_PARAMETERS.getId()};
        }

        public String getDisplayName() {
            return L10n.get((String)"SBIS_RELATED_DOCUMENTS_SETTINGS");
        }

        public String getRendererId() {
            return com.gridnine.xtrip.common.model.rules.standard.ValueTypes.YES_NO.name();
        }

        public boolean hasValue() {
            return true;
        }

        public void buildInfo(StringBuilder buf, Object value) {
            if (BooleanUtil.nullAsFalse((Boolean)((Boolean)value))) {
                buf.append(L10n.get((String)"SBIS_RELATED_DOCUMENTS_SETTINGS_YES"));
            } else {
                buf.append(L10n.get((String)"SBIS_RELATED_DOCUMENTS_SETTINGS_NO"));
            }
        }

        public String getRuleCategoryValue(Object actionSet, Object value) {
            return this.name();
        }

        public void apply(RuleProxy<?, ?> proxy, Object value) {
            SbisActionSet actionSet = (SbisActionSet)proxy.getActionSet();
            actionSet.setExportRelatedDocuments(BooleanUtil.nullAsFalse((Boolean)((Boolean)value)));
            proxy.getAppliedRuleCategories().add(this.getRuleCategoryValue(actionSet, value));
        }
    }
    ,
    SBIS_DOCUMENT_ELEMENT_DATA{

        public String getDisplayName() {
            return L10n.get((String)"SBIS_DOCUMENT_ELEMENT_DATA");
        }

        public String getRendererId() {
            return ValueTypes.SBIS_DOCUMENT_ELEMENT_DATA.name();
        }

        public boolean hasValue() {
            return true;
        }

        public void buildInfo(StringBuilder buf, Object value) {
            SbisDocumentElementData sbisDocumentElementData = (SbisDocumentElementData)value;
            if (sbisDocumentElementData != null && sbisDocumentElementData.getElement() != null) {
                SbisDocumentElementAttributesPredefined attributesPredefined = sbisDocumentElementData.getAttributesPredefined();
                StringBuilder builder = new StringBuilder();
                if (attributesPredefined.isProductStatus()) {
                    builder.append(L10n.get((String)"SBIS_SERVICE_TYPE"));
                }
                if (attributesPredefined.isBookingNumber()) {
                    if (builder.length() != 0) {
                        builder.append("; ");
                    }
                    builder.append(L10n.get((String)"SBIS_BOOKING_NUMBER"));
                }
                if (attributesPredefined.isBooking\u0421reateDate()) {
                    if (builder.length() != 0) {
                        builder.append("; ");
                    }
                    builder.append(L10n.get((String)"SBIS_BOOKING_CREATE_DATE"));
                }
                if (attributesPredefined.isCarrierRegistrationId()) {
                    if (builder.length() != 0) {
                        builder.append("; ");
                    }
                    builder.append(L10n.get((String)"SBIS_CARRIER_REGISTRATION_ID"));
                }
                if (attributesPredefined.isCarrierKpp()) {
                    if (builder.length() != 0) {
                        builder.append("; ");
                    }
                    builder.append(L10n.get((String)"SBIS_CARRIER_KPP"));
                }
                if (attributesPredefined.isTicketNumber()) {
                    if (builder.length() != 0) {
                        builder.append("; ");
                    }
                    builder.append(L10n.get((String)"SBIS_TICKET_NUMBER"));
                }
                if (attributesPredefined.isTicketDate()) {
                    if (builder.length() != 0) {
                        builder.append("; ");
                    }
                    builder.append(L10n.get((String)"SBIS_TICKET_DATE"));
                }
                if (attributesPredefined.isIntermediaryService()) {
                    if (builder.length() != 0) {
                        builder.append("; ");
                    }
                    builder.append(L10n.get((String)"SBIS_INTERMEDIARY_SERVICE"));
                }
                if (attributesPredefined.isVendorInvoiceFacturaNumber()) {
                    if (builder.length() != 0) {
                        builder.append("; ");
                    }
                    builder.append(L10n.get((String)"SBIS_VENDOR_INVOICE_FACTURA_NUMBER"));
                }
                if (attributesPredefined.isVendorInvoiceFacturaDate()) {
                    if (builder.length() != 0) {
                        builder.append("; ");
                    }
                    builder.append(L10n.get((String)"SBIS_VENDOR_INVOICE_FACTURA_DATE"));
                }
                if (attributesPredefined.isLocationType()) {
                    if (builder.length() != 0) {
                        builder.append("; ");
                    }
                    builder.append(L10n.get((String)"SBIS_LOCATION_TYPE"));
                }
                if (attributesPredefined.isServiceType()) {
                    if (builder.length() != 0) {
                        builder.append("; ");
                    }
                    builder.append(L10n.get((String)"SBIS_BILLING_ITEM_SERVICE_TYPE"));
                }
                List sbisDocumentElementAttributes = sbisDocumentElementData.getAttributes();
                String attributes = sbisDocumentElementAttributes.stream().filter(item -> TextUtil.nonBlank((String)item.getIdentifier()) && item.getCostCodeCategory() != null).map(item -> item.getIdentifier().concat(" - ").concat(item.getCostCodeCategory().toString())).collect(Collectors.joining("; "));
                buf.append(L10n.replace((String)L10n.get((String)"SBIS_DOCUMENT_ELEMENT_DATA_INFO"), (Object[])new Object[]{sbisDocumentElementData.getElement().toString(LocaleHelper.RU_LOCALE), attributes.length() != 0 ? attributes + (builder.length() != 0 ? "; " : "") : "", builder.length() != 0 ? builder : ""}));
            }
        }

        public String getRuleCategoryValue(Object actionSet, Object value) {
            SbisDocumentElementData sbisDocumentElementData = (SbisDocumentElementData)value;
            List sbisDocumentElementAttributes = sbisDocumentElementData.getAttributes();
            return "rule_category_sbis_document_element_data" + String.format("_%s_%s_%s_%s_%s_%s_%s_%s_%s_%s_%s_%s_%s_%s", sbisDocumentElementData.getElement().name(), sbisDocumentElementData.getAttributesPredefined().isProductStatus(), sbisDocumentElementData.getAttributesPredefined().isBookingNumber(), sbisDocumentElementData.getAttributesPredefined().isBooking\u0421reateDate(), sbisDocumentElementData.getAttributesPredefined().isCarrierRegistrationId(), sbisDocumentElementData.getAttributesPredefined().isCarrierKpp(), sbisDocumentElementData.getAttributesPredefined().isTicketNumber(), sbisDocumentElementData.getAttributesPredefined().isTicketDate(), sbisDocumentElementData.getAttributesPredefined().isIntermediaryService(), sbisDocumentElementData.getAttributesPredefined().isVendorInvoiceFacturaNumber(), sbisDocumentElementData.getAttributesPredefined().isVendorInvoiceFacturaDate(), sbisDocumentElementData.getAttributesPredefined().isLocationType(), sbisDocumentElementData.getAttributesPredefined().isServiceType(), sbisDocumentElementAttributes.stream().sorted(Comparator.comparing(i -> i.getCostCodeCategory().getCode())).map(item -> item.getIdentifier().concat(":").concat(item.getCostCodeCategory().toString())).collect(Collectors.joining("_")).toLowerCase());
        }

        public void apply(RuleProxy<?, ?> proxy, Object value) {
            SbisDocumentElementData sbisDocumentElementData = (SbisDocumentElementData)value;
            if (sbisDocumentElementData != null && proxy.getActionSet() instanceof SbisActionSet) {
                SbisActionSet actionSet = (SbisActionSet)proxy.getActionSet();
                actionSet.getSbisDocumentElementsData().add(sbisDocumentElementData);
                proxy.getAppliedRuleCategories().add(this.getRuleCategoryValue(actionSet, value));
            }
        }

        @Override
        String[] getTargetIds() {
            return new String[]{Targets.SBIS_PARAMETERS.getId()};
        }
    }
    ,
    SBIS_CUSTOMER_CODE{

        @Override
        String[] getTargetIds() {
            return new String[]{Targets.SBIS_PARAMETERS.getId()};
        }

        public String getDisplayName() {
            return L10n.get((String)"SBIS_CUSTOMER_CODE");
        }

        public String getRendererId() {
            return com.gridnine.xtrip.common.model.rules.standard.ValueTypes.STRING.name();
        }

        public boolean hasValue() {
            return true;
        }

        public void buildInfo(StringBuilder buf, Object value) {
            if (value != null) {
                buf.append((String)value);
            }
        }

        public String getRuleCategoryValue(Object actionSet, Object value) {
            return this.name();
        }

        public void apply(RuleProxy<?, ?> proxy, Object value) {
            SbisActionSet actionSet = (SbisActionSet)proxy.getActionSet();
            actionSet.setCustomerCode((String)value);
            proxy.getAppliedRuleCategories().add(this.getRuleCategoryValue(actionSet, value));
        }
    }
    ,
    SBIS_CUSTOMER_IDENTIFIER{

        @Override
        String[] getTargetIds() {
            return new String[]{Targets.SBIS_PARAMETERS.getId()};
        }

        public String getDisplayName() {
            return L10n.get((String)"SBIS_CUSTOMER_IDENTIFIER");
        }

        public String getRendererId() {
            return com.gridnine.xtrip.common.model.rules.standard.ValueTypes.STRING.name();
        }

        public boolean hasValue() {
            return true;
        }

        public void buildInfo(StringBuilder buf, Object value) {
            if (value != null) {
                buf.append((String)value);
            }
        }

        public String getRuleCategoryValue(Object actionSet, Object value) {
            return this.name();
        }

        public void apply(RuleProxy<?, ?> proxy, Object value) {
            SbisActionSet actionSet = (SbisActionSet)proxy.getActionSet();
            actionSet.setCustomerIdentifier((String)value);
            proxy.getAppliedRuleCategories().add(this.getRuleCategoryValue(actionSet, value));
        }
    }
    ,
    SBIS_FINANCE_DOCUMENT_TYPES{

        @Override
        String[] getTargetIds() {
            return new String[]{Targets.SBIS_PARAMETERS.getId()};
        }

        public String getDisplayName() {
            return L10n.get((String)"SBIS_FINANCE_DOCUMENT_TYPES");
        }

        public String getRendererId() {
            return ValueTypes.SBIS_FINANCE_DOCUMENT_TYPES.name();
        }

        public boolean hasValue() {
            return true;
        }

        public void buildInfo(StringBuilder buf, Object value) {
            if (value != null) {
                buf.append(((ArrayList)value).stream().map(FinanceDocumentType::toString).collect(Collectors.joining(", ")));
            }
        }

        public String getRuleCategoryValue(Object actionSet, Object value) {
            return this.name();
        }

        public void apply(RuleProxy<?, ?> proxy, Object value) {
            SbisActionSet actionSet = (SbisActionSet)proxy.getActionSet();
            actionSet.getFinanceDocumentTypes().addAll((ArrayList)value);
            proxy.getAppliedRuleCategories().add(this.getRuleCategoryValue(actionSet, value));
        }
    }
    ,
    SBIS_RELATED_DOCUMENTS_JOINING_SETTINGS{

        @Override
        String[] getTargetIds() {
            return new String[]{Targets.SBIS_PARAMETERS.getId()};
        }

        public String getDisplayName() {
            return L10n.get((String)"SBIS_RELATED_DOCUMENTS_JOINING_SETTINGS");
        }

        public String getRendererId() {
            return ValueTypes.SBIS_RELATED_DOCUMENTS_JOINING_SETTINGS.name();
        }

        public boolean hasValue() {
            return true;
        }

        public void buildInfo(StringBuilder buf, Object value) {
            if (value != null) {
                List settings = (List)value;
                buf.append(L10n.replace((String)L10n.get((String)"SBIS_RELATED_DOCUMENTS_JOINING_SETTINGS_INFO"), (Object[])new Object[]{settings.stream().filter(item -> !item.getDocumentTypes().isEmpty()).map(item -> (item.getDocumentTypes().containsAll(Arrays.asList(DocumentType.values())) ? L10n.get((String)"SBIS_RELATED_DOCUMENTS_JOINING_SETTINGS_ALL") : item.getDocumentTypes().stream().map(DocumentType::toString).collect(Collectors.joining(", "))).concat(TextUtil.nonBlank((String)item.getDocumentName()) ? " " + L10n.replace((String)L10n.get((String)"SBIS_RELATED_DOCUMENTS_JOINING_SETTINGS_TO_FILE"), (Object[])new Object[]{item.getDocumentName()}) : "")).collect(Collectors.joining("; "))}));
            }
        }

        public String getRuleCategoryValue(Object actionSet, Object value) {
            String parameter = "";
            if (value != null) {
                List settings = (List)value;
                parameter = settings.stream().flatMap(item -> item.getDocumentTypes().stream()).distinct().sorted(Comparator.comparingInt(Enum::ordinal)).map(DocumentType::toString).collect(Collectors.joining("_"));
            }
            return String.format("%s_%s", this.name(), parameter);
        }

        public void apply(RuleProxy<?, ?> proxy, Object value) {
            SbisActionSet actionSet = (SbisActionSet)proxy.getActionSet();
            actionSet.getSbisRelatedDocumentsJoiningSettings().addAll((List)value);
            proxy.getAppliedRuleCategories().add(this.getRuleCategoryValue(actionSet, value));
        }
    }
    ,
    FINANCE_PRINT_DATA{

        @Override
        String[] getTargetIds() {
            return new String[]{Targets.PRINT_PARAMETERS.getId()};
        }

        public String getDisplayName() {
            return "\u041d\u0430\u0441\u0442\u0440\u043e\u0439\u043a\u0438 \u043f\u0435\u0447\u0430\u0442\u0438";
        }

        public String getRendererId() {
            return ValueTypes.PRINT_DATA.name();
        }

        public boolean hasValue() {
            return true;
        }

        public void buildInfo(StringBuilder buf, Object value) {
            if (value != null) {
                buf.append(value);
            }
        }

        public String getRuleCategoryValue(Object actionSet, Object value) {
            return "finance_print_data";
        }

        public void apply(RuleProxy<?, ?> proxy, Object value) {
            PrintActionSet actionSet = (PrintActionSet)proxy.getActionSet();
            actionSet.getPrintDatas().add((FinancePrintData)value);
        }
    }
    ,
    AVAILABLE_REPORTS{

        @Override
        String[] getTargetIds() {
            return new String[]{Targets.REPORT_APPLICATION.getId()};
        }

        public String getDisplayName() {
            return L10nResourcesManager.getStr((String)Messages.Available_reports, (Object[])new Object[0]);
        }

        public String getRendererId() {
            return ValueTypes.AVAILABLE_REPORTS.name();
        }

        public boolean hasValue() {
            return true;
        }

        public void buildInfo(StringBuilder buf, Object value) {
            if (value != null) {
                AvailableReportsSettings val = (AvailableReportsSettings)value;
                if (val.getSelectedReportsIds().contains("ROOT")) {
                    buf.append(L10nResourcesManager.getStr((String)Messages.Show_all_reports, (Object[])new Object[0]));
                } else if (!val.getSelectedReportsIds().isEmpty()) {
                    buf.append(L10nResourcesManager.getStr((String)Messages.Show_several_reports, (Object[])new Object[0]));
                } else {
                    buf.append(L10nResourcesManager.getStr((String)Messages.Do_not_show_reports, (Object[])new Object[0]));
                }
            }
        }

        public String getRuleCategoryValue(Object actionSet, Object value) {
            return this.getId();
        }

        public void apply(RuleProxy<?, ?> proxy, Object value) {
            ReportApplicationActionSet as = (ReportApplicationActionSet)proxy.getActionSet();
            AvailableReportsSettings result = (AvailableReportsSettings)value;
            as.setAvailableReports(result);
            proxy.getAppliedRuleCategories().add(this.getRuleCategoryValue(as, value));
        }
    }
    ,
    AVAILABLE_REGISTRY_FIELDS{

        @Override
        String[] getTargetIds() {
            return new String[]{Targets.REPORT_APPLICATION.getId()};
        }

        public String getDisplayName() {
            return L10nResourcesManager.getStr((String)Messages.Available_registry_fields, (Object[])new Object[0]);
        }

        public String getRendererId() {
            return ValueTypes.AVAILABLE_REGISTRY_FIELDS.name();
        }

        public boolean hasValue() {
            return true;
        }

        public void buildInfo(StringBuilder buf, Object value) {
            if (value != null) {
                AvailableRegistryFieldsSettings val = (AvailableRegistryFieldsSettings)value;
                if (val.getSelectedFields().contains("_ROOT")) {
                    buf.append(L10nResourcesManager.getStr((String)Messages.Show_all_fields, (Object[])new Object[0]));
                } else if (!val.getSelectedFields().isEmpty()) {
                    buf.append(L10nResourcesManager.getStr((String)Messages.Show_several_fields, (Object[])new Object[0]));
                } else {
                    buf.append(L10nResourcesManager.getStr((String)Messages.Do_not_show_fields, (Object[])new Object[0]));
                }
            }
        }

        public String getRuleCategoryValue(Object actionSet, Object value) {
            return this.getId();
        }

        public void apply(RuleProxy<?, ?> proxy, Object value) {
            ReportApplicationActionSet as = (ReportApplicationActionSet)proxy.getActionSet();
            AvailableRegistryFieldsSettings result = (AvailableRegistryFieldsSettings)value;
            as.setAvailableRegistryFields(result);
            proxy.getAppliedRuleCategories().add(this.getRuleCategoryValue(as, value));
        }
    }
    ,
    SBIS_EXPORT_PARAMETERS{

        @Override
        String[] getTargetIds() {
            return new String[]{Targets.SBIS_PARAMETERS.getId()};
        }

        public String getDisplayName() {
            return "\u041f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u044b \u0432\u044b\u0433\u0440\u0443\u0437\u043a\u0438 \u042d\u0414\u041e";
        }

        public String getRendererId() {
            return ValueTypes.SBIS_EXPORT_PARAMETERS.name();
        }

        public boolean hasValue() {
            return true;
        }

        public void buildInfo(StringBuilder buf, Object value) {
            AtomicInteger countSelectItems = new AtomicInteger();
            AtomicInteger countAllIntems = new AtomicInteger();
            if (value != null) {
                SbisExportParametersSettings val = (SbisExportParametersSettings)value;
                EntityType rootEntityType = MetaRegistryHelper.getEntityType((String)SbisExportParametersSettings.class.getName());
                rootEntityType.getProperties().values().forEach(documentType -> {
                    Introspectable documentTypeValue = (Introspectable)val.getValue(documentType.getId());
                    EntityType documentTypeEntityType = MetaRegistryHelper.getEntityType((String)documentType.getType());
                    documentTypeEntityType.getProperties().values().forEach(serviceType -> {
                        Introspectable serviceTypeValue = (Introspectable)documentTypeValue.getValue(serviceType.getId());
                        EntityType serviceTypeEntityType = MetaRegistryHelper.getEntityType((String)serviceType.getType());
                        serviceTypeEntityType.getProperties().values().forEach(serviceTypeProperty -> {
                            if (serviceTypeValue != null && Boolean.TRUE.equals(serviceTypeValue.getValue(serviceTypeProperty.getId()))) {
                                countSelectItems.getAndIncrement();
                            }
                            countAllIntems.getAndIncrement();
                        });
                    });
                });
            }
            if (countSelectItems.get() == countAllIntems.get()) {
                buf.append("\u043f\u043e\u043a\u0430\u0437\u044b\u0432\u0430\u0442\u044c \u0432\u0441\u0435 \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u044b");
            } else if (countSelectItems.get() > 0 && countSelectItems.get() < countAllIntems.get()) {
                buf.append("\u043f\u043e\u043a\u0430\u0437\u044b\u0432\u0430\u0442\u044c \u043d\u0435\u0441\u043a\u043e\u043b\u044c\u043a\u043e \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u043e\u0432");
            } else {
                buf.append("\u043d\u0435 \u043f\u043e\u043a\u0430\u0437\u044b\u0432\u0430\u0442\u044c \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u044b");
            }
        }

        public String getRuleCategoryValue(Object actionSet, Object value) {
            return this.getId();
        }

        public void apply(RuleProxy<?, ?> proxy, Object value) {
            SbisActionSet actionSet = (SbisActionSet)proxy.getActionSet();
            actionSet.setSbisExportParametersSettings((SbisExportParametersSettings)value);
            proxy.getAppliedRuleCategories().add(this.getRuleCategoryValue(actionSet, value));
        }
    }
    ,
    DOCUMENT_SORT_TYPE{

        @Override
        String[] getTargetIds() {
            return new String[]{Targets.PRINT_PARAMETERS.getId()};
        }

        public String getDisplayName() {
            return "\u0422\u0438\u043f \u0441\u043e\u0440\u0442\u0438\u0440\u043e\u0432\u043a\u0438";
        }

        public String getRendererId() {
            return ValueTypes.DOCUMENT_SORT_TYPE.name();
        }

        public boolean hasValue() {
            return true;
        }

        public void buildInfo(StringBuilder buf, Object value) {
            buf.append(L10n.replace((String)"\u0423\u0441\u0442\u0430\u043d\u043e\u0432\u0438\u0442\u044c \u0442\u0438\u043f \u0441\u043e\u0440\u0442\u0438\u0440\u043e\u0432\u043a\u0438 \u0432 {0}", (Object[])new Object[]{value == null ? "???" : value}));
        }

        public String getRuleCategoryValue(Object actionSet, Object value) {
            return "document_sort_type";
        }

        public void apply(RuleProxy<?, ?> proxy, Object value) {
            PrintActionSet actionSet = (PrintActionSet)proxy.getActionSet();
            actionSet.setDocumentSortType((DocumentSortType)value);
        }
    }
    ,
    HOTEL_PROVIDER_COMMISSION{

        @Override
        String[] getTargetIds() {
            return new String[]{Targets.HOTEL_PREPROCESSING.getId()};
        }

        public void buildInfo(StringBuilder buf, Object value) {
            RulesHelper.buildCommissionInfo((StringBuilder)buf, (RuleResultValue)((RuleResultValue)value));
        }

        public String getDisplayName() {
            return L10n.get((String)"HOTEL_PROVIDER_COMMISSION_DISPLAYNAME");
        }

        public String getRendererId() {
            return com.gridnine.xtrip.common.model.rules.standard.ValueTypes.SIMPLE_COMMISSION.name();
        }

        public boolean hasValue() {
            return true;
        }

        public void apply(RuleProxy<?, ?> proxy, Object value) {
            HotelPreprocessingActionsProvider actions = (HotelPreprocessingActionsProvider)proxy.getActionSet();
            actions.setProviderCommission((RuleResultValue)value);
            proxy.getAppliedRuleCategories().add(this.getRuleCategoryValue(actions, value));
        }

        public String getRuleCategoryValue(Object actionSet, Object value) {
            return ((Object)((Object)this)).getClass().getName();
        }
    }
    ,
    NOTIFICATION_TO_HOTEL_TEMPLATE{

        public String getDisplayName() {
            return "\u0428\u0430\u0431\u043b\u043e\u043d \u043f\u0438\u0441\u044c\u043c\u0430 \u0432 \u043e\u0442\u0435\u043b\u044c";
        }

        public String getRendererId() {
            return ValueTypes.NOTIFICATION_TO_HOTEL_TEMPLATE.name();
        }

        public boolean hasValue() {
            return true;
        }

        public void buildInfo(StringBuilder buf, Object value) {
            if (value != null) {
                buf.append("\u0417\u0430\u043f\u0440\u043e\u0441 \u043d\u0430 \u0431\u0440\u043e\u043d\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u0435");
            }
        }

        public String getRuleCategoryValue(Object actionSet, Object value) {
            return "notification_to_hotel_template";
        }

        public void apply(RuleProxy<?, ?> proxy, Object value) {
            NotificationsActionsProvider as = (NotificationsActionsProvider)proxy.getActionSet();
            as.setHotelNotificationTemplate((MailTemplate)value);
            proxy.getAppliedRuleCategories().add(this.getRuleCategoryValue(as, value));
        }

        @Override
        String[] getTargetIds() {
            return new String[]{Targets.NOTIFICATION_TEMPLATE_HOTEL.getId()};
        }
    }
    ,
    NOTIFICATION_TO_AUTHORIZATION_TEMPLATE{

        public String getDisplayName() {
            return "\u0428\u0430\u0431\u043b\u043e\u043d \u043f\u0438\u0441\u044c\u043c\u0430 \u0434\u043b\u044f \u0430\u0432\u0442\u043e\u0440\u0438\u0437\u0430\u0446\u0438\u0438";
        }

        public String getRendererId() {
            return ValueTypes.NOTIFICATION_AUTHORIZATION_TEMPLATE.name();
        }

        public boolean hasValue() {
            return true;
        }

        public void buildInfo(StringBuilder buf, Object value) {
            if (value != null) {
                buf.append("\u0428\u0430\u0431\u043b\u043e\u043d \u043f\u0438\u0441\u044c\u043c\u0430 \u0434\u043b\u044f \u0430\u0432\u0442\u043e\u0440\u0438\u0437\u0430\u0446\u0438\u0438");
            }
        }

        public String getRuleCategoryValue(Object actionSet, Object value) {
            String res = ((AuthorizationMailTemplate)value).getAuthorizationRecipientRoles().stream().sorted(Comparator.naturalOrder()).map(Enum::name).collect(Collectors.joining(" "));
            return "notification_authorization_mail_template" + res;
        }

        public void apply(RuleProxy<?, ?> proxy, Object value) {
            AuthorizationTemplateActionResult as = (AuthorizationTemplateActionResult)proxy.getActionSet();
            as.addMailTemplate((AuthorizationMailTemplate)value);
            proxy.getAppliedRuleCategories().add(this.getRuleCategoryValue(as, value));
        }

        @Override
        String[] getTargetIds() {
            return new String[]{Targets.NOTIFICATION_TEMPLATE_AUTHORIZATION.getId()};
        }
    }
    ,
    NOTIFICATION_WITH_FINANCE_DOCS_TEMPLATE{

        public String getDisplayName() {
            return "\u0428\u0430\u0431\u043b\u043e\u043d \u043f\u0438\u0441\u044c\u043c\u0430 c \u0444\u0438\u043d. \u0434\u043e\u043a\u0443\u043c\u0435\u043d\u0442\u0430\u043c\u0438";
        }

        public String getRendererId() {
            return ValueTypes.NOTIFICATION_WITH_FINANCE_DOCS_TEMPLATE.name();
        }

        public boolean hasValue() {
            return true;
        }

        public void buildInfo(StringBuilder buf, Object value) {
            if (value != null) {
                buf.append("\u0428\u0430\u0431\u043b\u043e\u043d c \u0444\u0438\u043d. \u0434\u043e\u043a\u0443\u043c\u0435\u043d\u0442\u0430\u043c\u0438");
            }
        }

        public String getRuleCategoryValue(Object actionSet, Object value) {
            return "notification_with_finance_docs_template";
        }

        public void apply(RuleProxy<?, ?> proxy, Object value) {
            NotificationsActionsProvider as = (NotificationsActionsProvider)proxy.getActionSet();
            as.setFinanceDocsNotificationTemplate((MailTemplate)value);
            proxy.getAppliedRuleCategories().add(this.getRuleCategoryValue(as, value));
        }

        @Override
        String[] getTargetIds() {
            return new String[]{Targets.NOTIFICATION_TEMPLATE_FINDOCS.getId()};
        }
    }
    ,
    NOTIFICATION_WITH_EXTERNAL_FINANCE_DOCS_TEMPLATE{

        public String getDisplayName() {
            return "\u0428\u0430\u0431\u043b\u043e\u043d \u043f\u0438\u0441\u044c\u043c\u0430 c \u0432\u043d\u0435\u0448\u043d\u0438\u043c\u0438 \u0444\u0438\u043d. \u0434\u043e\u043a\u0443\u043c\u0435\u043d\u0442\u0430\u043c\u0438";
        }

        public String getRendererId() {
            return ValueTypes.NOTIFICATION_WITH_EXTERNAL_FINANCE_DOCS_TEMPLATE.name();
        }

        public boolean hasValue() {
            return true;
        }

        public void buildInfo(StringBuilder buf, Object value) {
            if (value != null) {
                buf.append("\u0428\u0430\u0431\u043b\u043e\u043d c \u0432\u043d\u0435\u0448\u043d\u0438\u043c\u0438 \u0444\u0438\u043d. \u0434\u043e\u043a\u0443\u043c\u0435\u043d\u0442\u0430\u043c\u0438");
            }
        }

        public String getRuleCategoryValue(Object actionSet, Object value) {
            return "notification_with_external_finance_docs_template";
        }

        public void apply(RuleProxy<?, ?> proxy, Object value) {
            NotificationsActionsProvider as = (NotificationsActionsProvider)proxy.getActionSet();
            as.setExternalFinanceDocsNotificationTemplate((MailTemplate)value);
            proxy.getAppliedRuleCategories().add(this.getRuleCategoryValue(as, value));
        }

        @Override
        String[] getTargetIds() {
            return new String[]{Targets.NOTIFICATION_TEMPLATE_EXTERNAL_FINDOCS.getId()};
        }
    }
    ,
    NOTIFICATION_ABOUT_ISSUE_TEMPLATE{

        public String getDisplayName() {
            return L10n.get((String)Messages.IbecorpActions_NOTIFICATION_ABOUT_ISSUE_TEMPLATE);
        }

        public String getRendererId() {
            return ValueTypes.NOTIFICATION_ABOUT_ISSUE_TEMPLATE.name();
        }

        public boolean hasValue() {
            return true;
        }

        public void buildInfo(StringBuilder buf, Object value) {
            if (value != null) {
                buf.append(L10n.get((String)Messages.IbecorpActions_NOTIFICATION_ABOUT_ISSUE_TEMPLATE));
            }
        }

        public String getRuleCategoryValue(Object actionSet, Object value) {
            return "notification_about_issue_template";
        }

        public void apply(RuleProxy<?, ?> proxy, Object value) {
            NotificationsActionSet as = (NotificationsActionSet)proxy.getActionSet();
            as.setIssueNotificationTemplate((IssueMailTemplate)value);
            proxy.getAppliedRuleCategories().add(this.getRuleCategoryValue(as, value));
        }

        @Override
        String[] getTargetIds() {
            return new String[]{Targets.NOTIFICATION_TEMPLATE_ISSUE.getId()};
        }
    }
    ,
    NOTIFICATION_ABOUT_BALANCE{

        public String getDisplayName() {
            return L10n.get((String)Messages.IbecorpActions_NOTIFICATION_ABOUT_BALANCE);
        }

        public String getRendererId() {
            return ValueTypes.NOTIFICATION_ABOUT_BALANCE.name();
        }

        public boolean hasValue() {
            return true;
        }

        public void buildInfo(StringBuilder buf, Object value) {
            if (value != null) {
                buf.append(L10n.get((String)Messages.IbecorpActions_NOTIFICATION_ABOUT_BALANCE));
            }
        }

        public String getRuleCategoryValue(Object actionSet, Object value) {
            return "notification_about_balance";
        }

        public void apply(RuleProxy<?, ?> proxy, Object value) {
            NotificationsActionSet as = (NotificationsActionSet)proxy.getActionSet();
            as.setBalanceNotificationTemplate((NotificationRecipientMailTemplate)value);
            proxy.getAppliedRuleCategories().add(this.getRuleCategoryValue(as, value));
        }

        @Override
        String[] getTargetIds() {
            return new String[]{Targets.NOTIFICATION_TEMPLATE_BALANCE.getId()};
        }
    }
    ,
    SUBAGENCY{

        public String getDisplayName() {
            return L10n.get((String)Messages.Actions_SUBAGENCY_displayName);
        }

        public String getRendererId() {
            return com.gridnine.xtrip.common.model.rules.standard.ValueTypes.AGENCY.name();
        }

        @Override
        String[] getTargetIds() {
            return new String[]{com.gridnine.xtrip.common.model.rules.standard.Targets.HOTELS_COMMISSION.getId()};
        }

        public void buildInfo(StringBuilder info, Object object) {
            info.append(this.getDisplayName()).append(" ").append(object == null ? "" : object.toString());
        }

        public boolean hasValue() {
            return true;
        }

        public void apply(RuleProxy<?, ?> proxy, Object value) {
            CommissionActionsProvider as = (CommissionActionsProvider)proxy.getActionSet();
            as.setSubagency((EntityReference)value);
        }

        public String getRuleCategoryValue(Object actionSet, Object value) {
            return "set_subagency";
        }
    }
    ,
    SEARCH_RESULT_SORT_TYPE_AVIA{

        public String getDisplayName() {
            return L10n.get((String)Messages.IbecorpRuleAction_SEARCH_RESULT_SORT_BY);
        }

        public String getRendererId() {
            return ValueTypes.SEARCH_RESULT_SORT_TYPE_AVIA.name();
        }

        public boolean hasValue() {
            return true;
        }

        public void buildInfo(StringBuilder buf, Object value) {
            buf.append(this.getDisplayName()).append(": ").append(value);
        }

        public String getRuleCategoryValue(Object actionSet, Object value) {
            return this.name().toLowerCase();
        }

        public void apply(RuleProxy<?, ?> proxy, Object value) {
            SearchResultSortTypeActionsProvider iap = (SearchResultSortTypeActionsProvider)proxy.getActionSet();
            SearchResultSortType sortType = (SearchResultSortType)value;
            iap.setSearchResultSortType(sortType);
            proxy.getAppliedRuleCategories().add(this.getRuleCategoryValue(iap, value));
        }

        @Override
        String[] getTargetIds() {
            return new String[0];
        }
    }
    ,
    SEARCH_RESULT_SORT_TYPE_RAILWAY{

        public String getDisplayName() {
            return L10n.get((String)Messages.IbecorpRuleAction_SEARCH_RESULT_SORT_BY);
        }

        public String getRendererId() {
            return ValueTypes.SEARCH_RESULT_SORT_TYPE_RAILWAY.name();
        }

        public boolean hasValue() {
            return true;
        }

        public void buildInfo(StringBuilder buf, Object value) {
            buf.append(this.getDisplayName()).append(": ").append(value);
        }

        public String getRuleCategoryValue(Object actionSet, Object value) {
            return this.name().toLowerCase();
        }

        public void apply(RuleProxy<?, ?> proxy, Object value) {
            SearchResultSortTypeActionsProvider iap = (SearchResultSortTypeActionsProvider)proxy.getActionSet();
            SearchResultSortType sortType = (SearchResultSortType)value;
            iap.setSearchResultSortType(sortType);
            proxy.getAppliedRuleCategories().add(this.getRuleCategoryValue(iap, value));
        }

        @Override
        String[] getTargetIds() {
            return new String[0];
        }
    }
    ,
    SEARCH_RESULT_SORT_TYPE_HOTEL{

        public String getDisplayName() {
            return L10n.get((String)Messages.IbecorpRuleAction_SEARCH_RESULT_SORT_BY);
        }

        public String getRendererId() {
            return ValueTypes.SEARCH_RESULT_SORT_TYPE_HOTEL.name();
        }

        public boolean hasValue() {
            return true;
        }

        public void buildInfo(StringBuilder buf, Object value) {
            buf.append(this.getDisplayName()).append(": ").append(value);
        }

        public String getRuleCategoryValue(Object actionSet, Object value) {
            return this.name().toLowerCase();
        }

        public void apply(RuleProxy<?, ?> proxy, Object value) {
            SearchResultSortTypeActionsProvider iap = (SearchResultSortTypeActionsProvider)proxy.getActionSet();
            SearchResultSortType sortType = (SearchResultSortType)value;
            iap.setSearchResultSortType(sortType);
            proxy.getAppliedRuleCategories().add(this.getRuleCategoryValue(iap, value));
        }

        @Override
        String[] getTargetIds() {
            return new String[0];
        }
    }
    ,
    HIDE_ADDITIONAL_NON_BRANDED_FARES{

        public String getDisplayName() {
            return L10n.get((String)Messages.IbecorpRuleAction_HIDE_ADDITIONAL_NON_BRANDED_FARES);
        }

        public String getRendererId() {
            return com.gridnine.xtrip.common.model.rules.standard.ValueTypes.YES_NO.name();
        }

        public boolean hasValue() {
            return true;
        }

        public void buildInfo(StringBuilder buf, Object value) {
            buf.append(this.getDisplayName()).append(": ").append(value);
        }

        public String getRuleCategoryValue(Object actionSet, Object value) {
            return "HIDE_ADDITIONAL_NON_BRANDED_FARES";
        }

        public void apply(RuleProxy<?, ?> proxy, Object value) {
            GDSParametersActionsProvider provider = (GDSParametersActionsProvider)proxy.getActionSet();
            provider.setHideAdditionalFares(((Boolean)value).booleanValue());
            proxy.getAppliedRuleCategories().add(this.getRuleCategoryValue(proxy.getActionSet(), value));
        }

        @Override
        String[] getTargetIds() {
            return new String[]{com.gridnine.xtrip.common.gds.rules.Targets.GDS_PARAMETERS_EX.getId()};
        }
    };


    public String getId() {
        return this.name();
    }

    abstract String[] getTargetIds();
}

