/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.ibecorp.rules;

import com.gridnine.xtrip.common.Environment;
import com.gridnine.xtrip.common.TimeService;
import com.gridnine.xtrip.common.gds.model.BaseGdsAccount;
import com.gridnine.xtrip.common.gds.rules.GdsPropertiesProvider;
import com.gridnine.xtrip.common.ibecorp.rules.AirPropertiesProvider;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.BaseTicketProduct;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.air.Segment;
import com.gridnine.xtrip.common.model.dict.DictionaryCache;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.dict.GeoLocation;
import com.gridnine.xtrip.common.model.helpers.AirProductHelper;
import com.gridnine.xtrip.common.model.helpers.CommonReservationGdsNameInfoHelper;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.profile.Person;
import com.gridnine.xtrip.common.model.rules.standard.GdsNamePropertiesProvider;
import com.gridnine.xtrip.common.model.rules.standard.RulesHelper;
import com.gridnine.xtrip.common.model.rules.standard.SalesContextPropertiesProvider;
import com.gridnine.xtrip.common.util.DateTimeConverter;
import com.gridnine.xtrip.common.util.EnumUtil;
import com.gridnine.xtrip.common.util.MiscUtil;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import org.apache.commons.lang.StringUtils;

public class AirPropertySet
implements AirPropertiesProvider,
SalesContextPropertiesProvider,
GdsPropertiesProvider,
GdsNamePropertiesProvider {
    private final Set<String> carriers = new HashSet<String>();
    private final Date lastIssueDate;
    private Date firstSegmentDepartureDate;
    private DictionaryReference<GeoLocation> firstSegmentDepartureLocation;
    private final String gdsName;
    private final EntityReference<? extends BaseGdsAccount> gdsAccount;
    private final EntityReference<Organization> client;
    private final String agencyCode;
    private final Set<String> subagencyCodes = new HashSet<String>();

    public AirPropertySet(Reservation reservation) {
        AirProductHelper.getAirProductsStream((Reservation)reservation).filter(product -> Objects.nonNull(product.getCarrier())).forEach(product -> this.carriers.add(product.getCarrier().getCode()));
        this.lastIssueDate = AirProductHelper.getAirProductsStream((Reservation)reservation).filter(p -> p.getIssueDate() != null).max(Comparator.comparing(BaseTicketProduct::getIssueDate)).map(BaseTicketProduct::getIssueDate).orElse(null);
        AirProductHelper.getSegments((Collection)AirProductHelper.getSegmentTariffs((Reservation)reservation)).stream().filter(segment -> Objects.nonNull(segment.getStartDate())).min(Comparator.comparing(Segment::getStartDate)).ifPresent(segment -> {
            this.firstSegmentDepartureLocation = segment.getDepartureLocation();
            this.firstSegmentDepartureDate = segment.getStartDate();
        });
        this.gdsAccount = reservation.getGdsNameInfo().getOnlineGdsAccount();
        this.gdsName = EnumUtil.nameOf((Enum)CommonReservationGdsNameInfoHelper.getRulesGdsName((Reservation)reservation));
        this.client = reservation.getBookingFile().getCustomerProfile();
        this.agencyCode = RulesHelper.getAgencyCode((Reservation)reservation);
        RulesHelper.addSubagencyCodes(this.subagencyCodes, (EntityReference)reservation.getSubagency());
    }

    @Override
    public Set<String> getCarriers() {
        return this.carriers;
    }

    @Override
    public Boolean isSameDayAsDeparture() {
        if (this.firstSegmentDepartureDate == null) {
            return false;
        }
        ZonedDateTime now = this.getCurrentDateTime();
        Date departureDate = DateTimeConverter.convert((Date)this.firstSegmentDepartureDate, (ZoneId)this.getDepartureZoneId(), (ZoneId)this.getServerZoneId());
        return MiscUtil.clearTime((Date)Date.from(now.toInstant())).equals(MiscUtil.clearTime((Date)departureDate));
    }

    @Override
    public double getHoursBeforeDeparture() {
        return this.calculateHoursBeforeDeparture();
    }

    @Override
    public double getHoursAfterIssueDate() {
        return this.calculateHoursAfterIssueDate();
    }

    public EntityReference<Organization> getClient() {
        return this.client;
    }

    public String getAgencyCode() {
        return this.agencyCode;
    }

    public Set<String> getSubagencyCodes() {
        return this.subagencyCodes;
    }

    public Set<String> getProfileGroups() {
        return null;
    }

    public EntityReference<Person> getAgent() {
        return null;
    }

    public EntityReference<? extends BaseGdsAccount> getGdsAccount() {
        return this.gdsAccount;
    }

    public String getGdsName() {
        return this.gdsName;
    }

    private double calculateHoursBeforeDeparture() {
        if (this.firstSegmentDepartureDate == null) {
            return -1.0;
        }
        ZonedDateTime now = this.getCurrentDateTime();
        Date departureDate = DateTimeConverter.convert((Date)this.firstSegmentDepartureDate, (ZoneId)this.getDepartureZoneId(), (ZoneId)this.getServerZoneId());
        return (double)(departureDate.getTime() - Date.from(now.toInstant()).getTime()) / 3600000.0;
    }

    private ZonedDateTime getCurrentDateTime() {
        return ((TimeService)Environment.getPublished(TimeService.class)).getCurrentZonedDateTime();
    }

    private ZoneId getServerZoneId() {
        return ZoneId.systemDefault();
    }

    private GeoLocation getDepartureLocation() {
        return (GeoLocation)DictionaryCache.get().resolveReference(this.firstSegmentDepartureLocation);
    }

    private ZoneId getDepartureZoneId() {
        if (this.firstSegmentDepartureLocation == null) {
            return this.getServerZoneId();
        }
        GeoLocation departureLoc = this.getDepartureLocation();
        if (departureLoc == null) {
            return this.getServerZoneId();
        }
        String timeZoneId = departureLoc.getTimeZoneId();
        return StringUtils.isEmpty((String)timeZoneId) ? ZoneId.systemDefault() : ZoneId.of(timeZoneId);
    }

    private double calculateHoursAfterIssueDate() {
        if (this.lastIssueDate == null) {
            return -1.0;
        }
        ZonedDateTime now = this.getCurrentDateTime();
        return (double)(Date.from(now.toInstant()).getTime() - this.lastIssueDate.getTime()) / 3600000.0;
    }
}

