/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.ibecorp.rules;

import com.gridnine.xtrip.common.ibecorp.rules.RzdParametersActionsProvider;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.dict.GdsName;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.ibecorp.railway.BaseRailGdsAccount;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.profile.OrganizationIndex;
import com.gridnine.xtrip.common.model.profile.OrganizationType;
import com.gridnine.xtrip.common.model.system.ContentType;
import com.gridnine.xtrip.common.util.TextUtil;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;

public class RzdParametersActions
implements RzdParametersActionsProvider {
    private static final long serialVersionUID = 6548934366589750659L;
    private final Set<GdsName> applicableGDS = new LinkedHashSet<GdsName>();
    private final Set<EntityReference<BaseRailGdsAccount>> applicableGdsAccounts = new HashSet<EntityReference<BaseRailGdsAccount>>();
    private ContentType docContentType;
    private boolean excludeFromResult;
    private Integer travelGroupCheckTime;
    private Integer travelGroupProductLimit;
    private Integer travelGroupLockTime;
    private boolean travelGroupSubagentNetwork;
    private EntityReference<Organization> blankOwner;
    private Integer searchDaysLimit;

    public Set<GdsName> getApplicableGDS() {
        return this.applicableGDS;
    }

    @Override
    public void addApplicableGDSAccount(EntityReference<BaseRailGdsAccount> account) {
        if (account != null) {
            this.applicableGdsAccounts.add(account);
        }
    }

    public Set<EntityReference<BaseRailGdsAccount>> getApplicableGdsAccounts() {
        return this.applicableGdsAccounts;
    }

    public ContentType getDocContentType() {
        return this.docContentType;
    }

    @Override
    public void setDocContentType(ContentType docContentType) {
        this.docContentType = docContentType;
    }

    public boolean isExcludeFromResult() {
        return this.excludeFromResult;
    }

    public void setExcludeFromResult(boolean excludeFromResult) {
        this.excludeFromResult = excludeFromResult;
    }

    public Integer getTravelGroupCheckTime() {
        return this.travelGroupCheckTime;
    }

    @Override
    public void setTravelGroupCheckTime(Integer travelGroupCheckTime) {
        this.travelGroupCheckTime = travelGroupCheckTime;
    }

    public Integer getTravelGroupProductLimit() {
        return this.travelGroupProductLimit;
    }

    @Override
    public void setTravelGroupProductLimit(Integer travelGroupProductLimit) {
        this.travelGroupProductLimit = travelGroupProductLimit;
    }

    public Integer getTravelGroupLockTime() {
        return this.travelGroupLockTime;
    }

    @Override
    public void setTravelGroupLockTime(Integer travelGroupLockTime) {
        this.travelGroupLockTime = travelGroupLockTime;
    }

    public boolean isTravelGroupSubagentNetwork() {
        return this.travelGroupSubagentNetwork;
    }

    @Override
    public void setTravelGroupSubagentNetwork(boolean travelGroupSubagentNetwork) {
        this.travelGroupSubagentNetwork = travelGroupSubagentNetwork;
    }

    public EntityReference<Organization> getBlankOwner() {
        return this.blankOwner;
    }

    @Override
    public void setBlankOwner(String blankOwnerCode) throws Exception {
        if (TextUtil.isBlank((String)blankOwnerCode)) {
            this.blankOwner = null;
            return;
        }
        EntityContainer ctr = EntityStorage.get().find(OrganizationIndex.class, OrganizationIndex.Property.code.name(), (Object)blankOwnerCode);
        if (ctr == null) {
            throw new Exception(String.format("can't find organization profile with code %s", blankOwnerCode));
        }
        if (!((Organization)ctr.getEntity()).getTypes().contains(OrganizationType.BLANK_OWNER)) {
            throw new Exception(String.format("organization with code %s is not a blank owner", blankOwnerCode));
        }
        this.blankOwner = ctr.toReference();
    }

    @Override
    public void setSearchDaysLimit(Integer searchDaysLimit) {
        this.searchDaysLimit = searchDaysLimit;
    }

    public Integer getSearchDaysLimit() {
        return this.searchDaysLimit;
    }
}

