/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.ibecorp.rules;

import com.gridnine.xtrip.common.ibecorp.rules.RzdParametersActions;
import com.gridnine.xtrip.common.ibecorp.rules.RzdParametersPropertiesProvider;
import com.gridnine.xtrip.common.ibecorp.rzd.model.RzdAbstractSearchParameters;
import com.gridnine.xtrip.common.midoffice.helper.CommonHelper;
import com.gridnine.xtrip.common.midoffice.model.SalesContext;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.dict.GdsName;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.profile.Person;
import com.gridnine.xtrip.common.model.rules.standard.RulesHelper;
import com.gridnine.xtrip.common.railway.model.rules.standart.RailwayProxyHelper;
import com.gridnine.xtrip.common.rules.elements.RuleProxy;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class RzdParametersProperties
implements RzdParametersPropertiesProvider {
    private static final long serialVersionUID = -8521300891916631118L;
    private final Set<String> subagencyCodes = new HashSet<String>();
    private final Set<String> profileGroups = new HashSet<String>();
    private final Set<String> arrivalLocations = new HashSet<String>();
    private final Set<String> departureLocations = new HashSet<String>();
    private final List<String[]> visitedCities = new ArrayList<String[]>();
    private Date departureDate;
    private final String gdsName;
    private final EntityReference<Person> agent;
    private final EntityReference<Organization> client;
    private String agencyCode;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RzdParametersProperties(GdsName gds, SalesContext ctx, RuleProxy<?, ?> proxy) {
        proxy.getTracer().traceEnteringMethod(this.getClass(), "constructor()", new String[0]);
        try {
            this.gdsName = gds == null ? null : gds.name();
            RulesHelper.addSubagencyCodes(this.subagencyCodes, (EntityReference)ctx.getSubagency());
            this.agent = ctx.getAgent();
            this.client = ctx.getClient();
            this.agencyCode = CommonHelper.getAgencyCode((SalesContext)ctx);
        }
        finally {
            proxy.getTracer().traceObject("proxy", (Object)this);
            proxy.getTracer().traceExitingMethod(this.getClass(), "constructor()", new String[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RzdParametersProperties(RzdAbstractSearchParameters params, SalesContext ctx, GdsName gds, RuleProxy<RzdParametersProperties, RzdParametersActions> proxy) {
        proxy.getTracer().traceEnteringMethod(this.getClass(), "constructor()", new String[0]);
        try {
            Set codes;
            this.departureDate = params.getDepartureDate();
            if (params.getDeparture() != null) {
                codes = RailwayProxyHelper.collectRailwayStationCodes(Collections.singleton(params.getDeparture().getCode()));
                this.departureLocations.addAll(codes);
                this.visitedCities.add(codes.toArray(new String[0]));
            }
            if (params.getArrival() != null) {
                codes = RailwayProxyHelper.collectRailwayStationCodes(Collections.singleton(params.getArrival().getCode()));
                this.arrivalLocations.addAll(codes);
                this.visitedCities.add(codes.toArray(new String[0]));
            }
            this.gdsName = gds == null ? null : gds.name();
            RulesHelper.addSubagencyCodes(this.subagencyCodes, (EntityReference)ctx.getSubagency());
            this.agent = ctx.getAgent();
            this.client = ctx.getClient();
            this.agencyCode = CommonHelper.getAgencyCode((SalesContext)ctx);
        }
        finally {
            proxy.getTracer().traceObject("proxy", (Object)this);
            proxy.getTracer().traceExitingMethod(this.getClass(), "constructor()", new String[0]);
        }
    }

    public Set<String> getSubagencyCodes() {
        return this.subagencyCodes;
    }

    public Set<String> getProfileGroups() {
        return this.profileGroups;
    }

    public Set<String> getArrivalLocations() {
        return this.arrivalLocations;
    }

    public Set<String> getDepartureLocations() {
        return this.departureLocations;
    }

    public List<String[]> getVisitedCities() {
        return this.visitedCities;
    }

    public Date getDepartureDate() {
        return this.departureDate;
    }

    public String getGdsName() {
        return this.gdsName;
    }

    public EntityReference<Person> getAgent() {
        return this.agent;
    }

    public EntityReference<Organization> getClient() {
        return this.client;
    }

    public String getAgencyCode() {
        return this.agencyCode;
    }
}

