/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.ibecorp.rzd;

import com.gridnine.xtrip.common.gds.helper.AgeRestriction;
import com.gridnine.xtrip.common.ibecorp.CommonIbecorpHelper;
import com.gridnine.xtrip.common.ibecorp.model.InMobGdsAccount;
import com.gridnine.xtrip.common.ibecorp.model.KzRailGdsAccount;
import com.gridnine.xtrip.common.ibecorp.model.UfsGdsAccount;
import com.gridnine.xtrip.common.ibecorp.rzd.AgeRestrictionCalculator;
import com.gridnine.xtrip.common.ibecorp.rzd.model.CarPlaceType;
import com.gridnine.xtrip.common.ibecorp.rzd.model.CarriageAttribute;
import com.gridnine.xtrip.common.ibecorp.rzd.model.CarriageAttributeEx;
import com.gridnine.xtrip.common.ibecorp.rzd.model.RzdBonusCardType;
import com.gridnine.xtrip.common.ibecorp.rzd.model.RzdCategory;
import com.gridnine.xtrip.common.ibecorp.rzd.model.RzdPrice;
import com.gridnine.xtrip.common.ibecorp.rzd.model.RzdPriceValues;
import com.gridnine.xtrip.common.ibecorp.rzd.model.RzdStatus;
import com.gridnine.xtrip.common.ibecorp.rzd.model.RzdTariff;
import com.gridnine.xtrip.common.ibecorp.rzd.model.RzdTrain;
import com.gridnine.xtrip.common.ibecorp.rzd.model.RzdValidationMessages;
import com.gridnine.xtrip.common.meta.EnumItem;
import com.gridnine.xtrip.common.meta.EnumType;
import com.gridnine.xtrip.common.meta.MetaRegistry;
import com.gridnine.xtrip.common.midoffice.helper.ReservationGdsNameInfoHelper;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.PassengerType;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.ReservationStatus;
import com.gridnine.xtrip.common.model.booking.Traveller;
import com.gridnine.xtrip.common.model.booking.railway.CarriageType;
import com.gridnine.xtrip.common.model.booking.railway.RailwayProduct;
import com.gridnine.xtrip.common.model.booking.railway.RailwaySegment;
import com.gridnine.xtrip.common.model.booking.railway.ServiceClass;
import com.gridnine.xtrip.common.model.dict.Country;
import com.gridnine.xtrip.common.model.dict.CountryReference;
import com.gridnine.xtrip.common.model.dict.DictionaryCache;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.dict.PassportType;
import com.gridnine.xtrip.common.model.dict.railway.RailwayCarrier;
import com.gridnine.xtrip.common.model.dict.railway.RailwayStation;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.helpers.BookingHelper;
import com.gridnine.xtrip.common.model.helpers.CommonReservationGdsNameInfoHelper;
import com.gridnine.xtrip.common.model.helpers.DictHelper;
import com.gridnine.xtrip.common.model.ibecorp.railway.BaseRailGdsAccount;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.profile.Passport;
import com.gridnine.xtrip.common.model.profile.RailwayBonusCard;
import com.gridnine.xtrip.common.model.rzd.ibecorp.RzdSettings;
import com.gridnine.xtrip.common.model.system.SystemSettingsType;
import com.gridnine.xtrip.common.model.validation.ValidationMessage;
import com.gridnine.xtrip.common.railway.model.helpers.RailwayProductHelper;
import com.gridnine.xtrip.common.railway.model.helpers.RailwayStationDictionaryHelper;
import com.gridnine.xtrip.common.util.CollectionUtil;
import com.gridnine.xtrip.common.util.DateInterval;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.PersonalName;
import com.gridnine.xtrip.common.util.TextUtil;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;

public class RzdCommonHelper {
    public static final String ORG_RZD_UID = "organization-blankowner-RZD-9et6h2";
    public static final String EMPTY_SEARCH_TRAINS_MESSGAE = "\u0420\u0435\u0439\u0441\u044b \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d\u044b.";
    public static final String TRAIN_MAIN_ROUTE_TITLE = "\u041e\u0421\u041d\u041e\u0412\u041d\u041e\u0419 \u041c\u0410\u0420\u0428\u0420\u0423\u0422";
    public static final Date minimumBirthdayDate = MiscUtil.createDate((int)1900, (int)1, (int)1);
    public static final EntityReference<RzdSettings> settingsRef = new EntityReference("ibecorp-RZD-SETTINGS", RzdSettings.class, null);
    public static final List<ServiceClass> NK1_CLASSES = Arrays.asList(ServiceClass.A1, ServiceClass.M1, ServiceClass.I1);
    public static final List<CarPlaceType> LOWER_CAR_PLACE_TYPES = Arrays.asList(CarPlaceType.LOWER, CarPlaceType.SIDE_LOWER, CarPlaceType.SIDE_LOWER_NEAR_RESTROOM, CarPlaceType.LAST_KUPE_LOWER, CarPlaceType.SIDE_LOWER, CarPlaceType.INVALIDS_LOWER, CarPlaceType.SIDE_LOWER_WITH_HIGHER_LEVEL_OF_NOISE, CarPlaceType.LOWER_IN_TWO_PLACE_COMPARTMENT, CarPlaceType.LAST_COMPARTMENT_LOWER_WITH_HIGHER_LEVEL_OF_NOISE, CarPlaceType.LOWER_WITH_CHILD, CarPlaceType.LAST_COMPARTMENT_LOWER);
    public static final List<CarPlaceType> UPPER_CAR_PLACE_TYPES = Arrays.asList(CarPlaceType.UPPER, CarPlaceType.SIDE_UPPER, CarPlaceType.SIDE_UPPER_NEAR_RESTROOM, CarPlaceType.LAST_KUPE_UPPER, CarPlaceType.SIDE_UPPER, CarPlaceType.INVALIDS_UPPER, CarPlaceType.SIDE_UPPER_WITH_HIGHER_LEVEL_OF_NOISE, CarPlaceType.UPPER_IN_TWO_PLACE_COMPARTMENT, CarPlaceType.LAST_COMPARTMENT_UPPER_WITH_HIGHER_LEVEL_OF_NOISE, CarPlaceType.UPPER_WITH_CHILD, CarPlaceType.LAST_COMPARTMENT_UPPER);
    private static Comparator<String> placeComparator = new Comparator<String>(){

        @Override
        public int compare(String s1, String s2) {
            return MiscUtil.compare((Comparable)this.toInteger(s1), (Comparable)this.toInteger(s2));
        }

        private Integer toInteger(String s) {
            if (TextUtil.isBlank((String)s)) {
                return null;
            }
            String intStr = s.replaceAll("\\D", "");
            return TextUtil.isBlank((String)intStr) ? null : Integer.valueOf(intStr);
        }
    };
    private static List<Class<? extends BaseRailGdsAccount>> ACTUALIZE_SUPPORT_GDS_ACCOUNTS_CLASSES = Arrays.asList(UfsGdsAccount.class, InMobGdsAccount.class, KzRailGdsAccount.class);
    private static final List<ServiceClass> EXTRA_INFANT_CLASSES = Arrays.asList(ServiceClass.A1, ServiceClass.M1, ServiceClass.I1);

    public static List<Reservation> getReservations(BookingFile bookingFile) {
        return BookingHelper.getReservationsForProduct((BookingFile)bookingFile, (Class[])new Class[]{RailwayProduct.class});
    }

    public static Reservation getFirstReservation(BookingFile bookingFile) {
        return BookingHelper.getFirstReservationForProduct((BookingFile)bookingFile, RailwayProduct.class);
    }

    public static Reservation getFirstReservation(Reservation currentReservation) {
        Reservation result = currentReservation;
        while (result.getPreviousReservation() != null) {
            result = result.getPreviousReservation();
        }
        return result;
    }

    public static List<Reservation> getRelatedReservations(Reservation reservation) {
        ArrayList<Reservation> result = new ArrayList<Reservation>();
        Reservation prev = reservation;
        while (prev.getPreviousReservation() != null) {
            prev = prev.getPreviousReservation();
            result.add(0, prev);
        }
        result.add(reservation);
        Reservation next = RzdCommonHelper.findNextReservation(reservation);
        while (next != null) {
            result.add(next);
            next = RzdCommonHelper.findNextReservation(next);
        }
        return result;
    }

    private static Reservation findNextReservation(Reservation reservation) {
        return reservation.getBookingFile().getReservations().stream().filter(res -> MiscUtil.equals((Object)res.getPreviousReservation(), (Object)reservation)).findFirst().orElse(null);
    }

    public static RailwayProduct getProduct(BookingFile bookingFile) {
        Reservation reservation = RzdCommonHelper.getFirstReservation(bookingFile);
        return RzdCommonHelper.getProduct(reservation);
    }

    public static RailwayProduct getProduct(Reservation res) {
        if (res == null) {
            return null;
        }
        return RzdCommonHelper.getProduct(res.getProducts());
    }

    public static RailwayProduct getProduct(Collection<BaseProduct> products) {
        if (CollectionUtil.isEmpty(products)) {
            return null;
        }
        for (BaseProduct bp : products) {
            if (!(bp instanceof RailwayProduct)) continue;
            RailwayProduct prod = (RailwayProduct)bp;
            return prod;
        }
        return null;
    }

    public static String calcFullTrainNumber(RailwaySegment segment) {
        if (segment.getSlot() != null) {
            return segment.getTrainNumber().concat(segment.getSlot());
        }
        return segment.getTrainNumber();
    }

    public static RailwayProduct getProductByUid(Reservation res, String uid) {
        for (BaseProduct bp : res.getProducts()) {
            RailwayProduct prod;
            if (!(bp instanceof RailwayProduct) || !(prod = (RailwayProduct)bp).getUid().equals(uid)) continue;
            return prod;
        }
        return null;
    }

    public static RailwaySegment getSegment(BookingFile bf) {
        RailwayProduct rp = RzdCommonHelper.getProduct(bf);
        return RzdCommonHelper.getSegment(rp);
    }

    public static RailwaySegment getSegment(Reservation reservation) {
        RailwayProduct rp = RzdCommonHelper.getProduct(reservation);
        return RzdCommonHelper.getSegment(rp);
    }

    public static RailwaySegment getSegment(RailwayProduct product) {
        if (product == null) {
            return null;
        }
        return product.getSegments().isEmpty() ? null : (RailwaySegment)product.getSegments().get(0);
    }

    public static List<RailwayProduct> getProducts(BookingFile bf) {
        ArrayList<RailwayProduct> result = new ArrayList<RailwayProduct>();
        for (Reservation res : RzdCommonHelper.getReservations(bf)) {
            result.addAll(RzdCommonHelper.getProducts(res));
        }
        return result;
    }

    public static List<RailwayProduct> getProducts(Reservation res) {
        ArrayList<RailwayProduct> result = new ArrayList<RailwayProduct>();
        if (res == null) {
            return result;
        }
        for (BaseProduct bp : res.getProducts()) {
            if (!(bp instanceof RailwayProduct)) continue;
            result.add((RailwayProduct)bp);
        }
        return result;
    }

    public static List<RailwayProduct> getEffectiveProducts(BookingFile bf) {
        ArrayList<RailwayProduct> result = new ArrayList<RailwayProduct>();
        for (Reservation res : RzdCommonHelper.getReservations(bf)) {
            result.addAll(RzdCommonHelper.getEffectiveProducts(res));
        }
        return result;
    }

    public static List<RailwayProduct> getEffectiveProducts(Reservation res) {
        ArrayList<RailwayProduct> result = new ArrayList<RailwayProduct>();
        if (res == null) {
            return result;
        }
        for (BaseProduct bp : res.getProducts()) {
            RailwayProduct prod;
            if (!(bp instanceof RailwayProduct) || !RzdCommonHelper.isEffectiveProduct(prod = (RailwayProduct)bp)) continue;
            result.add(prod);
        }
        return result;
    }

    public static boolean isEffectiveProduct(RailwayProduct product) {
        return product.getStatus() == ProductStatus.SELL && product.getNextProduct() == null;
    }

    public static List<String> getRecordLocatorsList(BookingFile bf) {
        ArrayList<String> result = new ArrayList<String>();
        for (Reservation res : RzdCommonHelper.getReservations(bf)) {
            String recordLocator = CommonReservationGdsNameInfoHelper.getDisplayedRecordLocator((Reservation)res);
            if (TextUtil.isBlank((String)recordLocator)) continue;
            result.add(recordLocator);
        }
        return result;
    }

    public static String getRecordLocators(BookingFile bf) {
        return MiscUtil.join(RzdCommonHelper.getRecordLocatorsList(bf), (String)",");
    }

    public static String getCarInfo(RailwaySegment segment, Locale locale) {
        String result = segment.getCarriageNumber();
        result = result + "/";
        result = result + (segment.getCarriageType() == null ? "" : RzdCommonHelper.getLocaleCaption(segment.getCarriageType(), locale));
        return result;
    }

    public static String getPlacesInfo(List<Reservation> reservations, ProductStatus status) {
        String result = "";
        if (reservations.isEmpty()) {
            return result;
        }
        TreeSet<String> places = new TreeSet<String>(placeComparator);
        for (Reservation res : reservations) {
            for (BaseProduct bp : res.getProducts()) {
                RailwayProduct rp;
                if (!(bp instanceof RailwayProduct) || (rp = (RailwayProduct)bp).getStatus() != status) continue;
                for (RailwaySegment seg : rp.getSegments()) {
                    places.addAll(seg.getPlaces());
                }
            }
        }
        result = result + RzdCommonHelper.convertPlacesSet(places);
        RailwayProduct product = RzdCommonHelper.getProduct(reservations.iterator().next());
        result = result + RzdCommonHelper.getServiceClassStr(product);
        return result;
    }

    public static String getServiceClassStr(RailwayProduct product) {
        String result = null;
        if (product != null) {
            ServiceClass serviceClass = ((RailwaySegment)product.getSegments().get(0)).getServiceClass();
            result = serviceClass != null ? " / " + serviceClass.toString() : "";
        }
        return result;
    }

    public static String convertPlacesSet(Collection<String> places) {
        StringBuilder sb = new StringBuilder();
        for (String nmb : places) {
            sb.append(nmb).append(" ");
        }
        sb.append("/ ");
        sb.append(places.size());
        return sb.toString();
    }

    public static String getOrderNumber(Reservation reservation) {
        RailwayProduct rp = RzdCommonHelper.getProduct(reservation);
        return rp == null ? null : rp.getEndorsement();
    }

    public static Traveller getFirstAdultTraveller(Reservation reservation) {
        if (reservation == null) {
            return null;
        }
        Traveller olderChild = null;
        Traveller firstTravelerWithoutType = null;
        for (BaseProduct bp : reservation.getProducts()) {
            if (!(bp instanceof RailwayProduct)) continue;
            RailwayProduct rp = (RailwayProduct)bp;
            for (Traveller passenger : rp.getPassengers()) {
                DictionaryReference passengerType = RailwayProductHelper.getPassengerType((RailwayProduct)rp, (Traveller)passenger);
                if (passengerType == null) {
                    if (firstTravelerWithoutType != null) continue;
                    firstTravelerWithoutType = passenger;
                    continue;
                }
                if (DictHelper.isAdultPassengerType((DictionaryReference)passengerType)) {
                    return passenger;
                }
                if (!DictHelper.isChildPassengerType((DictionaryReference)passengerType)) continue;
                Traveller child = passenger;
                if (olderChild != null && MiscUtil.compare((Date)child.getPassport().getBirthday(), (Date)olderChild.getPassport().getBirthday()) >= 0) continue;
                olderChild = child;
            }
        }
        return olderChild != null ? olderChild : firstTravelerWithoutType;
    }

    public static String buildPassengerNames(List<RailwayProduct> products) {
        StringBuilder sb = new StringBuilder();
        for (RailwayProduct rp : products) {
            for (Traveller tr : rp.getPassengers()) {
                if (sb.length() != 0) {
                    sb.append(", ");
                }
                sb.append(TextUtil.buildFullName((PersonalName)tr.getPassport()));
            }
        }
        return sb.toString();
    }

    public static String getLocaleCaption(Enum<?> item, Locale locale) {
        EnumType enumType = (EnumType)MetaRegistry.get().getEnums().get(item.getClass().getName());
        if (enumType == null) {
            return item.name();
        }
        EnumItem enumItem = (EnumItem)enumType.getItems().get(item.name());
        return enumItem == null ? item.name() : enumItem.getDisplayName(locale);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static EntityContainer<RzdSettings> getSettingsContainer() {
        EntityContainer result = EntityStorage.get().resolve(settingsRef);
        if (result != null) {
            return result;
        }
        EntityReference<RzdSettings> entityReference = settingsRef;
        synchronized (entityReference) {
            result = EntityStorage.get().resolve(settingsRef);
            if (result != null) {
                return result;
            }
            result = new EntityContainer(RzdSettings.class, settingsRef.getUid());
            RzdSettings settings = (RzdSettings)result.getEntity();
            settings.setWaitTime(Integer.valueOf(15));
            settings.setType(SystemSettingsType.OTHER);
            settings.setName("\u041d\u0430\u0441\u0442\u0440\u043e\u0439\u043a\u0438 \u0420\u0416\u0414-\u0448\u043b\u044e\u0437\u0430");
            result.setCreatedBy("system");
            result.setModifiedBy("system");
            result.getVersionInfo().setVersionNotes("created automatically");
            EntityStorage.get().save(result, false);
            return result;
        }
    }

    public static boolean isVoucherPrinted(RailwayProduct product) {
        return product.getIbecorpRzdStatus() == RzdStatus.PRINT;
    }

    public static boolean isRefundAvailable(RailwayProduct product) {
        if (product.getStatus() != ProductStatus.SELL || product.getNextProduct() != null || product.getReservation().getGdsNameInfo().getOnlineGdsAccount() == null || RzdCommonHelper.isVoucherPrinted(product)) {
            return false;
        }
        return TextUtil.isBlank((String)RzdCommonHelper.getValidateRefundMessage(product));
    }

    public static boolean isChangePrepaidMealAvailable(RailwayProduct product) {
        Reservation reservation = product.getReservation();
        return !(reservation.getStatus() != ReservationStatus.BOOKING && reservation.getStatus() != ReservationStatus.ISSUED || !reservation.getAdditionalInfo().getImData().isMealOptionPossible() && !product.getImData().isMealOptionPossible() || !RzdCommonHelper.isCorrectTimeForChangingPrepaidMeal(product));
    }

    private static boolean isCorrectTimeForChangingPrepaidMeal(RailwayProduct product) {
        RailwaySegment segment = RzdCommonHelper.getSegment(product);
        if (segment.getTrainDepartureDate() != null) {
            Date departureDate = RzdCommonHelper.isLastochka(segment) || RzdCommonHelper.isSapsan(segment) ? segment.getTrainDepartureDate() : MiscUtil.clearTime((Date)segment.getTrainDepartureDate());
            DateInterval di = new DateInterval(new Date(), departureDate);
            return di.getDuration(10) >= 48;
        }
        return true;
    }

    public static String getValidateRefundMessage(RailwayProduct product) {
        Date depDate;
        DateInterval di;
        if (CommonIbecorpHelper.getReservationStatus(product.getReservation()) != ReservationStatus.ISSUED) {
            return "\u0417\u0430\u043a\u0430\u0437 \u0434\u043e\u043b\u0436\u0435\u043d \u0431\u044b\u0442\u044c \u0432\u044b\u043f\u0438\u0441\u0430\u043d";
        }
        RailwaySegment segment = RzdCommonHelper.getSegment(product);
        if (product.getRefundExpireDate() != null) {
            if (segment.isHasEReg()) {
                if (product.getRefundExpireDate().before(new Date())) {
                    return String.format("\u0412\u043e\u0437\u0432\u0440\u0430\u0442 \u0432\u043e\u0437\u043c\u043e\u0436\u0435\u043d \u043d\u0435 \u043f\u043e\u0437\u0434\u043d\u0435\u0435 %1$td.%1$tm.%1$tY %1$tR", product.getRefundExpireDate());
                }
            } else if (new Date().after(segment.getDepartureDate())) {
                return "\u0412\u043e\u0437\u0432\u0440\u0430\u0442 \u0432\u043e\u0437\u043c\u043e\u0436\u0435\u043d \u0434\u043e \u043e\u0442\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u0438\u044f \u043f\u043e\u0435\u0437\u0434\u0430 \u0441\u043e \u0441\u0442\u0430\u043d\u0446\u0438\u0438 \u043e\u0442\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u0438\u044f \u043f\u0430\u0441\u0441\u0430\u0436\u0438\u0440\u0430";
            }
            return null;
        }
        if (RzdCommonHelper.isVoucherPrinted(product)) {
            return RzdStatus.PRINT + ". \u0412\u043e\u0437\u0432\u0440\u0430\u0442 \u0432\u043e\u0437\u043c\u043e\u0436\u0435\u043d \u0442\u043e\u043b\u044c\u043a\u043e \u0447\u0435\u0440\u0435\u0437 \u043a\u0430\u0441\u0441\u0443.";
        }
        boolean isSuburbanTrain = RzdCommonHelper.isSuburbanTrain(segment.getTrainNumber());
        if (isSuburbanTrain && (di = new DateInterval(new Date(), segment.getDepartureDate())).getDuration(10) < 2) {
            return "\u0412\u043e\u0437\u0432\u0440\u0430\u0442 \u0432\u043e\u0437\u043c\u043e\u0436\u0435\u043d \u043d\u0435 \u043f\u043e\u0437\u0434\u043d\u0435\u0435 \u0447\u0435\u043c \u0437\u0430 2 \u0447\u0430\u0441\u0430 \u0434\u043e \u043e\u0442\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u0438\u044f \u043f\u043e\u0435\u0437\u0434\u0430 \u0441\u043e \u0441\u0442\u0430\u043d\u0446\u0438\u0438 \u043e\u0442\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u0438\u044f \u043f\u0430\u0441\u0441\u0430\u0436\u0438\u0440\u0430";
        }
        boolean isInternational = Boolean.TRUE.equals(segment.getInternational());
        Date date = isInternational ? segment.getDepartureDate() : (depDate = segment.isHasEReg() ? segment.getTrainDepartureDate() : segment.getDepartureDate());
        if (depDate == null) {
            return null;
        }
        DateInterval di2 = new DateInterval(new Date(), depDate);
        if (isInternational) {
            if (di2.getDuration(10) < 6) {
                return "\u0412\u043e\u0437\u0432\u0440\u0430\u0442 \u0432\u043e\u0437\u043c\u043e\u0436\u0435\u043d \u043d\u0435 \u043f\u043e\u0437\u0434\u043d\u0435\u0435 \u0447\u0435\u043c \u0437\u0430 6 \u0447\u0430\u0441\u043e\u0432 \u0434\u043e \u043e\u0442\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u0438\u044f \u043f\u043e\u0435\u0437\u0434\u0430 \u0441\u043e \u0441\u0442\u0430\u043d\u0446\u0438\u0438 \u043e\u0442\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u0438\u044f \u043f\u0430\u0441\u0441\u0430\u0436\u0438\u0440\u0430";
            }
        } else if (segment.isHasEReg()) {
            if (di2.getDuration(10) < 1) {
                return "\u0412\u043e\u0437\u0432\u0440\u0430\u0442 \u0432\u043e\u0437\u043c\u043e\u0436\u0435\u043d \u043d\u0435 \u043f\u043e\u0437\u0434\u043d\u0435\u0435 \u0447\u0435\u043c \u0437\u0430 1 \u0447\u0430\u0441 \u0434\u043e \u043e\u0442\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u0438\u044f \u043e\u0442 \u043d\u0430\u0447\u0430\u043b\u044c\u043d\u043e\u0439 \u0441\u0442\u0430\u043d\u0446\u0438\u0438 \u043c\u0430\u0440\u0448\u0440\u0443\u0442\u0430 \u0441\u043b\u0435\u0434\u043e\u0432\u0430\u043d\u0438\u044f \u043f\u043e\u0435\u0437\u0434\u0430";
            }
        } else if (new Date().after(depDate)) {
            return "\u0412\u043e\u0437\u0432\u0440\u0430\u0442 \u0432\u043e\u0437\u043c\u043e\u0436\u0435\u043d \u0434\u043e \u043e\u0442\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u0438\u044f \u043f\u043e\u0435\u0437\u0434\u0430 \u0441\u043e \u0441\u0442\u0430\u043d\u0446\u0438\u0438 \u043e\u0442\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u0438\u044f \u043f\u0430\u0441\u0441\u0430\u0436\u0438\u0440\u0430";
        }
        return null;
    }

    public static boolean isERegAvailable(RailwayProduct product) {
        boolean productHasRefundOrExchange = product.getNextProduct() != null;
        boolean refundProduct = product.getStatus().equals((Object)ProductStatus.REFUND);
        return !productHasRefundOrExchange && !refundProduct && TextUtil.isBlank((String)RzdCommonHelper.getValidateSetERegMessage(product.getReservation())) && !RzdCommonHelper.isVoucherPrinted(product);
    }

    public static String getValidateSetERegMessage(Reservation reservation) {
        DateInterval di;
        if (CommonIbecorpHelper.getReservationStatus(reservation) != ReservationStatus.ISSUED) {
            return "\u0417\u0430\u043a\u0430\u0437 \u0434\u043e\u043b\u0436\u0435\u043d \u0431\u044b\u0442\u044c \u0432\u044b\u043f\u0438\u0441\u0430\u043d. \u041e\u043f\u0435\u0440\u0430\u0446\u0438\u044f \u0431\u0443\u0434\u0435\u0442 \u043e\u0442\u043c\u0435\u043d\u0435\u043d\u0430.";
        }
        RailwayProduct firstProduct = RzdCommonHelper.getProduct(reservation);
        RailwaySegment segment = RzdCommonHelper.getSegment(firstProduct);
        String recordLocator = CommonReservationGdsNameInfoHelper.getDisplayedRecordLocator((Reservation)reservation);
        if (!RzdCommonHelper.isERegEnabled(reservation)) {
            return String.format("\u0411\u0440\u043e\u043d\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u0435 '%s': \u043f\u043e\u0435\u0437\u0434 \u043d\u0435 \u043f\u043e\u0434\u0434\u0435\u0440\u0436\u0438\u0432\u0430\u0435\u0442 \u0443\u0434\u0430\u043b\u0435\u043d\u043d\u0443\u044e \u0440\u0435\u0433\u0438\u0441\u0442\u0440\u0430\u0446\u0438\u044e.", recordLocator);
        }
        if (RzdCommonHelper.isVoucherPrinted(firstProduct)) {
            return String.format("\u0411\u0440\u043e\u043d\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u0435 '%s': \u0438\u0437\u043c\u0435\u043d\u0435\u043d\u0438\u0435 \u042d\u0420 \u043d\u0435 \u0434\u043e\u0441\u0442\u0443\u043f\u043d\u043e. " + RzdStatus.PRINT, recordLocator);
        }
        Date erExpireDate = firstProduct.getERegExpireDate();
        if (erExpireDate != null) {
            if (erExpireDate.before(new Date())) {
                return String.format("\u0418\u0437\u043c\u0435\u043d\u0435\u043d\u0438\u0435 \u042d\u0420 \u0432\u043e\u0437\u043c\u043e\u0436\u043d\u043e \u043d\u0435 \u043f\u043e\u0437\u0434\u043d\u0435\u0435 %1$td.%1$tm.%1$tY %1$tR", firstProduct.getERegExpireDate());
            }
        } else if (segment.getTrainDepartureDate() != null && (di = new DateInterval(new Date(), segment.getTrainDepartureDate())).getDuration(10) < 1) {
            return "\u0418\u0437\u043c\u0435\u043d\u0435\u043d\u0438\u0435 \u042d\u0420 \u0432\u043e\u0437\u043c\u043e\u0436\u043d\u043e \u043d\u0435 \u043f\u043e\u0437\u0434\u043d\u0435\u0435 \u0447\u0435\u043c \u0437\u0430 1 \u0447\u0430\u0441 \u0434\u043e \u043e\u0442\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u0438\u044f \u043e\u0442 \u043d\u0430\u0447\u0430\u043b\u044c\u043d\u043e\u0439 \u0441\u0442\u0430\u043d\u0446\u0438\u0438 \u043c\u0430\u0440\u0448\u0440\u0443\u0442\u0430 \u0441\u043b\u0435\u0434\u043e\u0432\u0430\u043d\u0438\u044f \u043f\u043e\u0435\u0437\u0434\u0430";
        }
        return null;
    }

    public static boolean isERegEnabled(Reservation reservation) {
        if (reservation == null) {
            return false;
        }
        RailwaySegment segment = RzdCommonHelper.getSegment(reservation);
        return segment != null && segment.isERegEnabled();
    }

    public static boolean isHasEReg(RailwayProduct product) {
        RailwaySegment firstSegment = RzdCommonHelper.getSegment(product);
        return firstSegment != null && firstSegment.isHasEReg();
    }

    public static RailwayProduct getSellProductByBlankId(Reservation reservation, String blankId) {
        return RzdCommonHelper.getProductByBlankId(reservation, blankId, ProductStatus.SELL);
    }

    public static RailwayProduct getProductByBlankId(Reservation reservation, String blankId) {
        return RzdCommonHelper.getProductByBlankId(reservation, blankId, null);
    }

    public static RailwayProduct getProductByBlankId(Reservation reservation, String blankId, ProductStatus status) {
        if (blankId == null) {
            return null;
        }
        for (BaseProduct bp : reservation.getProducts()) {
            if (!(bp instanceof RailwayProduct)) continue;
            RailwayProduct rp = (RailwayProduct)bp;
            if (status != null && status != rp.getStatus() || !blankId.equals(rp.getBlankId())) continue;
            return rp;
        }
        return null;
    }

    public static boolean isRzdReservation(Reservation reservation) {
        for (BaseProduct bp : reservation.getProducts()) {
            if (!(bp instanceof RailwayProduct)) {
                return false;
            }
            RailwayProduct rp = (RailwayProduct)bp;
            if (rp.getBlankOwnerRef().equals((Object)new EntityReference(ORG_RZD_UID, Organization.class, null))) continue;
            return false;
        }
        return true;
    }

    public static Date getTimeLimit(BookingFile bf) {
        for (Reservation res : bf.getReservations()) {
            if (!RzdCommonHelper.isRzdReservation(res)) continue;
            return res.getTimeLimit();
        }
        return null;
    }

    public static void splitERegMap(Reservation reservation, Map<String, Boolean> eregMap, List<String> blanksTrue, List<String> blanksFalse) {
        for (Map.Entry<String, Boolean> entry : eregMap.entrySet()) {
            RailwaySegment segment;
            RailwayProduct rp = RzdCommonHelper.getProductByUid(reservation, entry.getKey());
            if (rp == null || rp.getStatus() != ProductStatus.SELL || rp.getNextProduct() != null || (segment = RzdCommonHelper.getSegment(rp)) == null || segment.isHasEReg() == entry.getValue().booleanValue()) continue;
            if (entry.getValue().booleanValue()) {
                blanksTrue.add(rp.getBlankId());
                continue;
            }
            blanksFalse.add(rp.getBlankId());
        }
    }

    public static boolean isSapsan(RzdTrain train) {
        return RzdCommonHelper.isSapsan(train.getBrand());
    }

    public static boolean isSapsan(RailwayProduct product) {
        return RzdCommonHelper.isSapsan(RzdCommonHelper.getSegment(product));
    }

    public static boolean isSapsan(RailwaySegment segment) {
        return RzdCommonHelper.isSapsan(segment.getTrainTitle()) || RzdCommonHelper.isSapsan(segment.getBrand());
    }

    public static boolean isSapsan(String title) {
        return "\u0421\u0410\u041f\u0421\u0410\u041d".equalsIgnoreCase(title);
    }

    public static boolean isLastochka(RailwaySegment segment) {
        return RzdCommonHelper.isLastochka(segment.getTrainTitle()) || RzdCommonHelper.isLastochka(segment.getBrand());
    }

    public static boolean isLastochka(String title) {
        return "\u041b\u0410\u0421\u0422\u041e\u0427\u041a\u0410".equalsIgnoreCase(title);
    }

    public static boolean isSamePassports(Passport p1, Passport p2, boolean checkBirthday) {
        boolean result;
        if (p1 == null || p2 == null || p1.getNumber() == null || p2.getNumber() == null) {
            return false;
        }
        boolean bl = result = p1.getType() == p2.getType() && p1.getNumber().equalsIgnoreCase(p2.getNumber());
        if (checkBirthday && result && p1.getBirthday() != null) {
            return p1.getBirthday().equals(p2.getBirthday());
        }
        return result;
    }

    public static DictionaryReference<PassengerType> rzdTariffToPassengerType(RzdTariff rzdTariff) {
        switch (rzdTariff) {
            case CHILD: 
            case CHILD_7: 
            case CHILD_12: 
            case CHILD_17: 
            case CHILD_KTZ: {
                return DictHelper.getChildPassengerType();
            }
            case BABY: 
            case INFANT_4: 
            case INFANT_6: 
            case INFANT_10: 
            case INFANT_12: 
            case INFANT_6_MKL11: 
            case INFANT_KTZ: {
                return DictHelper.getInfantPassengerType();
            }
        }
        return DictHelper.getAdultPassengerType();
    }

    public static RzdTariff getRzdTariff(RzdTariff rzdTariff, DictionaryReference<PassengerType> passengerType) {
        if (rzdTariff != null) {
            return rzdTariff;
        }
        return RzdCommonHelper.getRzdTariff(passengerType);
    }

    public static RzdTariff getRzdTariff(DictionaryReference<PassengerType> passengerType) {
        if (DictHelper.isInfantPassengerType(passengerType)) {
            return RzdTariff.BABY;
        }
        if (DictHelper.isChildPassengerType(passengerType)) {
            return RzdTariff.CHILD;
        }
        return RzdTariff.FULL;
    }

    public static void validateBirthday(Date birthDate, RzdTariff tariff, RzdTrain train, RzdPrice rzdPrice, Integer seatRangeFirst, Integer seatRangeLast, Collection<ValidationMessage> vms) {
        Date departureDate = train.getDepartureDatetime();
        boolean isSeatMotherWithChild = RzdCommonHelper.isSeatForMotherWithChild(seatRangeFirst, seatRangeLast);
        AgeRestriction ageRestriction = new AgeRestrictionCalculator().calculate(tariff, train, rzdPrice, isSeatMotherWithChild);
        ArrayList<ValidationMessage> messages = new ArrayList<ValidationMessage>();
        ageRestriction.validate(birthDate, departureDate, messages);
        if (minimumBirthdayDate.after(MiscUtil.clearTime((Date)birthDate))) {
            messages.add(RzdValidationMessages.getIncorrectBirthdayDate());
        }
        if (messages.isEmpty()) {
            return;
        }
        if (tariff == RzdTariff.SCHOOL) {
            vms.add(RzdValidationMessages.getIncorrectAgeForSchoolTariff());
        } else {
            vms.addAll(messages);
        }
    }

    public static boolean isSuburbanTrain(String trainDisplayNumber) {
        if (TextUtil.isBlank((String)trainDisplayNumber)) {
            return false;
        }
        return trainDisplayNumber.replaceAll("\\D", "").length() == 4;
    }

    public static boolean isSpecialCarriage(CarriageType carriageType, boolean isDM) {
        return carriageType == CarriageType.M && isDM;
    }

    public static ValidationMessage checkTravellersCount(int adultCount, int childCount, int babyCount, RzdPrice rzdPrice) {
        boolean isDM = rzdPrice.getSeatsIncluded() == 2;
        ServiceClass serviceClass = rzdPrice.getServiceClass();
        if (adultCount + childCount == 0) {
            return RzdValidationMessages.getNoPassengers();
        }
        if (adultCount == 0) {
            return RzdValidationMessages.getNoAdultPassengers();
        }
        if (adultCount < babyCount && !RzdCommonHelper.isLuxWithExtraInfants(rzdPrice)) {
            return RzdValidationMessages.getNotEnoughMajorPassengers();
        }
        if (isDM) {
            if (adultCount > 2) {
                return RzdValidationMessages.getTooManyAdults((int)2);
            }
            if (!(adultCount + childCount + babyCount <= 3 || adultCount == babyCount && RzdCommonHelper.isLuxWithExtraInfants(rzdPrice))) {
                return RzdValidationMessages.getTooManyTickets((int)3);
            }
            if (serviceClass == ServiceClass.E1 && adultCount + childCount > 2) {
                return RzdValidationMessages.getTooManyAdultsAndChilds((int)2);
            }
        }
        if (adultCount + childCount + babyCount > 4) {
            return RzdValidationMessages.getTooManyTickets((int)4);
        }
        Set<CarriageAttributeEx> carriageAttributesEx = CarriageAttributeEx.parseCarriageAttributes(rzdPrice.getSubcategory());
        boolean forChild = carriageAttributesEx.stream().filter(attr -> attr.getAttribute() == CarriageAttribute.CHILD).findAny().isPresent();
        if (forChild) {
            if (babyCount + childCount == 0) {
                return RzdValidationMessages.getNoChildPassengers();
            }
            if (adultCount > 2) {
                return RzdValidationMessages.getTooManyAdults((int)2);
            }
        }
        return null;
    }

    public static boolean isNK1(RzdPrice rzdPrice) {
        boolean isTwoPlacesPrice;
        CarriageType carriageType = rzdPrice.getCategory();
        ServiceClass serviceClass = rzdPrice.getServiceClass();
        boolean bl = isTwoPlacesPrice = rzdPrice.getSeatsIncluded() == 2;
        if (!isTwoPlacesPrice) {
            return false;
        }
        boolean carM = carriageType == CarriageType.M && NK1_CLASSES.contains(serviceClass);
        boolean carL = carriageType == CarriageType.L && ServiceClass.E1 == serviceClass;
        return carM || carL;
    }

    public static RailwayBonusCard createRailwayBonusCard(String number) {
        if (TextUtil.isBlank((String)number)) {
            return null;
        }
        RailwayBonusCard card = new RailwayBonusCard();
        card.setNumber(number);
        card.setRailwayCarrierCode(RzdBonusCardType.RZHD_BONUS.name());
        return card;
    }

    public static boolean isRussiaStation(DictionaryReference<RailwayStation> stationRef) {
        return MiscUtil.equals((Object)DictHelper.getRuRef(), RzdCommonHelper.getStationCountry(stationRef));
    }

    public static boolean isKzStation(DictionaryReference<RailwayStation> stationRef) {
        return MiscUtil.equals((Object)DictHelper.getKzRef(), RzdCommonHelper.getStationCountry(stationRef));
    }

    public static DictionaryReference<Country> getStationCountry(DictionaryReference<RailwayStation> stationRef) {
        RailwayStation station = (RailwayStation)DictionaryCache.get().resolveReference(stationRef);
        return station == null ? null : station.getCountry();
    }

    public static boolean isInternalRU(DictionaryReference<RailwayStation> stationFromRef, DictionaryReference<RailwayStation> stationToRef) {
        return RzdCommonHelper.isRussiaStation(stationFromRef) && RzdCommonHelper.isRussiaStation(stationToRef);
    }

    public static String formatRailwayFullName(DictionaryReference<RailwayStation> ref, Locale locale) {
        if (ref == null) {
            return null;
        }
        RailwayStation station = (RailwayStation)DictionaryCache.get().resolveReference(ref);
        if (station == null) {
            return ref.getCaption();
        }
        return RzdCommonHelper.formatRailwayFullName(station, locale);
    }

    public static String formatRailwayFullName(RailwayStation station, Locale locale) {
        String result = (String)MiscUtil.findByLocale((Map)station.getTranslations(), (Locale)locale);
        if (TextUtil.isBlank((String)result)) {
            return RailwayStationDictionaryHelper.getAnyShortName((RailwayStation)station);
        }
        return result;
    }

    public static String getPassportLabel(PassportType passportType, Locale locale) {
        return RzdCommonHelper.getLocaleCaption(passportType, locale);
    }

    public static boolean needActualBookingFile(BookingFile booking, boolean checkAllStatuses) {
        return booking.getReservations().stream().anyMatch(r -> {
            if (r == null) {
                return false;
            }
            if (ACTUALIZE_SUPPORT_GDS_ACCOUNTS_CLASSES.stream().noneMatch(cl -> ReservationGdsNameInfoHelper.hasOnlineGdsAccountOfClass((Reservation)r, (Class)cl))) {
                return false;
            }
            return checkAllStatuses || CommonIbecorpHelper.getReservationStatus(r) == ReservationStatus.ERROR;
        });
    }

    public static boolean isSeatForMotherWithChild(Integer seatRangeFirst, Integer seatRangeLast) {
        return RzdCommonHelper.isSeatForMotherWithChild(seatRangeFirst) && MiscUtil.equals((Object)seatRangeFirst, (Object)seatRangeLast);
    }

    public static boolean isSeatForMotherWithChild(Integer seatNumber) {
        if (seatNumber == null) {
            return false;
        }
        return seatNumber == 49;
    }

    public static boolean isPriceUnknown(BigDecimal originMin) {
        return BigDecimal.ZERO.compareTo(MiscUtil.guarded((BigDecimal)originMin)) == 0;
    }

    public static boolean isPriceUnknown(RzdCategory category) {
        return RzdCommonHelper.isPriceUnknown(category.getPriceOriginalMin());
    }

    public static boolean isPriceUnknown(RzdPriceValues priceValues) {
        if (priceValues == null) {
            return true;
        }
        return RzdCommonHelper.isPriceUnknown(priceValues.getOriginalMin());
    }

    public static Integer seat2IntValue(String seat) {
        if (TextUtil.isBlank((String)seat)) {
            return null;
        }
        String nmbStr = seat.split("\\D")[0];
        if (TextUtil.isBlank((String)nmbStr)) {
            return null;
        }
        return Integer.valueOf(nmbStr);
    }

    public static Integer getServiceClassLevel(ServiceClass serviceClass) {
        if (serviceClass == null) {
            return null;
        }
        return Integer.valueOf(serviceClass.name().replaceAll("\\D", ""));
    }

    public static boolean isLuxWithExtraInfants(RzdPrice rzdPrice) {
        if (rzdPrice.getSeatsIncluded() != 2 || CarriageType.M != rzdPrice.getCategory() || !EXTRA_INFANT_CLASSES.contains(rzdPrice.getServiceClass()) || rzdPrice.getCarrier() == null) {
            return false;
        }
        RailwayCarrier carrier = (RailwayCarrier)DictionaryCache.get().resolveReference(rzdPrice.getCarrier());
        if (carrier == null) {
            return false;
        }
        return carrier.getCodeVariants().values().contains("\u0424\u041f\u041a");
    }

    public static boolean isKzCitizenship(Passport psp) {
        return RzdCommonHelper.isCitizenship(psp, DictHelper.getKzRef());
    }

    public static boolean isByCitizenship(Passport psp) {
        return RzdCommonHelper.isCitizenship(psp, DictHelper.getByRef());
    }

    private static boolean isCitizenship(Passport psp, CountryReference checkCountryRef) {
        if (psp == null) {
            return false;
        }
        return MiscUtil.equals((Object)checkCountryRef, (Object)MiscUtil.guarded((Object)psp.getCitizenship(), (Object)psp.getOriginCountry()));
    }

    public static boolean isKzCitizenship(DictionaryReference<Country> countryRef) {
        return MiscUtil.equals((Object)DictHelper.getKzRef(), countryRef);
    }

    public static boolean isUzCitizenship(DictionaryReference<Country> countryRef) {
        return MiscUtil.equals((Object)DictHelper.getUzRef(), countryRef);
    }

    public static boolean isByCitizenship(DictionaryReference<Country> countryRef) {
        return MiscUtil.equals((Object)DictHelper.getByRef(), countryRef);
    }
}

