/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.ibecorp.rzd.model;

import com.gridnine.xtrip.common.ibecorp.rzd.model.CarriageAttribute;
import com.gridnine.xtrip.common.util.CollectionUtil;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;

public class CarriageAttributeEx {
    private CarriageAttribute attribute;
    private String valueEx;
    private static String CARRIAGE_ATTRIBUTES_SEP = " ";

    public CarriageAttributeEx() {
    }

    public CarriageAttributeEx(CarriageAttribute attribute) {
        this.attribute = attribute;
    }

    public CarriageAttribute getAttribute() {
        return this.attribute;
    }

    public void setAttribute(CarriageAttribute attribute) {
        this.attribute = attribute;
    }

    public String getValueEx() {
        return this.valueEx;
    }

    public void setValueEx(String valueEx) {
        this.valueEx = valueEx;
    }

    public String toString() {
        return this.attribute.getValue() + MiscUtil.guarded((String)this.valueEx);
    }

    public static Set<CarriageAttributeEx> parseCarriageAttributes(String text) {
        HashSet<CarriageAttributeEx> result = new HashSet<CarriageAttributeEx>();
        if (TextUtil.isBlank((String)text)) {
            return result;
        }
        String attributesText = text;
        for (CarriageAttribute attr : CarriageAttribute.values()) {
            if (!attr.getValue().contains(CARRIAGE_ATTRIBUTES_SEP) || !attributesText.contains(attr.getValue())) continue;
            result.add(new CarriageAttributeEx(attr));
            attributesText = attributesText.replaceFirst(Pattern.quote(attr.getValue()), "");
        }
        List arr = TextUtil.split((String)attributesText, (String)CARRIAGE_ATTRIBUTES_SEP, (boolean)true, (boolean)true);
        for (String value : arr) {
            CarriageAttribute atr = CarriageAttribute.getByValue(value);
            if (atr != null) {
                result.add(new CarriageAttributeEx(atr));
                continue;
            }
            String pattern = "^" + CarriageAttribute.U.getValue() + "\\d+[" + CarriageAttribute.B.getValue() + CarriageAttribute.E.getValue() + "]?$";
            if (!value.matches(pattern)) continue;
            int lastInd = value.length() - 1;
            if (value.endsWith(CarriageAttribute.B.getValue())) {
                result.add(new CarriageAttributeEx(CarriageAttribute.B));
            } else if (value.endsWith(CarriageAttribute.E.getValue())) {
                result.add(new CarriageAttributeEx(CarriageAttribute.E));
            } else {
                lastInd = value.length();
            }
            CarriageAttributeEx atrEx = new CarriageAttributeEx(CarriageAttribute.U);
            atrEx.setValueEx(value.substring(1, lastInd));
            result.add(atrEx);
        }
        return result;
    }

    public static String buildString(Collection<CarriageAttributeEx> carriageAttributesEx) {
        if (CollectionUtil.isEmpty(carriageAttributesEx)) {
            return null;
        }
        return TextUtil.join((String)" ", carriageAttributesEx, (boolean)true);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CarriageAttributeEx that = (CarriageAttributeEx)o;
        if (this.attribute != that.attribute) {
            return false;
        }
        return this.valueEx != null ? this.valueEx.equals(that.valueEx) : that.valueEx == null;
    }

    public int hashCode() {
        int result = this.attribute.hashCode();
        result = 31 * result + (this.valueEx != null ? this.valueEx.hashCode() : 0);
        return result;
    }
}

