/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.ibecorp.ukraine.l10n;

import com.gridnine.xtrip.common.l10n.model.Number2WordsConverter;
import com.gridnine.xtrip.common.l10n.model.UnsupportedCurrencyException;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;

public class UkraineNumber2WordsConverter
implements Number2WordsConverter {
    private static final String MINUS = "\u043c\u0438\u043d\u0443\u0441";
    private static final String INFINITY = "\u0431\u0435\u0441\u043a\u043e\u043d\u0435\u0447\u043d\u043e\u0441\u0442\u044c";
    private static final String ZERO = "\u043d\u043e\u043b\u044c";
    private static final String SEPARATOR = " ";
    private static final Locale locale = new Locale("uk");
    private static final Map<String, CurrencyData> currencies = new HashMap<String, CurrencyData>();
    private static final String[] exponent = new String[]{"", "\u0442\u0438\u0441\u044f\u0447\u0430", "\u043c\u0456\u043b\u044c\u0439\u043e\u043d", "\u043c\u0456\u043b\u044c\u044f\u0440\u0434", "\u0442\u0440\u0438\u043b\u044c\u0439\u043e\u043d", "\u043a\u0432\u0430\u0434\u0440\u0438\u043b\u044c\u0439\u043e\u043d", "\u043a\u0432\u0456\u043d\u0442\u0438\u043b\u044c\u0439\u043e\u043d", "\u0441\u0435\u043a\u0441\u0442\u0438\u043b\u044c\u0439\u043e\u043d", "\u0441\u0435\u043f\u0442\u0456\u043b\u043b\u0456\u043e\u043d", "\u043e\u043a\u0442\u0456\u043b\u043b\u0456\u043e\u043d", "\u043d\u043e\u043d\u0456\u043b\u043b\u0456\u043e\u043d", "\u0434\u0435\u0446\u0456\u043b\u043b\u0456\u043e\u043d", "\u0443\u043d\u0434\u0435\u0446\u0456\u043b\u043b\u0456\u043e\u043d", "\u0434\u0443\u043e\u0434\u0435\u0446\u0456\u043b\u043b\u0456\u043e\u043d", "\u0442\u0440\u0435\u0434\u0435\u0446\u0456\u043b\u043b\u0456\u043e\u043d", "\u043a\u0432\u0430\u0442\u0443\u043e\u0440\u0434\u0435\u0446\u0456\u043b\u043b\u0456\u043e\u043d", "\u043a\u0432\u0456\u043d\u0434\u0435\u0446\u0456\u043b\u043b\u0456\u043e\u043d", "\u0441\u0435\u043a\u0441\u0434\u0435\u0446\u0456\u043b\u043b\u0456\u043e\u043d", "\u0441\u0435\u043f\u0442\u0435\u043d\u0434\u0435\u0446\u0456\u043b\u043b\u0456\u043e\u043d", "\u043e\u043a\u0442\u043e\u0434\u0435\u0446\u0456\u043b\u043b\u0456\u043e\u043d", "\u043d\u043e\u0432\u0435\u043c\u0434\u0435\u0446\u0456\u043b\u043b\u0456\u043e\u043d", "\u0432\u0456\u0433\u0456\u043d\u0442\u0456\u043b\u043b\u0456\u043e\u043d", "\u0443\u043d\u0432\u0456\u0433\u0456\u043d\u0442\u0456\u043b\u043b\u0456\u043e\u043d", "\u0434\u0443\u043e\u0432\u0456\u0433\u0456\u043d\u0442\u0456\u043b\u043b\u0456\u043e\u043d", "\u0442\u0440\u0435\u0432\u0456\u0433\u0456\u043d\u0442\u0456\u043b\u043b\u0456\u043e\u043d", "\u043a\u0432\u0430\u0442\u0443\u043e\u0440\u0432\u0456\u0433\u0456\u043d\u0442\u0456\u043b\u043b\u0456\u043e\u043d", "\u043a\u0432\u0456\u043d\u0432\u0456\u0433\u0456\u043d\u0442\u0456\u043b\u043b\u0456\u043e\u043d", "\u0441\u0435\u043a\u0441\u0432\u0456\u0433\u0456\u043d\u0442\u0456\u043b\u043b\u0456\u043e\u043d", "\u0441\u0435\u043f\u0442\u0435\u043d\u0432\u0456\u0433\u0456\u043d\u0442\u0456\u043b\u043b\u0456\u043e\u043d", "\u043e\u043a\u0442\u043e\u0432\u0456\u0433\u0456\u043d\u0442\u0456\u043b\u043b\u0456\u043e\u043d", "\u043d\u043e\u0432\u0435\u043c\u0432\u0456\u0433\u0456\u043d\u0442\u0456\u043b\u043b\u0456\u043e\u043d", "\u0442\u0440\u0456\u0433\u0456\u043d\u0442\u0456\u043b\u043b\u0456\u043e\u043d", "\u0443\u043d\u0442\u0440\u0456\u0433\u0456\u043d\u0442\u0456\u043b\u043b\u0456\u043e\u043d", "\u0434\u0443\u043e\u0442\u0440\u0456\u0433\u0456\u043d\u0442\u0456\u043b\u043b\u0456\u043e\u043d", "\u0442\u0440\u0435\u0442\u0440\u0456\u0433\u0456\u043d\u0442\u0456\u043b\u043b\u0456\u043e\u043d", "\u043a\u0432\u0430\u0442\u043e\u0440\u0442\u0440\u0456\u0433\u0456\u043d\u0442\u0456\u043b\u043b\u0456\u043e\u043d", "\u043a\u0432\u0456\u043d\u0442\u0440\u0456\u0433\u0456\u043d\u0442\u0456\u043b\u043b\u0456\u043e\u043d", "\u0441\u0435\u043a\u0441\u0442\u0440\u0456\u0433\u0456\u043d\u0442\u0456\u043b\u043b\u0456\u043e\u043d", "\u0441\u0435\u043f\u0442\u0435\u043d\u0442\u0440\u0456\u0433\u0456\u043d\u0442\u0456\u043b\u043b\u0456\u043e\u043d", "\u043e\u043a\u0442\u043e\u0442\u0440\u0456\u0433\u0456\u043d\u0442\u0456\u043b\u043b\u0456\u043e\u043d", "\u043d\u043e\u0432\u0435\u043c\u0442\u0440\u0456\u0433\u0456\u043d\u0442\u0456\u043b\u043b\u0456\u043e\u043d", "\u043a\u0432\u0430\u0434\u0440\u0430\u0433\u0456\u043d\u0442\u0456\u043b\u043b\u0456\u043e\u043d", "\u0443\u043d\u043a\u0432\u0430\u0434\u0440\u0430\u0433\u0456\u043d\u0442\u0456\u043b\u043b\u0456\u043e\u043d", "\u0434\u0443\u043e\u043a\u0432\u0430\u0434\u0440\u0430\u0433\u0456\u043d\u0442\u0456\u043b\u043b\u0456\u043e\u043d", "\u0442\u0440\u0435\u043a\u0432\u0430\u0434\u0440\u0430\u0433\u0456\u043d\u0442\u0456\u043b\u043b\u0456\u043e\u043d", "\u043a\u0432\u0430\u0442\u043e\u0440\u043a\u0432\u0430\u0434\u0440\u0430\u0433\u0456\u043d\u0442\u0456\u043b\u043b\u0456\u043e\u043d", "\u043a\u0432\u0456\u043d\u043a\u0432\u0430\u0434\u0440\u0430\u0433\u0456\u043d\u0442\u0456\u043b\u043b\u0456\u043e\u043d", "\u0441\u0435\u043a\u0441\u043a\u0432\u0430\u0434\u0440\u0430\u0433\u0456\u043d\u0442\u0456\u043b\u043b\u0456\u043e\u043d", "\u0441\u0435\u043f\u0442\u0435\u043d\u043a\u0432\u0430\u0434\u0440\u0430\u0433\u0456\u043d\u0442\u0456\u043b\u043b\u0456\u043e\u043d", "\u043e\u043a\u0442\u043e\u043a\u0432\u0430\u0434\u0440\u0430\u0433\u0456\u043d\u0442\u0456\u043b\u043b\u0456\u043e\u043d", "\u043d\u043e\u0432\u0435\u043c\u043a\u0432\u0430\u0434\u0440\u0430\u0433\u0456\u043d\u0442\u0456\u043b\u043b\u0456\u043e\u043d", "\u043a\u0432\u0456\u043d\u043a\u0432\u0430\u0433\u0456\u043d\u0442\u0456\u043b\u043b\u0456\u043e\u043d", "\u0443\u043d\u043a\u0432\u0456\u043d\u043a\u0430\u0433\u0456\u043d\u0442\u0456\u043b\u043b\u0456\u043e\u043d", "\u0434\u0443\u043e\u043a\u0432\u0456\u043d\u043a\u0430\u0433\u0456\u043d\u0442\u0456\u043b\u043b\u0456\u043e\u043d", "\u0442\u0440\u0435\u043a\u0432\u0456\u043d\u043a\u0430\u0433\u0456\u043d\u0442\u0456\u043b\u043b\u0456\u043e\u043d", "\u043a\u0432\u0430\u0442\u043e\u0440\u043a\u0432\u0456\u043d\u043a\u0430\u0433\u0456\u043d\u0442\u0456\u043b\u043b\u0456\u043e\u043d", "\u043a\u0432\u0456\u043d\u043a\u0432\u0456\u043d\u043a\u0430\u0433\u0456\u043d\u0442\u0456\u043b\u043b\u0456\u043e\u043d", "\u0441\u0435\u043a\u0441\u043a\u0432\u0456\u043d\u043a\u0430\u0433\u0456\u043d\u0442\u0456\u043b\u043b\u0456\u043e\u043d", "\u0441\u0435\u043f\u0442\u0435\u043d\u043a\u0432\u0456\u043d\u043a\u0430\u0433\u0456\u043d\u0442\u0456\u043b\u043b\u0456\u043e\u043d", "\u043e\u043a\u0442\u043e\u043a\u0432\u0456\u043d\u043a\u0430\u0433\u0456\u043d\u0442\u0456\u043b\u043b\u0456\u043e\u043d", "\u043d\u043e\u0432\u0435\u043c\u043a\u0432\u0456\u043d\u043a\u0430\u0433\u0456\u043d\u0442\u0456\u043b\u043b\u0456\u043e\u043d", "\u0441\u0435\u043a\u0441\u0430\u0433\u0456\u043d\u0442\u0456\u043b\u043b\u0456\u043e\u043d", "\u0443\u043d\u0441\u0435\u043a\u0441\u0430\u0433\u0456\u043d\u0442\u0456\u043b\u043b\u0456\u043e\u043d", "\u0434\u0443\u043e\u0441\u0435\u043a\u0441\u0430\u0433\u0456\u043d\u0442\u0456\u043b\u043b\u0456\u043e\u043d", "\u0442\u0440\u0435\u0441\u0435\u043a\u0441\u0430\u0433\u0456\u043d\u0442\u0456\u043b\u043b\u0456\u043e\u043d", "\u043a\u0432\u0430\u0442\u043e\u0440\u0441\u0435\u043a\u0441\u0430\u0433\u0456\u043d\u0442\u0456\u043b\u043b\u0456\u043e\u043d", "\u043a\u0432\u0456\u043d\u0441\u0435\u043a\u0441\u0430\u0433\u0456\u043d\u0442\u0456\u043b\u043b\u0456\u043e\u043d", "\u0441\u0435\u043a\u0441\u0441\u0435\u043a\u0441\u0430\u0433\u0456\u043d\u0442\u0456\u043b\u043b\u0456\u043e\u043d", "\u0441\u0435\u043f\u0442\u0435\u043d\u0441\u0435\u043a\u0441\u0430\u0433\u0456\u043d\u0442\u0456\u043b\u043b\u0456\u043e\u043d", "\u043e\u043a\u0442\u043e\u0441\u0435\u043a\u0441\u0430\u0433\u0456\u043d\u0442\u0456\u043b\u043b\u0456\u043e\u043d", "\u043d\u043e\u0432\u0435\u043c\u0441\u0435\u043a\u0441\u0430\u0433\u0456\u043d\u0442\u0456\u043b\u043b\u0456\u043e\u043d", "\u0441\u0435\u043f\u0442\u0430\u0433\u0456\u043d\u0442\u0456\u043b\u043b\u0456\u043e\u043d", "\u0443\u043d\u0441\u0435\u043f\u0442\u0430\u0433\u0456\u043d\u0442\u0456\u043b\u043b\u0456\u043e\u043d", "\u0434\u0443\u043e\u0441\u0435\u043f\u0442\u0430\u0433\u0456\u043d\u0442\u0456\u043b\u043b\u0456\u043e\u043d", "\u0442\u0440\u0435\u0441\u0435\u043f\u0442\u0430\u0433\u0456\u043d\u0442\u0456\u043b\u043b\u0456\u043e\u043d", "\u043a\u0432\u0430\u0442\u043e\u0440\u0441\u0435\u043f\u0442\u0430\u0433\u0456\u043d\u0442\u0456\u043b\u043b\u0456\u043e\u043d", "\u043a\u0432\u0456\u043d\u0441\u0435\u043f\u0442\u0430\u0433\u0456\u043d\u0442\u0456\u043b\u043b\u0456\u043e\u043d", "\u0441\u0435\u043a\u0441\u0441\u0435\u043f\u0442\u0430\u0433\u0456\u043d\u0442\u0456\u043b\u043b\u0456\u043e\u043d", "\u0441\u0435\u043f\u0442\u0435\u043d\u0441\u0435\u043f\u0442\u0430\u0433\u0456\u043d\u0442\u0456\u043b\u043b\u0456\u043e\u043d", "\u043e\u043a\u0442\u043e\u0441\u0435\u043f\u0442\u0430\u0433\u0456\u043d\u0442\u0456\u043b\u043b\u0456\u043e\u043d", "\u043d\u043e\u0432\u0435\u043c\u0441\u0435\u043f\u0442\u0430\u0433\u0456\u043d\u0442\u0456\u043b\u043b\u0456\u043e\u043d", "\u043e\u043a\u0442\u043e\u0433\u0456\u043d\u0442\u0456\u043b\u043b\u0456\u043e\u043d", "\u0443\u043d\u043e\u043a\u0442\u043e\u0433\u0456\u043d\u0442\u0456\u043b\u043b\u0456\u043e\u043d", "\u0434\u0443\u043e\u043e\u043a\u0442\u043e\u0433\u0456\u043d\u0442\u0456\u043b\u043b\u0456\u043e\u043d", "\u0442\u0440\u0435\u043e\u043a\u0442\u043e\u0433\u0456\u043d\u0442\u0456\u043b\u043b\u0456\u043e\u043d", "\u043a\u0432\u0430\u0442\u043e\u0440\u043e\u043a\u0442\u043e\u0433\u0456\u043d\u0442\u0456\u043b\u043b\u0456\u043e\u043d", "\u043a\u0432\u0456\u043d\u043e\u043a\u0442\u043e\u0433\u0456\u043d\u0442\u0456\u043b\u043b\u0456\u043e\u043d", "\u0441\u0435\u043a\u0441\u043e\u043a\u0442\u043e\u0433\u0456\u043d\u0442\u0456\u043b\u043b\u0456\u043e\u043d", "\u0441\u0435\u043f\u0442\u043e\u043a\u0442\u043e\u0433\u0456\u043d\u0442\u0456\u043b\u043b\u0456\u043e\u043d", "\u043e\u043a\u0442\u043e\u043e\u043a\u0442\u043e\u0433\u0456\u043d\u0442\u0456\u043b\u043b\u0456\u043e\u043d", "\u043d\u043e\u0432\u0435\u043c\u043e\u043a\u0442\u043e\u0433\u0456\u043d\u0442\u0456\u043b\u043b\u0456\u043e\u043d", "\u043d\u043e\u043d\u0430\u0433\u0456\u043d\u0442\u0456\u043b\u043b\u0456\u043e\u043d", "\u0443\u043d\u043d\u043e\u043d\u0430\u0433\u0456\u043d\u0442\u0456\u043b\u043b\u0456\u043e\u043d", "\u0434\u0443\u043e\u043d\u043e\u043d\u0430\u0433\u0456\u043d\u0442\u0456\u043b\u043b\u0456\u043e\u043d", "\u0442\u0440\u0435\u043d\u043e\u043d\u0430\u0433\u0456\u043d\u0442\u0456\u043b\u043b\u0456\u043e\u043d", "\u043a\u0432\u0430\u0442\u043e\u0440\u043d\u043e\u043d\u0430\u0433\u0456\u043d\u0442\u0456\u043b\u043b\u0456\u043e\u043d", "\u043a\u0432\u0456\u043d\u043d\u043e\u043d\u0430\u0433\u0456\u043d\u0442\u0456\u043b\u043b\u0456\u043e\u043d", "\u0441\u0435\u043a\u0441\u043d\u043e\u043d\u0430\u0433\u0456\u043d\u0442\u0456\u043b\u043b\u0456\u043e\u043d", "\u0441\u0435\u043f\u0442\u0435\u043d\u043d\u043e\u043d\u0430\u0433\u0456\u043d\u0442\u0456\u043b\u043b\u0456\u043e\u043d", "\u043e\u043a\u0442\u043e\u043d\u043e\u043d\u0430\u0433\u0456\u043d\u0442\u0456\u043b\u043b\u0456\u043e\u043d", "\u043d\u043e\u0432\u0435\u043c\u043d\u043e\u043d\u0430\u0433\u0456\u043d\u0442\u0456\u043b\u043b\u0456\u043e\u043d", "\u0446\u0435\u043d\u0442\u0456\u043b\u043b\u0456\u043e\u043d"};
    private static final String[] teens = new String[]{"\u043e\u0434\u0438\u043d\u0430\u0434\u0446\u044f\u0442\u044c", "\u0434\u0432\u0430\u043d\u0430\u0434\u0446\u044f\u0442\u044c", "\u0442\u0440\u0438\u043d\u0430\u0434\u0446\u044f\u0442\u044c", "\u0447\u043e\u0442\u0438\u0440\u043d\u0430\u0434\u0446\u044f\u0442\u044c", "\u043f'\u044f\u0442\u043d\u0430\u0434\u0446\u044f\u0442\u044c", "\u0448\u0456\u0441\u0442\u043d\u0430\u0434\u0446\u044f\u0442\u044c", "\u0441\u0456\u043c\u043d\u0430\u0434\u0446\u044f\u0442\u044c", "\u0432\u0456\u0441\u0456\u043c\u043d\u0430\u0434\u0446\u044f\u0442\u044c", "\u0434\u0435\u0432'\u044f\u0442\u043d\u0430\u0434\u0446\u044f\u0442\u044c"};
    private static final String[] tens = new String[]{"\u0434\u0435\u0441\u044f\u0442\u044c", "\u0434\u0432\u0430\u0434\u0446\u044f\u0442\u044c", "\u0442\u0440\u0438\u0434\u0446\u044f\u0442\u044c", "\u0441\u043e\u0440\u043e\u043a", "\u043f'\u044f\u0442\u0434\u0435\u0441\u044f\u0442", "\u0448\u0456\u0441\u0442\u0434\u0435\u0441\u044f\u0442", "\u0441\u0456\u043c\u0434\u0435\u0441\u044f\u0442", "\u0432\u0456\u0441\u0456\u043c\u0434\u0435\u0441\u044f\u0442", "\u0434\u0435\u0432'\u044f\u043d\u043e\u0441\u0442\u043e"};
    private static final String[] hundreds = new String[]{"\u0441\u0442\u043e", "\u0434\u0432\u0456\u0441\u0442\u0456", "\u0442\u0440\u0438\u0441\u0442\u0430", "\u0447\u043e\u0442\u0438\u0440\u0438\u0441\u0442\u0430", "\u043f'\u044f\u0442\u0441\u043e\u0442", "\u0448\u0456\u0441\u0442\u0441\u043e\u0442", "\u0441\u0456\u043c\u0441\u043e\u0442", "\u0432\u0456\u0441\u0456\u043c\u0441\u043e\u0442", "\u0434\u0435\u0432'\u044f\u0442\u0441\u043e\u0442"};
    private static final Map<Gender, String[]> digits = new HashMap<Gender, String[]>();
    private static final Map<Declension, String> thousands = new HashMap<Declension, String>();

    public Locale getLocale() {
        return locale;
    }

    public Set<String> getCurrencies() {
        return Collections.unmodifiableSet(currencies.keySet());
    }

    public String toNumberWords(BigDecimal number) {
        if (number == null) {
            throw new IllegalArgumentException("Amount is null");
        }
        String[] entries = number.toPlainString().split("\\.");
        BigDecimal decimal = new BigDecimal(entries[0]);
        if (decimal.compareTo(BigDecimal.ZERO) == 0) {
            return ZERO;
        }
        WordsData wordsData = this.convertNumber(decimal.toPlainString(), Gender.MASCULINE);
        return wordsData.words;
    }

    public String toCurrencyWords(BigDecimal amount, String currency, boolean ignoreZeroDecimal, boolean ignoreZeroFraction, boolean convertFraction, boolean shortName) throws UnsupportedCurrencyException {
        return this.toCurrencyWords(amount, currency, ignoreZeroDecimal, ignoreZeroFraction, convertFraction);
    }

    public String toCurrencyWords(BigDecimal amount, String currency, boolean ignoreZeroDecimal, boolean ignoreZeroFraction, boolean convertFraction) throws UnsupportedCurrencyException {
        Declension numberDeclension;
        String numberWords;
        WordsData wordsData;
        if (amount == null) {
            throw new IllegalArgumentException("Amount is null");
        }
        if (currency == null) {
            throw new IllegalArgumentException("Currency is null");
        }
        if (!this.getCurrencies().contains(currency)) {
            throw new UnsupportedCurrencyException(String.format("Currency %s is not supported", currency));
        }
        CurrencyData currencyData = currencies.get(currency);
        StringBuilder currencyWords = new StringBuilder();
        String[] entries = amount.setScale(2, RoundingMode.HALF_UP).toPlainString().split("\\.");
        BigDecimal decimal = new BigDecimal(entries[0]);
        BigDecimal fraction = new BigDecimal(entries[1]);
        if (!ignoreZeroDecimal || decimal.compareTo(BigDecimal.ZERO) != 0) {
            wordsData = this.convertNumber(decimal.toPlainString(), currencyData.decimalGender);
            numberWords = wordsData.words;
            numberDeclension = wordsData.declension;
            if (numberWords == null) {
                numberWords = ZERO;
                numberDeclension = Declension.THIRD;
            }
            currencyWords.append(numberWords);
            currencyWords.append(SEPARATOR);
            currencyWords.append(currencyData.decimalNames.get((Object)numberDeclension));
        }
        if (!ignoreZeroFraction || fraction.compareTo(BigDecimal.ZERO) != 0) {
            wordsData = this.convertNumber(fraction.toPlainString(), currencyData.fractionGender);
            numberWords = wordsData.words;
            numberDeclension = wordsData.declension;
            if (numberWords == null) {
                numberWords = ZERO;
                numberDeclension = Declension.THIRD;
            }
            if (currencyWords.length() > 0) {
                currencyWords.append(SEPARATOR);
            }
            if (convertFraction) {
                currencyWords.append(numberWords);
            } else {
                currencyWords.append(String.format("%02d", fraction.intValue()));
            }
            currencyWords.append(SEPARATOR);
            currencyWords.append(currencyData.fractionNames.get((Object)numberDeclension));
        }
        return currencyWords.toString();
    }

    private WordsData convertNumber(String number, Gender gender) {
        String numberString = number;
        StringBuilder numberWords = new StringBuilder();
        Declension numberDeclension = null;
        if (numberString.substring(0, 1).equals("-")) {
            numberWords.append(MINUS);
            numberString = numberString.substring(1);
        }
        if (numberString.length() > exponent.length * 3) {
            numberWords.append(INFINITY);
            return new WordsData(numberWords.toString(), Declension.THIRD);
        }
        List<String> splitNumbers = this.splitNumber(numberString);
        for (int i = 0; i < splitNumbers.size(); ++i) {
            String splitNumber = splitNumbers.get(i);
            int pow = splitNumbers.size() - i - 1;
            WordsData wordsData = null;
            wordsData = pow == 0 ? this.convertNumberGroup(splitNumber, gender) : (pow == 1 ? this.convertNumberGroup(splitNumber, Gender.FEMININE) : this.convertNumberGroup(splitNumber, Gender.MASCULINE));
            String numberGroupWords = wordsData.words;
            Declension numberGroupDeclension = wordsData.declension;
            if (numberGroupWords == null) continue;
            if (numberWords.length() > 0) {
                numberWords.append(SEPARATOR);
            }
            numberWords.append(numberGroupWords);
            if (pow == 1) {
                numberWords.append(SEPARATOR);
                numberWords.append(thousands.get((Object)numberGroupDeclension));
            } else if (pow > 1) {
                numberWords.append(SEPARATOR);
                numberWords.append(exponent[pow]);
                if (numberGroupDeclension == Declension.SECOND) {
                    numberWords.append("\u0430");
                } else if (numberGroupDeclension == Declension.THIRD) {
                    numberWords.append("\u0456\u0432");
                }
            }
            numberDeclension = numberGroupDeclension;
        }
        return new WordsData(numberWords.length() > 0 ? numberWords.toString() : null, numberDeclension);
    }

    private WordsData convertNumberGroup(String number, Gender gender) {
        StringBuilder numberWords = new StringBuilder();
        Declension numberDeclension = null;
        int digit = Integer.parseInt(number);
        int e = digit % 10;
        int d = digit % 100 / 10;
        int s = digit % 1000 / 100;
        if (s > 0) {
            numberWords.append(hundreds[s - 1]);
            numberDeclension = Declension.THIRD;
        }
        if (d > 0) {
            if (numberWords.length() > 0) {
                numberWords.append(SEPARATOR);
            }
            if (d == 1 && e > 0) {
                numberWords.append(teens[e - 1]);
                numberDeclension = Declension.THIRD;
                e = 0;
            } else {
                numberWords.append(tens[d - 1]);
                numberDeclension = Declension.THIRD;
            }
        }
        if (e > 0) {
            if (numberWords.length() > 0) {
                numberWords.append(SEPARATOR);
            }
            numberWords.append(digits.get((Object)gender)[e - 1]);
            numberDeclension = e == 1 ? Declension.FIRST : (e < 5 ? Declension.SECOND : Declension.THIRD);
        }
        return new WordsData(numberWords.length() > 0 ? numberWords.toString() : null, numberDeclension);
    }

    private List<String> splitNumber(String number) {
        String last;
        ArrayList<String> numbers = new ArrayList<String>();
        String first = number.substring(0, number.length() % 3);
        if (first.length() > 0) {
            numbers.add(first);
        }
        if ((last = number.substring(first.length())).length() > 0) {
            numbers.addAll(Arrays.asList(last.split("(?<=\\G.{3})")));
        }
        return numbers;
    }

    static {
        digits.put(Gender.NEUTER, new String[]{"\u043e\u0434\u043d\u0435", "\u0434\u0432\u0430", "\u0442\u0440\u0438", "\u0447\u043e\u0442\u0438\u0440\u0438", "\u043f'\u044f\u0442\u044c", "\u0448\u0456\u0441\u0442\u044c", "\u0441\u0456\u043c", "\u0432\u0456\u0441\u0456\u043c", "\u0434\u0435\u0432'\u044f\u0442\u044c"});
        digits.put(Gender.MASCULINE, new String[]{"\u043e\u0434\u0438\u043d", "\u0434\u0432\u0430", "\u0442\u0440\u0438", "\u0447\u043e\u0442\u0438\u0440\u0438", "\u043f'\u044f\u0442\u044c", "\u0448\u0456\u0441\u0442\u044c", "\u0441\u0456\u043c", "\u0432\u0456\u0441\u0456\u043c", "\u0434\u0435\u0432'\u044f\u0442\u044c"});
        digits.put(Gender.FEMININE, new String[]{"\u043e\u0434\u043d\u0430", "\u0434\u0432\u0456", "\u0442\u0440\u0438", "\u0447\u043e\u0442\u0438\u0440\u0438", "\u043f'\u044f\u0442\u044c", "\u0448\u0456\u0441\u0442\u044c", "\u0441\u0456\u043c", "\u0432\u0456\u0441\u0456\u043c", "\u0434\u0435\u0432'\u044f\u0442\u044c"});
        thousands.put(Declension.FIRST, "\u0442\u0438\u0441\u044f\u0447\u0430");
        thousands.put(Declension.SECOND, "\u0442\u0438\u0441\u044f\u0447\u0456");
        thousands.put(Declension.THIRD, "\u0442\u0438\u0441\u044f\u0447");
        currencies.put("ALL", new CurrencyData(Gender.MASCULINE, new String[]{"\u043b\u0435\u043a", "\u043b\u0435\u043a\u0430", "\u043b\u0435\u043a\u043e\u0432"}, Gender.FEMININE, new String[]{"\u043a\u0456\u043d\u0434\u0430\u0440\u043a\u0430", "\u043a\u0456\u043d\u0434\u0430\u0440\u043a\u0456", "\u043a\u0456\u043d\u0434\u0430\u0440\u043e\u043a"}));
        currencies.put("AUD", new CurrencyData(Gender.MASCULINE, new String[]{"\u0430\u0432\u0441\u0442\u0440\u0430\u043b\u0456\u0439\u0441\u044c\u043a\u0438\u0439 \u0434\u043e\u043b\u0430\u0440", "\u0430\u0432\u0441\u0442\u0440\u0430\u043b\u0456\u0439\u0441\u044c\u043a\u0438\u0445 \u0434\u043e\u043b\u0430\u0440\u0430", "\u0430\u0432\u0441\u0442\u0440\u0430\u043b\u0456\u0439\u0441\u044c\u043a\u0438\u0445 \u0434\u043e\u043b\u0430\u0440\u0456\u0432"}, Gender.MASCULINE, new String[]{"\u0446\u0435\u043d\u0442", "\u0446\u0435\u043d\u0442\u0430", "\u0446\u0435\u043d\u0442\u0456\u0432"}));
        currencies.put("BGN", new CurrencyData(Gender.MASCULINE, new String[]{"\u043b\u0435\u0432", "\u043b\u0435\u0432\u0430", "\u043b\u0435\u0432\u0456\u0432"}, Gender.FEMININE, new String[]{"\u0441\u0442\u043e\u0442\u0456\u043d\u043a\u0456", "\u0441\u0442\u043e\u0442\u0456\u043d\u043a\u0456", "\u0441\u0442\u043e\u0442\u0438\u043d\u043e\u043a"}));
        currencies.put("BRL", new CurrencyData(Gender.MASCULINE, new String[]{"\u0431\u0440\u0430\u0437\u0438\u043b\u044c\u0441\u044c\u043a\u0438\u0439 \u0440\u0435\u0430\u043b", "\u0431\u0440\u0430\u0437\u0438\u043b\u044c\u0441\u044c\u043a\u0438\u0445 \u0440\u0435\u0430\u043b\u0430", "\u0431\u0440\u0430\u0437\u0438\u043b\u044c\u0441\u044c\u043a\u0438\u0445 \u0440\u0435\u0430\u043b\u0456\u0432"}, Gender.MASCULINE, new String[]{"\u0441\u0435\u043d\u0442\u0430\u0432\u043e", "\u0441\u0435\u043d\u0442\u0430\u0432\u043e", "\u0441\u0435\u043d\u0442\u0430\u0432\u043e"}));
        currencies.put("BYR", new CurrencyData(Gender.MASCULINE, new String[]{"\u0431\u0456\u043b\u043e\u0440\u0443\u0441\u044c\u043a\u0438\u0439 \u0440\u0443\u0431\u043b\u044c", "\u0431\u0456\u043b\u043e\u0440\u0443\u0441\u044c\u043a\u0438\u0445 \u0440\u0443\u0431\u043b\u044f", "\u0431\u0456\u043b\u043e\u0440\u0443\u0441\u044c\u043a\u0438\u0445 \u0440\u0443\u0431\u043b\u0456\u0432"}, Gender.FEMININE, new String[]{"\u043a\u043e\u043f\u0456\u0439\u043a\u0430", "\u043a\u043e\u043f\u0456\u0439\u043a\u0438", "\u043a\u043e\u043f\u0456\u0439\u043e\u043a"}));
        currencies.put("CAD", new CurrencyData(Gender.MASCULINE, new String[]{"\u043a\u0430\u043d\u0430\u0434\u0441\u044c\u043a\u0438\u0439 \u0434\u043e\u043b\u0430\u0440", "\u043a\u0430\u043d\u0430\u0434\u0441\u044c\u043a\u0438\u0445 \u0434\u043e\u043b\u0430\u0440\u0430", "\u043a\u0430\u043d\u0430\u0434\u0441\u044c\u043a\u0438\u0445 \u0434\u043e\u043b\u0430\u0440\u0456\u0432"}, Gender.MASCULINE, new String[]{"\u0446\u0435\u043d\u0442", "\u0446\u0435\u043d\u0442\u0430", "\u0446\u0435\u043d\u0442\u0456\u0432"}));
        currencies.put("CHF", new CurrencyData(Gender.MASCULINE, new String[]{"\u0448\u0432\u0435\u0439\u0446\u0430\u0440\u0441\u044c\u043a\u0438\u0439 \u0444\u0440\u0430\u043d\u043a", "\u0448\u0432\u0435\u0439\u0446\u0430\u0440\u0441\u044c\u043a\u0438\u0445 \u0444\u0440\u0430\u043d\u043a\u0430", "\u0448\u0432\u0435\u0439\u0446\u0430\u0440\u0441\u044c\u043a\u0438\u0445 \u0444\u0440\u0430\u043d\u043a\u0456\u0432"}, Gender.MASCULINE, new String[]{"\u0441\u0430\u043d\u0442\u0438\u043c", "\u0441\u0430\u043d\u0442\u0438\u043c\u0430", "\u0441\u0430\u043d\u0442\u0438\u043c\u0456\u0432"}));
        currencies.put("CYP", new CurrencyData(Gender.MASCULINE, new String[]{"\u043a\u0456\u043f\u0440\u0441\u044c\u043a\u0438\u0439 \u0444\u0443\u043d\u0442", "\u043a\u0456\u043f\u0440\u0441\u044c\u043a\u0438\u0445 \u0444\u0443\u043d\u0442\u0430", "\u043a\u0456\u043f\u0440\u0441\u044c\u043a\u0438\u0445 \u0444\u0443\u043d\u0442\u0456\u0432"}, Gender.MASCULINE, new String[]{"\u0446\u0435\u043d\u0442", "\u0446\u0435\u043d\u0442\u0430", "\u0446\u0435\u043d\u0442\u0456\u0432"}));
        currencies.put("CZK", new CurrencyData(Gender.FEMININE, new String[]{"\u0447\u0435\u0441\u044c\u043a\u0430 \u043a\u0440\u043e\u043d\u0430", "\u0447\u0435\u0441\u044c\u043a\u0438\u0445 \u043a\u0440\u043e\u043d\u0438", "\u0447\u0435\u0441\u044c\u043a\u0438\u0445 \u043a\u0440\u043e\u043d"}, Gender.MASCULINE, new String[]{"\u0433\u0430\u043b\u0456\u0440\u0436", "\u0433\u0430\u043b\u0456\u0440\u0436\u0430", "\u0433\u0430\u043b\u0456\u0440\u0436\u0435\u0439"}));
        currencies.put("DKK", new CurrencyData(Gender.FEMININE, new String[]{"\u0434\u0430\u0442\u0441\u044c\u043a\u0430 \u043a\u0440\u043e\u043d\u0430", "\u0434\u0430\u0442\u0441\u044c\u043a\u0438\u0445 \u043a\u0440\u043e\u043d\u0438", "\u0434\u0430\u0442\u0441\u044c\u043a\u0438\u0445 \u043a\u0440\u043e\u043d"}, Gender.MASCULINE, new String[]{"\u0435\u0440\u0456", "\u0435\u0440\u0456", "\u0435\u0440\u0456"}));
        currencies.put("EEK", new CurrencyData(Gender.FEMININE, new String[]{"\u0435\u0441\u0442\u043e\u043d\u0441\u044c\u043a\u0430 \u043a\u0440\u043e\u043d\u0430", "\u0435\u0441\u0442\u043e\u043d\u0441\u044c\u043a\u0438\u0445 \u043a\u0440\u043e\u043d\u0438", "\u0435\u0441\u0442\u043e\u043d\u0441\u044c\u043a\u0438\u0445 \u043a\u0440\u043e\u043d"}, Gender.MASCULINE, new String[]{"\u0446\u0435\u043d\u0442", "\u0446\u0435\u043d\u0442\u0430", "\u0446\u0435\u043d\u0442\u0456\u0432"}));
        currencies.put("EUR", new CurrencyData(Gender.MASCULINE, new String[]{"\u0454\u0432\u0440\u043e", "\u0454\u0432\u0440\u043e", "\u0454\u0432\u0440\u043e"}, Gender.MASCULINE, new String[]{"\u0454\u0432\u0440\u043e\u0446\u0435\u043d\u0442", "\u0454\u0432\u0440\u043e\u0446\u0435\u043d\u0442\u0430", "\u0454\u0432\u0440\u043e\u0446\u0435\u043d\u0442\u0456\u0432"}));
        currencies.put("CYP", new CurrencyData(Gender.MASCULINE, new String[]{"\u0444\u0443\u043d\u0442 \u0441\u0442\u0435\u0440\u043b\u0456\u043d\u0433\u0456\u0432", "\u0444\u0443\u043d\u0442\u0430 \u0441\u0442\u0435\u0440\u043b\u0456\u043d\u0433\u0456\u0432", "\u0444\u0443\u043d\u0442\u0456\u0432 \u0441\u0442\u0435\u0440\u043b\u0456\u043d\u0433\u0456\u0432"}, Gender.MASCULINE, new String[]{"\u043f\u0435\u043d\u0441", "\u043f\u0435\u043d\u0441\u0430", "\u043f\u0435\u043d\u0441\u0456\u0432"}));
        currencies.put("CAD", new CurrencyData(Gender.MASCULINE, new String[]{"\u0433\u043e\u043d\u043a\u043e\u043d\u0433\u0441\u044c\u043a\u0438\u0439 \u0434\u043e\u043b\u0430\u0440", "\u0433\u043e\u043d\u043a\u043e\u043d\u0433\u0441\u044c\u043a\u0438\u0445 \u0434\u043e\u043b\u0430\u0440\u0430", "\u0433\u043e\u043d\u043a\u043e\u043d\u0433\u0441\u044c\u043a\u0438\u0445 \u0434\u043e\u043b\u0430\u0440\u0456\u0432"}, Gender.MASCULINE, new String[]{"\u0446\u0435\u043d\u0442", "\u0446\u0435\u043d\u0442\u0430", "\u0446\u0435\u043d\u0442\u0456\u0432"}));
        currencies.put("HRK", new CurrencyData(Gender.FEMININE, new String[]{"\u0445\u043e\u0440\u0432\u0430\u0442\u0441\u044c\u043a\u0430 \u043a\u0443\u043d\u0430", "\u0445\u043e\u0440\u0432\u0430\u0442\u0441\u044c\u043a\u0438\u0445 \u043a\u0443\u043d\u0438", "\u0445\u043e\u0440\u0432\u0430\u0442\u0441\u044c\u043a\u0438\u0445 \u043a\u0443\u043d"}, Gender.FEMININE, new String[]{"\u043b\u0438\u043f\u0430", "\u043b\u0438\u043f\u0438", "\u043b\u0438\u043f"}));
        currencies.put("HUF", new CurrencyData(Gender.MASCULINE, new String[]{"\u0443\u0433\u043e\u0440\u0441\u044c\u043a\u0438\u0439 \u0444\u043e\u0440\u0438\u043d\u0442", "\u0443\u0433\u043e\u0440\u0441\u044c\u043a\u0438\u0445 \u0444\u043e\u0440\u0438\u043d\u0442\u0430", "\u0443\u0433\u043e\u0440\u0441\u044c\u043a\u0438\u0445 \u0444\u043e\u0440\u0438\u043d\u0442\u0456\u0432"}, Gender.MASCULINE, new String[]{"\u0444\u0456\u043b\u043b\u0435\u0440", "\u0444\u0456\u043b\u043b\u0435\u0440\u0438", "\u0444\u0456\u043b\u043b\u0435\u0440\u0456\u0432"}));
        currencies.put("ISK", new CurrencyData(Gender.FEMININE, new String[]{"\u0456\u0441\u043b\u0430\u043d\u0434\u0441\u044c\u043a\u0430 \u043a\u0440\u043e\u043d\u0430", "\u0456\u0441\u043b\u0430\u043d\u0434\u0441\u044c\u043a\u0438\u0445 \u043a\u0440\u043e\u043d\u0438", "\u0456\u0441\u043b\u0430\u043d\u0434\u0441\u044c\u043a\u0438\u0445 \u043a\u0440\u043e\u043d"}, Gender.MASCULINE, new String[]{"\u0435\u0440\u0456", "\u0435\u0440\u0456", "\u0435\u0440\u0456"}));
        currencies.put("JPY", new CurrencyData(Gender.FEMININE, new String[]{"\u0456\u0454\u043d\u0430", "\u0456\u0454\u043d\u0438", "\u0456\u0454\u043d"}, Gender.FEMININE, new String[]{"\u0441\u0456\u043d\u0430", "\u0441\u0435\u043d\u0438", "\u0441\u0435\u043d"}));
        currencies.put("LTL", new CurrencyData(Gender.MASCULINE, new String[]{"\u043b\u0456\u0442", "\u043b\u0456\u0442\u0430", "\u043b\u0456\u0442\u0456\u0432"}, Gender.MASCULINE, new String[]{"\u0446\u0435\u043d\u0442", "\u0446\u0435\u043d\u0442\u0430", "\u0446\u0435\u043d\u0442\u0456\u0432"}));
        currencies.put("LVL", new CurrencyData(Gender.MASCULINE, new String[]{"\u043b\u0430\u0442", "\u043b\u0430\u0442\u0430", "\u043b\u0430\u0442\u0456\u0432"}, Gender.MASCULINE, new String[]{"\u0441\u0430\u043d\u0442\u0438\u043c", "\u0441\u0430\u043d\u0442\u0438\u043c\u0430", "\u0441\u0430\u043d\u0442\u0438\u043c\u0456\u0432"}));
        currencies.put("MKD", new CurrencyData(Gender.MASCULINE, new String[]{"\u043c\u0430\u043a\u0435\u0434\u043e\u043d\u0441\u044c\u043a\u0438\u0439 \u0434\u0438\u043d\u0430\u0440", "\u043c\u0430\u043a\u0435\u0434\u043e\u043d\u0441\u044c\u043a\u0438\u0445 \u0434\u0438\u043d\u0430\u0440\u0430", "\u043c\u0430\u043a\u0435\u0434\u043e\u043d\u0441\u044c\u043a\u0438\u0445 \u0434\u0438\u043d\u0430\u0440\u0456\u0432"}, Gender.MASCULINE, new String[]{"\u0434\u0435\u043d\u0456", "\u0434\u0435\u043d\u0456", "\u0434\u0435\u043d\u0456"}));
        currencies.put("MTL", new CurrencyData(Gender.FEMININE, new String[]{"\u043c\u0430\u043b\u044c\u0442\u0456\u0439\u0441\u044c\u043a\u0430 \u043b\u0456\u0440\u0430", "\u043c\u0430\u043b\u044c\u0442\u0456\u0439\u0441\u044c\u043a\u0438\u0445 \u043b\u0456\u0440\u0438", "\u043c\u0430\u043b\u044c\u0442\u0456\u0439\u0441\u044c\u043a\u0438\u0445 \u043b\u0456\u0440"}, Gender.MASCULINE, new String[]{"\u0446\u0435\u043d\u0442", "\u0446\u0435\u043d\u0442\u0430", "\u0446\u0435\u043d\u0442\u0456\u0432"}));
        currencies.put("NOK", new CurrencyData(Gender.FEMININE, new String[]{"\u043d\u043e\u0440\u0432\u0435\u0437\u044c\u043a\u0430 \u043a\u0440\u043e\u043d\u0430", "\u043d\u043e\u0440\u0432\u0435\u0437\u044c\u043a\u0438\u0445 \u043a\u0440\u043e\u043d\u0438", "\u043d\u043e\u0440\u0432\u0435\u0437\u044c\u043a\u0438\u0445 \u043a\u0440\u043e\u043d"}, Gender.NEUTER, new String[]{"\u0435\u0440\u0456", "\u0435\u0440\u0456", "\u0435\u0440\u0456"}));
        currencies.put("PLN", new CurrencyData(Gender.MASCULINE, new String[]{"\u0437\u043b\u043e\u0442\u0438\u0439", "\u0437\u043b\u043e\u0442\u0438\u0445", "\u0437\u043b\u043e\u0442\u0438\u0445"}, Gender.MASCULINE, new String[]{"\u0433\u0440\u0456\u0448", "\u0433\u0440\u043e\u0448\u0430", "\u0433\u0440\u043e\u0448\u0456\u0432"}));
        currencies.put("ROL", new CurrencyData(Gender.MASCULINE, new String[]{"\u0440\u0443\u043c\u0443\u043d\u0441\u044c\u043a\u0438\u0439 \u043b\u0435\u0439", "\u0440\u0443\u043c\u0443\u043d\u0441\u044c\u043a\u0438\u0445 \u043b\u0435\u0439", "\u0440\u0443\u043c\u0443\u043d\u0441\u044c\u043a\u0438\u0445 \u043b\u0435\u0439"}, Gender.MASCULINE, new String[]{"\u0431\u0430\u043d\u044c", "\u0431\u0430\u043d\u0456", "\u0431\u0430\u043d\u0435\u0439"}));
        currencies.put("RUB", new CurrencyData(Gender.MASCULINE, new String[]{"\u0440\u043e\u0441\u0456\u0439\u0441\u044c\u043a\u0438\u0439 \u0440\u0443\u0431\u043b\u044c", "\u0440\u043e\u0441\u0456\u0439\u0441\u044c\u043a\u0438\u0445 \u0440\u0443\u0431\u043b\u044f", "\u0440\u043e\u0441\u0456\u0439\u0441\u044c\u043a\u0438\u0445 \u0440\u0443\u0431\u043b\u0456\u0432"}, Gender.FEMININE, new String[]{"\u043a\u043e\u043f\u0456\u0439\u043a\u0430", "\u043a\u043e\u043f\u0456\u0439\u043a\u0438", "\u043a\u043e\u043f\u0456\u0439\u043e\u043a"}));
        currencies.put("RUR", new CurrencyData(Gender.MASCULINE, new String[]{"\u0440\u043e\u0441\u0456\u0439\u0441\u044c\u043a\u0438\u0439 \u0440\u0443\u0431\u043b\u044c", "\u0440\u043e\u0441\u0456\u0439\u0441\u044c\u043a\u0438\u0445 \u0440\u0443\u0431\u043b\u044f", "\u0440\u043e\u0441\u0456\u0439\u0441\u044c\u043a\u0438\u0445 \u0440\u0443\u0431\u043b\u0456\u0432"}, Gender.FEMININE, new String[]{"\u043a\u043e\u043f\u0456\u0439\u043a\u0430", "\u043a\u043e\u043f\u0456\u0439\u043a\u0438", "\u043a\u043e\u043f\u0456\u0439\u043e\u043a"}));
        currencies.put("SEK", new CurrencyData(Gender.FEMININE, new String[]{"\u0448\u0432\u0435\u0434\u0441\u044c\u043a\u0430 \u043a\u0440\u043e\u043d\u0430", "\u0448\u0432\u0435\u0434\u0441\u044c\u043a\u0438\u0445 \u043a\u0440\u043e\u043d\u0438", "\u0448\u0432\u0435\u0434\u0441\u044c\u043a\u0438\u0445 \u043a\u0440\u043e\u043d"}, Gender.MASCULINE, new String[]{"\u0435\u0440\u0456", "\u0435\u0440\u0456", "\u0435\u0440\u0456"}));
        currencies.put("SIT", new CurrencyData(Gender.MASCULINE, new String[]{"\u0441\u043b\u043e\u0432\u0435\u043d\u0441\u044c\u043a\u0438\u0439 \u0442\u043e\u043b\u0430\u0440", "\u0441\u043b\u043e\u0432\u0435\u043d\u0441\u044c\u043a\u0438\u0445 \u0442\u043e\u043b\u0430\u0440\u0430", "\u0441\u043b\u043e\u0432\u0435\u043d\u0441\u044c\u043a\u0438\u0445 \u0442\u043e\u043b\u0430\u0440\u0456\u0432"}, Gender.FEMININE, new String[]{"\u0441\u0442\u043e\u0442\u0456\u043d\u0430", "\u0441\u0442\u043e\u0442\u0456\u043d\u0438", "\u0441\u0442\u043e\u0442\u0456\u043d"}));
        currencies.put("SKK", new CurrencyData(Gender.FEMININE, new String[]{"\u0441\u043b\u043e\u0432\u0430\u0446\u044c\u043a\u0430 \u043a\u0440\u043e\u043d\u0430", "\u0441\u043b\u043e\u0432\u0430\u0446\u044c\u043a\u0438\u0445 \u043a\u0440\u043e\u043d\u0438", "\u0441\u043b\u043e\u0432\u0430\u0446\u044c\u043a\u0438\u0445 \u043a\u0440\u043e\u043d"}, Gender.NEUTER, new String[]{"\u0433\u0435\u043b\u043b\u0435\u0440", "\u0433\u0435\u043b\u0435\u0440\u0438", "\u0433\u0435\u043b\u043b\u0435\u0440\u0456\u0432"}));
        currencies.put("TRY", new CurrencyData(Gender.FEMININE, new String[]{"\u0442\u0443\u0440\u0435\u0446\u044c\u043a\u0430 \u043b\u0456\u0440\u0430", "\u0442\u0443\u0440\u0435\u0446\u044c\u043a\u0438\u0445 \u043b\u0456\u0440\u0438", "\u0442\u0443\u0440\u0435\u0446\u044c\u043a\u0438\u0445 \u043b\u0456\u0440"}, Gender.MASCULINE, new String[]{"\u043f\u0456\u0430\u0441\u0442\u0440", "\u043f\u0456\u0430\u0441\u0442\u0440\u0430", "\u043f\u0456\u0430\u0441\u0442\u0440\u0456\u0432"}));
        currencies.put("UAH", new CurrencyData(Gender.FEMININE, new String[]{"\u0433\u0440\u0438\u0432\u043d\u044f", "\u0433\u0440\u0438\u0432\u043d\u0456", "\u0433\u0440\u0438\u0432\u0435\u043d\u044c"}, Gender.FEMININE, new String[]{"\u043a\u043e\u043f\u0456\u0439\u043a\u0430", "\u043a\u043e\u043f\u0456\u0439\u043a\u0438", "\u043a\u043e\u043f\u0456\u0439\u043e\u043a"}));
        currencies.put("USD", new CurrencyData(Gender.MASCULINE, new String[]{"\u0434\u043e\u043b\u0430\u0440 \u0421\u0428\u0410", "\u0434\u043e\u043b\u0430\u0440\u0430 \u0421\u0428\u0410", "\u0434\u043e\u043b\u0430\u0440\u0456\u0432 \u0421\u0428\u0410"}, Gender.MASCULINE, new String[]{"\u0446\u0435\u043d\u0442", "\u0446\u0435\u043d\u0442\u0430", "\u0446\u0435\u043d\u0442\u0456\u0432"}));
        currencies.put("YUM", new CurrencyData(Gender.MASCULINE, new String[]{"\u044e\u0433\u043e\u0441\u043b\u0430\u0432\u0441\u044c\u043a\u0438\u0439 \u0434\u0438\u043d\u0430\u0440", "\u044e\u0433\u043e\u0441\u043b\u0430\u0432\u0441\u044c\u043a\u0438\u0445 \u0434\u0438\u043d\u0430\u0440\u0430", "\u044e\u0433\u043e\u0441\u043b\u0430\u0432\u0441\u044c\u043a\u0438\u0445 \u0434\u0438\u043d\u0430\u0440\u0456\u0432"}, Gender.MASCULINE, new String[]{"\u043f\u0430\u0440\u0430", "\u043f\u0430\u0440\u0430", "\u043f\u0430\u0440\u0430"}));
        currencies.put("ZAR", new CurrencyData(Gender.MASCULINE, new String[]{"\u0440\u0430\u043d\u0434", "\u0440\u0430\u043d\u0434\u0430", "\u0440\u0430\u043d\u0434\u0456\u0432"}, Gender.MASCULINE, new String[]{"\u0446\u0435\u043d\u0442", "\u0446\u0435\u043d\u0442\u0430", "\u0446\u0435\u043d\u0442\u0456\u0432"}));
        currencies.put("KZT", new CurrencyData(Gender.MASCULINE, new String[]{"\u0442\u0435\u043d\u0433\u0435", "\u0442\u0435\u043d\u0433\u0435", "\u0442\u0435\u043d\u0433\u0435"}, Gender.MASCULINE, new String[]{"\u0442\u0456\u0438\u043d", "\u0442\u0456\u0438\u043d", "\u0442\u0456\u0438\u043d"}));
    }

    private static enum Declension {
        FIRST,
        SECOND,
        THIRD;

    }

    private static enum Gender {
        NEUTER,
        MASCULINE,
        FEMININE;

    }

    private static class CurrencyData {
        public final Gender decimalGender;
        public final Map<Declension, String> decimalNames = new HashMap<Declension, String>();
        public final Gender fractionGender;
        public final Map<Declension, String> fractionNames = new HashMap<Declension, String>();

        public CurrencyData(Gender decimalGender, String[] decimalNames, Gender fractionGender, String[] fractionNames) {
            this.decimalGender = decimalGender;
            this.decimalNames.put(Declension.FIRST, decimalNames[0]);
            this.decimalNames.put(Declension.SECOND, decimalNames[1]);
            this.decimalNames.put(Declension.THIRD, decimalNames[2]);
            this.fractionGender = fractionGender;
            this.fractionNames.put(Declension.FIRST, fractionNames[0]);
            this.fractionNames.put(Declension.SECOND, fractionNames[1]);
            this.fractionNames.put(Declension.THIRD, fractionNames[2]);
        }
    }

    private static class WordsData {
        public final String words;
        public final Declension declension;

        public WordsData(String words, Declension declension) {
            this.words = words;
            this.declension = declension;
        }
    }
}

