/*
 * Decompiled with CFR 0.152.
 */
package com.idrsolutions.image.jpeg;

import com.idrsolutions.image.jpeg.AdobeHolder;
import com.idrsolutions.image.jpeg.Component;
import com.idrsolutions.image.jpeg.DCT;
import com.idrsolutions.image.jpeg.Frame;
import com.idrsolutions.image.jpeg.Info;
import com.idrsolutions.image.jpeg.JFIFHolder;
import com.idrsolutions.image.jpeg.JpegHuffman;
import com.idrsolutions.image.jpeg.JpegLUT;
import com.idrsolutions.image.jpeg.JpegScanner;
import com.idrsolutions.image.jpeg2000.EnumeratedSpace;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferInt;
import java.util.ArrayList;
import java.util.HashMap;

public class JpegDecoder {
    private int offset;
    private byte[] data;
    private boolean cmykInverted = true;
    private final HashMap<Integer, int[]> qTables = new HashMap();
    private Info info;

    public BufferedImage read(byte[] byArray) throws Exception {
        this.info = new Info();
        this.updateJpegInfo(byArray);
        Object[] objectArray = JpegDecoder.decodeSampling(this.info);
        return this.getBufferdImageFromInfo(this.info, objectArray);
    }

    public byte[] readComponentsAsRawBytes(byte[] byArray) throws Exception {
        this.info = new Info();
        this.updateJpegInfo(byArray);
        Object[] objectArray = JpegDecoder.decodeSampling(this.info);
        return JpegDecoder.getBytesArrayFromInfo(this.info, objectArray);
    }

    public byte[] readComponentsAsConvertedBytes(byte[] byArray) throws Exception {
        this.info = new Info();
        this.updateJpegInfo(byArray);
        Object[] objectArray = JpegDecoder.decodeSampling(this.info);
        return this.getConvertedBytesFromInfo(this.info, objectArray);
    }

    private static Object[] decodeSampling(Info info) {
        int n;
        int n2;
        int n3;
        int n4;
        Component component;
        int n5;
        int n6 = info.nComp;
        int n7 = info.maxH;
        int n8 = info.maxV;
        Object[] objectArray = new Object[n6];
        int n9 = 0;
        int n10 = 0;
        for (n5 = 0; n5 < n6; ++n5) {
            component = info.frame.components.get(n5);
            n4 = component.blocksX + 1;
            n3 = component.blocksY + 1;
            n2 = n4 << 3;
            n = n3 << 3;
            n9 = Math.max(n2, n9);
            n10 = Math.max(n, n10);
        }
        info.maxLineX = n9;
        for (n5 = 0; n5 < n6; ++n5) {
            int n11;
            int n12;
            int n13;
            component = info.frame.components.get(n5);
            n4 = n8 / component.v;
            n3 = n7 / component.h;
            n2 = component.blocksX + 1;
            n = component.blocksY + 1;
            int n14 = n2 << 3;
            int n15 = n << 3;
            int[] nArray = component.codeBlock;
            byte[] byArray = new byte[n10 * n9];
            int n16 = 0;
            if (n4 == 1 && n3 == 1) {
                for (int i = 0; i < n; ++i) {
                    for (int j = 0; j < n2; ++j) {
                        n13 = j + i * n14 << 3;
                        for (n12 = 0; n12 < 8; ++n12) {
                            for (n11 = 0; n11 < 8; ++n11) {
                                byArray[n13 + n11] = (byte)nArray[n16++];
                            }
                            n13 += n14;
                        }
                    }
                }
            } else {
                int n17;
                byte[] byArray2 = new byte[n14 * n15];
                for (int i = 0; i < n; ++i) {
                    for (n12 = 0; n12 < n2; ++n12) {
                        n13 = n12 + i * n14 << 3;
                        for (n11 = 0; n11 < 8; ++n11) {
                            for (n17 = 0; n17 < 8; ++n17) {
                                byArray2[n13 + n17] = (byte)nArray[n16++];
                            }
                            n13 += n14;
                        }
                    }
                }
                n16 = 0;
                int n18 = 0;
                byte[] byArray3 = new byte[n14 * n3];
                for (n12 = 0; n12 < n15; ++n12) {
                    int n19 = 0;
                    for (n11 = 0; n11 < n14; ++n11) {
                        byte by = byArray2[n16++];
                        for (n17 = 0; n17 < n3; ++n17) {
                            byArray3[n19++] = by;
                        }
                    }
                    for (n11 = 0; n11 < n4; ++n11) {
                        if (n18 + n9 >= byArray.length) continue;
                        System.arraycopy(byArray3, 0, byArray, n18, n9);
                        n18 += n9;
                    }
                }
            }
            objectArray[n5] = byArray;
        }
        info.frame.components.clear();
        return objectArray;
    }

    private static byte[] getBytesArrayFromInfo(Info info, Object[] objectArray) {
        byte[] byArray = null;
        int n = 0;
        int n2 = info.maxLineX;
        switch (info.nComp) {
            case 1: {
                byte[] byArray2 = (byte[])objectArray[0];
                byArray = new byte[info.height * info.width];
                for (int i = 0; i < info.height; ++i) {
                    int n3 = i * n2;
                    for (int j = 0; j < info.width; ++j) {
                        byArray[n++] = byArray2[n3++];
                    }
                }
                break;
            }
            case 2: {
                byte[] byArray3 = (byte[])objectArray[0];
                byte[] byArray4 = (byte[])objectArray[1];
                byArray = new byte[info.height * info.width * 2];
                for (int i = 0; i < info.height; ++i) {
                    int n4 = i * n2;
                    for (int j = 0; j < info.width; ++j) {
                        byArray[n++] = byArray3[n4];
                        byArray[n++] = byArray4[n4];
                        ++n4;
                    }
                }
                break;
            }
            case 3: {
                byte[] byArray5 = (byte[])objectArray[0];
                byte[] byArray6 = (byte[])objectArray[1];
                byte[] byArray7 = (byte[])objectArray[2];
                byArray = new byte[info.height * info.width * 3];
                for (int i = 0; i < info.height; ++i) {
                    int n5 = i * n2;
                    for (int j = 0; j < info.width; ++j) {
                        byArray[n++] = byArray5[n5];
                        byArray[n++] = byArray6[n5];
                        byArray[n++] = byArray7[n5];
                        ++n5;
                    }
                }
                break;
            }
            case 4: {
                byte[] byArray8 = (byte[])objectArray[0];
                byte[] byArray9 = (byte[])objectArray[1];
                byte[] byArray10 = (byte[])objectArray[2];
                byte[] byArray11 = (byte[])objectArray[3];
                byArray = new byte[info.height * info.width * 4];
                for (int i = 0; i < info.height; ++i) {
                    int n6 = i * n2;
                    for (int j = 0; j < info.width; ++j) {
                        byArray[n++] = byArray8[n6];
                        byArray[n++] = byArray9[n6];
                        byArray[n++] = byArray10[n6];
                        byArray[n++] = byArray11[n6];
                        ++n6;
                    }
                }
                break;
            }
        }
        return byArray;
    }

    private byte[] getConvertedBytesFromInfo(Info info, Object[] objectArray) {
        byte[] byArray = null;
        int n = 0;
        int n2 = info.maxLineX;
        switch (info.nComp) {
            case 1: {
                byArray = new byte[info.width * info.height];
                byte[] byArray2 = (byte[])objectArray[0];
                for (int i = 0; i < info.height; ++i) {
                    int n3 = i * n2;
                    for (int j = 0; j < info.width; ++j) {
                        byArray[n++] = byArray2[n3++];
                    }
                }
                break;
            }
            case 2: {
                System.out.println("two color component jpegs not supported yet");
                break;
            }
            case 3: {
                byArray = new byte[info.width * info.height * 3];
                byte[] byArray3 = (byte[])objectArray[0];
                byte[] byArray4 = (byte[])objectArray[1];
                byte[] byArray5 = (byte[])objectArray[2];
                if (info.adobe != null && info.adobe.transformCode == 0) {
                    for (int i = 0; i < info.height; ++i) {
                        int n4 = i * n2;
                        for (int j = 0; j < info.width; ++j) {
                            int n5 = byArray3[n4] & 0xFF;
                            int n6 = byArray4[n4] & 0xFF;
                            int n7 = byArray5[n4] & 0xFF;
                            int n8 = n5 < 0 ? 0 : (n5 = n5 > 255 ? 255 : n5);
                            int n9 = n6 < 0 ? 0 : (n6 = n6 > 255 ? 255 : n6);
                            n7 = n7 < 0 ? 0 : (n7 > 255 ? 255 : n7);
                            byArray[n++] = (byte)n5;
                            byArray[n++] = (byte)n6;
                            byArray[n++] = (byte)n7;
                            ++n4;
                        }
                    }
                } else {
                    for (int i = 0; i < info.height; ++i) {
                        int n10 = i * n2;
                        for (int j = 0; j < info.width; ++j) {
                            int n11 = byArray3[n10] & 0xFF;
                            int n12 = byArray4[n10] & 0xFF;
                            int n13 = byArray5[n10] & 0xFF;
                            int n14 = (n12 -= 128) >> 2;
                            int n15 = ((n13 -= 128) >> 3) + (n13 >> 5);
                            int n16 = n11 + n13 + (n13 >> 2) + n15;
                            int n17 = n11 - (n14 + (n12 >> 4) + (n12 >> 5)) - ((n13 >> 1) + n15 + (n13 >> 4));
                            int n18 = n11 + n12 + (n12 >> 1) + n14 + (n12 >> 6);
                            int n19 = n16 < 0 ? 0 : (n16 = n16 > 255 ? 255 : n16);
                            int n20 = n17 < 0 ? 0 : (n17 = n17 > 255 ? 255 : n17);
                            n18 = n18 < 0 ? 0 : (n18 > 255 ? 255 : n18);
                            byArray[n++] = (byte)n16;
                            byArray[n++] = (byte)n17;
                            byArray[n++] = (byte)n18;
                            ++n10;
                        }
                    }
                }
                break;
            }
            case 4: {
                byArray = new byte[info.width * info.height * 3];
                byte[] byArray6 = (byte[])objectArray[0];
                byte[] byArray7 = (byte[])objectArray[1];
                byte[] byArray8 = (byte[])objectArray[2];
                byte[] byArray9 = (byte[])objectArray[3];
                EnumeratedSpace enumeratedSpace = new EnumeratedSpace();
                if (info.adobe.transformCode == 0) {
                    if (this.cmykInverted) {
                        for (int i = 0; i < info.height; ++i) {
                            int n21 = i * n2;
                            for (int j = 0; j < info.width; ++j) {
                                int n22 = 255 - (byArray6[n21] & 0xFF);
                                int n23 = 255 - (byArray7[n21] & 0xFF);
                                int n24 = 255 - (byArray8[n21] & 0xFF);
                                int n25 = 255 - (byArray9[n21] & 0xFF);
                                byte[] byArray10 = enumeratedSpace.getRGB((byte)n22, (byte)n23, (byte)n24, (byte)n25);
                                byArray[n++] = byArray10[0];
                                byArray[n++] = byArray10[1];
                                byArray[n++] = byArray10[2];
                                ++n21;
                            }
                        }
                    } else {
                        for (int i = 0; i < info.height; ++i) {
                            int n26 = i * n2;
                            for (int j = 0; j < info.width; ++j) {
                                int n27 = byArray6[n26] & 0xFF;
                                int n28 = byArray7[n26] & 0xFF;
                                int n29 = byArray8[n26] & 0xFF;
                                int n30 = byArray9[n26] & 0xFF;
                                byte[] byArray11 = enumeratedSpace.getRGB((byte)n27, (byte)n28, (byte)n29, (byte)n30);
                                byArray[n++] = byArray11[0];
                                byArray[n++] = byArray11[1];
                                byArray[n++] = byArray11[2];
                                ++n26;
                            }
                        }
                    }
                } else if (this.cmykInverted) {
                    for (int i = 0; i < info.height; ++i) {
                        int n31 = i * n2;
                        for (int j = 0; j < info.width; ++j) {
                            int n32;
                            int n33;
                            int n34 = 255 - (byArray6[n31] & 0xFF);
                            int n35 = 255 - (byArray7[n31] & 0xFF);
                            int n36 = 255 - (byArray8[n31] & 0xFF);
                            int n37 = 255 - (byArray9[n31] & 0xFF);
                            double d = 434.456 - (double)n34 - 1.402 * (double)n36;
                            double d2 = 119.541 - (double)n34 + 0.344 * (double)n35 + 0.714 * (double)n36;
                            double d3 = 481.816 - (double)n34 - 1.772 * (double)n35;
                            int n38 = d < 0.0 ? 0 : (n33 = d > 255.0 ? 255 : (int)d);
                            int n39 = d2 < 0.0 ? 0 : (n32 = d2 > 255.0 ? 255 : (int)d2);
                            n34 = d3 < 0.0 ? 0 : (d3 > 255.0 ? 255 : (int)d3);
                            byte[] byArray12 = enumeratedSpace.getRGB((byte)n33, (byte)n32, (byte)n34, (byte)n37);
                            byArray[n++] = byArray12[0];
                            byArray[n++] = byArray12[1];
                            byArray[n++] = byArray12[2];
                            ++n31;
                        }
                    }
                } else {
                    for (int i = 0; i < info.height; ++i) {
                        int n40 = i * n2;
                        for (int j = 0; j < info.width; ++j) {
                            int n41;
                            int n42;
                            int n43 = byArray6[n40] & 0xFF;
                            int n44 = byArray7[n40] & 0xFF;
                            int n45 = byArray8[n40] & 0xFF;
                            int n46 = byArray9[n40] & 0xFF;
                            double d = 434.456 - (double)n43 - 1.402 * (double)n45;
                            double d4 = 119.541 - (double)n43 + 0.344 * (double)n44 + 0.714 * (double)n45;
                            double d5 = 481.816 - (double)n43 - 1.772 * (double)n44;
                            int n47 = d < 0.0 ? 0 : (n42 = d > 255.0 ? 255 : (int)d);
                            int n48 = d4 < 0.0 ? 0 : (n41 = d4 > 255.0 ? 255 : (int)d4);
                            n43 = d5 < 0.0 ? 0 : (d5 > 255.0 ? 255 : (int)d5);
                            byte[] byArray13 = enumeratedSpace.getRGB((byte)n42, (byte)n41, (byte)n43, (byte)n46);
                            byArray[n++] = byArray13[0];
                            byArray[n++] = byArray13[1];
                            byArray[n++] = byArray13[2];
                            ++n40;
                        }
                    }
                }
                break;
            }
        }
        return byArray;
    }

    private BufferedImage getBufferdImageFromInfo(Info info, Object[] objectArray) {
        BufferedImage bufferedImage = null;
        int n = 0;
        int n2 = info.maxLineX;
        switch (info.nComp) {
            case 1: {
                bufferedImage = new BufferedImage(info.width, info.height, 10);
                byte[] byArray = ((DataBufferByte)bufferedImage.getRaster().getDataBuffer()).getData();
                byte[] byArray2 = (byte[])objectArray[0];
                for (int i = 0; i < info.height; ++i) {
                    int n3 = i * n2;
                    for (int j = 0; j < info.width; ++j) {
                        byArray[n++] = byArray2[n3++];
                    }
                }
                break;
            }
            case 2: {
                System.out.println("two color component jpegs not supported yet");
                break;
            }
            case 3: {
                bufferedImage = new BufferedImage(info.width, info.height, 1);
                int[] nArray = ((DataBufferInt)bufferedImage.getRaster().getDataBuffer()).getData();
                byte[] byArray = (byte[])objectArray[0];
                byte[] byArray3 = (byte[])objectArray[1];
                byte[] byArray4 = (byte[])objectArray[2];
                if (info.adobe != null && info.adobe.transformCode == 0) {
                    for (int i = 0; i < info.height; ++i) {
                        int n4 = i * n2;
                        for (int j = 0; j < info.width; ++j) {
                            int n5 = byArray[n4] & 0xFF;
                            int n6 = byArray3[n4] & 0xFF;
                            int n7 = byArray4[n4] & 0xFF;
                            int n8 = n5 < 0 ? 0 : (n5 = n5 > 255 ? 255 : n5);
                            int n9 = n6 < 0 ? 0 : (n6 = n6 > 255 ? 255 : n6);
                            n7 = n7 < 0 ? 0 : (n7 > 255 ? 255 : n7);
                            nArray[n++] = n5 << 16 | n6 << 8 | n7;
                            ++n4;
                        }
                    }
                } else {
                    for (int i = 0; i < info.height; ++i) {
                        int n10 = i * n2;
                        for (int j = 0; j < info.width; ++j) {
                            int n11 = byArray[n10] & 0xFF;
                            int n12 = byArray3[n10] & 0xFF;
                            int n13 = byArray4[n10] & 0xFF;
                            n11 = (n11 << 8) + 128;
                            int n14 = n11 + 359 * (n13 -= 128) >> 8;
                            int n15 = n11 - 88 * (n12 -= 128) - 183 * n13 >> 8;
                            int n16 = n11 + 454 * n12 >> 8;
                            int n17 = n14 < 0 ? 0 : (n14 = n14 > 255 ? 255 : n14);
                            int n18 = n15 < 0 ? 0 : (n15 = n15 > 255 ? 255 : n15);
                            n16 = n16 < 0 ? 0 : (n16 > 255 ? 255 : n16);
                            nArray[n++] = n14 << 16 | n15 << 8 | n16;
                            ++n10;
                        }
                    }
                }
                break;
            }
            case 4: {
                bufferedImage = new BufferedImage(info.width, info.height, 1);
                int[] nArray = ((DataBufferInt)bufferedImage.getRaster().getDataBuffer()).getData();
                byte[] byArray = (byte[])objectArray[0];
                byte[] byArray5 = (byte[])objectArray[1];
                byte[] byArray6 = (byte[])objectArray[2];
                byte[] byArray7 = (byte[])objectArray[3];
                EnumeratedSpace enumeratedSpace = new EnumeratedSpace();
                if (info.adobe.transformCode == 0) {
                    if (this.cmykInverted) {
                        for (int i = 0; i < info.height; ++i) {
                            int n19 = i * n2;
                            for (int j = 0; j < info.width; ++j) {
                                int n20 = 255 - (byArray[n19] & 0xFF);
                                int n21 = 255 - (byArray5[n19] & 0xFF);
                                int n22 = 255 - (byArray6[n19] & 0xFF);
                                int n23 = 255 - (byArray7[n19] & 0xFF);
                                byte[] byArray8 = enumeratedSpace.getRGB((byte)n20, (byte)n21, (byte)n22, (byte)n23);
                                int n24 = byArray8[0] & 0xFF;
                                int n25 = byArray8[1] & 0xFF;
                                int n26 = byArray8[2] & 0xFF;
                                nArray[n++] = n24 << 16 | n25 << 8 | n26;
                                ++n19;
                            }
                        }
                    } else {
                        for (int i = 0; i < info.height; ++i) {
                            int n27 = i * n2;
                            for (int j = 0; j < info.width; ++j) {
                                int n28 = byArray[n27] & 0xFF;
                                int n29 = byArray5[n27] & 0xFF;
                                int n30 = byArray6[n27] & 0xFF;
                                int n31 = byArray7[n27] & 0xFF;
                                byte[] byArray9 = enumeratedSpace.getRGB((byte)n28, (byte)n29, (byte)n30, (byte)n31);
                                int n32 = byArray9[0] & 0xFF;
                                int n33 = byArray9[1] & 0xFF;
                                int n34 = byArray9[2] & 0xFF;
                                nArray[n++] = n32 << 16 | n33 << 8 | n34;
                                ++n27;
                            }
                        }
                    }
                } else if (this.cmykInverted) {
                    for (int i = 0; i < info.height; ++i) {
                        int n35 = i * n2;
                        for (int j = 0; j < info.width; ++j) {
                            int n36;
                            int n37;
                            int n38 = 255 - (byArray[n35] & 0xFF);
                            int n39 = 255 - (byArray5[n35] & 0xFF);
                            int n40 = 255 - (byArray6[n35] & 0xFF);
                            int n41 = 255 - (byArray7[n35] & 0xFF);
                            double d = 434.456 - (double)n38 - 1.402 * (double)n40;
                            double d2 = 119.541 - (double)n38 + 0.344 * (double)n39 + 0.714 * (double)n40;
                            double d3 = 481.816 - (double)n38 - 1.772 * (double)n39;
                            int n42 = d < 0.0 ? 0 : (n37 = d > 255.0 ? 255 : (int)d);
                            int n43 = d2 < 0.0 ? 0 : (n36 = d2 > 255.0 ? 255 : (int)d2);
                            n38 = d3 < 0.0 ? 0 : (d3 > 255.0 ? 255 : (int)d3);
                            byte[] byArray10 = enumeratedSpace.getRGB((byte)n37, (byte)n36, (byte)n38, (byte)n41);
                            int n44 = byArray10[0] & 0xFF;
                            int n45 = byArray10[1] & 0xFF;
                            int n46 = byArray10[2] & 0xFF;
                            nArray[n++] = n44 << 16 | n45 << 8 | n46;
                            ++n35;
                        }
                    }
                } else {
                    for (int i = 0; i < info.height; ++i) {
                        int n47 = i * n2;
                        for (int j = 0; j < info.width; ++j) {
                            int n48;
                            int n49;
                            int n50 = byArray[n47] & 0xFF;
                            int n51 = byArray5[n47] & 0xFF;
                            int n52 = byArray6[n47] & 0xFF;
                            int n53 = byArray7[n47] & 0xFF;
                            double d = 434.456 - (double)n50 - 1.402 * (double)n52;
                            double d4 = 119.541 - (double)n50 + 0.344 * (double)n51 + 0.714 * (double)n52;
                            double d5 = 481.816 - (double)n50 - 1.772 * (double)n51;
                            int n54 = d < 0.0 ? 0 : (n49 = d > 255.0 ? 255 : (int)d);
                            int n55 = d4 < 0.0 ? 0 : (n48 = d4 > 255.0 ? 255 : (int)d4);
                            n50 = d5 < 0.0 ? 0 : (d5 > 255.0 ? 255 : (int)d5);
                            byte[] byArray11 = enumeratedSpace.getRGB((byte)n49, (byte)n48, (byte)n50, (byte)n53);
                            int n56 = byArray11[0] & 0xFF;
                            int n57 = byArray11[1] & 0xFF;
                            int n58 = byArray11[2] & 0xFF;
                            nArray[n++] = n56 << 16 | n57 << 8 | n58;
                            ++n47;
                        }
                    }
                }
                break;
            }
        }
        return bufferedImage;
    }

    private void updateJpegInfo(byte[] byArray) throws Exception {
        Object object;
        this.data = byArray;
        int n = byArray.length;
        int n2 = 0;
        Frame frame = new Frame();
        if (this.readUShort() != 65496) {
            throw new Exception("This File is not a valid JPEG");
        }
        Object[] objectArray = new Object[10];
        Object[] objectArray2 = new Object[10];
        int n3 = this.readUShort();
        while (n3 != 65497 && this.offset < n) {
            switch (n3) {
                case 65504: 
                case 65505: 
                case 65506: 
                case 65507: 
                case 65508: 
                case 65509: 
                case 65510: 
                case 65511: 
                case 65512: 
                case 65513: 
                case 65514: 
                case 65515: 
                case 65516: 
                case 65517: 
                case 65518: 
                case 65519: {
                    object = this.readDataArray();
                    if (n3 == 65504 && JpegDecoder.isJFIF((byte[])object)) {
                        JFIFHolder jFIFHolder = new JFIFHolder();
                        jFIFHolder.majorNo = object[5] & 0xFF;
                        jFIFHolder.minorNo = object[6] & 0xFF;
                        jFIFHolder.xDensity = (object[8] & 0xFF) << 8 | object[9] & 0xFF;
                        jFIFHolder.yDensity = (object[10] & 0xFF) << 8 | object[11] & 0xFF;
                        jFIFHolder.thumbnailWidth = object[12] & 0xFF;
                        jFIFHolder.thumbnailHeight = object[13] & 0xFF;
                        this.info.jfif = jFIFHolder;
                        break;
                    }
                    if (n3 != 65518 || !JpegDecoder.isAdobe((byte[])object)) break;
                    AdobeHolder adobeHolder = new AdobeHolder();
                    adobeHolder.version = object[6] & 0xFF;
                    adobeHolder.flag0 = object[7] & 0xFF00 | object[8] & 0xFF;
                    adobeHolder.flag1 = object[9] & 0xFF00 | object[10] & 0xFF;
                    adobeHolder.transformCode = object[11] & 0xFF;
                    this.info.adobe = adobeHolder;
                    break;
                }
                case 65472: 
                case 65473: 
                case 65474: {
                    int n4;
                    int n5;
                    int n6;
                    int n7;
                    this.offset += 2;
                    frame.baseline = n3 == 65472;
                    frame.extended = n3 == 65473;
                    frame.progressive = n3 == 65474;
                    frame.precision = byArray[this.offset++] & 0xFF;
                    frame.scanV = this.readUShort();
                    frame.scanH = this.readUShort();
                    int n8 = byArray[this.offset++] & 0xFF;
                    int n9 = 0;
                    int n10 = 0;
                    for (n7 = 0; n7 < n8; ++n7) {
                        int n11 = byArray[this.offset] & 0xFF;
                        n6 = byArray[this.offset + 1] & 0xFF;
                        n5 = n6 >> 4;
                        n4 = n6 & 0xF;
                        if (n9 < n5) {
                            n9 = n5;
                        }
                        if (n10 < n4) {
                            n10 = n4;
                        }
                        int n12 = byArray[this.offset + 2] & 0xFF;
                        Component component = new Component();
                        component.h = n5;
                        component.v = n4;
                        component.qTable = this.qTables.get(n12);
                        frame.components.add(component);
                        frame.componentID.put(n11, frame.components.size() - 1);
                        this.offset += 3;
                    }
                    frame.maxH = n9;
                    frame.maxV = n10;
                    JpegDecoder.initializeComponents(frame);
                    break;
                }
                case 65475: 
                case 65477: 
                case 65478: 
                case 65479: {
                    throw new Exception("Lossless Jpeg is not supported yet");
                }
                case 65481: 
                case 65482: 
                case 65483: {
                    throw new Exception("Arithmetic encoded Jpeg is not supported yet");
                }
                case 65499: {
                    int n4;
                    int n5;
                    int n7 = this.readUShort();
                    int n6 = n7 + this.offset - 2;
                    while (this.offset < n6) {
                        int n13;
                        n4 = byArray[this.offset++] & 0xFF;
                        int[] nArray = new int[64];
                        if (n4 >> 4 == 0) {
                            for (n13 = 0; n13 < 64; ++n13) {
                                n5 = JpegLUT.ZIGZAGORDER[n13];
                                nArray[n5] = byArray[this.offset++] & 0xFF;
                            }
                        } else if (n4 >> 4 == 1) {
                            for (n13 = 0; n13 < 64; ++n13) {
                                n5 = JpegLUT.ZIGZAGORDER[n13];
                                nArray[n5] = this.readUShort();
                            }
                        }
                        this.qTables.put(n4 & 0xF, nArray);
                    }
                    break;
                }
                case 65476: {
                    int n14;
                    int n15;
                    int n4 = this.readUShort();
                    for (n14 = 2; n14 < n4; n14 += 17 + n15) {
                        int n16 = byArray[this.offset++] & 0xFF;
                        int[] nArray = new int[16];
                        n15 = 0;
                        for (int i = 0; i < 16; ++i) {
                            nArray[i] = byArray[this.offset] & 0xFF;
                            n15 += nArray[i];
                            ++this.offset;
                        }
                        int[] nArray2 = new int[n15];
                        int n17 = 0;
                        while (n17 < n15) {
                            nArray2[n17] = byArray[this.offset] & 0xFF;
                            ++n17;
                            ++this.offset;
                        }
                        if (n16 >> 4 == 0) {
                            objectArray2[n16 & 0xF] = JpegHuffman.generateHuffmanTable(nArray, nArray2);
                            continue;
                        }
                        objectArray[n16 & 0xF] = JpegHuffman.generateHuffmanTable(nArray, nArray2);
                    }
                    break;
                }
                case 65501: {
                    this.offset += 2;
                    n2 = this.readUShort();
                    break;
                }
                case 65498: {
                    int n18;
                    int n15;
                    this.offset += 2;
                    int n14 = byArray[this.offset++] & 0xFF;
                    ArrayList<Component> arrayList = new ArrayList<Component>();
                    for (n18 = 0; n18 < n14; ++n18) {
                        n15 = frame.componentID.get(byArray[this.offset++] & 0xFF);
                        Component component = frame.components.get(n15);
                        int n19 = byArray[this.offset++] & 0xFF;
                        component.huffmanTableDC = objectArray2[n19 >> 4];
                        component.huffmanTableAC = objectArray[n19 & 0xF];
                        arrayList.add(component);
                    }
                    n18 = byArray[this.offset++] & 0xFF;
                    n15 = byArray[this.offset++] & 0xFF;
                    int n20 = byArray[this.offset++] & 0xFF;
                    JpegScanner jpegScanner = new JpegScanner(byArray);
                    int n21 = jpegScanner.decodeScan(this.offset, frame, arrayList, n2, n18, n15, n20 >> 4, n20 & 0xF);
                    this.offset += n21;
                    break;
                }
                case 65534: {
                    this.readDataArray();
                    break;
                }
                default: {
                    System.err.println("Invalid jpeg marker found");
                    int n22 = this.readUShort();
                    this.offset += n22 - 2;
                }
            }
            n3 = this.readUShort();
        }
        this.info.width = frame.scanH;
        this.info.height = frame.scanV;
        object = frame.components.iterator();
        while (object.hasNext()) {
            Component component = (Component)object.next();
            component.codeBlock = JpegDecoder.buildComponentData(component);
        }
        this.info.maxH = frame.maxH;
        this.info.maxV = frame.maxV;
        this.info.nComp = frame.components.size();
        this.info.frame = frame;
    }

    private int readUShort() {
        int n = (this.data[this.offset] & 0xFF) << 8 | this.data[this.offset + 1] & 0xFF;
        this.offset += 2;
        return n;
    }

    private static boolean isJFIF(byte[] byArray) {
        return (byArray[0] & 0xFF) == 74 && (byArray[1] & 0xFF) == 70 && (byArray[2] & 0xFF) == 73 && (byArray[3] & 0xFF) == 70 && (byArray[4] & 0xFF) == 0;
    }

    private static boolean isAdobe(byte[] byArray) {
        return (byArray[0] & 0xFF) == 65 && (byArray[1] & 0xFF) == 100 && (byArray[2] & 0xFF) == 111 && (byArray[3] & 0xFF) == 98 && (byArray[4] & 0xFF) == 101 && (byArray[5] & 0xFF) == 0;
    }

    private byte[] readDataArray() {
        int n = this.readUShort();
        byte[] byArray = new byte[n - 2];
        System.arraycopy(this.data, this.offset, byArray, 0, byArray.length);
        this.offset += byArray.length;
        return byArray;
    }

    private static void initializeComponents(Frame frame) {
        int n = (int)Math.ceil((double)frame.scanH / 8.0 / (double)frame.maxH);
        int n2 = (int)Math.ceil((double)frame.scanV / 8.0 / (double)frame.maxV);
        for (Component component : frame.components) {
            int n3 = (int)Math.ceil(Math.ceil((double)frame.scanH / 8.0) * (double)component.h / (1.0 * (double)frame.maxH));
            int n4 = (int)Math.ceil(Math.ceil((double)frame.scanV / 8.0) * (double)component.v / (1.0 * (double)frame.maxV));
            int n5 = n * component.h;
            int n6 = n2 * component.v;
            int n7 = 64 * (n6 + 1) * (n5 + 1);
            component.codeBlock = new int[n7];
            component.blocksX = n3;
            component.blocksY = n4;
        }
        frame.mcusX = n;
        frame.mcusY = n2;
    }

    private static int[] buildComponentData(Component component) {
        int n = component.blocksX;
        int n2 = component.blocksY;
        for (int i = 0; i < n2; ++i) {
            for (int j = 0; j < n; ++j) {
                int n3 = JpegScanner.getCodeBlockOffset(component, i, j);
                DCT.IDCTQ(component, n3);
            }
        }
        return component.codeBlock;
    }

    public boolean IsInverted() {
        return this.cmykInverted;
    }

    public void setInverted(boolean bl) {
        this.cmykInverted = bl;
    }

    public Info getInfo() {
        return this.info;
    }
}

