/*
 * Decompiled with CFR 0.152.
 */
package com.idrsolutions.image.png;

public class D4 {
    public final int a;
    public final int r;
    public final int g;
    public final int b;
    public final int argb;

    public D4(int n, int n2, int n3, int n4) {
        this.a = n;
        this.r = n2;
        this.g = n3;
        this.b = n4;
        this.argb = n << 24 | n2 << 16 | n3 << 8 | n4;
    }

    private static int diff(int n, int n2, int n3, int n4, D4 d4) {
        int n5 = n - d4.a;
        int n6 = n2 - d4.r;
        int n7 = n3 - d4.g;
        int n8 = n4 - d4.b;
        return n5 * n5 + n6 * n6 + n7 * n7 + n8 * n8;
    }

    public static int[] findClosest(int n, D4[] d4Array) {
        D4 d4 = d4Array[0];
        int n2 = n >> 24 & 0xFF;
        int n3 = n >> 16 & 0xFF;
        int n4 = n >> 8 & 0xFF;
        int n5 = n & 0xFF;
        int n6 = D4.diff(n2, n3, n4, n5, d4);
        int n7 = 0;
        for (int i = 1; i < 256; ++i) {
            D4 d42 = d4Array[i];
            int n8 = D4.diff(n2, n3, n4, n5, d42);
            if (n8 >= n6) continue;
            d4 = d42;
            n7 = i;
            n6 = n8;
        }
        return new int[]{d4.argb, n7};
    }

    public static byte[] process(byte[] byArray, byte[] byArray2, int[][] nArray, int n, int n2) {
        int n3;
        int n4;
        int n5;
        int n6 = 0;
        D4[] d4Array = new D4[256];
        for (int i = 0; i < 256; ++i) {
            n5 = byArray2[i] & 0xFF;
            n4 = byArray[n6++] & 0xFF;
            n3 = byArray[n6++] & 0xFF;
            int n7 = byArray[n6++] & 0xFF;
            d4Array[i] = new D4(n5, n4, n3, n7);
        }
        byte[] byArray3 = new byte[n * n2];
        n6 = 0;
        for (n5 = 0; n5 < n; ++n5) {
            for (n4 = 0; n4 < n2; ++n4) {
                int n8;
                n3 = nArray[n5][n4];
                int[] nArray2 = D4.findClosest(n3, d4Array);
                int n9 = nArray2[0];
                byArray3[n6++] = (byte)nArray2[1];
                int n10 = n3 >> 24 & 0xFF;
                int n11 = n3 >> 16 & 0xFF;
                int n12 = n3 >> 8 & 0xFF;
                int n13 = n3 & 0xFF;
                int n14 = n9 >> 24 & 0xFF;
                int n15 = n9 >> 16 & 0xFF;
                int n16 = n9 >> 8 & 0xFF;
                int n17 = n9 & 0xFF;
                int n18 = n10 - n14;
                int n19 = n11 - n15;
                int n20 = n12 - n16;
                int n21 = n13 - n17;
                if (n4 + 1 < n2) {
                    nArray[n5][n4 + 1] = n8 = D4.applyFloyd(nArray[n5][n4 + 1], n18, n19, n20, n21, 7);
                    if (n5 + 1 < n) {
                        nArray[n5 + 1][n4 + 1] = n8 = D4.applyFloyd(nArray[n5 + 1][n4 + 1], n18, n19, n20, n21, 1);
                    }
                }
                if (n5 + 1 >= n) continue;
                nArray[n5 + 1][n4] = n8 = D4.applyFloyd(nArray[n5 + 1][n4], n18, n19, n20, n21, 5);
                if (n4 - 1 < 0) continue;
                nArray[n5 + 1][n4 - 1] = n8 = D4.applyFloyd(nArray[n5 + 1][n4 - 1], n18, n19, n20, n21, 3);
            }
        }
        return byArray3;
    }

    private static int applyFloyd(int n, int n2, int n3, int n4, int n5, int n6) {
        int n7 = n >> 24 & 0xFF;
        int n8 = n >> 16 & 0xFF;
        int n9 = n >> 8 & 0xFF;
        int n10 = n & 0xFF;
        n8 += n3 * n6 / 16;
        n9 += n4 * n6 / 16;
        n10 += n5 * n6 / 16;
        if ((n7 += n2 * n6 / 16) < 0) {
            n7 = 0;
        } else if (n7 > 255) {
            n7 = 255;
        }
        if (n8 < 0) {
            n8 = 0;
        } else if (n8 > 255) {
            n8 = 255;
        }
        if (n9 < 0) {
            n9 = 0;
        } else if (n9 > 255) {
            n9 = 255;
        }
        if (n10 < 0) {
            n10 = 0;
        } else if (n10 > 255) {
            n10 = 255;
        }
        return n7 << 24 | n8 << 16 | n9 << 8 | n10;
    }
}

