/*
 * Decompiled with CFR 0.152.
 */
package com.idrsolutions.image.png;

import java.util.BitSet;

public class PngBitReader {
    private int p;
    private final int totalBitLen;
    private BitSet bitset;
    private byte[] data;
    private final boolean hasSmallBits;

    public PngBitReader(byte[] byArray, boolean bl) {
        this.hasSmallBits = bl;
        this.totalBitLen = byArray.length * 8;
        if (this.hasSmallBits) {
            this.bitset = new BitSet(this.totalBitLen);
            int n = 0;
            for (byte by : byArray) {
                for (int i = 7; i >= 0; --i) {
                    boolean bl2 = (by >> i & 1) == 1;
                    this.bitset.set(n, bl2);
                    ++n;
                }
            }
        } else {
            this.data = byArray;
        }
    }

    private int readBits(int n) {
        int n2 = 0;
        if (this.hasSmallBits) {
            BitSet bitSet = this.bitset.get(this.p, this.p + n);
            for (int i = 0; i < n; ++i) {
                if (bitSet.get(i)) {
                    n2 = n2 << 1 | 1;
                    continue;
                }
                n2 <<= 1;
            }
            this.p += n;
        } else {
            int n3 = n / 8;
            for (int i = 0; i < n3; ++i) {
                n2 <<= 8;
                n2 |= this.data[this.p / 8] & 0xFF;
                this.p += 8;
            }
        }
        return n2;
    }

    public int getPositive(int n) {
        return this.readBits(n);
    }

    public int getPointer() {
        return this.p;
    }

    public int getTotalBitLen() {
        return this.totalBitLen;
    }
}

