/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.color;

import com.idrsolutions.image.jpeg2000.EnumeratedSpace;
import java.awt.color.ColorSpace;
import java.awt.color.ICC_ColorSpace;
import java.awt.color.ICC_Profile;
import java.awt.image.BufferedImage;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jpedal.color.GenericColorSpace;
import org.jpedal.color.PdfColor;
import org.jpedal.examples.handlers.DefaultImageHelper;
import org.jpedal.exception.PdfException;
import org.jpedal.objects.raw.PdfObject;
import org.jpedal.utils.LogWriter;

public class DeviceCMYKColorSpace
extends GenericColorSpace {
    private static final long serialVersionUID = 4054062852632000027L;
    private float lastC = -1.0f;
    private float lastM = -1.0f;
    private float lastY = -1.0f;
    private float lastK = -1.0f;
    public static ColorSpace CMYK;

    @Override
    public void clearCache() {
        this.lastC = -1.0f;
    }

    private void initColorspace() {
        InputStream inputStream = null;
        try {
            String string = System.getProperty("org.jpedal.CMYKprofile");
            if (string == null) {
                inputStream = this.getClass().getResourceAsStream("/org/jpedal/res/cmm/cmyk.icm");
            } else {
                try {
                    inputStream = new FileInputStream(string);
                }
                catch (FileNotFoundException fileNotFoundException) {
                    try {
                        throw new PdfException("PdfException attempting to use user profile " + string + " Message=" + fileNotFoundException);
                    }
                    catch (PdfException pdfException) {
                        Logger.getLogger(DeviceCMYKColorSpace.class.getName()).log(Level.SEVERE, null, pdfException);
                    }
                }
            }
            ICC_Profile iCC_Profile = ICC_Profile.getInstance(inputStream);
            CMYK = new ICC_ColorSpace(iCC_Profile);
        }
        catch (IOException iOException) {
            if (LogWriter.isOutput()) {
                LogWriter.writeLog("Exception " + iOException);
            }
            throw new RuntimeException("Problem setting CMYK Colorspace with message " + iOException + " Possible cause file cmyk.icm corrupted");
        }
        finally {
            block18: {
                if (inputStream != null) {
                    try {
                        inputStream.close();
                    }
                    catch (IOException iOException) {
                        if (!LogWriter.isOutput()) break block18;
                        LogWriter.writeLog("Exception " + iOException);
                    }
                }
            }
        }
    }

    public DeviceCMYKColorSpace() {
        this.componentCount = 4;
        if (CMYK == null) {
            this.initColorspace();
        }
        this.cs = CMYK;
        this.setType(1498837125);
    }

    @Override
    public final void setColor(String[] stringArray, int n) {
        float[] fArray = new float[n];
        for (int i = 0; i < n; ++i) {
            fArray[i] = Float.parseFloat(stringArray[i]);
        }
        this.setColor(fArray, n);
    }

    @Override
    public final void setColor(float[] fArray, int n) {
        this.c = 1.0f;
        this.y = 1.0f;
        this.m = 1.0f;
        this.k = 1.0f;
        if (n > 3) {
            this.c = fArray[0];
            this.m = fArray[1];
            this.y = fArray[2];
            this.k = fArray[3];
        } else {
            if (n > 0) {
                this.c = fArray[0];
            }
            if (n > 1) {
                this.m = fArray[1];
            }
            if (n > 2) {
                this.y = fArray[2];
            }
            if (n > 3) {
                this.k = fArray[3];
            }
        }
        if (this.lastC != this.c || this.lastM != this.m || this.lastY != this.y || this.lastK != this.k) {
            this.rawValues = new float[4];
            this.rawValues[0] = this.c;
            this.rawValues[1] = this.m;
            this.rawValues[2] = this.y;
            this.rawValues[3] = this.k;
            this.lastC = this.c;
            this.lastM = this.m;
            this.lastY = this.y;
            this.lastK = this.k;
            int n2 = (int)(this.c * 255.0f);
            int n3 = (int)(this.m * 255.0f);
            int n4 = (int)(this.y * 255.0f);
            int n5 = (int)(this.k * 255.0f);
            int[] nArray = EnumeratedSpace.getStaticRGB(n2, n3, n4, n5);
            this.currentColor = new PdfColor(nArray[0], nArray[1], nArray[2]);
        }
    }

    @Override
    public final BufferedImage JPEGToRGBImage(byte[] byArray, int n, int n2, float[] fArray, int n3, int n4, boolean bl, PdfObject pdfObject) {
        return this.nonRGBJPEGToRGBImage(byArray, n, n2, fArray, n3, n4);
    }

    @Override
    public byte[] dataToRGBByteArray(byte[] byArray, int n, int n2, boolean bl) {
        int n3 = n * n2 * 4;
        int n4 = byArray.length;
        if (n3 > n4) {
            n3 = n4 - 3;
        }
        EnumeratedSpace enumeratedSpace = new EnumeratedSpace();
        byte[] byArray2 = new byte[n * n2 * 3];
        int n5 = 0;
        for (int i = 0; i < n3; i += 4) {
            byte by = byArray[i];
            byte by2 = byArray[i + 1];
            byte by3 = byArray[i + 2];
            byte by4 = byArray[i + 3];
            byte[] byArray3 = enumeratedSpace.getRGB(by, by2, by3, by4);
            byArray2[n5++] = byArray3[0];
            byArray2[n5++] = byArray3[1];
            byArray2[n5++] = byArray3[2];
        }
        return byArray2;
    }

    @Override
    public BufferedImage JPEG2000ToRGBImage(byte[] byArray, int n, int n2, float[] fArray, int n3, int n4, int n5) throws PdfException {
        BufferedImage bufferedImage = DefaultImageHelper.JPEG2000ToRGBImage(byArray, n, n2, fArray, n3, n4);
        if (bufferedImage != null) {
            return bufferedImage;
        }
        return this.JPEG2000ToImage(byArray, n3, n4, fArray);
    }

    @Override
    public final byte[] convertIndexToRGB(byte[] byArray) {
        this.isConverted = true;
        return this.convert4Index(byArray);
    }

    public static ColorSpace getColorSpaceInstance() {
        ColorSpace colorSpace = new DeviceCMYKColorSpace().getColorSpace();
        String string = System.getProperty("org.jpedal.CMYKprofile");
        if (string != null) {
            try {
                colorSpace = new ICC_ColorSpace(ICC_Profile.getInstance(new FileInputStream(string)));
            }
            catch (IOException iOException) {
                throw new RuntimeException("Unable to create CMYK colorspace with  " + string + "\nPlease check Path and file valid or use built-in " + iOException);
            }
        }
        return colorSpace;
    }
}

