/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.examples.acroform;

import java.util.ResourceBundle;
import org.jpedal.PdfDecoderInt;
import org.jpedal.PdfDecoderServer;
import org.jpedal.exception.PdfException;
import org.jpedal.fonts.FontMappings;
import org.jpedal.objects.PdfPageData;
import org.jpedal.objects.acroforms.AcroRenderer;
import org.jpedal.objects.acroforms.ReturnValues;
import org.jpedal.utils.Messages;

public class PdfFormUtilities {
    byte[] byteArray;
    boolean isOpen;
    int maxCount = -1;
    private int lastPage = -1;
    PdfPageData currentPageData;
    String imageType = "png";
    String name = "image";
    String user_dir = System.getProperty("user.dir");
    PdfDecoderInt decode_pdf;
    static final String separator = System.getProperty("file.separator");
    String password;
    String fileName;

    public PdfFormUtilities(String string) {
        this.fileName = string;
        this.init();
    }

    public PdfFormUtilities(byte[] byArray) {
        this.byteArray = byArray;
        this.init();
    }

    public void setPassword(String string) {
        this.password = string;
    }

    void init() {
        FontMappings.setFontReplacements();
        try {
            Messages.setBundle(ResourceBundle.getBundle("org.jpedal.international.messages"));
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.out.println("Exception loading resource bundle");
        }
        this.decode_pdf = new PdfDecoderServer(false);
    }

    void selectPage(int n) throws PdfException {
        if (n != this.lastPage) {
            this.currentPageData = this.decode_pdf.getPdfPageData();
            this.decode_pdf.flushObjectValues(true);
            try {
                this.decode_pdf.decodePage(n);
            }
            catch (Exception exception) {
                throw new PdfException(exception.getMessage());
            }
            this.lastPage = n;
        }
    }

    public int getPageCount() {
        return this.decode_pdf.getPageCount();
    }

    public boolean openPDFFile() throws PdfException {
        int n;
        this.isOpen = false;
        this.lastPage = -1;
        if (this.fileName != null && (n = this.fileName.lastIndexOf(separator)) != -1) {
            this.name = this.fileName.substring(n + 1, this.fileName.length() - 4);
        }
        try {
            if (this.fileName != null) {
                if (this.password == null) {
                    this.decode_pdf.openPdfFile(this.fileName);
                } else {
                    this.decode_pdf.openPdfFile(this.fileName, this.password);
                }
            } else if (this.byteArray != null) {
                if (this.password == null) {
                    this.decode_pdf.openPdfArray(this.byteArray);
                } else {
                    this.decode_pdf.openPdfArray(this.byteArray, this.password);
                }
            }
            if (this.decode_pdf.isEncrypted() && !this.decode_pdf.isPasswordSupplied() && !this.decode_pdf.isExtractionAllowed()) {
                if (!this.decode_pdf.isExtractionAllowed()) {
                    throw new PdfException("Not permitted to extract from PDF");
                }
                if (this.password == null) {
                    throw new PdfException("Unable to open encrypted PDF file - call setPassword(passsword) ");
                }
                if (this.password != null) {
                    throw new PdfException("Unable to open encrypted PDF file with password " + this.password);
                }
                this.isOpen = true;
            } else {
                this.isOpen = true;
            }
        }
        catch (Exception exception) {
            throw new PdfException(exception.getMessage());
        }
        return this.isOpen;
    }

    public void closePDFfile() {
        if (this.decode_pdf != null && this.decode_pdf.isOpen()) {
            this.decode_pdf.flushObjectValues(true);
            this.decode_pdf.closePdfFile();
        }
    }

    public Object[] getFormComponentsFromDocument(String string, ReturnValues returnValues) throws PdfException {
        return this.getFormComponentsFromPage(string, returnValues, -1);
    }

    public Object[] getFormComponentsFromPage(String string, ReturnValues returnValues, int n) throws PdfException {
        if (this.decode_pdf == null) {
            throw new PdfException("Valid PDF file must be open");
        }
        AcroRenderer acroRenderer = this.decode_pdf.getFormRenderer();
        return acroRenderer.getFormComponents(string, returnValues, n);
    }

    public byte[] getRawXFAData(int n) throws PdfException {
        boolean bl = this.decode_pdf.getFormRenderer().isXFA();
        byte[] byArray = null;
        if (bl) {
            switch (n) {
                case 1043741046: {
                    break;
                }
                case 1130793076: {
                    break;
                }
                case 1013350773: {
                    break;
                }
                default: {
                    throw new PdfException("Unknown value for dataType - use PdfDictionary.XFA_CONFIG, PdfDictionary.XFA_DATASET, PdfDictionary.XFA_TEMPLATE");
                }
            }
            byArray = this.decode_pdf.getFormRenderer().getXMLContentAsBytes(n);
        }
        return byArray;
    }
}

