/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.examples.text;

import java.io.File;
import java.io.InputStream;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.jpedal.examples.text.BaseTextExtraction;
import org.jpedal.exception.PdfException;
import org.w3c.dom.Document;

public class ExtractStructuredText
extends BaseTextExtraction {
    public ExtractStructuredText(String string) {
        super(string);
        this.init();
    }

    public ExtractStructuredText(byte[] byArray) {
        super(byArray);
        this.init();
    }

    @Override
    void decodeFile(String string) throws PdfException {
        Document document;
        this.fileName = string;
        if (this.openPDFFile() && (document = this.getStructuredTextContent()) != null) {
            InputStream inputStream = this.getClass().getResourceAsStream("/org/jpedal/examples/text/xmlstyle.xslt");
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            try {
                Transformer transformer = transformerFactory.newTransformer(new StreamSource(inputStream));
                if (document == null || !document.hasChildNodes()) {
                    return;
                }
                if (!document.getDocumentElement().hasChildNodes()) {
                    document.appendChild(document.createComment("There is NO Structured text in the file to extract!!"));
                    document.appendChild(document.createComment("JPedal can only extract it if it has been added when PDF created"));
                    document.appendChild(document.createComment("Please read our blog post at http://www.jpedal.org/PDFblog/2010/09/the-easy-way-to-discover-if-a-pdf-file-contains-structured-content/ "));
                }
                String string2 = "demo";
                int n = string.lastIndexOf(separator);
                if (n != -1) {
                    string2 = string.substring(n + 1, string.length() - 4);
                }
                String string3 = this.output_dir + separator + string2 + ".xml";
                File file = new File(this.output_dir);
                if (!file.exists()) {
                    File file2 = new File(this.output_dir);
                    file2.mkdirs();
                    file.createNewFile();
                }
                transformer.transform(new DOMSource(document), new StreamResult(string3));
            }
            catch (Exception exception) {
                throw new PdfException(exception.getMessage());
            }
            catch (Error error) {
                throw new PdfException(error.getMessage());
            }
        }
    }

    public static void main(String[] stringArray) {
        int n = stringArray.length;
        if (n == 0) {
            System.out.println("Example takes 2 parameters");
            System.out.println("Value 1 is the file name or directory of PDF files to process");
            System.out.println("Value 2 is Directory for writing the data as text files");
            System.exit(0);
        } else if (n == 2) {
            try {
                ExtractStructuredText.writeAllStructuredTextOutlinesToDir(stringArray[0], stringArray[1]);
            }
            catch (PdfException pdfException) {
                pdfException.printStackTrace();
            }
        } else {
            System.out.println("too many arguments entered - run with no values to see defaults");
            StringBuilder stringBuilder = new StringBuilder();
            for (String string : stringArray) {
                stringBuilder.append(string).append('\n');
            }
            System.out.println("you entered:\n" + stringBuilder + "as the arguments");
        }
    }

    @Override
    void init() {
        this.type = BaseTextExtraction.ExtractTypes.STRUCTURED_TEXT;
        super.init();
    }

    public static void writeAllStructuredTextOutlinesToDir(String string, String string2) throws PdfException {
        ExtractStructuredText extractStructuredText = new ExtractStructuredText(string);
        extractStructuredText.setup(string2);
        extractStructuredText.processFiles(string);
        extractStructuredText.closePDFfile();
    }

    private void setup(String string) {
        if (!string.endsWith(separator)) {
            string = string + separator;
        }
        this.output_dir = string;
    }

    public Document getStructuredTextContent() {
        return this.decode_pdf.getMarkedContent();
    }
}

