/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.jbig2;

import java.io.IOException;
import org.jpedal.jbig2.decoders.JBIG2StreamDecoder;

public class JBIG2DataWriter {
    private byte[] data;
    private int id;
    private JBIG2StreamDecoder decoder;

    public JBIG2DataWriter(byte[] byArray) {
        this.data = byArray;
    }

    public JBIG2DataWriter(JBIG2StreamDecoder jBIG2StreamDecoder, int n) {
        this.decoder = jBIG2StreamDecoder;
        try {
            int n2;
            this.id = n2 = (int)jBIG2StreamDecoder.getRandomFile().length();
            jBIG2StreamDecoder.getRandomFile().setLength(n2 + n);
            jBIG2StreamDecoder.getBitmapHolder().put(this.id, n);
        }
        catch (IOException iOException) {
            System.err.println(iOException.getMessage());
        }
    }

    public int getID() {
        return this.id;
    }

    public void setID(int n) {
        this.id = n;
    }

    public byte[] getData() {
        return this.data;
    }

    public void setData(byte[] byArray) {
        this.data = byArray;
    }

    public byte getItemAt(int n) {
        byte by = 0;
        if (this.data != null) {
            by = this.data[n];
        } else {
            try {
                long l = n + this.id;
                this.decoder.getRandomFile().seek(l);
                return this.decoder.getRandomFile().readByte();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        return by;
    }

    public void setItemAt(int n, byte by) {
        if (this.data != null) {
            this.data[n] = by;
        } else {
            try {
                long l = n + this.id;
                this.decoder.getRandomFile().seek(l);
                this.decoder.getRandomFile().writeByte(by);
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
    }

    public byte[] readBytes(int n, int n2) {
        byte[] byArray = new byte[n2];
        if (this.data != null) {
            System.arraycopy(this.data, n, byArray, 0, n2);
        } else {
            try {
                long l = n + this.id;
                this.decoder.getRandomFile().seek(l);
                this.decoder.getRandomFile().read(byArray);
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        return byArray;
    }

    public void putBytes(byte[] byArray, int n, int n2) {
        if (this.data != null) {
            System.arraycopy(byArray, 0, this.data, n, n2);
        } else {
            try {
                long l = n + this.id;
                this.decoder.getRandomFile().seek(l);
                this.decoder.getRandomFile().write(byArray, 0, n2);
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
    }

    public int getDataLength() {
        int n = this.data != null ? this.data.length : this.decoder.getBitmapHolder().get(this.id);
        if (n < 0) {
            System.out.println(n);
        }
        return n;
    }

    public void bulkCopy(Object object, int n, Object object2, int n2, int n3) {
        if (this.data != null) {
            System.arraycopy(object, n, object2, n2, n3);
        } else {
            System.err.println("copying data is not supported yet in data streams");
        }
    }

    public void clearResources() {
        if (this.data != null) {
            this.data = null;
        }
    }
}

