/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.jbig2;

import java.awt.image.BufferedImage;
import java.awt.image.DataBufferByte;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import org.jpedal.jbig2.JBIG2Data;
import org.jpedal.jbig2.JBIG2Exception;
import org.jpedal.jbig2.decoders.JBIG2StreamDecoder;
import org.jpedal.jbig2.image.JBIG2Bitmap;
import org.jpedal.jbig2.segment.Segment;

public class JBIG2Decoder {
    public static final long INT_MASK = 0xFFFFFFFFL;
    private final JBIG2StreamDecoder streamDecoder;

    public JBIG2Decoder() {
        this.streamDecoder = new JBIG2StreamDecoder();
    }

    public JBIG2Decoder(String string, int n) {
        this.streamDecoder = new JBIG2StreamDecoder(string, n);
    }

    public JBIG2Decoder(boolean bl, String string) {
        this.streamDecoder = new JBIG2StreamDecoder(bl, string);
    }

    public void setGlobalData(byte[] byArray) {
        this.streamDecoder.setGlobalData(byArray);
    }

    public void decodeJBIG2(File file) throws IOException, JBIG2Exception {
        this.decodeJBIG2(file.getAbsolutePath());
    }

    void decodeJBIG2(String string) throws IOException, JBIG2Exception {
        this.decodeJBIG2(new FileInputStream(string));
    }

    void decodeJBIG2(InputStream inputStream) throws IOException, JBIG2Exception {
        int n = inputStream.available();
        byte[] byArray = new byte[n];
        inputStream.read(byArray);
        JBIG2Data jBIG2Data = new JBIG2Data(byArray);
        this.decodeJBIG2(jBIG2Data);
    }

    public void decodeJBIG2(JBIG2Data jBIG2Data) throws IOException, JBIG2Exception {
        this.streamDecoder.decodeJBIG2(jBIG2Data);
    }

    public void decodeJBIG2(byte[] byArray) throws IOException, JBIG2Exception {
        this.streamDecoder.decodeJBIG2(new JBIG2Data(byArray));
    }

    public BufferedImage getPageAsBufferedImage(int n) {
        JBIG2Bitmap jBIG2Bitmap;
        byte[] byArray;
        if ((byArray = (jBIG2Bitmap = this.streamDecoder.findPageSegment(++n).getPageBitmap()).getWriteSafeData(true)) == null) {
            return null;
        }
        int n2 = jBIG2Bitmap.getWidth();
        int n3 = jBIG2Bitmap.getHeight();
        BufferedImage bufferedImage = new BufferedImage(n2, n3, 12);
        DataBufferByte dataBufferByte = new DataBufferByte(byArray, byArray.length);
        WritableRaster writableRaster = Raster.createPackedRaster(dataBufferByte, n2, n3, 1, null);
        bufferedImage.setData(writableRaster);
        return bufferedImage;
    }

    public int getNumberOfPages() {
        int n = this.streamDecoder.getNumberOfPages();
        if (this.streamDecoder.isNumberOfPagesKnown() && n != 0) {
            return n;
        }
        int n2 = 0;
        ArrayList<Segment> arrayList = this.getAllSegments();
        for (Segment segment : arrayList) {
            if (segment.getSegmentHeader().getSegmentType() != 48) continue;
            ++n2;
        }
        return n2;
    }

    ArrayList<Segment> getAllSegments() {
        return this.streamDecoder.getAllSegments();
    }

    public JBIG2Bitmap getPageAsJBIG2Bitmap(int n) {
        return this.streamDecoder.findPageSegment(++n).getPageBitmap();
    }

    public void deleteAllStreamInfo(int n) {
        if (this.streamDecoder.getRandomFile() != null) {
            try {
                this.streamDecoder.getRandomFile().close();
                if (this.streamDecoder.getTempFile() != null) {
                    this.streamDecoder.getTempFile().delete();
                }
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
    }
}

