/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.jbig2.image;

import org.jpedal.jbig2.JBIG2DataWriter;
import org.jpedal.jbig2.image.JBIG2Bitmap;

class BitmapPointer {
    private int x;
    private final int width;
    private final int height;
    private final int line;
    private int lineOffset;
    private final JBIG2DataWriter jBIG2DataWriter;

    public BitmapPointer(JBIG2Bitmap jBIG2Bitmap) {
        this.height = jBIG2Bitmap.getHeight();
        this.width = jBIG2Bitmap.getWidth();
        this.line = jBIG2Bitmap.getLine();
        this.jBIG2DataWriter = jBIG2Bitmap.getDataWriter();
    }

    public void setPointer(int n, int n2) {
        this.x = n;
        this.lineOffset = n2 < 0 || n2 >= this.height ? -1 : n2 * this.line;
    }

    public int nextPixel() {
        if (this.x >= this.width || this.lineOffset == -1) {
            return 0;
        }
        if (this.x < 0) {
            ++this.x;
            return 0;
        }
        int n = (this.jBIG2DataWriter.getItemAt(this.lineOffset + (this.x >> 3)) & 1 << 7 - (this.x & 7)) != 0 ? 1 : 0;
        ++this.x;
        return n;
    }
}

