/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.jbig2.segment.pattern;

import java.io.IOException;
import org.jpedal.jbig2.JBIG2Exception;
import org.jpedal.jbig2.decoders.JBIG2StreamDecoder;
import org.jpedal.jbig2.image.JBIG2Bitmap;
import org.jpedal.jbig2.segment.Segment;
import org.jpedal.jbig2.segment.pattern.PatternDictionaryFlags;
import org.jpedal.jbig2.util.BinaryOperation;

public class PatternDictionarySegment
extends Segment {
    private final PatternDictionaryFlags patternDictionaryFlags = new PatternDictionaryFlags();
    private JBIG2Bitmap[] bitmaps;
    private int size;

    public PatternDictionarySegment(JBIG2StreamDecoder jBIG2StreamDecoder) {
        super(jBIG2StreamDecoder);
    }

    @Override
    public void readSegment() throws IOException, JBIG2Exception {
        this.readPatternDictionaryFlags();
        short s = this.decoder.readByte();
        short s2 = this.decoder.readByte();
        short[] sArray = new short[4];
        this.decoder.readByte(sArray);
        int n = BinaryOperation.getInt32(sArray);
        boolean bl = this.patternDictionaryFlags.getFlagValue("HD_MMR") == 1;
        int n2 = this.patternDictionaryFlags.getFlagValue("HD_TEMPLATE");
        if (!bl) {
            this.arithmeticDecoder.resetGenericStats(n2, null);
            this.arithmeticDecoder.start();
        }
        short[] sArray2 = new short[4];
        short[] sArray3 = new short[4];
        sArray2[0] = -s;
        sArray3[0] = 0;
        sArray2[1] = -3;
        sArray3[1] = -1;
        sArray2[2] = 2;
        sArray3[2] = -2;
        sArray2[3] = -2;
        sArray3[3] = -2;
        this.size = n + 1;
        JBIG2Bitmap jBIG2Bitmap = new JBIG2Bitmap(this.size * s, s2, this.arithmeticDecoder, this.huffmanDecoder, this.mmrDecoder, this.decoder);
        jBIG2Bitmap.clear(0);
        if (bl) {
            jBIG2Bitmap.readBitmapWithMMR(this.segmentHeader.getSegmentDataLength() - 7);
        } else {
            jBIG2Bitmap.readBitmap(n2, false, false, null, sArray2, sArray3);
        }
        JBIG2Bitmap[] jBIG2BitmapArray = new JBIG2Bitmap[this.size];
        int n3 = 0;
        for (int i = 0; i < this.size; ++i) {
            jBIG2BitmapArray[i] = jBIG2Bitmap.getSlice(n3, 0, s, s2);
            n3 += s;
        }
        jBIG2Bitmap.getDataWriter().clearResources();
        this.bitmaps = jBIG2BitmapArray;
    }

    @Override
    public JBIG2Bitmap[] getBitmaps() {
        return this.bitmaps;
    }

    private void readPatternDictionaryFlags() {
        short s = this.decoder.readByte();
        this.patternDictionaryFlags.setFlags(s);
    }

    public int getSize() {
        return this.size;
    }
}

