/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.objects.acroforms.actions;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.SourceDataLine;
import org.jpedal.utils.LogWriter;

public class SoundHandler {
    private static final int EXTERNAL_BUFFER_SIZE = 128000;
    private static int frameSize;
    private static float sampleRate;
    private static int sampleSizeInBits;
    private static int channels;
    private static AudioFormat.Encoding encoding;

    public static void setAudioFormat(int n, int n2, float f, int n3) {
        sampleSizeInBits = n2;
        sampleRate = f;
        channels = n3;
        if (n != 926832749) {
            if (n == 1551661165) {
                encoding = AudioFormat.Encoding.PCM_UNSIGNED;
            } else {
                throw new RuntimeException("AudioFormat currently unsupported! - ");
            }
        }
    }

    private static AudioFormat getAudioFormat() {
        frameSize = sampleSizeInBits / 8 * channels;
        int n = (int)sampleRate;
        return new AudioFormat(encoding, sampleRate, sampleSizeInBits, channels, frameSize, n, true);
    }

    public static AudioInputStream getAudioInputStream(byte[] byArray) {
        AudioFormat audioFormat = SoundHandler.getAudioFormat();
        long l = byArray.length / frameSize;
        return new AudioInputStream(new ByteArrayInputStream(byArray), audioFormat, l);
    }

    public static void PlaySound(byte[] byArray) throws Exception {
        AudioFormat audioFormat = SoundHandler.getAudioFormat();
        long l = byArray.length / frameSize;
        AudioInputStream audioInputStream = new AudioInputStream(new ByteArrayInputStream(byArray), audioFormat, l);
        SoundHandler.playSoundFromStream(audioInputStream);
    }

    private static void playSoundFromStream(AudioInputStream audioInputStream) {
        SourceDataLine sourceDataLine;
        block5: {
            sourceDataLine = null;
            DataLine.Info info = new DataLine.Info(SourceDataLine.class, audioInputStream.getFormat());
            try {
                sourceDataLine = (SourceDataLine)AudioSystem.getLine(info);
                sourceDataLine.open(audioInputStream.getFormat());
            }
            catch (Exception exception) {
                if (!LogWriter.isOutput()) break block5;
                LogWriter.writeLog("Exception: " + exception.getMessage());
            }
        }
        sourceDataLine.start();
        int n = 0;
        byte[] byArray = new byte[128000];
        while (n != -1) {
            block6: {
                try {
                    n = audioInputStream.read(byArray, 0, byArray.length);
                }
                catch (IOException iOException) {
                    if (!LogWriter.isOutput()) break block6;
                    LogWriter.writeLog("Exception: " + iOException.getMessage());
                }
            }
            if (n < 0) continue;
            sourceDataLine.write(byArray, 0, n);
        }
        sourceDataLine.drain();
        sourceDataLine.close();
    }

    static {
        sampleRate = 44100.0f;
        sampleSizeInBits = 16;
        channels = 2;
        encoding = AudioFormat.Encoding.PCM_SIGNED;
    }
}

