/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.objects.acroforms.gui;

import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.jpedal.objects.acroforms.gui.certificates.CertificateHolder;
import org.jpedal.objects.raw.PdfObject;
import org.jpedal.utils.LogWriter;

public class Summary
extends JPanel {
    private final JDialog frame;
    private final PdfObject sigObject;
    private JTextField dateBox;
    private JButton jButton1;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JTextField locationBox;
    private JTextField reasonBox;
    private JButton showCertificateButton;
    private JTextField signedByBox;

    public void setValues(String string, String string2, String string3) {
        this.signedByBox.setText(string);
        this.reasonBox.setText(string2);
        String string4 = this.sigObject.getTextStreamValue(29);
        StringBuilder stringBuilder = new StringBuilder(string4);
        stringBuilder.delete(0, 2);
        stringBuilder.insert(4, '/');
        stringBuilder.insert(7, '/');
        stringBuilder.insert(10, ' ');
        stringBuilder.insert(13, ':');
        stringBuilder.insert(16, ':');
        stringBuilder.insert(19, ' ');
        this.dateBox.setText(stringBuilder.toString());
        this.locationBox.setText(string3);
    }

    public Summary(JDialog jDialog, PdfObject pdfObject) {
        this.frame = jDialog;
        this.sigObject = pdfObject;
        this.initComponents();
        byte[] byArray = this.sigObject.getTextStreamValueAsByte(322257476);
        if (byArray == null) {
            this.showCertificateButton.setEnabled(false);
        } else {
            this.showCertificateButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    Summary.this.showCertificate();
                }
            });
            this.add(this.showCertificateButton);
            this.showCertificateButton.setBounds(380, 10, 150, 23);
        }
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.jLabel2 = new JLabel();
        this.jLabel3 = new JLabel();
        this.locationBox = new JTextField();
        this.showCertificateButton = new JButton();
        this.signedByBox = new JTextField();
        this.reasonBox = new JTextField();
        this.jLabel4 = new JLabel();
        this.dateBox = new JTextField();
        this.jButton1 = new JButton();
        this.setLayout(null);
        this.jLabel1.setText("Location:");
        this.add(this.jLabel1);
        this.jLabel1.setBounds(310, 70, 70, 20);
        this.jLabel2.setText("Signed by:");
        this.add(this.jLabel2);
        this.jLabel2.setBounds(10, 10, 70, 20);
        this.jLabel3.setText("Reason:");
        this.add(this.jLabel3);
        this.jLabel3.setBounds(10, 40, 70, 20);
        this.locationBox.setEditable(false);
        this.add(this.locationBox);
        this.locationBox.setBounds(360, 70, 170, 20);
        this.showCertificateButton.setText("Show Certificate...");
        this.showCertificateButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Summary.this.showCertificate();
            }
        });
        this.add(this.showCertificateButton);
        this.showCertificateButton.setBounds(380, 10, 150, 23);
        this.signedByBox.setEditable(false);
        this.add(this.signedByBox);
        this.signedByBox.setBounds(70, 10, 300, 20);
        this.reasonBox.setEditable(false);
        this.add(this.reasonBox);
        this.reasonBox.setBounds(70, 40, 460, 20);
        this.jLabel4.setText("Date:");
        this.add(this.jLabel4);
        this.jLabel4.setBounds(10, 70, 70, 20);
        this.dateBox.setEditable(false);
        this.add(this.dateBox);
        this.dateBox.setBounds(70, 70, 230, 20);
        this.jButton1.setText("Close");
        this.jButton1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Summary.this.close();
            }
        });
        this.add(this.jButton1);
        this.jButton1.setBounds(433, 140, 90, 23);
    }

    private void close() {
        this.frame.setVisible(false);
    }

    private void showCertificate() {
        block3: {
            JDialog jDialog = new JDialog((Frame)null, "Certificate Viewer", true);
            CertificateHolder certificateHolder = new CertificateHolder(jDialog);
            try {
                byte[] byArray = this.sigObject.getTextStreamValueAsByte(322257476);
                ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
                CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
                X509Certificate x509Certificate = (X509Certificate)certificateFactory.generateCertificate(byteArrayInputStream);
                ((InputStream)byteArrayInputStream).close();
                SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy.MM.dd HH:mm:ss z");
                Date date = x509Certificate.getNotBefore();
                Date date2 = x509Certificate.getNotAfter();
                String string = Summary.byteToHex(x509Certificate.getPublicKey().getEncoded());
                String string2 = Summary.byteToHex(x509Certificate.getEncoded());
                String string3 = Summary.byteToHex(Summary.getDigest(byArray, "SHA1"));
                String string4 = Summary.byteToHex(Summary.getDigest(byArray, "MD5"));
                String string5 = x509Certificate.getPublicKey().toString();
                int n = string5.indexOf(10);
                if (n != -1) {
                    string5 = string5.substring(0, n);
                }
                certificateHolder.setValues(this.sigObject.getTextStreamValue(506543413), x509Certificate.getVersion(), x509Certificate.getSigAlgName(), x509Certificate.getSubjectX500Principal().toString(), x509Certificate.getIssuerX500Principal().toString(), x509Certificate.getSerialNumber(), simpleDateFormat.format(date), simpleDateFormat.format(date2), string5, string, string2, string3, string4);
                jDialog.getContentPane().add(certificateHolder);
                jDialog.setSize(440, 450);
                jDialog.setLocationRelativeTo(null);
                jDialog.setVisible(true);
            }
            catch (Exception exception) {
                if (!LogWriter.isOutput()) break block3;
                LogWriter.writeLog("Exception: " + exception.getMessage());
            }
        }
    }

    private static byte[] getDigest(byte[] byArray, String string) throws NoSuchAlgorithmException {
        MessageDigest messageDigest = MessageDigest.getInstance(string);
        messageDigest.update(byArray);
        return messageDigest.digest();
    }

    private static String byteToHex(byte[] byArray) {
        StringBuilder stringBuilder = new StringBuilder();
        for (byte by : byArray) {
            String string = Integer.toHexString(by);
            if (string.startsWith("ffffff")) {
                string = string.substring(6, string.length());
            } else if (string.length() == 1) {
                string = '0' + string;
            }
            string = string.toUpperCase();
            stringBuilder.append(string).append(' ');
        }
        return stringBuilder.toString();
    }
}

