/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.objects.acroforms.overridingImplementations;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import javax.swing.Icon;
import javax.swing.SwingConstants;
import org.jpedal.io.PdfObjectReader;
import org.jpedal.objects.acroforms.overridingImplementations.CustomImageIcon;
import org.jpedal.objects.raw.FormObject;
import org.jpedal.objects.raw.FormStream;
import org.jpedal.objects.raw.PdfObject;

public class FixImageIcon
extends CustomImageIcon
implements Icon,
SwingConstants {
    private static final long serialVersionUID = 8946195842453749725L;
    final PdfObject formObject;
    private boolean currentlyPrinting;
    private int printMultiplier = 1;
    private int selected = -1;
    private static final int UNSELECTEDICON = 0;
    private static final int SELECTEDICON = 1;
    private BufferedImage rootImageSelected;
    private BufferedImage rootImageUnselected;
    private BufferedImage imageSelected;
    private BufferedImage imageUnselected;
    private PdfObject selObj;
    private PdfObject unSelObj;
    private PdfObjectReader currentpdffile;
    private int subtype;
    private int offsetImage;

    public FixImageIcon(PdfObject pdfObject, BufferedImage bufferedImage, int n) {
        super(n);
        this.formObject = pdfObject;
        this.imageSelected = bufferedImage != null ? bufferedImage : FormObject.getOpaqueImage();
        this.selected = -1;
    }

    public FixImageIcon(PdfObject pdfObject, PdfObject pdfObject2, int n, PdfObjectReader pdfObjectReader, int n2, int n3) {
        super(n);
        this.formObject = pdfObject;
        this.selObj = pdfObject2;
        this.selected = -1;
        this.currentpdffile = pdfObjectReader;
        this.subtype = n2;
        this.offsetImage = n3;
    }

    public FixImageIcon(PdfObject pdfObject, PdfObject pdfObject2, PdfObject pdfObject3, int n, int n2, PdfObjectReader pdfObjectReader, int n3, int n4) {
        super(n);
        this.formObject = pdfObject;
        this.selObj = pdfObject2;
        this.unSelObj = pdfObject3;
        this.selected = n2;
        this.currentpdffile = pdfObjectReader;
        this.subtype = n3;
        this.offsetImage = n4;
    }

    @Override
    public Image getImage() {
        BufferedImage bufferedImage;
        this.checkAndCreateimage();
        switch (this.selected) {
            case 0: {
                bufferedImage = this.imageUnselected;
                break;
            }
            default: {
                bufferedImage = this.imageSelected;
            }
        }
        return bufferedImage;
    }

    @Override
    public synchronized void paintIcon(Component component, Graphics graphics, int n, int n2) {
        BufferedImage bufferedImage = (BufferedImage)this.getImage();
        if (bufferedImage == null) {
            return;
        }
        if (component.isEnabled()) {
            graphics.setColor(component.getBackground());
        } else {
            graphics.setColor(Color.gray);
        }
        Graphics2D graphics2D = (Graphics2D)graphics;
        if (this.iconWidth > 0 && this.iconHeight > 0) {
            int n3;
            int n4 = this.iconWidth;
            int n5 = this.iconHeight;
            boolean bl = false;
            if (this.iconRotation == 270 || this.iconRotation == 90) {
                bl = true;
                n4 = this.iconHeight;
                n5 = this.iconWidth;
            }
            if (this.currentpdffile != null) {
                float f;
                float f2 = (float)n4 / (float)bufferedImage.getWidth(null);
                float f3 = f2 - (f = (float)n5 / (float)bufferedImage.getHeight(null));
                int n6 = (int)f3;
                if (n6 != 0) {
                    bl = !bl;
                    int n7 = n4;
                    n4 = n5;
                    n5 = n7;
                    f2 = (float)n4 / (float)bufferedImage.getWidth(null);
                    f = (float)n5 / (float)bufferedImage.getHeight(null);
                }
                if (f2 < f) {
                    n4 = (int)(f2 * (float)bufferedImage.getWidth(null));
                    n5 = (int)(f2 * (float)bufferedImage.getHeight(null));
                } else {
                    n4 = (int)(f * (float)bufferedImage.getWidth(null));
                    n5 = (int)(f * (float)bufferedImage.getHeight(null));
                }
            }
            int n8 = 0;
            int n9 = 0;
            if (this.currentpdffile != null) {
                if (bl) {
                    n8 = (this.iconHeight - n4) / 2;
                    n9 = (this.iconWidth - n5) / 2;
                } else {
                    n8 = (this.iconWidth - n4) / 2;
                    n9 = (this.iconHeight - n5) / 2;
                }
            }
            if ((n3 = this.displaySingle ? FixImageIcon.validateRotationValue(this.pageRotate - this.iconRotation) : this.pageRotate) == 270) {
                graphics2D.rotate(-1.5707963267948966);
                graphics2D.translate(-n4, 0);
                graphics2D.drawImage(bufferedImage, -n8, n9, n4, n5, null);
            } else if (n3 == 90) {
                graphics2D.rotate(1.5707963267948966);
                graphics2D.translate(0, -n5);
                graphics2D.drawImage(bufferedImage, n8, -n9, n4, n5, null);
            } else if (n3 == 180) {
                graphics2D.rotate(Math.PI);
                graphics2D.translate(-n4, -n5);
                graphics2D.drawImage(bufferedImage, -n8, -n9, n4, n5, null);
            } else {
                graphics2D.drawImage(bufferedImage, n8, n9, n4, n5, null);
            }
        } else {
            graphics2D.drawImage((Image)bufferedImage, 0, 0, null);
        }
        graphics2D.translate(-n, -n2);
    }

    private void checkAndCreateimage() {
        if (this.currentpdffile == null) {
            return;
        }
        int n = this.iconWidth;
        int n2 = this.iconHeight;
        if (this.currentlyPrinting) {
            n = this.iconWidth * this.printMultiplier;
            n2 = this.iconHeight * this.printMultiplier;
        }
        switch (this.selected) {
            case 0: {
                if (this.rootImageUnselected != null && n <= this.rootImageUnselected.getWidth(null) && n2 <= this.rootImageUnselected.getHeight(null) && !((float)n < (float)this.rootImageUnselected.getWidth(null) / MAXSCALEFACTOR) && !((float)n2 < (float)this.rootImageUnselected.getHeight(null) / MAXSCALEFACTOR)) break;
                this.rootImageUnselected = FormStream.decode(this.formObject, this.currentpdffile, this.unSelObj, this.subtype, n, n2, this.offsetImage, 1.0f);
                this.imageUnselected = FormStream.rotate(this.rootImageUnselected, this.iconRotation);
                break;
            }
            default: {
                if (this.rootImageSelected != null && n <= this.rootImageSelected.getWidth(null) && n2 <= this.rootImageSelected.getHeight(null) && !((float)n < (float)this.rootImageSelected.getWidth(null) / MAXSCALEFACTOR) && !((float)n2 < (float)this.rootImageSelected.getHeight(null) / MAXSCALEFACTOR)) break;
                this.rootImageSelected = FormStream.decode(this.formObject, this.currentpdffile, this.selObj, this.subtype, n, n2, this.offsetImage, 1.0f);
                this.imageSelected = FormStream.rotate(this.rootImageSelected, this.iconRotation);
            }
        }
    }

    public void swapImage(boolean bl) {
        if (this.selected == -1) {
            return;
        }
        this.selected = bl ? 1 : 0;
    }

    public void setPrinting(boolean bl, int n) {
        this.currentlyPrinting = bl;
        this.printMultiplier = n;
        this.checkAndCreateimage();
    }
}

