/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.objects.acroforms.utils;

import java.awt.Color;
import java.awt.Rectangle;
import org.jpedal.objects.PdfPageData;
import org.jpedal.objects.acroforms.GUIData;
import org.jpedal.objects.raw.FormObject;
import org.jpedal.objects.raw.PdfObject;
import org.jpedal.render.output.GenericFontMapper;

public class FormsCSSHelper {
    public static int[] getTextColor(FormObject formObject) {
        int[] nArray = formObject != null ? FormsCSSHelper.getColor(formObject.getTextColor()) : null;
        return nArray;
    }

    public static int[] getBackgroundColor(FormObject formObject) {
        int[] nArray = formObject != null ? FormsCSSHelper.getColor(FormObject.generateColor(formObject.getDictionary(7451).getFloatArray(4631))) : null;
        return nArray;
    }

    public static int[] getBorderColor(FormObject formObject) {
        int[] nArray = formObject != null ? FormsCSSHelper.getColor(FormObject.generateColor(formObject.getDictionary(7451).getFloatArray(4627))) : null;
        return nArray;
    }

    public static int getBorderWidth(FormObject formObject) {
        PdfObject pdfObject = formObject.getDictionary(4643);
        int n = -1;
        if (pdfObject != null) {
            n = pdfObject.getInt(39);
        }
        if (n < 0) {
            n = 1;
        }
        return n;
    }

    private static int[] getColor(Color color) {
        int[] nArray;
        if (color != null) {
            int n = color.getRGB();
            int n2 = n >> 16 & 0xFF;
            int n3 = n >> 8 & 0xFF;
            int n4 = n & 0xFF;
            nArray = new int[]{n2, n3, n4};
        } else {
            nArray = null;
        }
        return nArray;
    }

    public static String addFont(FormObject formObject, boolean bl, boolean bl2, PdfPageData pdfPageData, int n, float f) {
        GenericFontMapper genericFontMapper = new GenericFontMapper(formObject.getFontName());
        String string = genericFontMapper.getFont();
        String string2 = genericFontMapper.getWeight();
        float f2 = formObject.getTextSize();
        if (f2 == 0.0f || f2 == -1.0f) {
            int n2;
            Rectangle rectangle = formObject.getBoundingRectangle();
            f2 = bl2 ? 12.0f : ((n2 = pdfPageData.getRotation(n)) == 90 || n2 == 270 ? (float)GUIData.calculateFontSize(rectangle.width, rectangle.height, bl, formObject.getTextStreamValue(38)) : (float)GUIData.calculateFontSize(rectangle.height, rectangle.width, bl, formObject.getTextStreamValue(38)));
        }
        String string3 = String.format("%s %dpx %s", string2, (int)(f2 *= f), string);
        return string3;
    }
}

