/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.objects.raw;

import java.awt.AlphaComposite;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.util.StringTokenizer;
import org.jpedal.external.ExternalHandlers;
import org.jpedal.fonts.FontMappings;
import org.jpedal.fonts.PdfFont;
import org.jpedal.fonts.StandardFonts;
import org.jpedal.fonts.glyph.T3Glyph;
import org.jpedal.io.ObjectStore;
import org.jpedal.io.PdfObjectReader;
import org.jpedal.objects.raw.FormObject;
import org.jpedal.objects.raw.PdfObject;
import org.jpedal.parser.PdfStreamDecoder;
import org.jpedal.render.T3Display;
import org.jpedal.utils.LogWriter;

public class FormStream {
    public static final boolean debugUnimplemented = false;
    public static final boolean debug = false;
    private static boolean showFontMessage;
    public static final boolean exitOnError = false;
    protected PdfObjectReader currentPdfFile;
    public boolean isXFA;
    public static final int[] id;

    public void createAppearanceString(FormObject formObject, PdfObjectReader pdfObjectReader) {
        this.currentPdfFile = pdfObjectReader;
        this.init(formObject);
    }

    private void init(FormObject formObject) {
        String string;
        int n = formObject.getInt(5686);
        if (n != -1) {
            formObject.commandFf(n);
        }
        this.resolveAdditionalAction(formObject);
        FormStream.setupAPimages(formObject);
        int n2 = formObject.getNameAsConstant(24);
        if (n2 != -1) {
            if (n2 == 36 || n2 == 32) {
                if (!formObject.hasDownImage()) {
                    formObject.setOffsetDownApp();
                }
            } else if (n2 == 30) {
                formObject.setNoDownIcon();
            } else if (n2 == 25) {
                formObject.setInvertForDownIcon();
            }
        }
        if ((string = formObject.getTextStreamValue(5137)) != null) {
            FormStream.decodeFontCommandObj(string, formObject);
        }
    }

    public static void setupAPimages(FormObject formObject) {
        PdfObject pdfObject = formObject.getDictionary(4384).getDictionary(30);
        if (pdfObject != null) {
            Object object;
            formObject.setAppreancesUsed(true);
            formObject.setNormalOnState(formObject.getName(4387));
            if (pdfObject.getDictionary(7998) != null) {
                formObject.setNormalOnState("On");
            } else {
                object = pdfObject.getOtherDictionaries();
                if (object != null && !object.isEmpty()) {
                    for (String string : object.keySet()) {
                        formObject.setNormalOnState(string);
                    }
                }
            }
            object = formObject.getName(4387);
            if (object != null && ((String)object).equals(formObject.getNormalOnState())) {
                formObject.setSelected(true);
            }
        }
    }

    private void resolveAdditionalAction(FormObject formObject) {
        int[] nArray = id;
        int n = nArray.length;
        for (int i = 0; i < n; ++i) {
            int n2;
            int n3 = n2 = nArray[i];
            this.currentPdfFile.setJavascriptForObject(formObject, 4369, n3);
            this.currentPdfFile.setJavascriptForObject(formObject, 17, n3);
        }
    }

    public static BufferedImage decode(PdfObject pdfObject, PdfObjectReader pdfObjectReader, PdfObject pdfObject2, int n, int n2, int n3, int n4, float f) {
        if (pdfObject2.getObjectType() == 129) {
            return ExternalHandlers.decode(pdfObject, pdfObjectReader, pdfObject2, n, n2, n3, n4, f);
        }
        pdfObjectReader.checkResolved(pdfObject2);
        try {
            Graphics2D graphics2D;
            BufferedImage bufferedImage;
            float f2;
            float f3;
            float f4;
            float f5;
            Object object;
            PdfStreamDecoder pdfStreamDecoder;
            T3Display t3Display;
            ObjectStore objectStore;
            block41: {
                objectStore = new ObjectStore();
                t3Display = new T3Display(0, false, 20, objectStore);
                t3Display.setHiResImageForDisplayMode(true);
                pdfStreamDecoder = new PdfStreamDecoder(pdfObjectReader, true, null);
                pdfStreamDecoder.setParameters(false, true, 15, 0, false, false);
                pdfStreamDecoder.setStreamType(1);
                pdfStreamDecoder.setObjectValue(-8, objectStore);
                pdfStreamDecoder.setRenderer(t3Display);
                try {
                    object = pdfObject2.getDictionary(2004251818);
                    if (object == null) {
                        object = (PdfObject)pdfObject2.getOtherDictionaries().get("Resources");
                    }
                    if (object != null) {
                        pdfStreamDecoder.readResources((PdfObject)object, false);
                    }
                }
                catch (Exception exception) {
                    System.out.println("Exception " + exception + " reading resources in XForm");
                    if (!LogWriter.isOutput()) break block41;
                    LogWriter.writeLog("Exception: " + exception.getMessage());
                }
            }
            object = pdfObject2.getDecodedStream();
            float[] fArray = pdfObject2.getFloatArray(1145198201);
            float[] fArray2 = pdfObject2.getFloatArray(303185736);
            pdfStreamDecoder.setBBox(fArray2);
            if (object != null) {
                pdfStreamDecoder.decodeStreamIntoObjects((byte[])object, false);
            }
            boolean bl = pdfStreamDecoder.ignoreColors;
            objectStore.flush();
            T3Glyph t3Glyph = new T3Glyph(t3Display, 0, 0, bl);
            float f6 = 0.0f;
            float f7 = 0.0f;
            if (fArray2 != null) {
                int n5;
                int n6;
                int n7 = 0;
                while (n7 < 4) {
                    int n8 = n7++;
                    fArray2[n8] = fArray2[n8] * f;
                }
                f6 = fArray2[0];
                f7 = fArray2[1];
                n7 = (int)(fArray2[2] + 0.5f - fArray2[0]);
                if (n7 < 0) {
                    n7 = -n7;
                }
                if ((n6 = (int)(fArray2[3] + 0.5f - fArray2[1])) < 0) {
                    n6 = -n6;
                }
                if (n7 == 0 && n6 > 0) {
                    n7 = 1;
                }
                if (n7 > 0 && n6 == 0) {
                    n6 = 1;
                }
                if ((n5 = (int)(f5 = (f4 = (float)n2 / (float)n7) - (f3 = (float)n3 / (float)n6))) != 0) {
                    int n9 = n2;
                    n2 = n3;
                    n3 = n9;
                    f4 = (float)n2 / (float)n7;
                    f3 = (float)n3 / (float)n6;
                }
                if (f4 < 1.0f || f3 < 1.0f) {
                    f2 = 1.0f;
                    n2 = n7;
                    n3 = n6;
                } else {
                    if (f4 > f3) {
                        f2 = f4;
                        n3 = (int)((float)n6 * f2);
                    } else {
                        f2 = f3;
                        n2 = (int)((float)n7 * f2);
                    }
                    f6 *= f2;
                    f7 *= f2;
                }
            } else {
                float f8;
                if ((float)n3 < 20.0f) {
                    n3 = 20;
                }
                if ((float)n2 < 20.0f) {
                    n2 = 20;
                }
                if ((f8 = (float)n2 / 20.0f) > (f4 = (float)n3 / 20.0f)) {
                    f2 = f8;
                    n3 = (int)(20.0f * f2);
                } else {
                    f2 = f4;
                    n2 = (int)(20.0f * f2);
                }
                f6 *= f2;
                f7 *= f2;
            }
            if (n2 == 0 || n3 == 0) {
                return null;
            }
            if (n4 == 1) {
                n2 += 2;
                n3 += 2;
            }
            int n10 = n3;
            if (fArray != null) {
                f4 = fArray[0];
                f3 = fArray[1];
                f5 = fArray[2];
                float f9 = fArray[3];
                float f10 = fArray[4] * f2 * f;
                float f11 = fArray[5] * f2 * f;
                if (f5 != 0.0f) {
                    bufferedImage = new BufferedImage(n3, n2, 2);
                    n10 = n2;
                } else {
                    bufferedImage = new BufferedImage(n2, n3, 2);
                    if (!(f3 < 0.0f)) {
                        if (f10 != 0.0f) {
                            f10 = -f6;
                        }
                        if (f11 != 0.0f) {
                            f11 = -f7;
                        }
                    }
                }
                graphics2D = (Graphics2D)bufferedImage.getGraphics();
                AffineTransform affineTransform = new AffineTransform();
                affineTransform.translate(0.0, n10);
                affineTransform.scale(1.0, -1.0);
                graphics2D.setTransform(affineTransform);
                AffineTransform affineTransform2 = new AffineTransform(f4, f3, f5, f9, f10, f11);
                graphics2D.transform(affineTransform2);
            } else {
                bufferedImage = new BufferedImage(n2, n3, 2);
                graphics2D = (Graphics2D)bufferedImage.getGraphics();
                AffineTransform affineTransform = new AffineTransform();
                affineTransform.translate(0.0, n10);
                affineTransform.scale(1.0, -1.0);
                graphics2D.setTransform(affineTransform);
            }
            if (n4 == 2) {
                graphics2D.scale(-1.0, -1.0);
            } else if (n4 == 1) {
                graphics2D.translate(1, 1);
            }
            if (n == 1919840408) {
                graphics2D.setComposite(AlphaComposite.getInstance(3, 0.5f));
            }
            t3Glyph.render(0, graphics2D, f2 * f, true);
            graphics2D.dispose();
            return bufferedImage;
        }
        catch (Exception exception) {
            if (LogWriter.isOutput()) {
                LogWriter.writeLog("Exception: " + exception.getMessage());
            }
            return null;
        }
        catch (Error error) {
            if (LogWriter.isOutput()) {
                LogWriter.writeLog("Error: " + error.getMessage());
            }
            if (ExternalHandlers.throwMissingCIDError && error.getMessage() != null && error.getMessage().contains("kochi")) {
                throw error;
            }
            return null;
        }
    }

    public static String decipherTextFromAP(PdfObjectReader pdfObjectReader, PdfObject pdfObject) {
        try {
            Object object;
            PdfStreamDecoder pdfStreamDecoder;
            ObjectStore objectStore;
            block11: {
                objectStore = new ObjectStore();
                T3Display t3Display = new T3Display(0, false, 20, objectStore);
                pdfStreamDecoder = new PdfStreamDecoder(pdfObjectReader, false, null);
                pdfStreamDecoder.setParameters(false, true, 15, 0, false, false);
                pdfStreamDecoder.setObjectValue(-8, objectStore);
                t3Display.setOptimisedRotation(false);
                pdfStreamDecoder.setRenderer(t3Display);
                try {
                    object = pdfObject.getDictionary(2004251818);
                    if (object != null) {
                        pdfStreamDecoder.readResources((PdfObject)object, false);
                    }
                }
                catch (Exception exception) {
                    if (!LogWriter.isOutput()) break block11;
                    LogWriter.writeLog("Exception: " + exception.getMessage());
                }
            }
            object = pdfObject.getDecodedStream();
            String string = "";
            if (object != null) {
                string = pdfStreamDecoder.decodeStreamIntoObjects((byte[])object, true);
            }
            if (string == null || string.isEmpty()) {
                string = null;
            }
            objectStore.flush();
            return string;
        }
        catch (Exception exception) {
            if (LogWriter.isOutput()) {
                LogWriter.writeLog("Exception: " + exception.getMessage());
            }
            return null;
        }
        catch (Error error) {
            if (LogWriter.isOutput()) {
                LogWriter.writeLog("Error: " + error.getMessage());
            }
            if (ExternalHandlers.throwMissingCIDError && error.getMessage() != null && error.getMessage().contains("kochi")) {
                throw error;
            }
            return null;
        }
    }

    public static BufferedImage rotate(BufferedImage bufferedImage, int n) {
        if (bufferedImage == null) {
            return null;
        }
        if (n == 0) {
            return bufferedImage;
        }
        double d = (double)n * Math.PI / 180.0;
        int n2 = bufferedImage.getWidth();
        int n3 = bufferedImage.getHeight();
        int n4 = (int)Math.round((double)n3 * Math.abs(Math.sin(d)) + (double)n2 * Math.abs(Math.cos(d)));
        int n5 = (int)Math.round((double)n3 * Math.abs(Math.cos(d)) + (double)n2 * Math.abs(Math.sin(d)));
        AffineTransform affineTransform = AffineTransform.getTranslateInstance((n4 - n2) / 2, (n5 - n3) / 2);
        affineTransform.rotate(d, n2 / 2, n3 / 2);
        BufferedImage bufferedImage2 = new BufferedImage(n4, n5, 2);
        Graphics2D graphics2D = bufferedImage2.createGraphics();
        graphics2D.drawRenderedImage(bufferedImage, affineTransform);
        graphics2D.dispose();
        return bufferedImage2;
    }

    public boolean hasXFADataSet() {
        return false;
    }

    public static void decodeFontCommandObj(String string, FormObject formObject) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, "() []");
        int n = stringTokenizer.countTokens();
        String[] stringArray = new String[n];
        int n2 = 0;
        while (stringTokenizer.hasMoreTokens()) {
            stringArray[n2] = stringTokenizer.nextToken();
            ++n2;
        }
        for (n2 = n - 1; n2 > -1; --n2) {
            float f;
            if (stringArray[n2].equals("g")) {
                --n2;
                f = 0.0f;
                try {
                    f = Float.parseFloat(FormStream.handleComma(stringArray[n2]));
                }
                catch (Exception exception) {
                    LogWriter.writeLog("Error in generating g value " + stringArray[n2] + ' ' + exception);
                }
                formObject.setTextColor(new float[]{f});
                continue;
            }
            if (stringArray[n2].equals("Tf")) {
                --n2;
                int n3 = 8;
                try {
                    n3 = (int)Float.parseFloat(FormStream.handleComma(stringArray[n2]));
                }
                catch (Exception exception) {
                    LogWriter.writeLog("Error in generating Tf size " + stringArray[n2] + ' ' + exception);
                }
                --n2;
                String string2 = null;
                try {
                    string2 = stringArray[n2];
                    if (string2.startsWith("/")) {
                        string2 = string2.substring(1);
                    }
                }
                catch (Exception exception) {
                    LogWriter.writeLog("Error in generating Tf font " + stringArray[n2] + "  " + exception);
                }
                PdfFont pdfFont = new PdfFont();
                pdfFont.setFont(string2, n3);
                String string3 = StandardFonts.expandName(string2);
                String string4 = (String)FontMappings.fontSubstitutionAliasTable.get(string3.toLowerCase());
                if (string4 != null) {
                    string3 = string4;
                }
                formObject.setFontName(string3);
                formObject.setTextFont(pdfFont.getGlyphData().getUnscaledFont());
                formObject.setTextSize(n3);
                continue;
            }
            if (stringArray[n2].equals("rg") || stringArray[n2].equals("r")) {
                f = Float.parseFloat(FormStream.handleComma(stringArray[--n2]));
                float f2 = Float.parseFloat(FormStream.handleComma(stringArray[--n2]));
                float f3 = Float.parseFloat(FormStream.handleComma(stringArray[--n2]));
                formObject.setTextColor(new float[]{f3, f2, f});
                continue;
            }
            if (stringArray[n2].equals("Sig")) {
                LogWriter.writeFormLog("Sig-  UNIMPLEMENTED=" + string + "< " + n2, false);
                continue;
            }
            if (stringArray[n2].equals("\\n") || showFontMessage) continue;
            showFontMessage = true;
            LogWriter.writeFormLog("{stream} Unknown FONT command " + stringArray[n2] + ' ' + n2 + " string=" + string, false);
        }
    }

    private static String handleComma(String string) {
        int n = string.indexOf(44);
        if (n != -1) {
            string = string.substring(0, n);
        }
        return string;
    }

    public byte[] getXFA(int n) {
        throw new RuntimeException("getXFA Should never be called in base class");
    }

    public boolean isXFA() {
        return this.isXFA;
    }

    static {
        id = new int[]{17, 4866, 4668, 21, 40, 20, 37, 5695, 8223, 8211, 8230, 8217, 31, 4865, 27, 22, 38, 4866, 5139, 10019, 5155, 10016, 5152};
    }
}

