/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.objects.structuredtext;

import java.util.HashMap;
import java.util.Map;
import org.jpedal.objects.raw.PdfObject;
import org.jpedal.render.DynamicVectorRenderer;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class StructuredContentHandler {
    private final Map markedContentProperties;
    int markedContentLevel;
    private StringBuffer markedContentSequence;
    private static final boolean debug = false;
    private boolean contentExtracted;
    private String currentKey;
    final Map keys;
    final Map dictionaries;
    Map values;
    final boolean buildDirectly;
    DynamicVectorRenderer current;
    Document doc;
    Element root;
    private float x1;
    private float y1;
    private float x2;
    private float y2;
    boolean isHTML;

    public StructuredContentHandler(Object object) {
        if (object instanceof Map) {
            this.buildDirectly = false;
            this.values = (Map)object;
        } else {
            this.buildDirectly = true;
            this.doc = (Document)object;
            this.root = this.doc.createElement("TaggedPDF-doc");
            this.doc.appendChild(this.root);
        }
        this.markedContentProperties = new HashMap();
        this.markedContentLevel = 0;
        this.markedContentSequence = new StringBuffer();
        this.currentKey = "";
        this.keys = new HashMap();
        this.dictionaries = new HashMap();
    }

    public void DP(PdfObject pdfObject) {
    }

    public void BDC(PdfObject pdfObject) {
        int n;
        if (this.markedContentLevel == 0) {
            this.markedContentSequence = new StringBuffer();
        }
        ++this.markedContentLevel;
        if (this.buildDirectly) {
            pdfObject.setIntNumber(487790868, -1);
        }
        if ((n = pdfObject.getInt(487790868)) != -1) {
            this.keys.put(this.markedContentLevel, String.valueOf(n));
        }
        this.dictionaries.put(String.valueOf(this.markedContentLevel), pdfObject);
    }

    public void BMC(String string) {
        string = this.setBMCvalues(string);
        if (this.buildDirectly && string != null) {
            Element element = (Element)this.root.getElementsByTagName(string).item(0);
            if (element == null) {
                element = this.doc.createElement(string);
                this.root.appendChild(element);
            }
            this.root = element;
        }
    }

    String setBMCvalues(String string) {
        if (string.startsWith("/")) {
            string = string.substring(1);
        }
        if (this.markedContentLevel == 0 && !this.isHTML) {
            this.markedContentSequence = new StringBuffer();
        }
        this.markedContentProperties.put(this.markedContentLevel, string);
        ++this.markedContentLevel;
        this.keys.put(this.markedContentLevel, string);
        return string;
    }

    public void EMC() {
        this.setEMCValues();
        if (this.buildDirectly) {
            Object object;
            Object object2;
            boolean bl;
            PdfObject pdfObject = (PdfObject)this.dictionaries.get(this.currentKey);
            boolean bl2 = bl = pdfObject == null;
            if (pdfObject != null && (object2 = pdfObject.getOtherDictionaries()) != null) {
                for (Object object3 : object2.keySet()) {
                    this.root.setAttribute(object3.toString(), object2.get(object3).toString());
                    this.root.setAttribute("x1", String.valueOf((int)this.x1));
                    this.root.setAttribute("y1", String.valueOf((int)this.y1));
                    this.root.setAttribute("x2", String.valueOf((int)this.x2));
                    this.root.setAttribute("y2", String.valueOf((int)this.y2));
                }
            }
            if (bl) {
                if (this.currentKey != null) {
                    object2 = this.doc.createTextNode(StructuredContentHandler.stripEscapeChars(this.markedContentSequence.toString()));
                    this.root.appendChild((Node)object2);
                    object = this.root.getParentNode();
                    if (object instanceof Element) {
                        this.root = (Element)object;
                    }
                }
            } else {
                Object object3;
                object2 = "p";
                if (object2 == null) {
                    object2 = "p";
                }
                object = this.doc.createElement((String)object2);
                this.root.appendChild((Node)object);
                object3 = this.doc.createTextNode(this.markedContentSequence.toString());
                object.appendChild((Node)object3);
            }
            this.markedContentSequence = new StringBuffer();
        } else {
            String string = this.markedContentSequence.toString();
            PdfObject pdfObject = (PdfObject)this.dictionaries.get(String.valueOf(this.markedContentLevel));
            int n = -1;
            if (pdfObject != null) {
                n = pdfObject.getInt(487790868);
            }
            if (n != -1) {
                this.values.put(String.valueOf(n), string);
                this.markedContentSequence = new StringBuffer();
            }
            this.dictionaries.remove(String.valueOf(this.markedContentLevel));
        }
        if (this.markedContentLevel > 0) {
            --this.markedContentLevel;
        }
    }

    void setEMCValues() {
        this.contentExtracted = true;
        this.currentKey = (String)this.keys.get(this.markedContentLevel);
        if (this.currentKey == null) {
            this.currentKey = String.valueOf(this.markedContentLevel);
        }
    }

    public void setText(StringBuffer stringBuffer, float f, float f2, float f3, float f4) {
        if (this.markedContentSequence.length() == 0) {
            this.markedContentSequence = stringBuffer;
            if (this.markedContentSequence.length() > 0 && this.markedContentSequence.charAt(0) == ' ') {
                this.markedContentSequence.deleteCharAt(0);
            }
        } else {
            this.markedContentSequence.append(stringBuffer);
        }
        this.x1 = f;
        this.y1 = f2;
        this.x2 = f3;
        this.y2 = f4;
    }

    private static String stripEscapeChars(Object object) {
        int n = 32;
        StringBuilder stringBuilder = new StringBuilder((String)object);
        int n2 = stringBuilder.length();
        for (int i = 0; i < n2; ++i) {
            char c = stringBuilder.charAt(i);
            if (c == '\\' && n != 92) {
                stringBuilder.deleteCharAt(i);
                --n2;
            }
            n = c;
        }
        return stringBuilder.toString();
    }

    public boolean hasContent() {
        return this.contentExtracted;
    }
}

