/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.parser.image;

import com.idrsolutions.image.jpeg2000.Jpeg2000Decoder;
import java.awt.image.BufferedImage;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import java.io.ByteArrayInputStream;
import java.util.Iterator;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.stream.ImageInputStream;
import org.jpedal.color.GenericColorSpace;
import org.jpedal.exception.PdfException;
import org.jpedal.objects.raw.PdfObject;
import org.jpedal.parser.image.data.ImageData;
import org.jpedal.utils.LogWriter;

public class JPeg2000ImageDecoder {
    public static BufferedImage decode(String string, int n, int n2, GenericColorSpace genericColorSpace, byte[] byArray, float[] fArray, ImageData imageData, int n3) throws RuntimeException, PdfException {
        if (LogWriter.isOutput()) {
            LogWriter.writeLog("JPeg 2000 Image " + string + ' ' + n + "W * " + n2 + 'H');
        }
        BufferedImage bufferedImage = genericColorSpace.JPEG2000ToRGBImage(byArray, n, n2, fArray, imageData.getpX(), imageData.getpY(), n3);
        return bufferedImage;
    }

    public static byte[] getBytesFromJPEG2000(byte[] byArray, GenericColorSpace genericColorSpace, PdfObject pdfObject) {
        Jpeg2000Decoder jpeg2000Decoder = new Jpeg2000Decoder();
        try {
            return jpeg2000Decoder.readComponentsAsConvertedBytes(byArray);
        }
        catch (Exception exception) {
            if (LogWriter.isOutput()) {
                LogWriter.writeLog("Exception with JPeg Image " + exception);
            }
            return null;
        }
    }

    static Raster getRasterFromJPEG2000(byte[] byArray) {
        WritableRaster writableRaster;
        block3: {
            ImageReader imageReader = null;
            writableRaster = null;
            try {
                ImageReader imageReader2;
                ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
                Iterator<ImageReader> iterator = ImageIO.getImageReadersByFormatName("JPEG2000");
                while (iterator.hasNext() && !(imageReader = (imageReader2 = iterator.next())).canReadRaster()) {
                }
                ImageIO.setUseCache(false);
                ImageInputStream imageInputStream = ImageIO.createImageInputStream(byteArrayInputStream);
                imageReader.setInput(imageInputStream, true);
                writableRaster = imageReader.read(0).getRaster();
                byteArrayInputStream.close();
                imageReader.dispose();
                imageInputStream.close();
            }
            catch (Exception exception) {
                if (!LogWriter.isOutput()) break block3;
                LogWriter.writeLog("Problem closing  " + exception);
            }
        }
        return writableRaster;
    }
}

