/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.render;

import java.awt.Shape;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javafx.application.Platform;
import javafx.embed.swing.SwingFXUtils;
import javafx.scene.Group;
import javafx.scene.Node;
import javafx.scene.effect.BlendMode;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.image.WritableImage;
import javafx.scene.paint.Color;
import javafx.scene.paint.ImagePattern;
import javafx.scene.paint.Paint;
import javafx.scene.shape.FillRule;
import javafx.scene.shape.LineTo;
import javafx.scene.shape.MoveTo;
import javafx.scene.shape.Path;
import javafx.scene.text.Font;
import javafx.scene.text.Text;
import javafx.scene.transform.Affine;
import javafx.scene.transform.NonInvertibleTransformException;
import javafx.scene.transform.Transform;
import org.jpedal.color.PatternColorSpace;
import org.jpedal.exception.PdfException;
import org.jpedal.fonts.PdfFont;
import org.jpedal.fonts.glyph.PdfGlyph;
import org.jpedal.fonts.tt.TTGlyph;
import org.jpedal.io.ObjectStore;
import org.jpedal.objects.GraphicsState;
import org.jpedal.render.GUIDisplay;
import org.jpedal.utils.LogWriter;
import org.jpedal.utils.Matrix;
import org.jpedal.utils.repositories.Vector_Int;
import org.jpedal.utils.repositories.Vector_Object;
import org.jpedal.utils.repositories.generic.Vector_Rectangle_Int;

public class FXDisplay
extends GUIDisplay {
    final Group pdfContent = new Group();
    private final List collection = new ArrayList(2000);

    public FXDisplay() {
        this.init();
    }

    public FXDisplay(int n, boolean bl, int n2, ObjectStore objectStore) {
        this.rawPageNumber = n;
        this.objectStoreRef = objectStore;
        this.addBackground = bl;
        this.init();
        this.setupArrays(n2);
    }

    @Override
    public void flushAdditionalObjOnPage() {
        throw new RuntimeException("NOt used in JavaFX implementation - please redecode the page");
    }

    public FXDisplay(int n, ObjectStore objectStore, boolean bl) {
        this.rawPageNumber = n;
        this.objectStoreRef = objectStore;
        this.isPrinting = bl;
        this.init();
        this.setupArrays(5000);
    }

    private void init() {
        this.isSwing = false;
    }

    @Override
    public void flush() {
        this.pageObjects.clear();
        this.objectType.clear();
        this.areas.clear();
        this.currentItem = 0;
    }

    @Override
    public void drawAdditionalObjectsOverPage(final int[] nArray, final java.awt.Color[] colorArray, final Object[] objectArray) throws PdfException {
        if (objectArray == null) {
            return;
        }
        if (Platform.isFxApplicationThread()) {
            this.drawUserContent(nArray, objectArray, colorArray);
        } else {
            Platform.runLater((Runnable)new Runnable(){

                @Override
                public void run() {
                    block2: {
                        try {
                            FXDisplay.this.drawUserContent(nArray, objectArray, colorArray);
                        }
                        catch (PdfException pdfException) {
                            if (!LogWriter.isOutput()) break block2;
                            LogWriter.writeLog("Exception with additional objects: " + pdfException.getMessage());
                        }
                    }
                }
            });
        }
    }

    @Override
    public int drawImage(int n, BufferedImage bufferedImage, GraphicsState graphicsState, boolean bl, String string, int n2, int n3) {
        int n4;
        this.rawPageNumber = n;
        float[][] fArray = graphicsState.CTM;
        WritableImage writableImage = SwingFXUtils.toFXImage((BufferedImage)bufferedImage, null);
        float f = (float)writableImage.getWidth();
        float f2 = (float)writableImage.getHeight();
        ImageView imageView = new ImageView((Image)writableImage);
        float[] fArray2 = new float[6];
        if (n2 == 1) {
            fArray2 = new float[]{fArray[0][0] / f, fArray[0][1] / f, fArray[1][0] / f2, fArray[1][1] / f2, fArray[2][0], fArray[2][1]};
            imageView.getTransforms().setAll((Object[])new Transform[]{Transform.affine((double)fArray2[0], (double)fArray2[1], (double)fArray2[2], (double)fArray2[3], (double)fArray2[4], (double)fArray2[5])});
        } else if (n2 == 0) {
            fArray2 = new float[]{fArray[0][0] / f, fArray[0][1] / f, -fArray[1][0] / f2, -fArray[1][1] / f2, fArray[2][0] + fArray[1][0], fArray[2][1] + fArray[1][1]};
            imageView.getTransforms().setAll((Object[])new Transform[]{Transform.affine((double)fArray2[0], (double)fArray2[1], (double)fArray2[2], (double)fArray2[3], (double)fArray2[4], (double)fArray2[5])});
        } else if (n2 == 2) {
            float[][] fArrayArray = new float[][]{{0.0f, 1.0f / f, 0.0f}, {1.0f / f2, 0.0f, 0.0f}, {0.0f, 0.0f, 1.0f}};
            fArray = Matrix.multiply(fArrayArray, fArray);
            fArray2 = new float[]{fArray[0][0], fArray[0][1], fArray[1][0], fArray[1][1], fArray[2][0], fArray[2][1]};
            imageView.getTransforms().add((Object)Transform.affine((double)fArray2[0], (double)fArray2[1], (double)fArray2[2], (double)fArray2[3], (double)fArray2[4], (double)fArray2[5]));
        }
        FXDisplay.setClip(graphicsState, fArray2, (Node)imageView);
        FXDisplay.setBlendMode(graphicsState, (Node)imageView);
        this.addToScene((Node)imageView);
        if (fArray[0][0] > 0.0f && (double)fArray[0][0] < 0.05 && fArray[0][1] != 0.0f && fArray[1][0] != 0.0f && fArray[1][1] != 0.0f) {
            this.areas.addElement(null);
        } else {
            this.w = (int)(fArray[0][0] * 1.0f);
            if (this.w == 0) {
                this.w = (int)(fArray[0][1] * 1.0f);
            }
            this.h = (int)(fArray[1][1] * 1.0f);
            if (this.h == 0) {
                this.h = (int)(fArray[1][0] * 1.0f);
            }
            if (!this.useHiResImageForDisplay && fArray[1][0] < 0.0f && fArray[0][1] > 0.0f && fArray[0][0] == 0.0f && fArray[1][1] == 0.0f) {
                n4 = this.w;
                this.w = -this.h;
                this.h = n4;
            }
            if (this.h < 0 && !this.useHiResImageForDisplay) {
                this.h = -this.h;
            }
            n4 = (int)graphicsState.x;
            int n5 = (int)graphicsState.y;
            int n6 = this.w;
            int n7 = this.h;
            if (n7 < 0) {
                n5 += n7;
                n7 = -n7;
            }
            if (n7 == 0) {
                n7 = 1;
            }
            int[] nArray = new int[]{n4, n5, n6, n7};
            this.areas.addElement(nArray);
            this.objectType.addElement(3);
        }
        if (!this.isRenderingToImage()) {
            int n8 = n4 = bufferedImage.getWidth() < 100 && bufferedImage.getHeight() < 100 || bufferedImage.getHeight() == 1 ? 1 : 0;
            if (this.useHiResImageForDisplay && n4 == 0) {
                this.pageObjects.addElement(null);
            } else {
                this.pageObjects.addElement(bufferedImage);
            }
            if (this.rawKey == null) {
                this.objectStoreRef.saveStoredImage(n + "_HIRES_" + this.currentItem, bufferedImage, false, false, "tif");
                this.imageIDtoName.put(this.currentItem, n + "_HIRES_" + this.currentItem);
            } else {
                this.objectStoreRef.saveStoredImage(n + "_HIRES_" + this.currentItem + '_' + this.rawKey, bufferedImage, false, false, "tif");
                this.imageIDtoName.put(this.currentItem, n + "_HIRES_" + this.currentItem + '_' + this.rawKey);
            }
        }
        ++this.currentItem;
        return this.currentItem - 1;
    }

    @Override
    public void drawShape(Object object, GraphicsState graphicsState, int n) {
        javafx.scene.shape.Shape shape = (javafx.scene.shape.Shape)object;
        float[] fArray = new float[]{graphicsState.CTM[0][0], graphicsState.CTM[0][1], graphicsState.CTM[1][0], graphicsState.CTM[1][1], graphicsState.CTM[2][0], graphicsState.CTM[2][1]};
        shape.getTransforms().add((Object)Transform.affine((double)fArray[0], (double)fArray[1], (double)fArray[2], (double)fArray[3], (double)fArray[4], (double)fArray[5]));
        if (graphicsState.nonstrokeColorSpace.getID() == 1146450818) {
            this.drawPatternedShape(graphicsState, (Path)shape);
        } else {
            FXDisplay.setFXParams(shape, graphicsState.getFillType(), graphicsState, this.changeLineArtAndText);
            FXDisplay.setClip(graphicsState, fArray, (Node)shape);
            FXDisplay.setBlendMode(graphicsState, (Node)shape);
            this.addToScene((Node)shape);
        }
        int[] nArray = new int[]{(int)shape.getBoundsInLocal().getMinX(), (int)shape.getBoundsInLocal().getMinY(), (int)shape.getBoundsInLocal().getWidth(), (int)shape.getBoundsInLocal().getHeight()};
        this.pageObjects.addElement(shape);
        this.objectType.addElement(2);
        this.areas.addElement(nArray);
        ++this.currentItem;
    }

    private void drawPatternedShape(GraphicsState graphicsState, Path path) {
        PatternColorSpace patternColorSpace = (PatternColorSpace)graphicsState.nonstrokeColorSpace;
        BufferedImage bufferedImage = patternColorSpace.getImageForPatternedShape(graphicsState, path);
        if (bufferedImage == null) {
            return;
        }
        WritableImage writableImage = SwingFXUtils.toFXImage((BufferedImage)bufferedImage, null);
        double d = writableImage.getWidth();
        double d2 = writableImage.getHeight();
        ImagePattern imagePattern = new ImagePattern((Image)writableImage, 0.0, 0.0, d, d2, false);
        path.setStroke((Paint)new Color(0.0, 0.0, 0.0, 0.0));
        path.setFill((Paint)imagePattern);
        this.addToScene((Node)path);
    }

    protected static void setFXParams(javafx.scene.shape.Shape shape, int n, GraphicsState graphicsState, boolean bl) {
        double d;
        int n2;
        int n3;
        int n4;
        int n5;
        shape.setStroke(null);
        if (n == 2 || n == 3) {
            n5 = graphicsState.nonstrokeColorSpace.getColor().getRGB();
            if (bl && textColor != null && (itemToRender == -1 || endItem == -1 || itemToRender <= endItem) && FXDisplay.checkColorThreshold(n5)) {
                n5 = textColor.getRGB();
            }
            n4 = n5 >> 16 & 0xFF;
            n3 = n5 >> 8 & 0xFF;
            n2 = n5 & 0xFF;
            d = graphicsState.getAlpha(2);
            shape.setFill((Paint)Color.rgb((int)n4, (int)n3, (int)n2, (double)d));
        }
        if (n == 1) {
            n5 = graphicsState.strokeColorSpace.getColor().getRGB();
            if (bl && textColor != null && (itemToRender == -1 || endItem == -1 || itemToRender <= endItem) && FXDisplay.checkColorThreshold(n5)) {
                n5 = textColor.getRGB();
            }
            n4 = n5 >> 16 & 0xFF;
            n3 = n5 >> 8 & 0xFF;
            n2 = n5 & 0xFF;
            d = graphicsState.getAlpha(1);
            shape.setStroke((Paint)Color.rgb((int)n4, (int)n3, (int)n2, (double)d));
            graphicsState.applyFXStroke(shape);
        }
    }

    @Override
    public void drawCustom(Object object) {
        this.addToScene((Node)((javafx.scene.shape.Shape)object));
    }

    @Override
    public void drawEmbeddedText(float[][] fArray, int n, PdfGlyph pdfGlyph, Object object, int n2, GraphicsState graphicsState, double[] dArray, String string, PdfFont pdfFont, float f) {
        Object object2;
        Object object3;
        if (n2 == 6) {
            return;
        }
        if (pdfGlyph == null && object == null) {
            double d;
            object3 = new Text(string);
            object2 = Font.font((String)pdfFont.getGlyphData().font_family_name, (double)n);
            object3.setFont(object2);
            FXDisplay.setFXParams((javafx.scene.shape.Shape)object3, 2, graphicsState, textColor != null);
            if ((graphicsState.getTextRenderType() & 1) == 1) {
                FXDisplay.setFXParams((javafx.scene.shape.Shape)object3, 1, graphicsState, textColor != null);
            }
            FXDisplay.setBlendMode(graphicsState, (Node)object3);
            if (n2 != 4) {
                d = 1.0 / (double)n;
                object3.getTransforms().add((Object)Transform.affine((double)(dArray[0] * d), (double)(dArray[1] * d), (double)(dArray[2] * d), (double)(dArray[3] * d), (double)fArray[2][0], (double)fArray[2][1]));
            } else {
                d = 1.0 / (double)n;
                object3.getTransforms().setAll((Object[])new Transform[]{Transform.affine((double)((double)fArray[0][0] * d), (double)((double)fArray[0][1] * d), (double)((double)fArray[1][0] * d), (double)((double)fArray[1][1] * d), (double)fArray[2][0], (double)fArray[2][1])});
            }
            float[] fArray2 = new float[]{fArray[0][0], fArray[1][0], fArray[0][1], fArray[1][1], fArray[2][0], fArray[2][1]};
            javafx.scene.shape.Shape shape = graphicsState.getFXClippingShape();
            if (shape != null && !shape.contains((double)fArray[2][0], (double)fArray[2][1])) {
                FXDisplay.setClip(graphicsState, fArray2, (Node)object3);
            }
            this.pageObjects.addElement(object3);
            this.addToScene((Node)object3);
        } else {
            object3 = pdfGlyph.getPath();
            object3.setFillRule(FillRule.EVEN_ODD);
            if (n2 != 4) {
                object3.getTransforms().setAll((Object[])new Transform[]{Transform.affine((double)dArray[0], (double)dArray[1], (double)dArray[2], (double)dArray[3], (double)dArray[4], (double)dArray[5])});
            } else if (!TTGlyph.useHinting) {
                object3.getTransforms().setAll((Object[])new Transform[]{Transform.affine((double)dArray[0], (double)dArray[1], (double)dArray[2], (double)dArray[3], (double)dArray[4], (double)dArray[5])});
            } else {
                object3.getTransforms().setAll((Object[])new Transform[]{Transform.affine((double)(dArray[0] * 0.01), (double)(dArray[1] * 0.01), (double)(dArray[2] * 0.01), (double)(dArray[3] * 0.01), (double)dArray[4], (double)dArray[5])});
            }
            FXDisplay.setFXParams((javafx.scene.shape.Shape)object3, graphicsState.getTextRenderType(), graphicsState, textColor != null);
            FXDisplay.setBlendMode(graphicsState, (Node)object3);
            object2 = new float[]{fArray[0][0], fArray[1][0], fArray[0][1], fArray[1][1], fArray[2][0], fArray[2][1]};
            javafx.scene.shape.Shape shape = graphicsState.getFXClippingShape();
            if (shape != null && !shape.contains((double)fArray[2][0], (double)fArray[2][1])) {
                FXDisplay.setClip(graphicsState, (float[])object2, (Node)object3);
            }
            this.pageObjects.addElement(object3);
            this.addToScene((Node)object3);
        }
        this.objectType.addElement(n2);
        if (n2 < 0) {
            this.areas.addElement(null);
        } else if (object != null) {
            object3 = new int[]{(int)fArray[2][0], (int)fArray[2][1], n, n};
            this.areas.addElement((int[])object3);
        } else {
            int n3 = n;
            if (n3 < 0) {
                n3 = -n3;
            }
            object2 = new int[]{(int)fArray[2][0], (int)fArray[2][1], n3, n3};
            this.areas.addElement((int[])object2);
        }
        ++this.currentItem;
    }

    private static void setClip(GraphicsState graphicsState, float[] fArray, Node node) {
        javafx.scene.shape.Shape shape = graphicsState.getFXClippingShape();
        if (shape != null) {
            try {
                boolean bl;
                if (!Arrays.equals(fArray, new float[]{1.0f, 0.0f, 0.0f, -1.0f, 0.0f, 0.0f})) {
                    Affine affine = Transform.affine((double)fArray[0], (double)fArray[1], (double)fArray[2], (double)fArray[3], (double)fArray[4], (double)fArray[5]).createInverse();
                    shape.getTransforms().add((Object)affine);
                }
                boolean bl2 = bl = shape.getBoundsInLocal().getMinX() > node.getBoundsInLocal().getMinX() && node.getBoundsInLocal().getMaxY() > shape.getBoundsInLocal().getMaxY();
                if (bl) {
                    node.setClip((Node)shape);
                }
            }
            catch (NonInvertibleTransformException nonInvertibleTransformException) {
                nonInvertibleTransformException.printStackTrace();
            }
        }
    }

    public Group getFXPane() {
        if (this.collection != null && !this.collection.isEmpty()) {
            this.pdfContent.getChildren().addAll((Collection)this.collection);
            this.collection.clear();
        }
        return this.pdfContent;
    }

    protected static void setBlendMode(GraphicsState graphicsState, Node node) {
        switch (graphicsState.getBMValue()) {
            case 1451587725: {
                node.setBlendMode(BlendMode.MULTIPLY);
                break;
            }
            case 1110792305: {
                node.setBlendMode(BlendMode.SCREEN);
                break;
            }
            case 1113290622: {
                node.setBlendMode(BlendMode.OVERLAY);
                break;
            }
            case 1111181679: {
                node.setBlendMode(BlendMode.DARKEN);
                break;
            }
            case 945843829: {
                node.setBlendMode(BlendMode.LIGHTEN);
                break;
            }
            case 2071170184: {
                node.setBlendMode(BlendMode.COLOR_DODGE);
                break;
            }
            case 1367441811: {
                node.setBlendMode(BlendMode.COLOR_BURN);
                break;
            }
            case 1786342520: {
                node.setBlendMode(BlendMode.HARD_LIGHT);
                break;
            }
            case 2020441219: {
                node.setBlendMode(BlendMode.SOFT_LIGHT);
                break;
            }
            case 1802796208: {
                node.setBlendMode(BlendMode.DIFFERENCE);
                break;
            }
            case -1955824744: {
                node.setBlendMode(BlendMode.EXCLUSION);
                break;
            }
            default: {
                node.setBlendMode(null);
            }
        }
    }

    private void addToScene(Node node) {
        this.collection.add(node);
    }

    private void setupArrays(int n) {
        this.areas = new Vector_Rectangle_Int(n);
        this.objectType = new Vector_Int(n);
        this.pageObjects = new Vector_Object(n);
        this.currentItem = 0;
    }

    @Override
    public void paintBackground(Shape shape) {
        if (this.addBackground) {
            Path path = new Path();
            path.getElements().add((Object)new MoveTo((double)this.xx, (double)this.yy));
            path.getElements().add((Object)new LineTo((double)this.xx, (double)(this.yy + (int)((float)this.h * this.scaling))));
            path.getElements().add((Object)new LineTo((double)(this.xx + (int)((float)this.w * this.scaling)), (double)(this.yy + (int)((float)this.h * this.scaling))));
            path.getElements().add((Object)new LineTo((double)(this.xx + (int)((float)this.w * this.scaling)), (double)this.yy));
            path.getElements().add((Object)new LineTo((double)this.xx, (double)this.yy));
            path.setFill((Paint)new Color((double)((float)this.backgroundColor.getRed() / 255.0f), (double)((float)this.backgroundColor.getGreen() / 255.0f), (double)((float)this.backgroundColor.getBlue() / 255.0f), 1.0));
            this.addToScene((Node)path);
        }
    }
}

