/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.utils;

import org.jpedal.utils.LogWriter;

public abstract class SwingWorker {
    private Object value;
    private final ThreadVar threadVar;

    protected synchronized Object getValue() {
        return this.value;
    }

    private synchronized void setValue(Object object) {
        this.value = object;
    }

    public abstract Object construct();

    public void interrupt() {
        Thread thread = this.threadVar.get();
        if (thread != null) {
            thread.interrupt();
            while (thread.isAlive()) {
                try {
                    Thread.sleep(20L);
                }
                catch (InterruptedException interruptedException) {
                    if (!LogWriter.isOutput()) continue;
                    LogWriter.writeLog("Exception: " + interruptedException.getMessage());
                }
            }
        }
        this.threadVar.clear();
    }

    public Object get() {
        Thread thread;
        while ((thread = this.threadVar.get()) != null) {
            try {
                thread.join();
            }
            catch (InterruptedException interruptedException) {
                if (LogWriter.isOutput()) {
                    LogWriter.writeLog("Exception in handling thread " + interruptedException);
                }
                Thread.currentThread().interrupt();
                return null;
            }
        }
        return this.getValue();
    }

    public SwingWorker() {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                try {
                    SwingWorker.this.setValue(SwingWorker.this.construct());
                }
                catch (Exception exception) {
                    if (LogWriter.isOutput()) {
                        LogWriter.writeLog("Caught a Exception " + exception);
                    }
                }
                finally {
                    SwingWorker.this.threadVar.clear();
                }
            }
        };
        Thread thread = new Thread(runnable);
        thread.setDaemon(true);
        this.threadVar = new ThreadVar(thread);
    }

    public void start() {
        Thread thread = this.threadVar.get();
        if (thread != null) {
            thread.start();
        }
    }

    private static class ThreadVar {
        private Thread thread;

        ThreadVar(Thread thread) {
            this.thread = thread;
        }

        synchronized Thread get() {
            return this.thread;
        }

        synchronized void clear() {
            this.thread = null;
        }
    }
}

