/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.utils.repositories;

public class FastByteArrayOutputStream {
    int increment_size = 1000;
    protected int current_item;
    int max_size = 250;
    protected byte[] items;

    public FastByteArrayOutputStream() {
        this.items = new byte[this.max_size];
    }

    protected static int incrementSize(int n) {
        n = n < 8000 ? (n *= 4) : (n < 320000 ? (n *= 2) : (n += 320000));
        return n;
    }

    public byte[] toByteArray() {
        byte[] byArray = new byte[this.current_item];
        System.arraycopy(this.items, 0, byArray, 0, this.current_item);
        return byArray;
    }

    public FastByteArrayOutputStream(int n) {
        this.max_size = n;
        this.items = new byte[this.max_size];
    }

    public final void write(byte by) {
        if (this.current_item + 1 >= this.max_size) {
            this.checkSize(this.current_item + 1);
        }
        this.items[this.current_item] = by;
        ++this.current_item;
    }

    public final void write(int n) {
        if (this.current_item + 1 >= this.max_size) {
            this.checkSize(this.current_item + 1);
        }
        this.items[this.current_item] = (byte)(n & 0xFF);
        ++this.current_item;
    }

    public final void write(byte[] byArray, int n, int n2) {
        int n3 = n2 - n;
        if (this.current_item + n3 >= this.max_size) {
            this.checkSize(this.current_item + n3);
        }
        for (int i = 0; i < n3; ++i) {
            this.items[this.current_item] = byArray[i + n];
            ++this.current_item;
        }
    }

    public final void write(byte[] byArray) {
        int n = byArray.length;
        if (this.current_item + n >= this.max_size) {
            this.checkSize(this.current_item + n);
        }
        byte[] byArray2 = byArray;
        int n2 = byArray2.length;
        for (int i = 0; i < n2; ++i) {
            byte by;
            this.items[this.current_item] = by = byArray2[i];
            ++this.current_item;
        }
    }

    public final int size() {
        return this.current_item;
    }

    private void checkSize(int n) {
        if (n >= this.max_size) {
            int n2 = this.max_size;
            this.max_size += this.increment_size;
            if (this.max_size <= n) {
                this.max_size = n + this.increment_size + 2;
            }
            byte[] byArray = this.items;
            this.items = new byte[this.max_size];
            System.arraycopy(byArray, 0, this.items, 0, n2);
            this.increment_size = FastByteArrayOutputStream.incrementSize(this.increment_size);
        }
    }
}

