/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.utils.repositories;

import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.PathIterator;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import org.jpedal.io.PathSerializer;
import org.jpedal.utils.repositories.generic.GUIVector_Rectangle;

public class Vector_Rectangle
extends GUIVector_Rectangle
implements Serializable {
    private Rectangle[] items;

    public Vector_Rectangle(int n) {
        this.items = new Rectangle[this.max_size];
        this.max_size = n;
        this.items = new Rectangle[this.max_size];
    }

    public void writeToStream(ByteArrayOutputStream byteArrayOutputStream) throws IOException {
        ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
        objectOutputStream.writeObject(this.max_size);
        for (int i = 0; i < this.max_size; ++i) {
            Rectangle rectangle = this.items[i];
            if (rectangle == null) {
                objectOutputStream.writeObject(null);
                continue;
            }
            PathIterator pathIterator = rectangle.getPathIterator(new AffineTransform());
            PathSerializer.serializePath(objectOutputStream, pathIterator);
        }
    }

    public void restoreFromStream(ByteArrayInputStream byteArrayInputStream) throws IOException, ClassNotFoundException {
        int n;
        ObjectInputStream objectInputStream = new ObjectInputStream(byteArrayInputStream);
        this.max_size = n = ((Integer)objectInputStream.readObject()).intValue();
        this.items = new Rectangle[n];
        for (int i = 0; i < n; ++i) {
            GeneralPath generalPath = PathSerializer.deserializePath(objectInputStream);
            this.items[i] = generalPath == null ? null : generalPath.getBounds();
        }
    }

    public Vector_Rectangle() {
        this.items = new Rectangle[this.max_size];
    }

    public synchronized void addElement(Rectangle rectangle) {
        this.checkSize(this.current_item);
        this.items[this.current_item] = rectangle;
        ++this.current_item;
    }

    public final void clear() {
        this.checkPoint = -1;
        if (this.current_item > 0) {
            for (int i = 0; i < this.current_item; ++i) {
                this.items[i] = null;
            }
        } else {
            for (int i = 0; i < this.max_size; ++i) {
                this.items[i] = null;
            }
        }
        this.current_item = 0;
    }

    public final Rectangle[] get() {
        return this.items;
    }

    private void checkSize(int n) {
        if (n >= this.max_size) {
            int n2 = this.max_size;
            this.max_size += this.increment_size;
            if (this.max_size <= n) {
                this.max_size = n + this.increment_size + 2;
            }
            Rectangle[] rectangleArray = this.items;
            this.items = new Rectangle[this.max_size];
            System.arraycopy(rectangleArray, 0, this.items, 0, n2);
            this.increment_size = Vector_Rectangle.incrementSize(this.increment_size);
        }
    }

    public void trim() {
        Rectangle[] rectangleArray = new Rectangle[this.current_item];
        System.arraycopy(this.items, 0, rectangleArray, 0, this.current_item);
        this.items = rectangleArray;
        this.max_size = this.current_item;
    }
}

