/*
 * Decompiled with CFR 0.152.
 */
package org.krysalis.barcode4j.output.java2d;

import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphVector;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import org.krysalis.barcode4j.BarcodeDimension;
import org.krysalis.barcode4j.TextAlignment;
import org.krysalis.barcode4j.output.AbstractCanvasProvider;

public class Java2DCanvasProvider
extends AbstractCanvasProvider {
    private static final boolean DEBUG = false;
    private Graphics2D g2d;

    public Java2DCanvasProvider(Graphics2D g2d, int orientation) {
        super(orientation);
        this.setGraphics2D(g2d);
    }

    public void setGraphics2D(Graphics2D g2d) {
        this.g2d = g2d;
    }

    public Graphics2D getGraphics2D() {
        return this.g2d;
    }

    public void establishDimensions(BarcodeDimension dim) {
        super.establishDimensions(dim);
        int orientation = BarcodeDimension.normalizeOrientation(this.getOrientation());
        double w = dim.getWidthPlusQuiet(orientation);
        double h = dim.getHeightPlusQuiet(orientation);
        this.g2d = (Graphics2D)this.g2d.create();
        switch (orientation) {
            case 90: {
                this.g2d.rotate(-1.5707963267948966);
                this.g2d.translate(-h, 0.0);
                break;
            }
            case 180: {
                this.g2d.rotate(-Math.PI);
                this.g2d.translate(-w, -h);
                break;
            }
            case 270: {
                this.g2d.rotate(-4.71238898038469);
                this.g2d.translate(0.0, -w);
                break;
            }
        }
    }

    public void deviceFillRect(double x, double y, double w, double h) {
        this.g2d.fill(new Rectangle2D.Double(x, y, w, h));
    }

    public void deviceDrawRect(double x, double y, double w, double h) {
        this.g2d.draw(new Rectangle2D.Double(x, y, w, h));
    }

    public void deviceText(String text, double x1, double x2, double y1, String fontName, double fontSize, TextAlignment textAlign) {
        Font font = new Font(fontName, 0, (int)Math.round(fontSize));
        FontRenderContext frc = this.g2d.getFontRenderContext();
        GlyphVector gv = font.createGlyphVector(frc, text);
        float textwidth = (float)gv.getLogicalBounds().getWidth();
        float distributableSpace = (float)(x2 - x1 - (double)textwidth);
        float intercharSpace = gv.getNumGlyphs() > 1 ? distributableSpace / (float)(gv.getNumGlyphs() - 1) : 0.0f;
        float indent = textAlign == TextAlignment.TA_JUSTIFY ? (text.length() > 1 ? 0.0f : distributableSpace / 2.0f) : (textAlign == TextAlignment.TA_CENTER ? distributableSpace / 2.0f : (textAlign == TextAlignment.TA_RIGHT ? distributableSpace : 0.0f));
        Font oldFont = this.g2d.getFont();
        this.g2d.setFont(font);
        if (textAlign == TextAlignment.TA_JUSTIFY) {
            for (int i = 0; i < gv.getNumGlyphs(); ++i) {
                Point2D point = gv.getGlyphPosition(i);
                point.setLocation(point.getX() + (double)((float)i * intercharSpace), point.getY());
                gv.setGlyphPosition(i, point);
            }
        }
        this.g2d.drawGlyphVector(gv, (float)x1 + indent, (float)y1);
        this.g2d.setFont(oldFont);
    }
}

