/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.jr;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.gridnine.xtrip.common.jr.ReportParametersProvider;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.xml.XSUtil;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.URL;
import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.xml.namespace.QName;
import javax.xml.stream.Location;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.Characters;
import javax.xml.stream.events.EndElement;
import javax.xml.stream.events.StartElement;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRExporterParameter;
import net.sf.jasperreports.engine.JRParameter;
import net.sf.jasperreports.engine.JRRewindableDataSource;
import net.sf.jasperreports.engine.JasperCompileManager;
import net.sf.jasperreports.engine.JasperFillManager;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.JasperReport;
import net.sf.jasperreports.engine.export.JExcelApiExporter;
import net.sf.jasperreports.engine.export.JRHtmlExporter;
import net.sf.jasperreports.engine.export.JRPdfExporter;
import net.sf.jasperreports.engine.export.JRRtfExporter;
import net.sf.jasperreports.engine.export.JRXlsExporterParameter;
import net.sf.jasperreports.engine.export.ooxml.JRDocxExporter;
import net.sf.jasperreports.engine.export.ooxml.JRDocxExporterParameter;
import net.sf.jasperreports.engine.export.ooxml.JRXlsxExporter;
import net.sf.jasperreports.engine.util.JRLoader;
import net.sf.jasperreports.engine.util.JRSaver;
import org.apache.commons.io.IOUtils;

public final class JasperUtil {
    private static final Cache<String, JasperReport> cache = JasperUtil.createCache();
    private static final Cache<URL, JasperReport> cache2 = JasperUtil.createCache();

    private static <K, V> Cache<K, V> createCache() {
        String spec = System.getProperty("com.gridnine.xtrip.common.jr.cache");
        return (spec != null ? CacheBuilder.from((String)spec) : CacheBuilder.newBuilder().softValues().expireAfterAccess(1L, TimeUnit.DAYS)).build();
    }

    public static JasperReport getReport(byte[] content) throws Exception {
        String hash = MiscUtil.getCheckSum((byte[])content);
        return (JasperReport)cache.get((Object)hash, () -> JasperUtil.compileReport(content));
    }

    public static JasperReport getReport(URL url) throws Exception {
        return (JasperReport)cache2.get((Object)url, () -> {
            try (InputStream in = url.openStream();){
                JasperReport jasperReport = JasperUtil.compileReport(IOUtils.toByteArray((InputStream)in));
                return jasperReport;
            }
        });
    }

    private static JasperReport compileReport(byte[] content) throws JRException {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(JasperCompileManager.class.getClassLoader());
        try {
            JasperReport jasperReport = JasperCompileManager.compileReport((InputStream)new ByteArrayInputStream(content));
            return jasperReport;
        }
        finally {
            Thread.currentThread().setContextClassLoader(cl);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] fillReport(JasperReport jasperReport, Map<String, Object> parameters, JRDataSource dataSource, ReportParametersProvider callback) throws Exception {
        if (callback != null) {
            ArrayList<JRParameter> params = new ArrayList<JRParameter>();
            for (JRParameter param : jasperReport.getParameters()) {
                if (!param.isForPrompting() || param.isSystemDefined() || parameters.containsKey(param.getName())) continue;
                params.add(param);
            }
            if (!params.isEmpty()) {
                Map<JRParameter, Object> values = callback.fillAdditionalParameters(params);
                if (values == null) {
                    return null;
                }
                for (Map.Entry<JRParameter, Object> entry : values.entrySet()) {
                    parameters.put(entry.getKey().getName(), entry.getValue());
                }
            }
        }
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(JasperCompileManager.class.getClassLoader());
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            JasperFillManager.fillReportToStream((JasperReport)jasperReport, (OutputStream)baos, parameters, (JRDataSource)dataSource);
            byte[] byArray = baos.toByteArray();
            return byArray;
        }
        finally {
            Thread.currentThread().setContextClassLoader(cl);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] fillReport(byte[] content, int pageCount, Map<String, Object> parameters, JRRewindableDataSource dataSource, ReportParametersProvider callback) throws Exception {
        if (pageCount < 1) {
            throw new IllegalArgumentException("Illegal pageCount: " + pageCount);
        }
        JasperReport jasperReport = JasperUtil.getReport(content);
        if (callback != null) {
            ArrayList<JRParameter> params = new ArrayList<JRParameter>();
            for (JRParameter param : jasperReport.getParameters()) {
                if (!param.isForPrompting() || param.isSystemDefined() || parameters.containsKey(param.getName())) continue;
                params.add(param);
            }
            if (!params.isEmpty()) {
                Map<JRParameter, Object> values = callback.fillAdditionalParameters(params);
                if (values == null) {
                    return null;
                }
                for (Map.Entry<JRParameter, Object> entry : values.entrySet()) {
                    parameters.put(entry.getKey().getName(), entry.getValue());
                }
            }
        }
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(JasperCompileManager.class.getClassLoader());
        try {
            byte[] byArray;
            JasperPrint print = JasperFillManager.fillReport((JasperReport)jasperReport, parameters, (JRDataSource)dataSource);
            if (print.getPages().size() > pageCount) {
                double hiZoom = 1.0;
                double loZoom = 0.0;
                for (int i = 0; i < 5; ++i) {
                    double zoom = (hiZoom + loZoom) / 2.0;
                    if (zoom < 0.1) {
                        throw new IllegalStateException("Unable to fit document to " + pageCount + " page" + (pageCount > 1 ? "s" : ""));
                    }
                    JasperReport jasperReport2 = JasperUtil.getReport(JasperUtil.transformReport(content, zoom));
                    dataSource.moveFirst();
                    JasperPrint print2 = JasperFillManager.fillReport((JasperReport)jasperReport2, parameters, (JRDataSource)dataSource);
                    if (print2.getPages().size() <= pageCount) {
                        loZoom = zoom;
                        print = print2;
                        continue;
                    }
                    hiZoom = zoom;
                }
            }
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            try {
                JRSaver.saveObject((Object)print, (OutputStream)baos);
                byArray = baos.toByteArray();
            }
            catch (Throwable throwable) {
                baos.close();
                throw throwable;
            }
            baos.close();
            return byArray;
        }
        finally {
            Thread.currentThread().setContextClassLoader(cl);
        }
    }

    private static boolean isTransformTag(String tag) {
        return true;
    }

    private static boolean isTransformAttribute(String tag, String name) {
        return "y".equals(name) || "height".equals(name) || "font".equals(tag) && "size".equals(name) || "style".equals(tag) && "fontSize".equals(name);
    }

    private static String transformAttribute(String tag, String name, String value, double zoom) {
        if ("band".equals(tag)) {
            try {
                return Integer.toString((int)Math.round((double)Integer.parseInt(value) * zoom) + 1);
            }
            catch (NumberFormatException e) {
                return value;
            }
        }
        try {
            return Integer.toString((int)Math.round((double)Integer.parseInt(value) * zoom));
        }
        catch (NumberFormatException e) {
            return value;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static byte[] transformReport(byte[] content, double zoom) throws XMLStreamException, IOException {
        block24: {
            block23: {
                out = new ByteArrayOutputStream();
                in = new ByteArrayInputStream(content);
                writer = new OutputStreamWriter(out);
                factory = XSUtil.getXMLInputFactory();
                reader = factory.createXMLEventReader(in);
                block15: while (true) {
                    if (!reader.hasNext()) break block23;
                    event = reader.nextEvent();
                    switch (event.getEventType()) {
                        case 1: {
                            element = event.asStartElement();
                            tag = element.getName().getLocalPart();
                            if (JasperUtil.isTransformTag(tag)) {
                                attributes = new ArrayList<Attribute>();
                                iterator = element.getAttributes();
                                break block24;
                            } else {
                                event.writeAsEncodedUnicode(writer);
                                continue block15;
                            }
                        }
                        default: {
                            event.writeAsEncodedUnicode(writer);
                            break;
                        }
                    }
                    continue;
                    break;
                }
                finally {
                    reader.close();
                }
                finally {
                    writer.flush();
                    writer.close();
                }
                finally {
                    in.close();
                }
            }
            var5_4 = out.toByteArray();
            return var5_4;
            finally {
                out.close();
            }
        }
        while (iterator.hasNext()) {
            a = iterator.next();
            name = a.getName().getLocalPart();
            value = a.getValue();
            if (JasperUtil.isTransformAttribute(tag, name)) {
                newValue = JasperUtil.transformAttribute(tag, name, value, zoom);
                newAttribute = new Attribute(){

                    @Override
                    public void writeAsEncodedUnicode(Writer w) throws XMLStreamException {
                        QName qName = this.getName();
                        String prefix = qName.getPrefix();
                        try {
                            if (prefix != null && prefix.length() > 0) {
                                w.write(prefix);
                                w.write(58);
                            }
                            w.write(qName.getLocalPart());
                            w.write(61);
                            w.write(34);
                            this.writeEscapedAttrValue(w, this.getValue());
                            w.write(34);
                        }
                        catch (IOException e) {
                            throw new XMLStreamException(e.getMessage(), e);
                        }
                    }

                    protected void writeEscapedAttrValue(Writer w, String v) throws IOException {
                        int i = 0;
                        int len = v.length();
                        do {
                            int start = i;
                            char c = '\u0000';
                            while (i < len && (c = v.charAt(i)) != '<' && c != '&' && c != '\"') {
                                ++i;
                            }
                            int outLen = i - start;
                            if (outLen > 0) {
                                w.write(v, start, outLen);
                            }
                            if (i >= len) continue;
                            if (c == '<') {
                                w.write("&lt;");
                                continue;
                            }
                            if (c == '&') {
                                w.write("&amp;");
                                continue;
                            }
                            if (c != '\"') continue;
                            w.write("&quot;");
                        } while (++i < len);
                    }

                    @Override
                    public QName getName() {
                        return a.getName();
                    }

                    @Override
                    public String getValue() {
                        return newValue;
                    }

                    @Override
                    public String getDTDType() {
                        return a.getDTDType();
                    }

                    @Override
                    public int getEventType() {
                        return a.getEventType();
                    }

                    @Override
                    public boolean isSpecified() {
                        return a.isSpecified();
                    }

                    @Override
                    public Location getLocation() {
                        return a.getLocation();
                    }

                    @Override
                    public boolean isStartElement() {
                        return a.isStartElement();
                    }

                    @Override
                    public boolean isAttribute() {
                        return a.isAttribute();
                    }

                    @Override
                    public boolean isNamespace() {
                        return a.isNamespace();
                    }

                    @Override
                    public boolean isEndElement() {
                        return a.isEndElement();
                    }

                    @Override
                    public boolean isEntityReference() {
                        return a.isEntityReference();
                    }

                    @Override
                    public boolean isProcessingInstruction() {
                        return a.isProcessingInstruction();
                    }

                    @Override
                    public boolean isCharacters() {
                        return a.isCharacters();
                    }

                    @Override
                    public boolean isStartDocument() {
                        return a.isStartDocument();
                    }

                    @Override
                    public boolean isEndDocument() {
                        return a.isEndDocument();
                    }

                    @Override
                    public StartElement asStartElement() {
                        return a.asStartElement();
                    }

                    @Override
                    public EndElement asEndElement() {
                        return a.asEndElement();
                    }

                    @Override
                    public Characters asCharacters() {
                        return a.asCharacters();
                    }

                    @Override
                    public QName getSchemaType() {
                        return a.getSchemaType();
                    }
                };
                attributes.add(newAttribute);
                continue;
            }
            attributes.add(a);
        }
        qName = element.getName();
        writer.write(60);
        prefix = qName.getPrefix();
        if (prefix != null && prefix.length() > 0) {
            writer.write(prefix);
            writer.write(58);
        }
        writer.write(qName.getLocalPart());
        for (Attribute attr : attributes) {
            writer.write(32);
            attr.writeAsEncodedUnicode(writer);
        }
        iter = element.getNamespaces();
        while (iter.hasNext()) {
            namespace = iter.next();
            writer.write(32);
            namespace.writeAsEncodedUnicode(writer);
        }
        writer.write(62);
        ** continue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] convertToExcel(byte[] source) throws Exception {
        if (source == null || source.length == 0) {
            return null;
        }
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(JasperCompileManager.class.getClassLoader());
        try {
            JasperPrint jprint = (JasperPrint)JRLoader.loadObject((InputStream)new ByteArrayInputStream(source));
            JExcelApiExporter exporter = new JExcelApiExporter();
            exporter.setParameter(JRExporterParameter.JASPER_PRINT, (Object)jprint);
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            exporter.setParameter(JRExporterParameter.OUTPUT_STREAM, (Object)baos);
            exporter.exportReport();
            byte[] byArray = baos.toByteArray();
            return byArray;
        }
        finally {
            Thread.currentThread().setContextClassLoader(cl);
        }
    }

    public static byte[] convertToExcelX(byte[] source) throws Exception {
        if (source == null || source.length == 0) {
            return null;
        }
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(JasperCompileManager.class.getClassLoader());
        try {
            byte[] byArray = JasperUtil.convertToExcelX((JasperPrint)JRLoader.loadObject((InputStream)new ByteArrayInputStream(source)));
            return byArray;
        }
        finally {
            Thread.currentThread().setContextClassLoader(cl);
        }
    }

    public static byte[] convertToExcelX(JasperPrint jprint) throws Exception {
        JRXlsxExporter exporter = new JRXlsxExporter();
        exporter.setParameter(JRXlsExporterParameter.JASPER_PRINT, (Object)jprint);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        exporter.setParameter(JRXlsExporterParameter.OUTPUT_STREAM, (Object)baos);
        exporter.exportReport();
        return baos.toByteArray();
    }

    public static byte[] convertToDocX(byte[] source) throws Exception {
        if (source == null || source.length == 0) {
            return null;
        }
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(JasperCompileManager.class.getClassLoader());
        try {
            byte[] byArray = JasperUtil.convertToDocX((JasperPrint)JRLoader.loadObject((InputStream)new ByteArrayInputStream(source)));
            return byArray;
        }
        finally {
            Thread.currentThread().setContextClassLoader(cl);
        }
    }

    public static byte[] convertToDocX(JasperPrint jprint) throws Exception {
        JRDocxExporter exporter = new JRDocxExporter();
        exporter.setParameter(JRDocxExporterParameter.JASPER_PRINT, (Object)jprint);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        exporter.setParameter(JRDocxExporterParameter.OUTPUT_STREAM, (Object)baos);
        exporter.exportReport();
        return baos.toByteArray();
    }

    public static byte[] convertToRtf(byte[] source) throws Exception {
        if (source == null || source.length == 0) {
            return null;
        }
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(JasperCompileManager.class.getClassLoader());
        try {
            byte[] byArray = JasperUtil.convertToRtf((JasperPrint)JRLoader.loadObject((InputStream)new ByteArrayInputStream(source)));
            return byArray;
        }
        finally {
            Thread.currentThread().setContextClassLoader(cl);
        }
    }

    public static byte[] convertToRtf(JasperPrint jprint) throws Exception {
        JRRtfExporter exporter = new JRRtfExporter();
        exporter.setParameter(JRExporterParameter.JASPER_PRINT, (Object)jprint);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        exporter.setParameter(JRExporterParameter.OUTPUT_STREAM, (Object)baos);
        exporter.exportReport();
        return baos.toByteArray();
    }

    public static byte[] convertToPdf(byte[] source) throws Exception {
        if (source == null || source.length == 0) {
            return null;
        }
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(JasperCompileManager.class.getClassLoader());
        try {
            byte[] byArray = JasperUtil.convertToPdf((JasperPrint)JRLoader.loadObject((InputStream)new ByteArrayInputStream(source)));
            return byArray;
        }
        finally {
            Thread.currentThread().setContextClassLoader(cl);
        }
    }

    public static byte[] convertToPdf(JasperPrint jasperPrint) throws Exception {
        JRPdfExporter exporter = new JRPdfExporter();
        exporter.setParameter(JRExporterParameter.JASPER_PRINT, (Object)jasperPrint);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        exporter.setParameter(JRExporterParameter.OUTPUT_STREAM, (Object)baos);
        exporter.exportReport();
        return baos.toByteArray();
    }

    public static String exportToHtml(JasperPrint jasperPrint) throws JRException {
        StringBuffer out = new StringBuffer();
        JRHtmlExporter exporter = new JRHtmlExporter();
        exporter.setParameter(JRExporterParameter.JASPER_PRINT, (Object)jasperPrint);
        exporter.setParameter(JRExporterParameter.OUTPUT_STRING_BUFFER, (Object)out);
        exporter.setParameter(JRExporterParameter.CHARACTER_ENCODING, (Object)"UTF-8");
        exporter.exportReport();
        return out.toString();
    }

    public static void exportToPdfToStream(JasperPrint jasperPrint, OutputStream outputStream) throws JRException {
        JRPdfExporter exporter = new JRPdfExporter();
        exporter.setParameter(JRExporterParameter.JASPER_PRINT, (Object)jasperPrint);
        exporter.setParameter(JRExporterParameter.OUTPUT_STREAM, (Object)outputStream);
        exporter.exportReport();
    }
}

