/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.base;

import java.awt.Color;
import java.io.IOException;
import java.io.ObjectInputStream;
import net.sf.jasperreports.charts.JRAreaPlot;
import net.sf.jasperreports.charts.JRBar3DPlot;
import net.sf.jasperreports.charts.JRBarPlot;
import net.sf.jasperreports.charts.JRBubblePlot;
import net.sf.jasperreports.charts.JRCandlestickPlot;
import net.sf.jasperreports.charts.JRCategoryDataset;
import net.sf.jasperreports.charts.JRGanttDataset;
import net.sf.jasperreports.charts.JRHighLowDataset;
import net.sf.jasperreports.charts.JRHighLowPlot;
import net.sf.jasperreports.charts.JRLinePlot;
import net.sf.jasperreports.charts.JRMeterPlot;
import net.sf.jasperreports.charts.JRMultiAxisPlot;
import net.sf.jasperreports.charts.JRPie3DPlot;
import net.sf.jasperreports.charts.JRPieDataset;
import net.sf.jasperreports.charts.JRPiePlot;
import net.sf.jasperreports.charts.JRScatterPlot;
import net.sf.jasperreports.charts.JRThermometerPlot;
import net.sf.jasperreports.charts.JRTimePeriodDataset;
import net.sf.jasperreports.charts.JRTimeSeriesDataset;
import net.sf.jasperreports.charts.JRTimeSeriesPlot;
import net.sf.jasperreports.charts.JRValueDataset;
import net.sf.jasperreports.charts.JRXyDataset;
import net.sf.jasperreports.charts.JRXyzDataset;
import net.sf.jasperreports.charts.type.EdgeEnum;
import net.sf.jasperreports.engine.JRChart;
import net.sf.jasperreports.engine.JRChartDataset;
import net.sf.jasperreports.engine.JRChartPlot;
import net.sf.jasperreports.engine.JRCloneable;
import net.sf.jasperreports.engine.JRExpression;
import net.sf.jasperreports.engine.JRExpressionCollector;
import net.sf.jasperreports.engine.JRFont;
import net.sf.jasperreports.engine.JRGroup;
import net.sf.jasperreports.engine.JRHyperlinkHelper;
import net.sf.jasperreports.engine.JRHyperlinkParameter;
import net.sf.jasperreports.engine.JRLineBox;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.JRVisitor;
import net.sf.jasperreports.engine.base.JRBaseElement;
import net.sf.jasperreports.engine.base.JRBaseFont;
import net.sf.jasperreports.engine.base.JRBaseHyperlink;
import net.sf.jasperreports.engine.base.JRBaseLineBox;
import net.sf.jasperreports.engine.base.JRBaseObjectFactory;
import net.sf.jasperreports.engine.type.EvaluationTimeEnum;
import net.sf.jasperreports.engine.type.HyperlinkTargetEnum;
import net.sf.jasperreports.engine.type.HyperlinkTypeEnum;
import net.sf.jasperreports.engine.type.ModeEnum;
import net.sf.jasperreports.engine.util.JRBoxUtil;
import net.sf.jasperreports.engine.util.JRCloneUtils;
import net.sf.jasperreports.engine.util.JRStyleResolver;

public class JRBaseChart
extends JRBaseElement
implements JRChart {
    private static final long serialVersionUID = 10200L;
    public static final String PROPERTY_LEGEND_BACKGROUND_COLOR = "legendBackgroundColor";
    public static final String PROPERTY_LEGEND_COLOR = "legendColor";
    public static final String PROPERTY_LEGEND_POSITION = "legendPosition";
    public static final String PROPERTY_SHOW_LEGEND = "showLegend";
    public static final String PROPERTY_SUBTITLE_COLOR = "subtitleColor";
    public static final String PROPERTY_TITLE_COLOR = "titleColor";
    public static final String PROPERTY_TITLE_POSITION = "titlePosition";
    public static final String PROPERTY_RENDER_TYPE = "renderType";
    public static final String PROPERTY_THEME = "theme";
    protected byte chartType;
    protected Boolean showLegend;
    protected EvaluationTimeEnum evaluationTimeValue = EvaluationTimeEnum.NOW;
    protected String linkType;
    protected String linkTarget;
    private JRHyperlinkParameter[] hyperlinkParameters;
    protected Color titleColor;
    protected Color subtitleColor;
    protected Color legendColor;
    protected Color legendBackgroundColor;
    protected EdgeEnum legendPositionValue;
    protected EdgeEnum titlePositionValue;
    protected String renderType;
    protected String theme;
    protected JRLineBox lineBox;
    protected JRFont titleFont;
    protected JRFont subtitleFont;
    protected JRFont legendFont;
    protected String customizerClass;
    protected JRGroup evaluationGroup;
    protected JRExpression titleExpression;
    protected JRExpression subtitleExpression;
    protected JRExpression anchorNameExpression;
    protected JRExpression hyperlinkReferenceExpression;
    protected JRExpression hyperlinkAnchorExpression;
    protected JRExpression hyperlinkPageExpression;
    private JRExpression hyperlinkTooltipExpression;
    protected JRChartDataset dataset;
    protected JRChartPlot plot;
    protected int bookmarkLevel = 0;
    private int PSEUDO_SERIAL_VERSION_UID = 40600;
    private Byte border;
    private Byte topBorder;
    private Byte leftBorder;
    private Byte bottomBorder;
    private Byte rightBorder;
    private Color borderColor;
    private Color topBorderColor;
    private Color leftBorderColor;
    private Color bottomBorderColor;
    private Color rightBorderColor;
    private Integer padding;
    private Integer topPadding;
    private Integer leftPadding;
    private Integer bottomPadding;
    private Integer rightPadding;
    private boolean isShowLegend;
    private byte legendPosition;
    private byte titlePosition;
    private byte hyperlinkType;
    private byte hyperlinkTarget;
    private byte evaluationTime;
    private Byte legendPositionByte;
    private Byte titlePositionByte;

    protected JRBaseChart(JRChart chart, JRBaseObjectFactory factory) {
        super(chart, factory);
        this.chartType = chart.getChartType();
        switch (this.chartType) {
            case 1: {
                this.dataset = factory.getCategoryDataset((JRCategoryDataset)chart.getDataset());
                this.plot = factory.getAreaPlot((JRAreaPlot)chart.getPlot());
                break;
            }
            case 3: {
                this.dataset = factory.getCategoryDataset((JRCategoryDataset)chart.getDataset());
                this.plot = factory.getBarPlot((JRBarPlot)chart.getPlot());
                break;
            }
            case 2: {
                this.dataset = factory.getCategoryDataset((JRCategoryDataset)chart.getDataset());
                this.plot = factory.getBar3DPlot((JRBar3DPlot)chart.getPlot());
                break;
            }
            case 4: {
                this.dataset = factory.getXyzDataset((JRXyzDataset)chart.getDataset());
                this.plot = factory.getBubblePlot((JRBubblePlot)chart.getPlot());
                break;
            }
            case 5: {
                this.dataset = factory.getHighLowDataset((JRHighLowDataset)chart.getDataset());
                this.plot = factory.getCandlestickPlot((JRCandlestickPlot)chart.getPlot());
                break;
            }
            case 6: {
                this.dataset = factory.getHighLowDataset((JRHighLowDataset)chart.getDataset());
                this.plot = factory.getHighLowPlot((JRHighLowPlot)chart.getPlot());
                break;
            }
            case 7: {
                this.dataset = factory.getCategoryDataset((JRCategoryDataset)chart.getDataset());
                this.plot = factory.getLinePlot((JRLinePlot)chart.getPlot());
                break;
            }
            case 17: {
                this.dataset = factory.getValueDataset((JRValueDataset)chart.getDataset());
                this.plot = factory.getMeterPlot((JRMeterPlot)chart.getPlot());
                break;
            }
            case 19: {
                this.dataset = null;
                this.plot = factory.getMultiAxisPlot((JRMultiAxisPlot)chart.getPlot());
                break;
            }
            case 9: {
                this.dataset = factory.getPieDataset((JRPieDataset)chart.getDataset());
                this.plot = factory.getPiePlot((JRPiePlot)chart.getPlot());
                break;
            }
            case 8: {
                this.dataset = factory.getPieDataset((JRPieDataset)chart.getDataset());
                this.plot = factory.getPie3DPlot((JRPie3DPlot)chart.getPlot());
                break;
            }
            case 10: {
                this.dataset = factory.getXyDataset((JRXyDataset)chart.getDataset());
                this.plot = factory.getScatterPlot((JRScatterPlot)chart.getPlot());
                break;
            }
            case 12: {
                this.dataset = factory.getCategoryDataset((JRCategoryDataset)chart.getDataset());
                this.plot = factory.getBarPlot((JRBarPlot)chart.getPlot());
                break;
            }
            case 11: {
                this.dataset = factory.getCategoryDataset((JRCategoryDataset)chart.getDataset());
                this.plot = factory.getBar3DPlot((JRBar3DPlot)chart.getPlot());
                break;
            }
            case 18: {
                this.dataset = factory.getValueDataset((JRValueDataset)chart.getDataset());
                this.plot = factory.getThermometerPlot((JRThermometerPlot)chart.getPlot());
                break;
            }
            case 16: {
                this.dataset = factory.getTimeSeriesDataset((JRTimeSeriesDataset)chart.getDataset());
                this.plot = factory.getTimeSeriesPlot((JRTimeSeriesPlot)chart.getPlot());
                break;
            }
            case 13: {
                this.dataset = factory.getXyDataset((JRXyDataset)chart.getDataset());
                this.plot = factory.getAreaPlot((JRAreaPlot)chart.getPlot());
                break;
            }
            case 14: {
                switch (chart.getDataset().getDatasetType()) {
                    case 6: {
                        this.dataset = factory.getTimeSeriesDataset((JRTimeSeriesDataset)chart.getDataset());
                        break;
                    }
                    case 5: {
                        this.dataset = factory.getTimePeriodDataset((JRTimePeriodDataset)chart.getDataset());
                        break;
                    }
                    case 3: {
                        this.dataset = factory.getXyDataset((JRXyDataset)chart.getDataset());
                    }
                }
                this.plot = factory.getBarPlot((JRBarPlot)chart.getPlot());
                break;
            }
            case 15: {
                this.dataset = factory.getXyDataset((JRXyDataset)chart.getDataset());
                this.plot = factory.getLinePlot((JRLinePlot)chart.getPlot());
                break;
            }
            case 20: {
                this.dataset = factory.getCategoryDataset((JRCategoryDataset)chart.getDataset());
                this.plot = factory.getAreaPlot((JRAreaPlot)chart.getPlot());
                break;
            }
            case 21: {
                this.dataset = factory.getGanttDataset((JRGanttDataset)chart.getDataset());
                this.plot = factory.getBarPlot((JRBarPlot)chart.getPlot());
                break;
            }
            default: {
                throw new JRRuntimeException("Chart type not supported.");
            }
        }
        this.showLegend = chart.getShowLegend();
        this.evaluationTimeValue = chart.getEvaluationTimeValue();
        this.linkType = chart.getLinkType();
        this.linkTarget = chart.getLinkTarget();
        this.titlePositionValue = chart.getTitlePositionValue();
        this.titleColor = chart.getOwnTitleColor();
        this.subtitleColor = chart.getOwnSubtitleColor();
        this.legendColor = chart.getOwnLegendColor();
        this.legendBackgroundColor = chart.getOwnLegendBackgroundColor();
        this.legendPositionValue = chart.getLegendPositionValue();
        this.renderType = chart.getRenderType();
        this.theme = chart.getTheme();
        this.titleFont = factory.getFont(this, chart.getTitleFont());
        this.subtitleFont = factory.getFont(this, chart.getSubtitleFont());
        this.legendFont = factory.getFont(this, chart.getLegendFont());
        this.evaluationGroup = factory.getGroup(chart.getEvaluationGroup());
        this.titleExpression = factory.getExpression(chart.getTitleExpression());
        this.subtitleExpression = factory.getExpression(chart.getSubtitleExpression());
        this.anchorNameExpression = factory.getExpression(chart.getAnchorNameExpression());
        this.hyperlinkReferenceExpression = factory.getExpression(chart.getHyperlinkReferenceExpression());
        this.hyperlinkAnchorExpression = factory.getExpression(chart.getHyperlinkAnchorExpression());
        this.hyperlinkPageExpression = factory.getExpression(chart.getHyperlinkPageExpression());
        this.hyperlinkTooltipExpression = factory.getExpression(chart.getHyperlinkTooltipExpression());
        this.bookmarkLevel = chart.getBookmarkLevel();
        this.hyperlinkParameters = JRBaseHyperlink.copyHyperlinkParameters(chart, factory);
        this.customizerClass = chart.getCustomizerClass();
        this.lineBox = chart.getLineBox().clone(this);
    }

    @Override
    public Boolean getShowLegend() {
        return this.showLegend;
    }

    @Override
    public void setShowLegend(Boolean isShowLegend) {
        Boolean old = this.showLegend;
        this.showLegend = isShowLegend;
        this.getEventSupport().firePropertyChange(PROPERTY_SHOW_LEGEND, old, this.showLegend);
    }

    @Override
    public EvaluationTimeEnum getEvaluationTimeValue() {
        return this.evaluationTimeValue;
    }

    @Override
    public JRGroup getEvaluationGroup() {
        return this.evaluationGroup;
    }

    @Override
    public JRLineBox getLineBox() {
        return this.lineBox;
    }

    @Override
    public JRFont getTitleFont() {
        return this.titleFont;
    }

    @Override
    public EdgeEnum getTitlePositionValue() {
        return this.titlePositionValue;
    }

    @Override
    public void setTitlePosition(EdgeEnum titlePositionValue) {
        EdgeEnum old = this.titlePositionValue;
        this.titlePositionValue = titlePositionValue;
        this.getEventSupport().firePropertyChange(PROPERTY_TITLE_POSITION, old, this.titlePositionValue);
    }

    @Override
    public Color getTitleColor() {
        return JRStyleResolver.getTitleColor(this);
    }

    @Override
    public Color getOwnTitleColor() {
        return this.titleColor;
    }

    @Override
    public void setTitleColor(Color titleColor) {
        Color old = this.titleColor;
        this.titleColor = titleColor;
        this.getEventSupport().firePropertyChange(PROPERTY_TITLE_COLOR, old, this.titleColor);
    }

    @Override
    public JRFont getSubtitleFont() {
        return this.subtitleFont;
    }

    @Override
    public Color getOwnSubtitleColor() {
        return this.subtitleColor;
    }

    @Override
    public Color getSubtitleColor() {
        return JRStyleResolver.getSubtitleColor(this);
    }

    @Override
    public void setSubtitleColor(Color subtitleColor) {
        Color old = this.subtitleColor;
        this.subtitleColor = subtitleColor;
        this.getEventSupport().firePropertyChange(PROPERTY_SUBTITLE_COLOR, old, this.subtitleColor);
    }

    @Override
    public Color getLegendBackgroundColor() {
        return JRStyleResolver.getLegendBackgroundColor(this);
    }

    @Override
    public Color getOwnLegendBackgroundColor() {
        return this.legendBackgroundColor;
    }

    @Override
    public Color getOwnLegendColor() {
        return this.legendColor;
    }

    @Override
    public Color getLegendColor() {
        return JRStyleResolver.getLegendColor(this);
    }

    @Override
    public JRFont getLegendFont() {
        return this.legendFont;
    }

    @Override
    public void setLegendBackgroundColor(Color legendBackgroundColor) {
        Color old = this.legendBackgroundColor;
        this.legendBackgroundColor = legendBackgroundColor;
        this.getEventSupport().firePropertyChange(PROPERTY_LEGEND_BACKGROUND_COLOR, old, this.legendBackgroundColor);
    }

    @Override
    public void setLegendColor(Color legendColor) {
        Color old = this.legendColor;
        this.legendColor = legendColor;
        this.getEventSupport().firePropertyChange(PROPERTY_LEGEND_COLOR, old, this.legendColor);
    }

    @Override
    public EdgeEnum getLegendPositionValue() {
        return this.legendPositionValue;
    }

    @Override
    public void setLegendPosition(EdgeEnum legendPositionValue) {
        EdgeEnum old = this.legendPositionValue;
        this.legendPositionValue = legendPositionValue;
        this.getEventSupport().firePropertyChange(PROPERTY_LEGEND_POSITION, old, this.legendPositionValue);
    }

    @Override
    public byte getHyperlinkType() {
        return this.getHyperlinkTypeValue().getValue();
    }

    @Override
    public HyperlinkTypeEnum getHyperlinkTypeValue() {
        return JRHyperlinkHelper.getHyperlinkTypeValue(this);
    }

    @Override
    public byte getHyperlinkTarget() {
        return JRHyperlinkHelper.getHyperlinkTarget(this);
    }

    @Override
    public JRExpression getTitleExpression() {
        return this.titleExpression;
    }

    @Override
    public JRExpression getSubtitleExpression() {
        return this.subtitleExpression;
    }

    @Override
    public JRExpression getAnchorNameExpression() {
        return this.anchorNameExpression;
    }

    @Override
    public JRExpression getHyperlinkReferenceExpression() {
        return this.hyperlinkReferenceExpression;
    }

    @Override
    public JRExpression getHyperlinkAnchorExpression() {
        return this.hyperlinkAnchorExpression;
    }

    @Override
    public JRExpression getHyperlinkPageExpression() {
        return this.hyperlinkPageExpression;
    }

    @Override
    public JRChartDataset getDataset() {
        return this.dataset;
    }

    @Override
    public JRChartPlot getPlot() {
        return this.plot;
    }

    @Override
    public byte getChartType() {
        return this.chartType;
    }

    @Override
    public String getRenderType() {
        return this.renderType;
    }

    @Override
    public void setRenderType(String renderType) {
        String old = this.renderType;
        this.renderType = renderType;
        this.getEventSupport().firePropertyChange(PROPERTY_RENDER_TYPE, old, this.renderType);
    }

    @Override
    public String getTheme() {
        return this.theme;
    }

    @Override
    public void setTheme(String theme) {
        String old = this.theme;
        this.theme = theme;
        this.getEventSupport().firePropertyChange(PROPERTY_THEME, old, this.theme);
    }

    @Override
    public void collectExpressions(JRExpressionCollector collector) {
        collector.collect(this);
    }

    @Override
    public void visit(JRVisitor visitor) {
        visitor.visitChart(this);
    }

    @Override
    public int getBookmarkLevel() {
        return this.bookmarkLevel;
    }

    @Override
    public String getCustomizerClass() {
        return this.customizerClass;
    }

    @Override
    public ModeEnum getModeValue() {
        return JRStyleResolver.getMode(this, ModeEnum.TRANSPARENT);
    }

    @Override
    public String getLinkType() {
        return this.linkType;
    }

    @Override
    public String getLinkTarget() {
        return this.linkTarget;
    }

    @Override
    public JRHyperlinkParameter[] getHyperlinkParameters() {
        return this.hyperlinkParameters;
    }

    @Override
    public JRExpression getHyperlinkTooltipExpression() {
        return this.hyperlinkTooltipExpression;
    }

    @Override
    public Color getDefaultLineColor() {
        return this.getForecolor();
    }

    @Override
    public Object clone() {
        JRBaseChart clone = (JRBaseChart)super.clone();
        clone.lineBox = this.lineBox.clone(clone);
        clone.hyperlinkParameters = (JRHyperlinkParameter[])JRCloneUtils.cloneArray((JRCloneable[])this.hyperlinkParameters);
        clone.titleFont = JRCloneUtils.nullSafeClone((JRBaseFont)this.titleFont);
        clone.subtitleFont = JRCloneUtils.nullSafeClone((JRBaseFont)this.subtitleFont);
        clone.legendFont = JRCloneUtils.nullSafeClone((JRBaseFont)this.legendFont);
        clone.titleExpression = JRCloneUtils.nullSafeClone(this.titleExpression);
        clone.subtitleExpression = JRCloneUtils.nullSafeClone(this.subtitleExpression);
        clone.anchorNameExpression = JRCloneUtils.nullSafeClone(this.anchorNameExpression);
        clone.hyperlinkReferenceExpression = JRCloneUtils.nullSafeClone(this.hyperlinkReferenceExpression);
        clone.hyperlinkAnchorExpression = JRCloneUtils.nullSafeClone(this.hyperlinkAnchorExpression);
        clone.hyperlinkPageExpression = JRCloneUtils.nullSafeClone(this.hyperlinkPageExpression);
        clone.hyperlinkTooltipExpression = JRCloneUtils.nullSafeClone(this.hyperlinkTooltipExpression);
        clone.dataset = JRCloneUtils.nullSafeClone(this.dataset);
        clone.plot = this.plot == null ? null : (JRChartPlot)this.plot.clone(clone);
        return clone;
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        if (this.lineBox == null) {
            this.lineBox = new JRBaseLineBox(this);
            JRBoxUtil.setToBox(this.border, this.topBorder, this.leftBorder, this.bottomBorder, this.rightBorder, this.borderColor, this.topBorderColor, this.leftBorderColor, this.bottomBorderColor, this.rightBorderColor, this.padding, this.topPadding, this.leftPadding, this.bottomPadding, this.rightPadding, this.lineBox);
            this.border = null;
            this.topBorder = null;
            this.leftBorder = null;
            this.bottomBorder = null;
            this.rightBorder = null;
            this.borderColor = null;
            this.topBorderColor = null;
            this.leftBorderColor = null;
            this.bottomBorderColor = null;
            this.rightBorderColor = null;
            this.padding = null;
            this.topPadding = null;
            this.leftPadding = null;
            this.bottomPadding = null;
            this.rightPadding = null;
        }
        if (this.linkType == null) {
            this.linkType = JRHyperlinkHelper.getLinkType(HyperlinkTypeEnum.getByValue(this.hyperlinkType));
        }
        if (this.linkTarget == null) {
            this.linkTarget = JRHyperlinkHelper.getLinkTarget(HyperlinkTargetEnum.getByValue(this.hyperlinkTarget));
        }
        if (this.PSEUDO_SERIAL_VERSION_UID < 30702) {
            this.evaluationTimeValue = EvaluationTimeEnum.getByValue(this.evaluationTime);
            if (this.PSEUDO_SERIAL_VERSION_UID < 30103) {
                this.legendPositionValue = EdgeEnum.getByValue(this.legendPosition);
                this.titlePositionValue = EdgeEnum.getByValue(this.titlePosition);
                this.showLegend = this.isShowLegend;
            } else {
                this.legendPositionValue = EdgeEnum.getByValue(this.legendPositionByte);
                this.titlePositionValue = EdgeEnum.getByValue(this.titlePositionByte);
                this.legendPositionByte = null;
                this.titlePositionByte = null;
            }
        }
    }
}

