/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.util;

import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Locale;
import java.util.ResourceBundle;
import net.sf.jasperreports.engine.util.MessageProvider;

public class ResourceBundleMessageProvider
implements MessageProvider {
    private final String baseName;
    private final HashMap<Locale, ResourceBundle> bundles = new HashMap();

    public ResourceBundleMessageProvider(String baseName) {
        this.baseName = baseName;
    }

    @Override
    public String getMessage(String code, Object[] args, Locale locale) {
        String pattern = this.getMessage(code, locale);
        return MessageFormat.format(pattern, args);
    }

    public String getMessage(String code, Locale locale) {
        ResourceBundle bundle = this.bundles.get(locale);
        if (bundle == null) {
            bundle = ResourceBundle.getBundle(this.baseName, locale);
            this.bundles.put(locale, bundle);
        }
        return bundle.getString(code);
    }
}

