/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.midoffice.helper;

import com.gridnine.xtrip.common.gds.model.GdsTracingDocumentPart;
import com.gridnine.xtrip.common.gds.model.GdsTracingSearchItem;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.util.GZIPUtil;
import java.nio.charset.StandardCharsets;
import java.util.function.Consumer;
import java.util.function.Supplier;

public class GdsTracingHelper {
    public static byte[] getGlobalData(GdsTracingDocumentPart part) {
        return GdsTracingHelper.get(() -> ((GdsTracingDocumentPart)part).getGlobalDataCompressed(), () -> ((GdsTracingDocumentPart)part).getGlobalData());
    }

    public static String getGlobalDataAsString(GdsTracingDocumentPart part) {
        return GdsTracingHelper.getAsString(GdsTracingHelper.getGlobalData(part));
    }

    public static void setGlobalData(GdsTracingDocumentPart part, String data) {
        GdsTracingHelper.set(arg_0 -> ((GdsTracingDocumentPart)part).setGlobalDataCompressed(arg_0), data);
    }

    public static void setGlobalData(GdsTracingDocumentPart part, byte[] data) {
        GdsTracingHelper.set(arg_0 -> ((GdsTracingDocumentPart)part).setGlobalDataCompressed(arg_0), data);
    }

    public static byte[] getData(GdsTracingSearchItem item) {
        return GdsTracingHelper.get(() -> ((GdsTracingSearchItem)item).getDataCompressed(), () -> ((GdsTracingSearchItem)item).getData());
    }

    public static String getDataAsString(GdsTracingSearchItem item) {
        return GdsTracingHelper.getAsString(GdsTracingHelper.getData(item));
    }

    public static void setData(GdsTracingSearchItem item, String data) {
        GdsTracingHelper.set(arg_0 -> ((GdsTracingSearchItem)item).setDataCompressed(arg_0), data);
    }

    public static void setData(GdsTracingSearchItem item, byte[] data) {
        GdsTracingHelper.set(arg_0 -> ((GdsTracingSearchItem)item).setDataCompressed(arg_0), data);
    }

    private static String getAsString(byte[] data) {
        return data != null ? new String(data, StandardCharsets.UTF_8) : null;
    }

    private static byte[] get(Supplier<byte[]> dataSupplier, Supplier<String> legacySupplier) {
        byte[] compressedData = dataSupplier.get();
        if (compressedData != null) {
            try {
                return GZIPUtil.gunzip((byte[])compressedData);
            }
            catch (Exception ex) {
                throw Xeption.forDeveloper((String)"gunzip failed", (Throwable)ex, (Object[])new Object[0]);
            }
        }
        String legacyData = legacySupplier.get();
        return legacyData != null ? legacyData.getBytes(StandardCharsets.UTF_8) : null;
    }

    private static void set(Consumer<byte[]> dataConsumer, String data) {
        GdsTracingHelper.set(dataConsumer, data != null ? data.getBytes(StandardCharsets.UTF_8) : null);
    }

    private static void set(Consumer<byte[]> dataConsumer, byte[] data) {
        try {
            dataConsumer.accept(data != null ? GZIPUtil.gzip((byte[])data) : null);
        }
        catch (Exception ex) {
            throw Xeption.forDeveloper((String)"gzip failed", (Throwable)ex, (Object[])new Object[0]);
        }
    }
}

